// Code generated by go-swagger; DO NOT EDIT.

package groups_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGroupsServiceListGroupsParams creates a new GroupsServiceListGroupsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGroupsServiceListGroupsParams() *GroupsServiceListGroupsParams {
	return &GroupsServiceListGroupsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGroupsServiceListGroupsParamsWithTimeout creates a new GroupsServiceListGroupsParams object
// with the ability to set a timeout on a request.
func NewGroupsServiceListGroupsParamsWithTimeout(timeout time.Duration) *GroupsServiceListGroupsParams {
	return &GroupsServiceListGroupsParams{
		timeout: timeout,
	}
}

// NewGroupsServiceListGroupsParamsWithContext creates a new GroupsServiceListGroupsParams object
// with the ability to set a context for a request.
func NewGroupsServiceListGroupsParamsWithContext(ctx context.Context) *GroupsServiceListGroupsParams {
	return &GroupsServiceListGroupsParams{
		Context: ctx,
	}
}

// NewGroupsServiceListGroupsParamsWithHTTPClient creates a new GroupsServiceListGroupsParams object
// with the ability to set a custom HTTPClient for a request.
func NewGroupsServiceListGroupsParamsWithHTTPClient(client *http.Client) *GroupsServiceListGroupsParams {
	return &GroupsServiceListGroupsParams{
		HTTPClient: client,
	}
}

/*
GroupsServiceListGroupsParams contains all the parameters to send to the API endpoint

	for the groups service list groups operation.

	Typically these are written to a http.Request.
*/
type GroupsServiceListGroupsParams struct {

	/* FilterGroupResourceIds.

	     group_resource_ids is a way to filter groups by a list of group
	ids when we need to resolve group attributes (e.g. name) from a
	list of ids we get from a project policy.
	*/
	FilterGroupResourceIds []string

	/* FilterMemberPrincipalID.

	   member_principal_id is an optional query param to filter groups that a principal belongs to.
	*/
	FilterMemberPrincipalID *string

	/* PaginationNextPageToken.

	     Specifies a page token to use to retrieve the next page. Set this to the
	`next_page_token` returned by previous list requests to get the next page of
	results. If set, `previous_page_token` must not be set.
	*/
	PaginationNextPageToken *string

	/* PaginationPageSize.

	     The max number of results per page that should be returned. If the number
	of available results is larger than `page_size`, a `next_page_token` is
	returned which can be used to get the next page of results in subsequent
	requests. A value of zero will cause `page_size` to be defaulted.

	     Format: int64
	*/
	PaginationPageSize *int64

	/* PaginationPreviousPageToken.

	     Specifies a page token to use to retrieve the previous page. Set this to
	the `previous_page_token` returned by previous list requests to get the
	previous page of results. If set, `next_page_token` must not be set.
	*/
	PaginationPreviousPageToken *string

	/* ParentResourceName.

	     parent_resource is the parent resource of the group.
	organization/<org_id>
	*/
	ParentResourceName string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the groups service list groups params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GroupsServiceListGroupsParams) WithDefaults() *GroupsServiceListGroupsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the groups service list groups params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GroupsServiceListGroupsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the groups service list groups params
func (o *GroupsServiceListGroupsParams) WithTimeout(timeout time.Duration) *GroupsServiceListGroupsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the groups service list groups params
func (o *GroupsServiceListGroupsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the groups service list groups params
func (o *GroupsServiceListGroupsParams) WithContext(ctx context.Context) *GroupsServiceListGroupsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the groups service list groups params
func (o *GroupsServiceListGroupsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the groups service list groups params
func (o *GroupsServiceListGroupsParams) WithHTTPClient(client *http.Client) *GroupsServiceListGroupsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the groups service list groups params
func (o *GroupsServiceListGroupsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilterGroupResourceIds adds the filterGroupResourceIds to the groups service list groups params
func (o *GroupsServiceListGroupsParams) WithFilterGroupResourceIds(filterGroupResourceIds []string) *GroupsServiceListGroupsParams {
	o.SetFilterGroupResourceIds(filterGroupResourceIds)
	return o
}

// SetFilterGroupResourceIds adds the filterGroupResourceIds to the groups service list groups params
func (o *GroupsServiceListGroupsParams) SetFilterGroupResourceIds(filterGroupResourceIds []string) {
	o.FilterGroupResourceIds = filterGroupResourceIds
}

// WithFilterMemberPrincipalID adds the filterMemberPrincipalID to the groups service list groups params
func (o *GroupsServiceListGroupsParams) WithFilterMemberPrincipalID(filterMemberPrincipalID *string) *GroupsServiceListGroupsParams {
	o.SetFilterMemberPrincipalID(filterMemberPrincipalID)
	return o
}

// SetFilterMemberPrincipalID adds the filterMemberPrincipalId to the groups service list groups params
func (o *GroupsServiceListGroupsParams) SetFilterMemberPrincipalID(filterMemberPrincipalID *string) {
	o.FilterMemberPrincipalID = filterMemberPrincipalID
}

// WithPaginationNextPageToken adds the paginationNextPageToken to the groups service list groups params
func (o *GroupsServiceListGroupsParams) WithPaginationNextPageToken(paginationNextPageToken *string) *GroupsServiceListGroupsParams {
	o.SetPaginationNextPageToken(paginationNextPageToken)
	return o
}

// SetPaginationNextPageToken adds the paginationNextPageToken to the groups service list groups params
func (o *GroupsServiceListGroupsParams) SetPaginationNextPageToken(paginationNextPageToken *string) {
	o.PaginationNextPageToken = paginationNextPageToken
}

// WithPaginationPageSize adds the paginationPageSize to the groups service list groups params
func (o *GroupsServiceListGroupsParams) WithPaginationPageSize(paginationPageSize *int64) *GroupsServiceListGroupsParams {
	o.SetPaginationPageSize(paginationPageSize)
	return o
}

// SetPaginationPageSize adds the paginationPageSize to the groups service list groups params
func (o *GroupsServiceListGroupsParams) SetPaginationPageSize(paginationPageSize *int64) {
	o.PaginationPageSize = paginationPageSize
}

// WithPaginationPreviousPageToken adds the paginationPreviousPageToken to the groups service list groups params
func (o *GroupsServiceListGroupsParams) WithPaginationPreviousPageToken(paginationPreviousPageToken *string) *GroupsServiceListGroupsParams {
	o.SetPaginationPreviousPageToken(paginationPreviousPageToken)
	return o
}

// SetPaginationPreviousPageToken adds the paginationPreviousPageToken to the groups service list groups params
func (o *GroupsServiceListGroupsParams) SetPaginationPreviousPageToken(paginationPreviousPageToken *string) {
	o.PaginationPreviousPageToken = paginationPreviousPageToken
}

// WithParentResourceName adds the parentResourceName to the groups service list groups params
func (o *GroupsServiceListGroupsParams) WithParentResourceName(parentResourceName string) *GroupsServiceListGroupsParams {
	o.SetParentResourceName(parentResourceName)
	return o
}

// SetParentResourceName adds the parentResourceName to the groups service list groups params
func (o *GroupsServiceListGroupsParams) SetParentResourceName(parentResourceName string) {
	o.ParentResourceName = parentResourceName
}

// WriteToRequest writes these params to a swagger request
func (o *GroupsServiceListGroupsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.FilterGroupResourceIds != nil {

		// binding items for filter.group_resource_ids
		joinedFilterGroupResourceIds := o.bindParamFilterGroupResourceIds(reg)

		// query array param filter.group_resource_ids
		if err := r.SetQueryParam("filter.group_resource_ids", joinedFilterGroupResourceIds...); err != nil {
			return err
		}
	}

	if o.FilterMemberPrincipalID != nil {

		// query param filter.member_principal_id
		var qrFilterMemberPrincipalID string

		if o.FilterMemberPrincipalID != nil {
			qrFilterMemberPrincipalID = *o.FilterMemberPrincipalID
		}
		qFilterMemberPrincipalID := qrFilterMemberPrincipalID
		if qFilterMemberPrincipalID != "" {

			if err := r.SetQueryParam("filter.member_principal_id", qFilterMemberPrincipalID); err != nil {
				return err
			}
		}
	}

	if o.PaginationNextPageToken != nil {

		// query param pagination.next_page_token
		var qrPaginationNextPageToken string

		if o.PaginationNextPageToken != nil {
			qrPaginationNextPageToken = *o.PaginationNextPageToken
		}
		qPaginationNextPageToken := qrPaginationNextPageToken
		if qPaginationNextPageToken != "" {

			if err := r.SetQueryParam("pagination.next_page_token", qPaginationNextPageToken); err != nil {
				return err
			}
		}
	}

	if o.PaginationPageSize != nil {

		// query param pagination.page_size
		var qrPaginationPageSize int64

		if o.PaginationPageSize != nil {
			qrPaginationPageSize = *o.PaginationPageSize
		}
		qPaginationPageSize := swag.FormatInt64(qrPaginationPageSize)
		if qPaginationPageSize != "" {

			if err := r.SetQueryParam("pagination.page_size", qPaginationPageSize); err != nil {
				return err
			}
		}
	}

	if o.PaginationPreviousPageToken != nil {

		// query param pagination.previous_page_token
		var qrPaginationPreviousPageToken string

		if o.PaginationPreviousPageToken != nil {
			qrPaginationPreviousPageToken = *o.PaginationPreviousPageToken
		}
		qPaginationPreviousPageToken := qrPaginationPreviousPageToken
		if qPaginationPreviousPageToken != "" {

			if err := r.SetQueryParam("pagination.previous_page_token", qPaginationPreviousPageToken); err != nil {
				return err
			}
		}
	}

	// path param parent_resource_name
	if err := r.SetPathParam("parent_resource_name", o.ParentResourceName); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGroupsServiceListGroups binds the parameter filter.group_resource_ids
func (o *GroupsServiceListGroupsParams) bindParamFilterGroupResourceIds(formats strfmt.Registry) []string {
	filterGroupResourceIdsIR := o.FilterGroupResourceIds

	var filterGroupResourceIdsIC []string
	for _, filterGroupResourceIdsIIR := range filterGroupResourceIdsIR { // explode []string

		filterGroupResourceIdsIIV := filterGroupResourceIdsIIR // string as string
		filterGroupResourceIdsIC = append(filterGroupResourceIdsIC, filterGroupResourceIdsIIV)
	}

	// items.CollectionFormat: "multi"
	filterGroupResourceIdsIS := swag.JoinByFormat(filterGroupResourceIdsIC, "multi")

	return filterGroupResourceIdsIS
}
