// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Billing20201105ContractBillingMethod ContractBillingMethod contains the information used to associate a Billing
// Account to a contract negotiated with our sales organization.
//
// swagger:model billing_20201105ContractBillingMethod
type Billing20201105ContractBillingMethod struct {

	// created_at is the time at which the Contract was created.
	// Format: date-time
	CreatedAt strfmt.DateTime `json:"created_at,omitempty"`

	// reference is the unique reference number, provided to the customer, which
	// allows them to associate a Billing Account to their sales contract.
	Reference string `json:"reference,omitempty"`
}

// Validate validates this billing 20201105 contract billing method
func (m *Billing20201105ContractBillingMethod) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Billing20201105ContractBillingMethod) validateCreatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.CreatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("created_at", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this billing 20201105 contract billing method based on context it is used
func (m *Billing20201105ContractBillingMethod) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *Billing20201105ContractBillingMethod) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Billing20201105ContractBillingMethod) UnmarshalBinary(b []byte) error {
	var res Billing20201105ContractBillingMethod
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
