// Code generated by go-swagger; DO NOT EDIT.

package contract_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewContractServiceListContractsParams creates a new ContractServiceListContractsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewContractServiceListContractsParams() *ContractServiceListContractsParams {
	return &ContractServiceListContractsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewContractServiceListContractsParamsWithTimeout creates a new ContractServiceListContractsParams object
// with the ability to set a timeout on a request.
func NewContractServiceListContractsParamsWithTimeout(timeout time.Duration) *ContractServiceListContractsParams {
	return &ContractServiceListContractsParams{
		timeout: timeout,
	}
}

// NewContractServiceListContractsParamsWithContext creates a new ContractServiceListContractsParams object
// with the ability to set a context for a request.
func NewContractServiceListContractsParamsWithContext(ctx context.Context) *ContractServiceListContractsParams {
	return &ContractServiceListContractsParams{
		Context: ctx,
	}
}

// NewContractServiceListContractsParamsWithHTTPClient creates a new ContractServiceListContractsParams object
// with the ability to set a custom HTTPClient for a request.
func NewContractServiceListContractsParamsWithHTTPClient(client *http.Client) *ContractServiceListContractsParams {
	return &ContractServiceListContractsParams{
		HTTPClient: client,
	}
}

/*
ContractServiceListContractsParams contains all the parameters to send to the API endpoint

	for the contract service list contracts operation.

	Typically these are written to a http.Request.
*/
type ContractServiceListContractsParams struct {

	/* BillingAccountID.

	   blling_account_id is the identifier of the list of contracts' billing account.
	*/
	BillingAccountID string

	/* ByActiveFrom.

	   Query param filter: `by_active_from` filters by the date the contract starts.

	   Format: date-time
	*/
	ByActiveFrom *strfmt.DateTime

	/* ByActiveUntil.

	   Query param filter: `by_active_until` filters by the date the contract ends.

	   Format: date-time
	*/
	ByActiveUntil *strfmt.DateTime

	/* ByStatus.

	   Query param filter: `by_status` filters by contract status/
	*/
	ByStatus []string

	/* OrganizationID.

	   organization_id is the organization where list of contracts' billing account belongs.
	*/
	OrganizationID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the contract service list contracts params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContractServiceListContractsParams) WithDefaults() *ContractServiceListContractsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the contract service list contracts params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContractServiceListContractsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the contract service list contracts params
func (o *ContractServiceListContractsParams) WithTimeout(timeout time.Duration) *ContractServiceListContractsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the contract service list contracts params
func (o *ContractServiceListContractsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the contract service list contracts params
func (o *ContractServiceListContractsParams) WithContext(ctx context.Context) *ContractServiceListContractsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the contract service list contracts params
func (o *ContractServiceListContractsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the contract service list contracts params
func (o *ContractServiceListContractsParams) WithHTTPClient(client *http.Client) *ContractServiceListContractsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the contract service list contracts params
func (o *ContractServiceListContractsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBillingAccountID adds the billingAccountID to the contract service list contracts params
func (o *ContractServiceListContractsParams) WithBillingAccountID(billingAccountID string) *ContractServiceListContractsParams {
	o.SetBillingAccountID(billingAccountID)
	return o
}

// SetBillingAccountID adds the billingAccountId to the contract service list contracts params
func (o *ContractServiceListContractsParams) SetBillingAccountID(billingAccountID string) {
	o.BillingAccountID = billingAccountID
}

// WithByActiveFrom adds the byActiveFrom to the contract service list contracts params
func (o *ContractServiceListContractsParams) WithByActiveFrom(byActiveFrom *strfmt.DateTime) *ContractServiceListContractsParams {
	o.SetByActiveFrom(byActiveFrom)
	return o
}

// SetByActiveFrom adds the byActiveFrom to the contract service list contracts params
func (o *ContractServiceListContractsParams) SetByActiveFrom(byActiveFrom *strfmt.DateTime) {
	o.ByActiveFrom = byActiveFrom
}

// WithByActiveUntil adds the byActiveUntil to the contract service list contracts params
func (o *ContractServiceListContractsParams) WithByActiveUntil(byActiveUntil *strfmt.DateTime) *ContractServiceListContractsParams {
	o.SetByActiveUntil(byActiveUntil)
	return o
}

// SetByActiveUntil adds the byActiveUntil to the contract service list contracts params
func (o *ContractServiceListContractsParams) SetByActiveUntil(byActiveUntil *strfmt.DateTime) {
	o.ByActiveUntil = byActiveUntil
}

// WithByStatus adds the byStatus to the contract service list contracts params
func (o *ContractServiceListContractsParams) WithByStatus(byStatus []string) *ContractServiceListContractsParams {
	o.SetByStatus(byStatus)
	return o
}

// SetByStatus adds the byStatus to the contract service list contracts params
func (o *ContractServiceListContractsParams) SetByStatus(byStatus []string) {
	o.ByStatus = byStatus
}

// WithOrganizationID adds the organizationID to the contract service list contracts params
func (o *ContractServiceListContractsParams) WithOrganizationID(organizationID string) *ContractServiceListContractsParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the contract service list contracts params
func (o *ContractServiceListContractsParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WriteToRequest writes these params to a swagger request
func (o *ContractServiceListContractsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param billing_account_id
	if err := r.SetPathParam("billing_account_id", o.BillingAccountID); err != nil {
		return err
	}

	if o.ByActiveFrom != nil {

		// query param by_active_from
		var qrByActiveFrom strfmt.DateTime

		if o.ByActiveFrom != nil {
			qrByActiveFrom = *o.ByActiveFrom
		}
		qByActiveFrom := qrByActiveFrom.String()
		if qByActiveFrom != "" {

			if err := r.SetQueryParam("by_active_from", qByActiveFrom); err != nil {
				return err
			}
		}
	}

	if o.ByActiveUntil != nil {

		// query param by_active_until
		var qrByActiveUntil strfmt.DateTime

		if o.ByActiveUntil != nil {
			qrByActiveUntil = *o.ByActiveUntil
		}
		qByActiveUntil := qrByActiveUntil.String()
		if qByActiveUntil != "" {

			if err := r.SetQueryParam("by_active_until", qByActiveUntil); err != nil {
				return err
			}
		}
	}

	if o.ByStatus != nil {

		// binding items for by_status
		joinedByStatus := o.bindParamByStatus(reg)

		// query array param by_status
		if err := r.SetQueryParam("by_status", joinedByStatus...); err != nil {
			return err
		}
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamContractServiceListContracts binds the parameter by_status
func (o *ContractServiceListContractsParams) bindParamByStatus(formats strfmt.Registry) []string {
	byStatusIR := o.ByStatus

	var byStatusIC []string
	for _, byStatusIIR := range byStatusIR { // explode []string

		byStatusIIV := byStatusIIR // string as string
		byStatusIC = append(byStatusIC, byStatusIIV)
	}

	// items.CollectionFormat: "multi"
	byStatusIS := swag.JoinByFormat(byStatusIC, "multi")

	return byStatusIS
}
