// Code generated by go-swagger; DO NOT EDIT.

package webhook_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-webhook/stable/2023-05-31/models"
)

// WebhookServiceUpdateWebhookReader is a Reader for the WebhookServiceUpdateWebhook structure.
type WebhookServiceUpdateWebhookReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WebhookServiceUpdateWebhookReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWebhookServiceUpdateWebhookOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWebhookServiceUpdateWebhookDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWebhookServiceUpdateWebhookOK creates a WebhookServiceUpdateWebhookOK with default headers values
func NewWebhookServiceUpdateWebhookOK() *WebhookServiceUpdateWebhookOK {
	return &WebhookServiceUpdateWebhookOK{}
}

/*
WebhookServiceUpdateWebhookOK describes a response with status code 200, with default header values.

A successful response.
*/
type WebhookServiceUpdateWebhookOK struct {
	Payload *models.HashicorpCloudWebhookUpdateWebhookResponse
}

// IsSuccess returns true when this webhook service update webhook o k response has a 2xx status code
func (o *WebhookServiceUpdateWebhookOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this webhook service update webhook o k response has a 3xx status code
func (o *WebhookServiceUpdateWebhookOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this webhook service update webhook o k response has a 4xx status code
func (o *WebhookServiceUpdateWebhookOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this webhook service update webhook o k response has a 5xx status code
func (o *WebhookServiceUpdateWebhookOK) IsServerError() bool {
	return false
}

// IsCode returns true when this webhook service update webhook o k response a status code equal to that given
func (o *WebhookServiceUpdateWebhookOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the webhook service update webhook o k response
func (o *WebhookServiceUpdateWebhookOK) Code() int {
	return 200
}

func (o *WebhookServiceUpdateWebhookOK) Error() string {
	return fmt.Sprintf("[PATCH /2023-05-31/{resource_name}][%d] webhookServiceUpdateWebhookOK  %+v", 200, o.Payload)
}

func (o *WebhookServiceUpdateWebhookOK) String() string {
	return fmt.Sprintf("[PATCH /2023-05-31/{resource_name}][%d] webhookServiceUpdateWebhookOK  %+v", 200, o.Payload)
}

func (o *WebhookServiceUpdateWebhookOK) GetPayload() *models.HashicorpCloudWebhookUpdateWebhookResponse {
	return o.Payload
}

func (o *WebhookServiceUpdateWebhookOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWebhookUpdateWebhookResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWebhookServiceUpdateWebhookDefault creates a WebhookServiceUpdateWebhookDefault with default headers values
func NewWebhookServiceUpdateWebhookDefault(code int) *WebhookServiceUpdateWebhookDefault {
	return &WebhookServiceUpdateWebhookDefault{
		_statusCode: code,
	}
}

/*
WebhookServiceUpdateWebhookDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WebhookServiceUpdateWebhookDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this webhook service update webhook default response has a 2xx status code
func (o *WebhookServiceUpdateWebhookDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this webhook service update webhook default response has a 3xx status code
func (o *WebhookServiceUpdateWebhookDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this webhook service update webhook default response has a 4xx status code
func (o *WebhookServiceUpdateWebhookDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this webhook service update webhook default response has a 5xx status code
func (o *WebhookServiceUpdateWebhookDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this webhook service update webhook default response a status code equal to that given
func (o *WebhookServiceUpdateWebhookDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the webhook service update webhook default response
func (o *WebhookServiceUpdateWebhookDefault) Code() int {
	return o._statusCode
}

func (o *WebhookServiceUpdateWebhookDefault) Error() string {
	return fmt.Sprintf("[PATCH /2023-05-31/{resource_name}][%d] WebhookService_UpdateWebhook default  %+v", o._statusCode, o.Payload)
}

func (o *WebhookServiceUpdateWebhookDefault) String() string {
	return fmt.Sprintf("[PATCH /2023-05-31/{resource_name}][%d] WebhookService_UpdateWebhook default  %+v", o._statusCode, o.Payload)
}

func (o *WebhookServiceUpdateWebhookDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WebhookServiceUpdateWebhookDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
