// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2024-11-22/models"
)

// WaypointServiceListActionConfigsReader is a Reader for the WaypointServiceListActionConfigs structure.
type WaypointServiceListActionConfigsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceListActionConfigsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceListActionConfigsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceListActionConfigsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceListActionConfigsOK creates a WaypointServiceListActionConfigsOK with default headers values
func NewWaypointServiceListActionConfigsOK() *WaypointServiceListActionConfigsOK {
	return &WaypointServiceListActionConfigsOK{}
}

/*
WaypointServiceListActionConfigsOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceListActionConfigsOK struct {
	Payload *models.HashicorpCloudWaypointListActionConfigResponse
}

// IsSuccess returns true when this waypoint service list action configs o k response has a 2xx status code
func (o *WaypointServiceListActionConfigsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service list action configs o k response has a 3xx status code
func (o *WaypointServiceListActionConfigsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service list action configs o k response has a 4xx status code
func (o *WaypointServiceListActionConfigsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service list action configs o k response has a 5xx status code
func (o *WaypointServiceListActionConfigsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service list action configs o k response a status code equal to that given
func (o *WaypointServiceListActionConfigsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service list action configs o k response
func (o *WaypointServiceListActionConfigsOK) Code() int {
	return 200
}

func (o *WaypointServiceListActionConfigsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/actionconfigs][%d] waypointServiceListActionConfigsOK %s", 200, payload)
}

func (o *WaypointServiceListActionConfigsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/actionconfigs][%d] waypointServiceListActionConfigsOK %s", 200, payload)
}

func (o *WaypointServiceListActionConfigsOK) GetPayload() *models.HashicorpCloudWaypointListActionConfigResponse {
	return o.Payload
}

func (o *WaypointServiceListActionConfigsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointListActionConfigResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceListActionConfigsDefault creates a WaypointServiceListActionConfigsDefault with default headers values
func NewWaypointServiceListActionConfigsDefault(code int) *WaypointServiceListActionConfigsDefault {
	return &WaypointServiceListActionConfigsDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceListActionConfigsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceListActionConfigsDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service list action configs default response has a 2xx status code
func (o *WaypointServiceListActionConfigsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service list action configs default response has a 3xx status code
func (o *WaypointServiceListActionConfigsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service list action configs default response has a 4xx status code
func (o *WaypointServiceListActionConfigsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service list action configs default response has a 5xx status code
func (o *WaypointServiceListActionConfigsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service list action configs default response a status code equal to that given
func (o *WaypointServiceListActionConfigsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service list action configs default response
func (o *WaypointServiceListActionConfigsDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceListActionConfigsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/actionconfigs][%d] WaypointService_ListActionConfigs default %s", o._statusCode, payload)
}

func (o *WaypointServiceListActionConfigsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/actionconfigs][%d] WaypointService_ListActionConfigs default %s", o._statusCode, payload)
}

func (o *WaypointServiceListActionConfigsDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceListActionConfigsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
