// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceGetTFWorkspaceInfoReader is a Reader for the WaypointServiceGetTFWorkspaceInfo structure.
type WaypointServiceGetTFWorkspaceInfoReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceGetTFWorkspaceInfoReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceGetTFWorkspaceInfoOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceGetTFWorkspaceInfoDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceGetTFWorkspaceInfoOK creates a WaypointServiceGetTFWorkspaceInfoOK with default headers values
func NewWaypointServiceGetTFWorkspaceInfoOK() *WaypointServiceGetTFWorkspaceInfoOK {
	return &WaypointServiceGetTFWorkspaceInfoOK{}
}

/*
WaypointServiceGetTFWorkspaceInfoOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceGetTFWorkspaceInfoOK struct {
	Payload *models.HashicorpCloudWaypointGetTFWorkspaceInfoResponse
}

// IsSuccess returns true when this waypoint service get t f workspace info o k response has a 2xx status code
func (o *WaypointServiceGetTFWorkspaceInfoOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service get t f workspace info o k response has a 3xx status code
func (o *WaypointServiceGetTFWorkspaceInfoOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service get t f workspace info o k response has a 4xx status code
func (o *WaypointServiceGetTFWorkspaceInfoOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service get t f workspace info o k response has a 5xx status code
func (o *WaypointServiceGetTFWorkspaceInfoOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service get t f workspace info o k response a status code equal to that given
func (o *WaypointServiceGetTFWorkspaceInfoOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service get t f workspace info o k response
func (o *WaypointServiceGetTFWorkspaceInfoOK) Code() int {
	return 200
}

func (o *WaypointServiceGetTFWorkspaceInfoOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/application/{application.id}/workspace][%d] waypointServiceGetTFWorkspaceInfoOK %s", 200, payload)
}

func (o *WaypointServiceGetTFWorkspaceInfoOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/application/{application.id}/workspace][%d] waypointServiceGetTFWorkspaceInfoOK %s", 200, payload)
}

func (o *WaypointServiceGetTFWorkspaceInfoOK) GetPayload() *models.HashicorpCloudWaypointGetTFWorkspaceInfoResponse {
	return o.Payload
}

func (o *WaypointServiceGetTFWorkspaceInfoOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointGetTFWorkspaceInfoResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceGetTFWorkspaceInfoDefault creates a WaypointServiceGetTFWorkspaceInfoDefault with default headers values
func NewWaypointServiceGetTFWorkspaceInfoDefault(code int) *WaypointServiceGetTFWorkspaceInfoDefault {
	return &WaypointServiceGetTFWorkspaceInfoDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceGetTFWorkspaceInfoDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceGetTFWorkspaceInfoDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service get t f workspace info default response has a 2xx status code
func (o *WaypointServiceGetTFWorkspaceInfoDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service get t f workspace info default response has a 3xx status code
func (o *WaypointServiceGetTFWorkspaceInfoDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service get t f workspace info default response has a 4xx status code
func (o *WaypointServiceGetTFWorkspaceInfoDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service get t f workspace info default response has a 5xx status code
func (o *WaypointServiceGetTFWorkspaceInfoDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service get t f workspace info default response a status code equal to that given
func (o *WaypointServiceGetTFWorkspaceInfoDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service get t f workspace info default response
func (o *WaypointServiceGetTFWorkspaceInfoDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceGetTFWorkspaceInfoDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/application/{application.id}/workspace][%d] WaypointService_GetTFWorkspaceInfo default %s", o._statusCode, payload)
}

func (o *WaypointServiceGetTFWorkspaceInfoDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/application/{application.id}/workspace][%d] WaypointService_GetTFWorkspaceInfo default %s", o._statusCode, payload)
}

func (o *WaypointServiceGetTFWorkspaceInfoDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceGetTFWorkspaceInfoDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
