// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// LockProjectReader is a Reader for the LockProject structure.
type LockProjectReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LockProjectReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLockProjectOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLockProjectDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLockProjectOK creates a LockProjectOK with default headers values
func NewLockProjectOK() *LockProjectOK {
	return &LockProjectOK{}
}

/*
LockProjectOK describes a response with status code 200, with default header values.

A successful response.
*/
type LockProjectOK struct {
	Payload models.Secrets20231128LockProjectResponse
}

// IsSuccess returns true when this lock project o k response has a 2xx status code
func (o *LockProjectOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this lock project o k response has a 3xx status code
func (o *LockProjectOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this lock project o k response has a 4xx status code
func (o *LockProjectOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this lock project o k response has a 5xx status code
func (o *LockProjectOK) IsServerError() bool {
	return false
}

// IsCode returns true when this lock project o k response a status code equal to that given
func (o *LockProjectOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the lock project o k response
func (o *LockProjectOK) Code() int {
	return 200
}

func (o *LockProjectOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/lock][%d] lockProjectOK %s", 200, payload)
}

func (o *LockProjectOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/lock][%d] lockProjectOK %s", 200, payload)
}

func (o *LockProjectOK) GetPayload() models.Secrets20231128LockProjectResponse {
	return o.Payload
}

func (o *LockProjectOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewLockProjectDefault creates a LockProjectDefault with default headers values
func NewLockProjectDefault(code int) *LockProjectDefault {
	return &LockProjectDefault{
		_statusCode: code,
	}
}

/*
LockProjectDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type LockProjectDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this lock project default response has a 2xx status code
func (o *LockProjectDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this lock project default response has a 3xx status code
func (o *LockProjectDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this lock project default response has a 4xx status code
func (o *LockProjectDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this lock project default response has a 5xx status code
func (o *LockProjectDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this lock project default response a status code equal to that given
func (o *LockProjectDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the lock project default response
func (o *LockProjectDefault) Code() int {
	return o._statusCode
}

func (o *LockProjectDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/lock][%d] LockProject default %s", o._statusCode, payload)
}

func (o *LockProjectDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/lock][%d] LockProject default %s", o._statusCode, payload)
}

func (o *LockProjectDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *LockProjectDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
