// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// GetGcpIntegrationReader is a Reader for the GetGcpIntegration structure.
type GetGcpIntegrationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetGcpIntegrationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetGcpIntegrationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetGcpIntegrationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetGcpIntegrationOK creates a GetGcpIntegrationOK with default headers values
func NewGetGcpIntegrationOK() *GetGcpIntegrationOK {
	return &GetGcpIntegrationOK{}
}

/*
GetGcpIntegrationOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetGcpIntegrationOK struct {
	Payload *models.Secrets20231128GetGcpIntegrationResponse
}

// IsSuccess returns true when this get gcp integration o k response has a 2xx status code
func (o *GetGcpIntegrationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get gcp integration o k response has a 3xx status code
func (o *GetGcpIntegrationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get gcp integration o k response has a 4xx status code
func (o *GetGcpIntegrationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get gcp integration o k response has a 5xx status code
func (o *GetGcpIntegrationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get gcp integration o k response a status code equal to that given
func (o *GetGcpIntegrationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get gcp integration o k response
func (o *GetGcpIntegrationOK) Code() int {
	return 200
}

func (o *GetGcpIntegrationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/gcp/config/{name}][%d] getGcpIntegrationOK %s", 200, payload)
}

func (o *GetGcpIntegrationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/gcp/config/{name}][%d] getGcpIntegrationOK %s", 200, payload)
}

func (o *GetGcpIntegrationOK) GetPayload() *models.Secrets20231128GetGcpIntegrationResponse {
	return o.Payload
}

func (o *GetGcpIntegrationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128GetGcpIntegrationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetGcpIntegrationDefault creates a GetGcpIntegrationDefault with default headers values
func NewGetGcpIntegrationDefault(code int) *GetGcpIntegrationDefault {
	return &GetGcpIntegrationDefault{
		_statusCode: code,
	}
}

/*
GetGcpIntegrationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetGcpIntegrationDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this get gcp integration default response has a 2xx status code
func (o *GetGcpIntegrationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get gcp integration default response has a 3xx status code
func (o *GetGcpIntegrationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get gcp integration default response has a 4xx status code
func (o *GetGcpIntegrationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get gcp integration default response has a 5xx status code
func (o *GetGcpIntegrationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get gcp integration default response a status code equal to that given
func (o *GetGcpIntegrationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get gcp integration default response
func (o *GetGcpIntegrationDefault) Code() int {
	return o._statusCode
}

func (o *GetGcpIntegrationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/gcp/config/{name}][%d] GetGcpIntegration default %s", o._statusCode, payload)
}

func (o *GetGcpIntegrationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/gcp/config/{name}][%d] GetGcpIntegration default %s", o._statusCode, payload)
}

func (o *GetGcpIntegrationDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *GetGcpIntegrationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
