// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetAppSecretVersionParams creates a new GetAppSecretVersionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetAppSecretVersionParams() *GetAppSecretVersionParams {
	return &GetAppSecretVersionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetAppSecretVersionParamsWithTimeout creates a new GetAppSecretVersionParams object
// with the ability to set a timeout on a request.
func NewGetAppSecretVersionParamsWithTimeout(timeout time.Duration) *GetAppSecretVersionParams {
	return &GetAppSecretVersionParams{
		timeout: timeout,
	}
}

// NewGetAppSecretVersionParamsWithContext creates a new GetAppSecretVersionParams object
// with the ability to set a context for a request.
func NewGetAppSecretVersionParamsWithContext(ctx context.Context) *GetAppSecretVersionParams {
	return &GetAppSecretVersionParams{
		Context: ctx,
	}
}

// NewGetAppSecretVersionParamsWithHTTPClient creates a new GetAppSecretVersionParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetAppSecretVersionParamsWithHTTPClient(client *http.Client) *GetAppSecretVersionParams {
	return &GetAppSecretVersionParams{
		HTTPClient: client,
	}
}

/*
GetAppSecretVersionParams contains all the parameters to send to the API endpoint

	for the get app secret version operation.

	Typically these are written to a http.Request.
*/
type GetAppSecretVersionParams struct {

	// AppName.
	AppName string

	// OrganizationID.
	OrganizationID string

	// ProjectID.
	ProjectID string

	// SecretName.
	SecretName string

	// Version.
	//
	// Format: int64
	Version int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get app secret version params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAppSecretVersionParams) WithDefaults() *GetAppSecretVersionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get app secret version params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAppSecretVersionParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get app secret version params
func (o *GetAppSecretVersionParams) WithTimeout(timeout time.Duration) *GetAppSecretVersionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get app secret version params
func (o *GetAppSecretVersionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get app secret version params
func (o *GetAppSecretVersionParams) WithContext(ctx context.Context) *GetAppSecretVersionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get app secret version params
func (o *GetAppSecretVersionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get app secret version params
func (o *GetAppSecretVersionParams) WithHTTPClient(client *http.Client) *GetAppSecretVersionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get app secret version params
func (o *GetAppSecretVersionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAppName adds the appName to the get app secret version params
func (o *GetAppSecretVersionParams) WithAppName(appName string) *GetAppSecretVersionParams {
	o.SetAppName(appName)
	return o
}

// SetAppName adds the appName to the get app secret version params
func (o *GetAppSecretVersionParams) SetAppName(appName string) {
	o.AppName = appName
}

// WithOrganizationID adds the organizationID to the get app secret version params
func (o *GetAppSecretVersionParams) WithOrganizationID(organizationID string) *GetAppSecretVersionParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the get app secret version params
func (o *GetAppSecretVersionParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WithProjectID adds the projectID to the get app secret version params
func (o *GetAppSecretVersionParams) WithProjectID(projectID string) *GetAppSecretVersionParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the get app secret version params
func (o *GetAppSecretVersionParams) SetProjectID(projectID string) {
	o.ProjectID = projectID
}

// WithSecretName adds the secretName to the get app secret version params
func (o *GetAppSecretVersionParams) WithSecretName(secretName string) *GetAppSecretVersionParams {
	o.SetSecretName(secretName)
	return o
}

// SetSecretName adds the secretName to the get app secret version params
func (o *GetAppSecretVersionParams) SetSecretName(secretName string) {
	o.SecretName = secretName
}

// WithVersion adds the version to the get app secret version params
func (o *GetAppSecretVersionParams) WithVersion(version int64) *GetAppSecretVersionParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the get app secret version params
func (o *GetAppSecretVersionParams) SetVersion(version int64) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *GetAppSecretVersionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param app_name
	if err := r.SetPathParam("app_name", o.AppName); err != nil {
		return err
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	// path param project_id
	if err := r.SetPathParam("project_id", o.ProjectID); err != nil {
		return err
	}

	// path param secret_name
	if err := r.SetPathParam("secret_name", o.SecretName); err != nil {
		return err
	}

	// path param version
	if err := r.SetPathParam("version", swag.FormatInt64(o.Version)); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
