// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewGetAppParams creates a new GetAppParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetAppParams() *GetAppParams {
	return &GetAppParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetAppParamsWithTimeout creates a new GetAppParams object
// with the ability to set a timeout on a request.
func NewGetAppParamsWithTimeout(timeout time.Duration) *GetAppParams {
	return &GetAppParams{
		timeout: timeout,
	}
}

// NewGetAppParamsWithContext creates a new GetAppParams object
// with the ability to set a context for a request.
func NewGetAppParamsWithContext(ctx context.Context) *GetAppParams {
	return &GetAppParams{
		Context: ctx,
	}
}

// NewGetAppParamsWithHTTPClient creates a new GetAppParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetAppParamsWithHTTPClient(client *http.Client) *GetAppParams {
	return &GetAppParams{
		HTTPClient: client,
	}
}

/*
GetAppParams contains all the parameters to send to the API endpoint

	for the get app operation.

	Typically these are written to a http.Request.
*/
type GetAppParams struct {

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	LocationRegionRegion *string

	// Name.
	Name string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get app params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAppParams) WithDefaults() *GetAppParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get app params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAppParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get app params
func (o *GetAppParams) WithTimeout(timeout time.Duration) *GetAppParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get app params
func (o *GetAppParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get app params
func (o *GetAppParams) WithContext(ctx context.Context) *GetAppParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get app params
func (o *GetAppParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get app params
func (o *GetAppParams) WithHTTPClient(client *http.Client) *GetAppParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get app params
func (o *GetAppParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithLocationOrganizationID adds the locationOrganizationID to the get app params
func (o *GetAppParams) WithLocationOrganizationID(locationOrganizationID string) *GetAppParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the get app params
func (o *GetAppParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the get app params
func (o *GetAppParams) WithLocationProjectID(locationProjectID string) *GetAppParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the get app params
func (o *GetAppParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the get app params
func (o *GetAppParams) WithLocationRegionProvider(locationRegionProvider *string) *GetAppParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the get app params
func (o *GetAppParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the get app params
func (o *GetAppParams) WithLocationRegionRegion(locationRegionRegion *string) *GetAppParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the get app params
func (o *GetAppParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WithName adds the name to the get app params
func (o *GetAppParams) WithName(name string) *GetAppParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the get app params
func (o *GetAppParams) SetName(name string) {
	o.Name = name
}

// WriteToRequest writes these params to a swagger request
func (o *GetAppParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
