// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDeleteSyncIntegrationParams creates a new DeleteSyncIntegrationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeleteSyncIntegrationParams() *DeleteSyncIntegrationParams {
	return &DeleteSyncIntegrationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteSyncIntegrationParamsWithTimeout creates a new DeleteSyncIntegrationParams object
// with the ability to set a timeout on a request.
func NewDeleteSyncIntegrationParamsWithTimeout(timeout time.Duration) *DeleteSyncIntegrationParams {
	return &DeleteSyncIntegrationParams{
		timeout: timeout,
	}
}

// NewDeleteSyncIntegrationParamsWithContext creates a new DeleteSyncIntegrationParams object
// with the ability to set a context for a request.
func NewDeleteSyncIntegrationParamsWithContext(ctx context.Context) *DeleteSyncIntegrationParams {
	return &DeleteSyncIntegrationParams{
		Context: ctx,
	}
}

// NewDeleteSyncIntegrationParamsWithHTTPClient creates a new DeleteSyncIntegrationParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeleteSyncIntegrationParamsWithHTTPClient(client *http.Client) *DeleteSyncIntegrationParams {
	return &DeleteSyncIntegrationParams{
		HTTPClient: client,
	}
}

/*
DeleteSyncIntegrationParams contains all the parameters to send to the API endpoint

	for the delete sync integration operation.

	Typically these are written to a http.Request.
*/
type DeleteSyncIntegrationParams struct {

	// CascadeDelete.
	CascadeDelete *bool

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	LocationRegionRegion *string

	// Name.
	Name string

	// PurgeSyncedSecrets.
	PurgeSyncedSecrets *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete sync integration params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteSyncIntegrationParams) WithDefaults() *DeleteSyncIntegrationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete sync integration params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteSyncIntegrationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete sync integration params
func (o *DeleteSyncIntegrationParams) WithTimeout(timeout time.Duration) *DeleteSyncIntegrationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete sync integration params
func (o *DeleteSyncIntegrationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete sync integration params
func (o *DeleteSyncIntegrationParams) WithContext(ctx context.Context) *DeleteSyncIntegrationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete sync integration params
func (o *DeleteSyncIntegrationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete sync integration params
func (o *DeleteSyncIntegrationParams) WithHTTPClient(client *http.Client) *DeleteSyncIntegrationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete sync integration params
func (o *DeleteSyncIntegrationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCascadeDelete adds the cascadeDelete to the delete sync integration params
func (o *DeleteSyncIntegrationParams) WithCascadeDelete(cascadeDelete *bool) *DeleteSyncIntegrationParams {
	o.SetCascadeDelete(cascadeDelete)
	return o
}

// SetCascadeDelete adds the cascadeDelete to the delete sync integration params
func (o *DeleteSyncIntegrationParams) SetCascadeDelete(cascadeDelete *bool) {
	o.CascadeDelete = cascadeDelete
}

// WithLocationOrganizationID adds the locationOrganizationID to the delete sync integration params
func (o *DeleteSyncIntegrationParams) WithLocationOrganizationID(locationOrganizationID string) *DeleteSyncIntegrationParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the delete sync integration params
func (o *DeleteSyncIntegrationParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the delete sync integration params
func (o *DeleteSyncIntegrationParams) WithLocationProjectID(locationProjectID string) *DeleteSyncIntegrationParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the delete sync integration params
func (o *DeleteSyncIntegrationParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the delete sync integration params
func (o *DeleteSyncIntegrationParams) WithLocationRegionProvider(locationRegionProvider *string) *DeleteSyncIntegrationParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the delete sync integration params
func (o *DeleteSyncIntegrationParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the delete sync integration params
func (o *DeleteSyncIntegrationParams) WithLocationRegionRegion(locationRegionRegion *string) *DeleteSyncIntegrationParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the delete sync integration params
func (o *DeleteSyncIntegrationParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WithName adds the name to the delete sync integration params
func (o *DeleteSyncIntegrationParams) WithName(name string) *DeleteSyncIntegrationParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the delete sync integration params
func (o *DeleteSyncIntegrationParams) SetName(name string) {
	o.Name = name
}

// WithPurgeSyncedSecrets adds the purgeSyncedSecrets to the delete sync integration params
func (o *DeleteSyncIntegrationParams) WithPurgeSyncedSecrets(purgeSyncedSecrets *bool) *DeleteSyncIntegrationParams {
	o.SetPurgeSyncedSecrets(purgeSyncedSecrets)
	return o
}

// SetPurgeSyncedSecrets adds the purgeSyncedSecrets to the delete sync integration params
func (o *DeleteSyncIntegrationParams) SetPurgeSyncedSecrets(purgeSyncedSecrets *bool) {
	o.PurgeSyncedSecrets = purgeSyncedSecrets
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteSyncIntegrationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CascadeDelete != nil {

		// query param cascade_delete
		var qrCascadeDelete bool

		if o.CascadeDelete != nil {
			qrCascadeDelete = *o.CascadeDelete
		}
		qCascadeDelete := swag.FormatBool(qrCascadeDelete)
		if qCascadeDelete != "" {

			if err := r.SetQueryParam("cascade_delete", qCascadeDelete); err != nil {
				return err
			}
		}
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.PurgeSyncedSecrets != nil {

		// query param purge_synced_secrets
		var qrPurgeSyncedSecrets bool

		if o.PurgeSyncedSecrets != nil {
			qrPurgeSyncedSecrets = *o.PurgeSyncedSecrets
		}
		qPurgeSyncedSecrets := swag.FormatBool(qrPurgeSyncedSecrets)
		if qPurgeSyncedSecrets != "" {

			if err := r.SetQueryParam("purge_synced_secrets", qPurgeSyncedSecrets); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
