// Code generated by go-swagger; DO NOT EDIT.

package data_source_registration_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewOnboardDataSourceParams creates a new OnboardDataSourceParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewOnboardDataSourceParams() *OnboardDataSourceParams {
	return &OnboardDataSourceParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewOnboardDataSourceParamsWithTimeout creates a new OnboardDataSourceParams object
// with the ability to set a timeout on a request.
func NewOnboardDataSourceParamsWithTimeout(timeout time.Duration) *OnboardDataSourceParams {
	return &OnboardDataSourceParams{
		timeout: timeout,
	}
}

// NewOnboardDataSourceParamsWithContext creates a new OnboardDataSourceParams object
// with the ability to set a context for a request.
func NewOnboardDataSourceParamsWithContext(ctx context.Context) *OnboardDataSourceParams {
	return &OnboardDataSourceParams{
		Context: ctx,
	}
}

// NewOnboardDataSourceParamsWithHTTPClient creates a new OnboardDataSourceParams object
// with the ability to set a custom HTTPClient for a request.
func NewOnboardDataSourceParamsWithHTTPClient(client *http.Client) *OnboardDataSourceParams {
	return &OnboardDataSourceParams{
		HTTPClient: client,
	}
}

/*
OnboardDataSourceParams contains all the parameters to send to the API endpoint

	for the onboard data source operation.

	Typically these are written to a http.Request.
*/
type OnboardDataSourceParams struct {

	// Body.
	Body OnboardDataSourceBody

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the onboard data source params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *OnboardDataSourceParams) WithDefaults() *OnboardDataSourceParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the onboard data source params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *OnboardDataSourceParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the onboard data source params
func (o *OnboardDataSourceParams) WithTimeout(timeout time.Duration) *OnboardDataSourceParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the onboard data source params
func (o *OnboardDataSourceParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the onboard data source params
func (o *OnboardDataSourceParams) WithContext(ctx context.Context) *OnboardDataSourceParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the onboard data source params
func (o *OnboardDataSourceParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the onboard data source params
func (o *OnboardDataSourceParams) WithHTTPClient(client *http.Client) *OnboardDataSourceParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the onboard data source params
func (o *OnboardDataSourceParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the onboard data source params
func (o *OnboardDataSourceParams) WithBody(body OnboardDataSourceBody) *OnboardDataSourceParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the onboard data source params
func (o *OnboardDataSourceParams) SetBody(body OnboardDataSourceBody) {
	o.Body = body
}

// WithLocationProjectID adds the locationProjectID to the onboard data source params
func (o *OnboardDataSourceParams) WithLocationProjectID(locationProjectID string) *OnboardDataSourceParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the onboard data source params
func (o *OnboardDataSourceParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *OnboardDataSourceParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if err := r.SetBodyParam(o.Body); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
