// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpCloudPacker20230101UpdateVersionBody hashicorp cloud packer 20230101 update version body
//
// swagger:model hashicorp.cloud.packer_20230101.UpdateVersionBody
type HashicorpCloudPacker20230101UpdateVersionBody struct {

	// Set to "true" when all builds associated with this version have
	// successfully completed and uploaded metadata to the registry. When
	// "complete" is true, this version is considered ready to use, and can
	// have channels assigned to it.
	Complete bool `json:"complete,omitempty"`

	// When set to true, any user created channels will not be rolled back to the
	// last valid version they were assigned to.
	DisableRollbackChannels bool `json:"disable_rollback_channels,omitempty"`

	// When set to true, will make a previously revoked version valid again.
	Restore bool `json:"restore,omitempty"`

	// Optional field to provide the reason for why this version is being revoked.
	RevocationMessage string `json:"revocation_message,omitempty"`

	// revoke_at accepts strings in the [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt)
	// format to represent the revocation timestamp. To instantly revoke the
	// version, provide the current timestamp.
	// The revoke_at timestamp will always be recorded in
	// UTC (Coordinated Universal Time).
	// This option is equivalent to the 'revoke_in' option and therefore only
	// one of them should be set when updating the version.
	// Format: date-time
	RevokeAt strfmt.DateTime `json:"revoke_at,omitempty"`

	// revoke_in accepts a signed sequence of decimal numbers with a unit suffix
	// to represent the duration to the revocation date, such as '30d' or '2h45m'.
	// Valid time units are 's', 'm', 'h', and 'd' as for seconds, minutes, hours,
	// and days.
	// To instantly revoke the version, provide the duration of zero seconds
	// ("0s").
	// The revoke_in duration will be used to calculate the version revocation
	// timestamp, which will be recorded as UTC (Coordinated Universal Time).
	// This option is equivalent to the 'revoke_at' option and therefore only one
	// of them should be set when updating the version.
	RevokeIn string `json:"revoke_in,omitempty"`

	// When set to true, the version's descendants won't inherit its revocation
	// status.
	SkipDescendantsRevocation bool `json:"skip_descendants_revocation,omitempty"`
}

// Validate validates this hashicorp cloud packer 20230101 update version body
func (m *HashicorpCloudPacker20230101UpdateVersionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRevokeAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudPacker20230101UpdateVersionBody) validateRevokeAt(formats strfmt.Registry) error {
	if swag.IsZero(m.RevokeAt) { // not required
		return nil
	}

	if err := validate.FormatOf("revoke_at", "body", "date-time", m.RevokeAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this hashicorp cloud packer 20230101 update version body based on context it is used
func (m *HashicorpCloudPacker20230101UpdateVersionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudPacker20230101UpdateVersionBody) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudPacker20230101UpdateVersionBody) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudPacker20230101UpdateVersionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
