// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewPackerServiceDeleteVersionParams creates a new PackerServiceDeleteVersionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPackerServiceDeleteVersionParams() *PackerServiceDeleteVersionParams {
	return &PackerServiceDeleteVersionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPackerServiceDeleteVersionParamsWithTimeout creates a new PackerServiceDeleteVersionParams object
// with the ability to set a timeout on a request.
func NewPackerServiceDeleteVersionParamsWithTimeout(timeout time.Duration) *PackerServiceDeleteVersionParams {
	return &PackerServiceDeleteVersionParams{
		timeout: timeout,
	}
}

// NewPackerServiceDeleteVersionParamsWithContext creates a new PackerServiceDeleteVersionParams object
// with the ability to set a context for a request.
func NewPackerServiceDeleteVersionParamsWithContext(ctx context.Context) *PackerServiceDeleteVersionParams {
	return &PackerServiceDeleteVersionParams{
		Context: ctx,
	}
}

// NewPackerServiceDeleteVersionParamsWithHTTPClient creates a new PackerServiceDeleteVersionParams object
// with the ability to set a custom HTTPClient for a request.
func NewPackerServiceDeleteVersionParamsWithHTTPClient(client *http.Client) *PackerServiceDeleteVersionParams {
	return &PackerServiceDeleteVersionParams{
		HTTPClient: client,
	}
}

/*
PackerServiceDeleteVersionParams contains all the parameters to send to the API endpoint

	for the packer service delete version operation.

	Typically these are written to a http.Request.
*/
type PackerServiceDeleteVersionParams struct {

	// BucketName.
	BucketName string

	// Fingerprint.
	Fingerprint string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	LocationRegionRegion *string

	/* RollbackChannels.

	     When set to true, any user-created channels will automatically rolleback
	to the last valid version they were assigned to.
	*/
	RollbackChannels *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the packer service delete version params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PackerServiceDeleteVersionParams) WithDefaults() *PackerServiceDeleteVersionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the packer service delete version params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PackerServiceDeleteVersionParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the packer service delete version params
func (o *PackerServiceDeleteVersionParams) WithTimeout(timeout time.Duration) *PackerServiceDeleteVersionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the packer service delete version params
func (o *PackerServiceDeleteVersionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the packer service delete version params
func (o *PackerServiceDeleteVersionParams) WithContext(ctx context.Context) *PackerServiceDeleteVersionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the packer service delete version params
func (o *PackerServiceDeleteVersionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the packer service delete version params
func (o *PackerServiceDeleteVersionParams) WithHTTPClient(client *http.Client) *PackerServiceDeleteVersionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the packer service delete version params
func (o *PackerServiceDeleteVersionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBucketName adds the bucketName to the packer service delete version params
func (o *PackerServiceDeleteVersionParams) WithBucketName(bucketName string) *PackerServiceDeleteVersionParams {
	o.SetBucketName(bucketName)
	return o
}

// SetBucketName adds the bucketName to the packer service delete version params
func (o *PackerServiceDeleteVersionParams) SetBucketName(bucketName string) {
	o.BucketName = bucketName
}

// WithFingerprint adds the fingerprint to the packer service delete version params
func (o *PackerServiceDeleteVersionParams) WithFingerprint(fingerprint string) *PackerServiceDeleteVersionParams {
	o.SetFingerprint(fingerprint)
	return o
}

// SetFingerprint adds the fingerprint to the packer service delete version params
func (o *PackerServiceDeleteVersionParams) SetFingerprint(fingerprint string) {
	o.Fingerprint = fingerprint
}

// WithLocationOrganizationID adds the locationOrganizationID to the packer service delete version params
func (o *PackerServiceDeleteVersionParams) WithLocationOrganizationID(locationOrganizationID string) *PackerServiceDeleteVersionParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the packer service delete version params
func (o *PackerServiceDeleteVersionParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the packer service delete version params
func (o *PackerServiceDeleteVersionParams) WithLocationProjectID(locationProjectID string) *PackerServiceDeleteVersionParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the packer service delete version params
func (o *PackerServiceDeleteVersionParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the packer service delete version params
func (o *PackerServiceDeleteVersionParams) WithLocationRegionProvider(locationRegionProvider *string) *PackerServiceDeleteVersionParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the packer service delete version params
func (o *PackerServiceDeleteVersionParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the packer service delete version params
func (o *PackerServiceDeleteVersionParams) WithLocationRegionRegion(locationRegionRegion *string) *PackerServiceDeleteVersionParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the packer service delete version params
func (o *PackerServiceDeleteVersionParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WithRollbackChannels adds the rollbackChannels to the packer service delete version params
func (o *PackerServiceDeleteVersionParams) WithRollbackChannels(rollbackChannels *bool) *PackerServiceDeleteVersionParams {
	o.SetRollbackChannels(rollbackChannels)
	return o
}

// SetRollbackChannels adds the rollbackChannels to the packer service delete version params
func (o *PackerServiceDeleteVersionParams) SetRollbackChannels(rollbackChannels *bool) {
	o.RollbackChannels = rollbackChannels
}

// WriteToRequest writes these params to a swagger request
func (o *PackerServiceDeleteVersionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param bucket_name
	if err := r.SetPathParam("bucket_name", o.BucketName); err != nil {
		return err
	}

	// path param fingerprint
	if err := r.SetPathParam("fingerprint", o.Fingerprint); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if o.RollbackChannels != nil {

		// query param rollback_channels
		var qrRollbackChannels bool

		if o.RollbackChannels != nil {
			qrRollbackChannels = *o.RollbackChannels
		}
		qRollbackChannels := swag.FormatBool(qrRollbackChannels)
		if qRollbackChannels != "" {

			if err := r.SetQueryParam("rollback_channels", qRollbackChannels); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
