// Code generated by go-swagger; DO NOT EDIT.

package log_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new log service API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for log service API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	LogServiceCreateArchive(params *LogServiceCreateArchiveParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceCreateArchiveOK, error)

	LogServiceCreateStreamingDestination(params *LogServiceCreateStreamingDestinationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceCreateStreamingDestinationOK, error)

	LogServiceCreateStreamingDestination2(params *LogServiceCreateStreamingDestination2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceCreateStreamingDestination2OK, error)

	LogServiceCreateStreamingDestinationFilter(params *LogServiceCreateStreamingDestinationFilterParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceCreateStreamingDestinationFilterOK, error)

	LogServiceDeleteStreamingDestination(params *LogServiceDeleteStreamingDestinationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceDeleteStreamingDestinationOK, error)

	LogServiceGet(params *LogServiceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceGetOK, error)

	LogServiceGetArchive(params *LogServiceGetArchiveParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceGetArchiveOK, error)

	LogServiceGetStreamingDestination(params *LogServiceGetStreamingDestinationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceGetStreamingDestinationOK, error)

	LogServiceGetStreamingDestination2(params *LogServiceGetStreamingDestination2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceGetStreamingDestination2OK, error)

	LogServiceListArchives(params *LogServiceListArchivesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceListArchivesOK, error)

	LogServiceListStreamingDestinations(params *LogServiceListStreamingDestinationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceListStreamingDestinationsOK, error)

	LogServiceListStreamingDestinations2(params *LogServiceListStreamingDestinations2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceListStreamingDestinations2OK, error)

	LogServiceListStreamingDestinationsForResource(params *LogServiceListStreamingDestinationsForResourceParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceListStreamingDestinationsForResourceOK, error)

	LogServiceSearch(params *LogServiceSearchParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceSearchOK, error)

	LogServiceStore(params *LogServiceStoreParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceStoreOK, error)

	LogServiceTestStreamingDestination(params *LogServiceTestStreamingDestinationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceTestStreamingDestinationOK, error)

	LogServiceUpdateStreamingDestination(params *LogServiceUpdateStreamingDestinationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceUpdateStreamingDestinationOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
LogServiceCreateArchive creates an archive request
*/
func (a *Client) LogServiceCreateArchive(params *LogServiceCreateArchiveParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceCreateArchiveOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLogServiceCreateArchiveParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "LogService_CreateArchive",
		Method:             "POST",
		PathPattern:        "/logs/2021-03-30/organizations/{resource.location.organization_id}/projects/{resource.location.project_id}/resources/{resource.id}/archives",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &LogServiceCreateArchiveReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LogServiceCreateArchiveOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LogServiceCreateArchiveDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LogServiceCreateStreamingDestination creates a streaming destination for a given resource
*/
func (a *Client) LogServiceCreateStreamingDestination(params *LogServiceCreateStreamingDestinationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceCreateStreamingDestinationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLogServiceCreateStreamingDestinationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "LogService_CreateStreamingDestination",
		Method:             "POST",
		PathPattern:        "/logs/2021-03-30/organizations/{location.organization_id}/projects/{location.project_id}/resources/destinations",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &LogServiceCreateStreamingDestinationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LogServiceCreateStreamingDestinationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LogServiceCreateStreamingDestinationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LogServiceCreateStreamingDestination2 creates a streaming destination for a given resource
*/
func (a *Client) LogServiceCreateStreamingDestination2(params *LogServiceCreateStreamingDestination2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceCreateStreamingDestination2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLogServiceCreateStreamingDestination2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "LogService_CreateStreamingDestination2",
		Method:             "POST",
		PathPattern:        "/logs/2021-03-30/organizations/{location.organization_id}/resources/destinations",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &LogServiceCreateStreamingDestination2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LogServiceCreateStreamingDestination2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LogServiceCreateStreamingDestination2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LogServiceCreateStreamingDestinationFilter creates a streaming destination filter for a given resource
*/
func (a *Client) LogServiceCreateStreamingDestinationFilter(params *LogServiceCreateStreamingDestinationFilterParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceCreateStreamingDestinationFilterOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLogServiceCreateStreamingDestinationFilterParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "LogService_CreateStreamingDestinationFilter",
		Method:             "POST",
		PathPattern:        "/logs/2021-03-30/organizations/{organization_id}/resources/destinations/{destination_id}/filter",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &LogServiceCreateStreamingDestinationFilterReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LogServiceCreateStreamingDestinationFilterOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LogServiceCreateStreamingDestinationFilterDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LogServiceDeleteStreamingDestination deletes a streaming destination by its project and id
*/
func (a *Client) LogServiceDeleteStreamingDestination(params *LogServiceDeleteStreamingDestinationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceDeleteStreamingDestinationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLogServiceDeleteStreamingDestinationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "LogService_DeleteStreamingDestination",
		Method:             "DELETE",
		PathPattern:        "/logs/2021-03-30/organizations/{location.organization_id}/projects/{location.project_id}/resources/destinations/{destination_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &LogServiceDeleteStreamingDestinationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LogServiceDeleteStreamingDestinationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LogServiceDeleteStreamingDestinationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LogServiceGet gets log entries from one or more log streams
*/
func (a *Client) LogServiceGet(params *LogServiceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLogServiceGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "LogService_Get",
		Method:             "POST",
		PathPattern:        "/logs/2021-03-30/entries/query",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &LogServiceGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LogServiceGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LogServiceGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LogServiceGetArchive lists archives for a given resource
*/
func (a *Client) LogServiceGetArchive(params *LogServiceGetArchiveParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceGetArchiveOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLogServiceGetArchiveParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "LogService_GetArchive",
		Method:             "GET",
		PathPattern:        "/logs/2021-03-30/organizations/{resource.location.organization_id}/projects/{resource.location.project_id}/resources/{resource.id}/archives/{id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &LogServiceGetArchiveReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LogServiceGetArchiveOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LogServiceGetArchiveDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LogServiceGetStreamingDestination gets a streaming destination by its project and id
*/
func (a *Client) LogServiceGetStreamingDestination(params *LogServiceGetStreamingDestinationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceGetStreamingDestinationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLogServiceGetStreamingDestinationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "LogService_GetStreamingDestination",
		Method:             "GET",
		PathPattern:        "/logs/2021-03-30/organizations/{location.organization_id}/projects/{location.project_id}/resources/destinations/{destination_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &LogServiceGetStreamingDestinationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LogServiceGetStreamingDestinationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LogServiceGetStreamingDestinationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LogServiceGetStreamingDestination2 gets a streaming destination by its project and id
*/
func (a *Client) LogServiceGetStreamingDestination2(params *LogServiceGetStreamingDestination2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceGetStreamingDestination2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLogServiceGetStreamingDestination2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "LogService_GetStreamingDestination2",
		Method:             "GET",
		PathPattern:        "/logs/2021-03-30/organizations/{location.organization_id}/resources/destinations/{destination_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &LogServiceGetStreamingDestination2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LogServiceGetStreamingDestination2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LogServiceGetStreamingDestination2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LogServiceListArchives lists archives for a given resource
*/
func (a *Client) LogServiceListArchives(params *LogServiceListArchivesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceListArchivesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLogServiceListArchivesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "LogService_ListArchives",
		Method:             "GET",
		PathPattern:        "/logs/2021-03-30/organizations/{resource.location.organization_id}/projects/{resource.location.project_id}/resources/{resource.id}/archives",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &LogServiceListArchivesReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LogServiceListArchivesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LogServiceListArchivesDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LogServiceListStreamingDestinations lists streaming destinations for a given location
*/
func (a *Client) LogServiceListStreamingDestinations(params *LogServiceListStreamingDestinationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceListStreamingDestinationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLogServiceListStreamingDestinationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "LogService_ListStreamingDestinations",
		Method:             "GET",
		PathPattern:        "/logs/2021-03-30/organizations/{location.organization_id}/projects/{location.project_id}/resources/destinations",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &LogServiceListStreamingDestinationsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LogServiceListStreamingDestinationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LogServiceListStreamingDestinationsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LogServiceListStreamingDestinations2 lists streaming destinations for a given location
*/
func (a *Client) LogServiceListStreamingDestinations2(params *LogServiceListStreamingDestinations2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceListStreamingDestinations2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLogServiceListStreamingDestinations2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "LogService_ListStreamingDestinations2",
		Method:             "GET",
		PathPattern:        "/logs/2021-03-30/organizations/{location.organization_id}/resources/destinations",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &LogServiceListStreamingDestinations2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LogServiceListStreamingDestinations2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LogServiceListStreamingDestinations2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LogServiceListStreamingDestinationsForResource log service list streaming destinations for resource API
*/
func (a *Client) LogServiceListStreamingDestinationsForResource(params *LogServiceListStreamingDestinationsForResourceParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceListStreamingDestinationsForResourceOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLogServiceListStreamingDestinationsForResourceParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "LogService_ListStreamingDestinationsForResource",
		Method:             "POST",
		PathPattern:        "/logs/2021-03-30/organizations/{resource.location.organization_id}/projects/{resource.location.project_id}/resources/{resource.id}/destinations",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &LogServiceListStreamingDestinationsForResourceReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LogServiceListStreamingDestinationsForResourceOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LogServiceListStreamingDestinationsForResourceDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LogServiceSearch searches for log entries in a public tenant
*/
func (a *Client) LogServiceSearch(params *LogServiceSearchParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceSearchOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLogServiceSearchParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "LogService_Search",
		Method:             "POST",
		PathPattern:        "/logs/2022-06-06/organizations/{organization_id}/entries/preview/search",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &LogServiceSearchReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LogServiceSearchOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LogServiceSearchDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LogServiceStore stores for log entries in a public tenant
*/
func (a *Client) LogServiceStore(params *LogServiceStoreParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceStoreOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLogServiceStoreParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "LogService_Store",
		Method:             "POST",
		PathPattern:        "/logs/2021-03-30/organizations/{stream.organization_id}/entries/store",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &LogServiceStoreReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LogServiceStoreOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LogServiceStoreDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LogServiceTestStreamingDestination tests a streaming destination config record by sending a test record to the provided configuration
*/
func (a *Client) LogServiceTestStreamingDestination(params *LogServiceTestStreamingDestinationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceTestStreamingDestinationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLogServiceTestStreamingDestinationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "LogService_TestStreamingDestination",
		Method:             "POST",
		PathPattern:        "/logs/2021-03-30/organizations/{location.organization_id}/projects/{location.project_id}/resources/destinations/test",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &LogServiceTestStreamingDestinationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LogServiceTestStreamingDestinationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LogServiceTestStreamingDestinationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LogServiceUpdateStreamingDestination updates a streaming destination by its id
*/
func (a *Client) LogServiceUpdateStreamingDestination(params *LogServiceUpdateStreamingDestinationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LogServiceUpdateStreamingDestinationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLogServiceUpdateStreamingDestinationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "LogService_UpdateStreamingDestination",
		Method:             "PATCH",
		PathPattern:        "/logs/2021-03-30/organizations/{destination.resource.location.organization_id}/projects/{destination.resource.location.project_id}/resources/destinations/{destination.resource.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &LogServiceUpdateStreamingDestinationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LogServiceUpdateStreamingDestinationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LogServiceUpdateStreamingDestinationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
