// Code generated by go-swagger; DO NOT EDIT.

package profile_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ProfileServiceEnableMFAReader is a Reader for the ProfileServiceEnableMFA structure.
type ProfileServiceEnableMFAReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ProfileServiceEnableMFAReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewProfileServiceEnableMFAOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewProfileServiceEnableMFADefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewProfileServiceEnableMFAOK creates a ProfileServiceEnableMFAOK with default headers values
func NewProfileServiceEnableMFAOK() *ProfileServiceEnableMFAOK {
	return &ProfileServiceEnableMFAOK{}
}

/*
ProfileServiceEnableMFAOK describes a response with status code 200, with default header values.

A successful response.
*/
type ProfileServiceEnableMFAOK struct {
	Payload *models.HashicorpCloudIamEnableMFAResponse
}

// IsSuccess returns true when this profile service enable m f a o k response has a 2xx status code
func (o *ProfileServiceEnableMFAOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this profile service enable m f a o k response has a 3xx status code
func (o *ProfileServiceEnableMFAOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this profile service enable m f a o k response has a 4xx status code
func (o *ProfileServiceEnableMFAOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this profile service enable m f a o k response has a 5xx status code
func (o *ProfileServiceEnableMFAOK) IsServerError() bool {
	return false
}

// IsCode returns true when this profile service enable m f a o k response a status code equal to that given
func (o *ProfileServiceEnableMFAOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the profile service enable m f a o k response
func (o *ProfileServiceEnableMFAOK) Code() int {
	return 200
}

func (o *ProfileServiceEnableMFAOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/me/enable-mfa][%d] profileServiceEnableMFAOK %s", 200, payload)
}

func (o *ProfileServiceEnableMFAOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/me/enable-mfa][%d] profileServiceEnableMFAOK %s", 200, payload)
}

func (o *ProfileServiceEnableMFAOK) GetPayload() *models.HashicorpCloudIamEnableMFAResponse {
	return o.Payload
}

func (o *ProfileServiceEnableMFAOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudIamEnableMFAResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewProfileServiceEnableMFADefault creates a ProfileServiceEnableMFADefault with default headers values
func NewProfileServiceEnableMFADefault(code int) *ProfileServiceEnableMFADefault {
	return &ProfileServiceEnableMFADefault{
		_statusCode: code,
	}
}

/*
ProfileServiceEnableMFADefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ProfileServiceEnableMFADefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this profile service enable m f a default response has a 2xx status code
func (o *ProfileServiceEnableMFADefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this profile service enable m f a default response has a 3xx status code
func (o *ProfileServiceEnableMFADefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this profile service enable m f a default response has a 4xx status code
func (o *ProfileServiceEnableMFADefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this profile service enable m f a default response has a 5xx status code
func (o *ProfileServiceEnableMFADefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this profile service enable m f a default response a status code equal to that given
func (o *ProfileServiceEnableMFADefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the profile service enable m f a default response
func (o *ProfileServiceEnableMFADefault) Code() int {
	return o._statusCode
}

func (o *ProfileServiceEnableMFADefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/me/enable-mfa][%d] ProfileService_EnableMFA default %s", o._statusCode, payload)
}

func (o *ProfileServiceEnableMFADefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/me/enable-mfa][%d] ProfileService_EnableMFA default %s", o._statusCode, payload)
}

func (o *ProfileServiceEnableMFADefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ProfileServiceEnableMFADefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
