// Code generated by go-swagger; DO NOT EDIT.

package invitations_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	httptransport "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// New creates a new invitations service API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

// New creates a new invitations service API client with basic auth credentials.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - user: user for basic authentication header.
// - password: password for basic authentication header.
func NewClientWithBasicAuth(host, basePath, scheme, user, password string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BasicAuth(user, password)
	return &Client{transport: transport, formats: strfmt.Default}
}

// New creates a new invitations service API client with a bearer token for authentication.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - bearerToken: bearer token for Bearer authentication header.
func NewClientWithBearerToken(host, basePath, scheme, bearerToken string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BearerToken(bearerToken)
	return &Client{transport: transport, formats: strfmt.Default}
}

/*
Client for invitations service API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption may be used to customize the behavior of Client methods.
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	InvitationsServiceAcceptOrganizationInvitation(params *InvitationsServiceAcceptOrganizationInvitationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*InvitationsServiceAcceptOrganizationInvitationOK, error)

	InvitationsServiceCreateOrganizationInvitations(params *InvitationsServiceCreateOrganizationInvitationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*InvitationsServiceCreateOrganizationInvitationsOK, error)

	InvitationsServiceDeleteOrganizationInvitation(params *InvitationsServiceDeleteOrganizationInvitationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*InvitationsServiceDeleteOrganizationInvitationOK, error)

	InvitationsServiceGetOrganizationNameByInvitationToken(params *InvitationsServiceGetOrganizationNameByInvitationTokenParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*InvitationsServiceGetOrganizationNameByInvitationTokenOK, error)

	InvitationsServiceListOrganizationInvitations(params *InvitationsServiceListOrganizationInvitationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*InvitationsServiceListOrganizationInvitationsOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
InvitationsServiceAcceptOrganizationInvitation accepts organization invitation accepts an organization invitation expects an invitation token in the body
*/
func (a *Client) InvitationsServiceAcceptOrganizationInvitation(params *InvitationsServiceAcceptOrganizationInvitationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*InvitationsServiceAcceptOrganizationInvitationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewInvitationsServiceAcceptOrganizationInvitationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "InvitationsService_AcceptOrganizationInvitation",
		Method:             "POST",
		PathPattern:        "/iam/2019-12-10/accept-invitation",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &InvitationsServiceAcceptOrganizationInvitationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*InvitationsServiceAcceptOrganizationInvitationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*InvitationsServiceAcceptOrganizationInvitationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
InvitationsServiceCreateOrganizationInvitations creates organization invitations creates one or more organization invitations
*/
func (a *Client) InvitationsServiceCreateOrganizationInvitations(params *InvitationsServiceCreateOrganizationInvitationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*InvitationsServiceCreateOrganizationInvitationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewInvitationsServiceCreateOrganizationInvitationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "InvitationsService_CreateOrganizationInvitations",
		Method:             "POST",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/invitations",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &InvitationsServiceCreateOrganizationInvitationsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*InvitationsServiceCreateOrganizationInvitationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*InvitationsServiceCreateOrganizationInvitationsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
InvitationsServiceDeleteOrganizationInvitation deletes organization invitation creates an organization invitation
*/
func (a *Client) InvitationsServiceDeleteOrganizationInvitation(params *InvitationsServiceDeleteOrganizationInvitationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*InvitationsServiceDeleteOrganizationInvitationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewInvitationsServiceDeleteOrganizationInvitationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "InvitationsService_DeleteOrganizationInvitation",
		Method:             "DELETE",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/invitations/{invitation_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &InvitationsServiceDeleteOrganizationInvitationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*InvitationsServiceDeleteOrganizationInvitationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*InvitationsServiceDeleteOrganizationInvitationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
InvitationsServiceGetOrganizationNameByInvitationToken gets organization name by invitation token returns the organization name for the invitation associated with the invitation token provided
*/
func (a *Client) InvitationsServiceGetOrganizationNameByInvitationToken(params *InvitationsServiceGetOrganizationNameByInvitationTokenParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*InvitationsServiceGetOrganizationNameByInvitationTokenOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewInvitationsServiceGetOrganizationNameByInvitationTokenParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "InvitationsService_GetOrganizationNameByInvitationToken",
		Method:             "GET",
		PathPattern:        "/iam/2019-12-10/invitations/{invitation_token}/organization",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &InvitationsServiceGetOrganizationNameByInvitationTokenReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*InvitationsServiceGetOrganizationNameByInvitationTokenOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*InvitationsServiceGetOrganizationNameByInvitationTokenDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
InvitationsServiceListOrganizationInvitations lists organization invitations returns a list of organization invitations
*/
func (a *Client) InvitationsServiceListOrganizationInvitations(params *InvitationsServiceListOrganizationInvitationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*InvitationsServiceListOrganizationInvitationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewInvitationsServiceListOrganizationInvitationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "InvitationsService_ListOrganizationInvitations",
		Method:             "GET",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/invitations",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &InvitationsServiceListOrganizationInvitationsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*InvitationsServiceListOrganizationInvitationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*InvitationsServiceListOrganizationInvitationsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
