// Code generated by go-swagger; DO NOT EDIT.

package groups_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// GroupsServiceCountGroupsForPrincipalsReader is a Reader for the GroupsServiceCountGroupsForPrincipals structure.
type GroupsServiceCountGroupsForPrincipalsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GroupsServiceCountGroupsForPrincipalsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGroupsServiceCountGroupsForPrincipalsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGroupsServiceCountGroupsForPrincipalsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGroupsServiceCountGroupsForPrincipalsOK creates a GroupsServiceCountGroupsForPrincipalsOK with default headers values
func NewGroupsServiceCountGroupsForPrincipalsOK() *GroupsServiceCountGroupsForPrincipalsOK {
	return &GroupsServiceCountGroupsForPrincipalsOK{}
}

/*
GroupsServiceCountGroupsForPrincipalsOK describes a response with status code 200, with default header values.

A successful response.
*/
type GroupsServiceCountGroupsForPrincipalsOK struct {
	Payload *models.HashicorpCloudIamCountGroupsForPrincipalsResponse
}

// IsSuccess returns true when this groups service count groups for principals o k response has a 2xx status code
func (o *GroupsServiceCountGroupsForPrincipalsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this groups service count groups for principals o k response has a 3xx status code
func (o *GroupsServiceCountGroupsForPrincipalsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this groups service count groups for principals o k response has a 4xx status code
func (o *GroupsServiceCountGroupsForPrincipalsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this groups service count groups for principals o k response has a 5xx status code
func (o *GroupsServiceCountGroupsForPrincipalsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this groups service count groups for principals o k response a status code equal to that given
func (o *GroupsServiceCountGroupsForPrincipalsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the groups service count groups for principals o k response
func (o *GroupsServiceCountGroupsForPrincipalsOK) Code() int {
	return 200
}

func (o *GroupsServiceCountGroupsForPrincipalsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/iam/{parent_resource_name}/groups/count-for-principals][%d] groupsServiceCountGroupsForPrincipalsOK %s", 200, payload)
}

func (o *GroupsServiceCountGroupsForPrincipalsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/iam/{parent_resource_name}/groups/count-for-principals][%d] groupsServiceCountGroupsForPrincipalsOK %s", 200, payload)
}

func (o *GroupsServiceCountGroupsForPrincipalsOK) GetPayload() *models.HashicorpCloudIamCountGroupsForPrincipalsResponse {
	return o.Payload
}

func (o *GroupsServiceCountGroupsForPrincipalsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudIamCountGroupsForPrincipalsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGroupsServiceCountGroupsForPrincipalsDefault creates a GroupsServiceCountGroupsForPrincipalsDefault with default headers values
func NewGroupsServiceCountGroupsForPrincipalsDefault(code int) *GroupsServiceCountGroupsForPrincipalsDefault {
	return &GroupsServiceCountGroupsForPrincipalsDefault{
		_statusCode: code,
	}
}

/*
GroupsServiceCountGroupsForPrincipalsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GroupsServiceCountGroupsForPrincipalsDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this groups service count groups for principals default response has a 2xx status code
func (o *GroupsServiceCountGroupsForPrincipalsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this groups service count groups for principals default response has a 3xx status code
func (o *GroupsServiceCountGroupsForPrincipalsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this groups service count groups for principals default response has a 4xx status code
func (o *GroupsServiceCountGroupsForPrincipalsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this groups service count groups for principals default response has a 5xx status code
func (o *GroupsServiceCountGroupsForPrincipalsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this groups service count groups for principals default response a status code equal to that given
func (o *GroupsServiceCountGroupsForPrincipalsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the groups service count groups for principals default response
func (o *GroupsServiceCountGroupsForPrincipalsDefault) Code() int {
	return o._statusCode
}

func (o *GroupsServiceCountGroupsForPrincipalsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/iam/{parent_resource_name}/groups/count-for-principals][%d] GroupsService_CountGroupsForPrincipals default %s", o._statusCode, payload)
}

func (o *GroupsServiceCountGroupsForPrincipalsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/iam/{parent_resource_name}/groups/count-for-principals][%d] GroupsService_CountGroupsForPrincipals default %s", o._statusCode, payload)
}

func (o *GroupsServiceCountGroupsForPrincipalsDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *GroupsServiceCountGroupsForPrincipalsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
