// Code generated by go-swagger; DO NOT EDIT.

package auth_config_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	httptransport "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// New creates a new auth config service API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

// New creates a new auth config service API client with basic auth credentials.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - user: user for basic authentication header.
// - password: password for basic authentication header.
func NewClientWithBasicAuth(host, basePath, scheme, user, password string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BasicAuth(user, password)
	return &Client{transport: transport, formats: strfmt.Default}
}

// New creates a new auth config service API client with a bearer token for authentication.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - bearerToken: bearer token for Bearer authentication header.
func NewClientWithBearerToken(host, basePath, scheme, bearerToken string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BearerToken(bearerToken)
	return &Client{transport: transport, formats: strfmt.Default}
}

/*
Client for auth config service API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption may be used to customize the behavior of Client methods.
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	AuthConfigServiceCreateAuthConnection(params *AuthConfigServiceCreateAuthConnectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuthConfigServiceCreateAuthConnectionOK, error)

	AuthConfigServiceDeleteAuthConnectionFromOrganization(params *AuthConfigServiceDeleteAuthConnectionFromOrganizationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuthConfigServiceDeleteAuthConnectionFromOrganizationOK, error)

	AuthConfigServiceEditAuthConnection(params *AuthConfigServiceEditAuthConnectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuthConfigServiceEditAuthConnectionOK, error)

	AuthConfigServiceGetAuthConnections(params *AuthConfigServiceGetAuthConnectionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuthConfigServiceGetAuthConnectionsOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
AuthConfigServiceCreateAuthConnection creates auth connection creates an auth connection
*/
func (a *Client) AuthConfigServiceCreateAuthConnection(params *AuthConfigServiceCreateAuthConnectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuthConfigServiceCreateAuthConnectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAuthConfigServiceCreateAuthConnectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "AuthConfigService_CreateAuthConnection",
		Method:             "POST",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/auth_connections",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &AuthConfigServiceCreateAuthConnectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AuthConfigServiceCreateAuthConnectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AuthConfigServiceCreateAuthConnectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AuthConfigServiceDeleteAuthConnectionFromOrganization deletes auth connection from organization permanently deletes a persisted auth connection
*/
func (a *Client) AuthConfigServiceDeleteAuthConnectionFromOrganization(params *AuthConfigServiceDeleteAuthConnectionFromOrganizationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuthConfigServiceDeleteAuthConnectionFromOrganizationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAuthConfigServiceDeleteAuthConnectionFromOrganizationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "AuthConfigService_DeleteAuthConnectionFromOrganization",
		Method:             "DELETE",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/auth_connections",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &AuthConfigServiceDeleteAuthConnectionFromOrganizationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AuthConfigServiceDeleteAuthConnectionFromOrganizationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AuthConfigServiceDeleteAuthConnectionFromOrganizationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AuthConfigServiceEditAuthConnection edits auth connection edits an existing auth connection
*/
func (a *Client) AuthConfigServiceEditAuthConnection(params *AuthConfigServiceEditAuthConnectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuthConfigServiceEditAuthConnectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAuthConfigServiceEditAuthConnectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "AuthConfigService_EditAuthConnection",
		Method:             "PATCH",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/auth_connections",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &AuthConfigServiceEditAuthConnectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AuthConfigServiceEditAuthConnectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AuthConfigServiceEditAuthConnectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AuthConfigServiceGetAuthConnections auth config service get auth connections API
*/
func (a *Client) AuthConfigServiceGetAuthConnections(params *AuthConfigServiceGetAuthConnectionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuthConfigServiceGetAuthConnectionsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAuthConfigServiceGetAuthConnectionsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "AuthConfigService_GetAuthConnections",
		Method:             "GET",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/auth_connections",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &AuthConfigServiceGetAuthConnectionsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AuthConfigServiceGetAuthConnectionsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AuthConfigServiceGetAuthConnectionsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
