// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/validate"
)

// HashicorpCloudConsul20200826ClusterState State is the state of the Consul cluster. Note that this state
// represents the abstract Consul cluster itself, not necessarily whether
// Consul cluster is currently available or not.
//
//   - UNSET: UNSET is a sentinel zero value so that an uninitialized value can be
//
// detected.
//   - PENDING: PENDING is the state the cluster is in while it is waiting to be created.
//   - CREATING: CREATING is the state the cluster is in while it is being provisioned for
//
// the first time.
//   - RUNNING: RUNNING is the steady state while the cluster is running.
//   - FAILED: FAILED is a failure state in which the cluster is unavailable and may
//
// required an operator restore action to recover.
//   - UPDATING: UPDATING is the state the cluster is in while undergoing a version
//
// update.
//   - RESTORING: RESTORING is the state the cluster is in while restoring from a snapshot.
//   - DELETING: DELETING is the state the cluster is in while it is being de-provisioned.
//   - DELETED: DELETED is the state the cluster is in when it has been de-provisioned. At
//
// this point, the cluster is eligible for garbage collection.
//
// swagger:model hashicorp.cloud.consul_20200826.Cluster.State
type HashicorpCloudConsul20200826ClusterState string

func NewHashicorpCloudConsul20200826ClusterState(value HashicorpCloudConsul20200826ClusterState) *HashicorpCloudConsul20200826ClusterState {
	return &value
}

// Pointer returns a pointer to a freshly-allocated HashicorpCloudConsul20200826ClusterState.
func (m HashicorpCloudConsul20200826ClusterState) Pointer() *HashicorpCloudConsul20200826ClusterState {
	return &m
}

const (

	// HashicorpCloudConsul20200826ClusterStateUNSET captures enum value "UNSET"
	HashicorpCloudConsul20200826ClusterStateUNSET HashicorpCloudConsul20200826ClusterState = "UNSET"

	// HashicorpCloudConsul20200826ClusterStatePENDING captures enum value "PENDING"
	HashicorpCloudConsul20200826ClusterStatePENDING HashicorpCloudConsul20200826ClusterState = "PENDING"

	// HashicorpCloudConsul20200826ClusterStateCREATING captures enum value "CREATING"
	HashicorpCloudConsul20200826ClusterStateCREATING HashicorpCloudConsul20200826ClusterState = "CREATING"

	// HashicorpCloudConsul20200826ClusterStateRUNNING captures enum value "RUNNING"
	HashicorpCloudConsul20200826ClusterStateRUNNING HashicorpCloudConsul20200826ClusterState = "RUNNING"

	// HashicorpCloudConsul20200826ClusterStateFAILED captures enum value "FAILED"
	HashicorpCloudConsul20200826ClusterStateFAILED HashicorpCloudConsul20200826ClusterState = "FAILED"

	// HashicorpCloudConsul20200826ClusterStateUPDATING captures enum value "UPDATING"
	HashicorpCloudConsul20200826ClusterStateUPDATING HashicorpCloudConsul20200826ClusterState = "UPDATING"

	// HashicorpCloudConsul20200826ClusterStateRESTORING captures enum value "RESTORING"
	HashicorpCloudConsul20200826ClusterStateRESTORING HashicorpCloudConsul20200826ClusterState = "RESTORING"

	// HashicorpCloudConsul20200826ClusterStateDELETING captures enum value "DELETING"
	HashicorpCloudConsul20200826ClusterStateDELETING HashicorpCloudConsul20200826ClusterState = "DELETING"

	// HashicorpCloudConsul20200826ClusterStateDELETED captures enum value "DELETED"
	HashicorpCloudConsul20200826ClusterStateDELETED HashicorpCloudConsul20200826ClusterState = "DELETED"
)

// for schema
var hashicorpCloudConsul20200826ClusterStateEnum []interface{}

func init() {
	var res []HashicorpCloudConsul20200826ClusterState
	if err := json.Unmarshal([]byte(`["UNSET","PENDING","CREATING","RUNNING","FAILED","UPDATING","RESTORING","DELETING","DELETED"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		hashicorpCloudConsul20200826ClusterStateEnum = append(hashicorpCloudConsul20200826ClusterStateEnum, v)
	}
}

func (m HashicorpCloudConsul20200826ClusterState) validateHashicorpCloudConsul20200826ClusterStateEnum(path, location string, value HashicorpCloudConsul20200826ClusterState) error {
	if err := validate.EnumCase(path, location, value, hashicorpCloudConsul20200826ClusterStateEnum, true); err != nil {
		return err
	}
	return nil
}

// Validate validates this hashicorp cloud consul 20200826 cluster state
func (m HashicorpCloudConsul20200826ClusterState) Validate(formats strfmt.Registry) error {
	var res []error

	// value enum
	if err := m.validateHashicorpCloudConsul20200826ClusterStateEnum("", "body", m); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// ContextValidate validates this hashicorp cloud consul 20200826 cluster state based on context it is used
func (m HashicorpCloudConsul20200826ClusterState) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}
