// Code generated by go-swagger; DO NOT EDIT.

package boundary_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewBoundaryServiceResetControllerConfigurationParams creates a new BoundaryServiceResetControllerConfigurationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewBoundaryServiceResetControllerConfigurationParams() *BoundaryServiceResetControllerConfigurationParams {
	return &BoundaryServiceResetControllerConfigurationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewBoundaryServiceResetControllerConfigurationParamsWithTimeout creates a new BoundaryServiceResetControllerConfigurationParams object
// with the ability to set a timeout on a request.
func NewBoundaryServiceResetControllerConfigurationParamsWithTimeout(timeout time.Duration) *BoundaryServiceResetControllerConfigurationParams {
	return &BoundaryServiceResetControllerConfigurationParams{
		timeout: timeout,
	}
}

// NewBoundaryServiceResetControllerConfigurationParamsWithContext creates a new BoundaryServiceResetControllerConfigurationParams object
// with the ability to set a context for a request.
func NewBoundaryServiceResetControllerConfigurationParamsWithContext(ctx context.Context) *BoundaryServiceResetControllerConfigurationParams {
	return &BoundaryServiceResetControllerConfigurationParams{
		Context: ctx,
	}
}

// NewBoundaryServiceResetControllerConfigurationParamsWithHTTPClient creates a new BoundaryServiceResetControllerConfigurationParams object
// with the ability to set a custom HTTPClient for a request.
func NewBoundaryServiceResetControllerConfigurationParamsWithHTTPClient(client *http.Client) *BoundaryServiceResetControllerConfigurationParams {
	return &BoundaryServiceResetControllerConfigurationParams{
		HTTPClient: client,
	}
}

/*
BoundaryServiceResetControllerConfigurationParams contains all the parameters to send to the API endpoint

	for the boundary service reset controller configuration operation.

	Typically these are written to a http.Request.
*/
type BoundaryServiceResetControllerConfigurationParams struct {

	/* ClusterID.

	   The cluster name as set by the user on cluster creation.
	*/
	ClusterID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure").
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1").
	*/
	LocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the boundary service reset controller configuration params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BoundaryServiceResetControllerConfigurationParams) WithDefaults() *BoundaryServiceResetControllerConfigurationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the boundary service reset controller configuration params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BoundaryServiceResetControllerConfigurationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the boundary service reset controller configuration params
func (o *BoundaryServiceResetControllerConfigurationParams) WithTimeout(timeout time.Duration) *BoundaryServiceResetControllerConfigurationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the boundary service reset controller configuration params
func (o *BoundaryServiceResetControllerConfigurationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the boundary service reset controller configuration params
func (o *BoundaryServiceResetControllerConfigurationParams) WithContext(ctx context.Context) *BoundaryServiceResetControllerConfigurationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the boundary service reset controller configuration params
func (o *BoundaryServiceResetControllerConfigurationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the boundary service reset controller configuration params
func (o *BoundaryServiceResetControllerConfigurationParams) WithHTTPClient(client *http.Client) *BoundaryServiceResetControllerConfigurationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the boundary service reset controller configuration params
func (o *BoundaryServiceResetControllerConfigurationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the boundary service reset controller configuration params
func (o *BoundaryServiceResetControllerConfigurationParams) WithClusterID(clusterID string) *BoundaryServiceResetControllerConfigurationParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the boundary service reset controller configuration params
func (o *BoundaryServiceResetControllerConfigurationParams) SetClusterID(clusterID string) {
	o.ClusterID = clusterID
}

// WithLocationOrganizationID adds the locationOrganizationID to the boundary service reset controller configuration params
func (o *BoundaryServiceResetControllerConfigurationParams) WithLocationOrganizationID(locationOrganizationID string) *BoundaryServiceResetControllerConfigurationParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the boundary service reset controller configuration params
func (o *BoundaryServiceResetControllerConfigurationParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the boundary service reset controller configuration params
func (o *BoundaryServiceResetControllerConfigurationParams) WithLocationProjectID(locationProjectID string) *BoundaryServiceResetControllerConfigurationParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the boundary service reset controller configuration params
func (o *BoundaryServiceResetControllerConfigurationParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the boundary service reset controller configuration params
func (o *BoundaryServiceResetControllerConfigurationParams) WithLocationRegionProvider(locationRegionProvider *string) *BoundaryServiceResetControllerConfigurationParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the boundary service reset controller configuration params
func (o *BoundaryServiceResetControllerConfigurationParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the boundary service reset controller configuration params
func (o *BoundaryServiceResetControllerConfigurationParams) WithLocationRegionRegion(locationRegionRegion *string) *BoundaryServiceResetControllerConfigurationParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the boundary service reset controller configuration params
func (o *BoundaryServiceResetControllerConfigurationParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *BoundaryServiceResetControllerConfigurationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
