// Code generated by go-swagger; DO NOT EDIT.

package boundary_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-boundary-service/stable/2021-12-21/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// BoundaryServiceDeleteReader is a Reader for the BoundaryServiceDelete structure.
type BoundaryServiceDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *BoundaryServiceDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewBoundaryServiceDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewBoundaryServiceDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewBoundaryServiceDeleteOK creates a BoundaryServiceDeleteOK with default headers values
func NewBoundaryServiceDeleteOK() *BoundaryServiceDeleteOK {
	return &BoundaryServiceDeleteOK{}
}

/*
BoundaryServiceDeleteOK describes a response with status code 200, with default header values.

A successful response.
*/
type BoundaryServiceDeleteOK struct {
	Payload *models.HashicorpCloudBoundary20211221DeleteResponse
}

// IsSuccess returns true when this boundary service delete o k response has a 2xx status code
func (o *BoundaryServiceDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this boundary service delete o k response has a 3xx status code
func (o *BoundaryServiceDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this boundary service delete o k response has a 4xx status code
func (o *BoundaryServiceDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this boundary service delete o k response has a 5xx status code
func (o *BoundaryServiceDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this boundary service delete o k response a status code equal to that given
func (o *BoundaryServiceDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the boundary service delete o k response
func (o *BoundaryServiceDeleteOK) Code() int {
	return 200
}

func (o *BoundaryServiceDeleteOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}][%d] boundaryServiceDeleteOK %s", 200, payload)
}

func (o *BoundaryServiceDeleteOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}][%d] boundaryServiceDeleteOK %s", 200, payload)
}

func (o *BoundaryServiceDeleteOK) GetPayload() *models.HashicorpCloudBoundary20211221DeleteResponse {
	return o.Payload
}

func (o *BoundaryServiceDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudBoundary20211221DeleteResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBoundaryServiceDeleteDefault creates a BoundaryServiceDeleteDefault with default headers values
func NewBoundaryServiceDeleteDefault(code int) *BoundaryServiceDeleteDefault {
	return &BoundaryServiceDeleteDefault{
		_statusCode: code,
	}
}

/*
BoundaryServiceDeleteDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type BoundaryServiceDeleteDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// IsSuccess returns true when this boundary service delete default response has a 2xx status code
func (o *BoundaryServiceDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this boundary service delete default response has a 3xx status code
func (o *BoundaryServiceDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this boundary service delete default response has a 4xx status code
func (o *BoundaryServiceDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this boundary service delete default response has a 5xx status code
func (o *BoundaryServiceDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this boundary service delete default response a status code equal to that given
func (o *BoundaryServiceDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the boundary service delete default response
func (o *BoundaryServiceDeleteDefault) Code() int {
	return o._statusCode
}

func (o *BoundaryServiceDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}][%d] BoundaryService_Delete default %s", o._statusCode, payload)
}

func (o *BoundaryServiceDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}][%d] BoundaryService_Delete default %s", o._statusCode, payload)
}

func (o *BoundaryServiceDeleteDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *BoundaryServiceDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
