// Code generated by go-swagger; DO NOT EDIT.

package billing_account_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewBillingAccountServiceGetParams creates a new BillingAccountServiceGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewBillingAccountServiceGetParams() *BillingAccountServiceGetParams {
	return &BillingAccountServiceGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewBillingAccountServiceGetParamsWithTimeout creates a new BillingAccountServiceGetParams object
// with the ability to set a timeout on a request.
func NewBillingAccountServiceGetParamsWithTimeout(timeout time.Duration) *BillingAccountServiceGetParams {
	return &BillingAccountServiceGetParams{
		timeout: timeout,
	}
}

// NewBillingAccountServiceGetParamsWithContext creates a new BillingAccountServiceGetParams object
// with the ability to set a context for a request.
func NewBillingAccountServiceGetParamsWithContext(ctx context.Context) *BillingAccountServiceGetParams {
	return &BillingAccountServiceGetParams{
		Context: ctx,
	}
}

// NewBillingAccountServiceGetParamsWithHTTPClient creates a new BillingAccountServiceGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewBillingAccountServiceGetParamsWithHTTPClient(client *http.Client) *BillingAccountServiceGetParams {
	return &BillingAccountServiceGetParams{
		HTTPClient: client,
	}
}

/*
BillingAccountServiceGetParams contains all the parameters to send to the API endpoint

	for the billing account service get operation.

	Typically these are written to a http.Request.
*/
type BillingAccountServiceGetParams struct {

	/* ID.

	     id is the user-settable ID that uniquely identifies the Billing Account
	within the organization.
	*/
	ID string

	/* OrganizationID.

	     organization_id is the ID of the organization to which the Billing Account
	belongs.
	*/
	OrganizationID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the billing account service get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BillingAccountServiceGetParams) WithDefaults() *BillingAccountServiceGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the billing account service get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BillingAccountServiceGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the billing account service get params
func (o *BillingAccountServiceGetParams) WithTimeout(timeout time.Duration) *BillingAccountServiceGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the billing account service get params
func (o *BillingAccountServiceGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the billing account service get params
func (o *BillingAccountServiceGetParams) WithContext(ctx context.Context) *BillingAccountServiceGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the billing account service get params
func (o *BillingAccountServiceGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the billing account service get params
func (o *BillingAccountServiceGetParams) WithHTTPClient(client *http.Client) *BillingAccountServiceGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the billing account service get params
func (o *BillingAccountServiceGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithID adds the id to the billing account service get params
func (o *BillingAccountServiceGetParams) WithID(id string) *BillingAccountServiceGetParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the billing account service get params
func (o *BillingAccountServiceGetParams) SetID(id string) {
	o.ID = id
}

// WithOrganizationID adds the organizationID to the billing account service get params
func (o *BillingAccountServiceGetParams) WithOrganizationID(organizationID string) *BillingAccountServiceGetParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the billing account service get params
func (o *BillingAccountServiceGetParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WriteToRequest writes these params to a swagger request
func (o *BillingAccountServiceGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param id
	if err := r.SetPathParam("id", o.ID); err != nil {
		return err
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
