// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package tcp_response_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetTCPResponseRuleBackendOKCode is the HTTP code returned for type GetTCPResponseRuleBackendOK
const GetTCPResponseRuleBackendOKCode int = 200

/*
GetTCPResponseRuleBackendOK Successful operation

swagger:response getTcpResponseRuleBackendOK
*/
type GetTCPResponseRuleBackendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.TCPResponseRule `json:"body,omitempty"`
}

// NewGetTCPResponseRuleBackendOK creates GetTCPResponseRuleBackendOK with default headers values
func NewGetTCPResponseRuleBackendOK() *GetTCPResponseRuleBackendOK {

	return &GetTCPResponseRuleBackendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get Tcp response rule backend o k response
func (o *GetTCPResponseRuleBackendOK) WithConfigurationVersion(configurationVersion string) *GetTCPResponseRuleBackendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Tcp response rule backend o k response
func (o *GetTCPResponseRuleBackendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Tcp response rule backend o k response
func (o *GetTCPResponseRuleBackendOK) WithPayload(payload *models.TCPResponseRule) *GetTCPResponseRuleBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Tcp response rule backend o k response
func (o *GetTCPResponseRuleBackendOK) SetPayload(payload *models.TCPResponseRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetTCPResponseRuleBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetTCPResponseRuleBackendNotFoundCode is the HTTP code returned for type GetTCPResponseRuleBackendNotFound
const GetTCPResponseRuleBackendNotFoundCode int = 404

/*
GetTCPResponseRuleBackendNotFound The specified resource was not found

swagger:response getTcpResponseRuleBackendNotFound
*/
type GetTCPResponseRuleBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetTCPResponseRuleBackendNotFound creates GetTCPResponseRuleBackendNotFound with default headers values
func NewGetTCPResponseRuleBackendNotFound() *GetTCPResponseRuleBackendNotFound {

	return &GetTCPResponseRuleBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get Tcp response rule backend not found response
func (o *GetTCPResponseRuleBackendNotFound) WithConfigurationVersion(configurationVersion string) *GetTCPResponseRuleBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Tcp response rule backend not found response
func (o *GetTCPResponseRuleBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Tcp response rule backend not found response
func (o *GetTCPResponseRuleBackendNotFound) WithPayload(payload *models.Error) *GetTCPResponseRuleBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Tcp response rule backend not found response
func (o *GetTCPResponseRuleBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetTCPResponseRuleBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetTCPResponseRuleBackendDefault General Error

swagger:response getTcpResponseRuleBackendDefault
*/
type GetTCPResponseRuleBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetTCPResponseRuleBackendDefault creates GetTCPResponseRuleBackendDefault with default headers values
func NewGetTCPResponseRuleBackendDefault(code int) *GetTCPResponseRuleBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetTCPResponseRuleBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get TCP response rule backend default response
func (o *GetTCPResponseRuleBackendDefault) WithStatusCode(code int) *GetTCPResponseRuleBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get TCP response rule backend default response
func (o *GetTCPResponseRuleBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get TCP response rule backend default response
func (o *GetTCPResponseRuleBackendDefault) WithConfigurationVersion(configurationVersion string) *GetTCPResponseRuleBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get TCP response rule backend default response
func (o *GetTCPResponseRuleBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get TCP response rule backend default response
func (o *GetTCPResponseRuleBackendDefault) WithPayload(payload *models.Error) *GetTCPResponseRuleBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get TCP response rule backend default response
func (o *GetTCPResponseRuleBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetTCPResponseRuleBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
