// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package tcp_request_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceAllTCPRequestRuleBackendOKCode is the HTTP code returned for type ReplaceAllTCPRequestRuleBackendOK
const ReplaceAllTCPRequestRuleBackendOKCode int = 200

/*
ReplaceAllTCPRequestRuleBackendOK All TCP Request Rule lines replaced

swagger:response replaceAllTcpRequestRuleBackendOK
*/
type ReplaceAllTCPRequestRuleBackendOK struct {

	/*
	  In: Body
	*/
	Payload models.TCPRequestRules `json:"body,omitempty"`
}

// NewReplaceAllTCPRequestRuleBackendOK creates ReplaceAllTCPRequestRuleBackendOK with default headers values
func NewReplaceAllTCPRequestRuleBackendOK() *ReplaceAllTCPRequestRuleBackendOK {

	return &ReplaceAllTCPRequestRuleBackendOK{}
}

// WithPayload adds the payload to the replace all Tcp request rule backend o k response
func (o *ReplaceAllTCPRequestRuleBackendOK) WithPayload(payload models.TCPRequestRules) *ReplaceAllTCPRequestRuleBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Tcp request rule backend o k response
func (o *ReplaceAllTCPRequestRuleBackendOK) SetPayload(payload models.TCPRequestRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllTCPRequestRuleBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.TCPRequestRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllTCPRequestRuleBackendAcceptedCode is the HTTP code returned for type ReplaceAllTCPRequestRuleBackendAccepted
const ReplaceAllTCPRequestRuleBackendAcceptedCode int = 202

/*
ReplaceAllTCPRequestRuleBackendAccepted Configuration change accepted and reload requested

swagger:response replaceAllTcpRequestRuleBackendAccepted
*/
type ReplaceAllTCPRequestRuleBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload models.TCPRequestRules `json:"body,omitempty"`
}

// NewReplaceAllTCPRequestRuleBackendAccepted creates ReplaceAllTCPRequestRuleBackendAccepted with default headers values
func NewReplaceAllTCPRequestRuleBackendAccepted() *ReplaceAllTCPRequestRuleBackendAccepted {

	return &ReplaceAllTCPRequestRuleBackendAccepted{}
}

// WithReloadID adds the reloadId to the replace all Tcp request rule backend accepted response
func (o *ReplaceAllTCPRequestRuleBackendAccepted) WithReloadID(reloadID string) *ReplaceAllTCPRequestRuleBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace all Tcp request rule backend accepted response
func (o *ReplaceAllTCPRequestRuleBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace all Tcp request rule backend accepted response
func (o *ReplaceAllTCPRequestRuleBackendAccepted) WithPayload(payload models.TCPRequestRules) *ReplaceAllTCPRequestRuleBackendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Tcp request rule backend accepted response
func (o *ReplaceAllTCPRequestRuleBackendAccepted) SetPayload(payload models.TCPRequestRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllTCPRequestRuleBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.TCPRequestRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllTCPRequestRuleBackendBadRequestCode is the HTTP code returned for type ReplaceAllTCPRequestRuleBackendBadRequest
const ReplaceAllTCPRequestRuleBackendBadRequestCode int = 400

/*
ReplaceAllTCPRequestRuleBackendBadRequest Bad request

swagger:response replaceAllTcpRequestRuleBackendBadRequest
*/
type ReplaceAllTCPRequestRuleBackendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllTCPRequestRuleBackendBadRequest creates ReplaceAllTCPRequestRuleBackendBadRequest with default headers values
func NewReplaceAllTCPRequestRuleBackendBadRequest() *ReplaceAllTCPRequestRuleBackendBadRequest {

	return &ReplaceAllTCPRequestRuleBackendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace all Tcp request rule backend bad request response
func (o *ReplaceAllTCPRequestRuleBackendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceAllTCPRequestRuleBackendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all Tcp request rule backend bad request response
func (o *ReplaceAllTCPRequestRuleBackendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all Tcp request rule backend bad request response
func (o *ReplaceAllTCPRequestRuleBackendBadRequest) WithPayload(payload *models.Error) *ReplaceAllTCPRequestRuleBackendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Tcp request rule backend bad request response
func (o *ReplaceAllTCPRequestRuleBackendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllTCPRequestRuleBackendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceAllTCPRequestRuleBackendDefault General Error

swagger:response replaceAllTcpRequestRuleBackendDefault
*/
type ReplaceAllTCPRequestRuleBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllTCPRequestRuleBackendDefault creates ReplaceAllTCPRequestRuleBackendDefault with default headers values
func NewReplaceAllTCPRequestRuleBackendDefault(code int) *ReplaceAllTCPRequestRuleBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceAllTCPRequestRuleBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace all TCP request rule backend default response
func (o *ReplaceAllTCPRequestRuleBackendDefault) WithStatusCode(code int) *ReplaceAllTCPRequestRuleBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace all TCP request rule backend default response
func (o *ReplaceAllTCPRequestRuleBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace all TCP request rule backend default response
func (o *ReplaceAllTCPRequestRuleBackendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceAllTCPRequestRuleBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all TCP request rule backend default response
func (o *ReplaceAllTCPRequestRuleBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all TCP request rule backend default response
func (o *ReplaceAllTCPRequestRuleBackendDefault) WithPayload(payload *models.Error) *ReplaceAllTCPRequestRuleBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all TCP request rule backend default response
func (o *ReplaceAllTCPRequestRuleBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllTCPRequestRuleBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
