// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package tcp_request_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteTCPRequestRuleBackendAcceptedCode is the HTTP code returned for type DeleteTCPRequestRuleBackendAccepted
const DeleteTCPRequestRuleBackendAcceptedCode int = 202

/*
DeleteTCPRequestRuleBackendAccepted Configuration change accepted and reload requested

swagger:response deleteTcpRequestRuleBackendAccepted
*/
type DeleteTCPRequestRuleBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteTCPRequestRuleBackendAccepted creates DeleteTCPRequestRuleBackendAccepted with default headers values
func NewDeleteTCPRequestRuleBackendAccepted() *DeleteTCPRequestRuleBackendAccepted {

	return &DeleteTCPRequestRuleBackendAccepted{}
}

// WithReloadID adds the reloadId to the delete Tcp request rule backend accepted response
func (o *DeleteTCPRequestRuleBackendAccepted) WithReloadID(reloadID string) *DeleteTCPRequestRuleBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete Tcp request rule backend accepted response
func (o *DeleteTCPRequestRuleBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteTCPRequestRuleBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteTCPRequestRuleBackendNoContentCode is the HTTP code returned for type DeleteTCPRequestRuleBackendNoContent
const DeleteTCPRequestRuleBackendNoContentCode int = 204

/*
DeleteTCPRequestRuleBackendNoContent TCP Request Rule deleted

swagger:response deleteTcpRequestRuleBackendNoContent
*/
type DeleteTCPRequestRuleBackendNoContent struct {
}

// NewDeleteTCPRequestRuleBackendNoContent creates DeleteTCPRequestRuleBackendNoContent with default headers values
func NewDeleteTCPRequestRuleBackendNoContent() *DeleteTCPRequestRuleBackendNoContent {

	return &DeleteTCPRequestRuleBackendNoContent{}
}

// WriteResponse to the client
func (o *DeleteTCPRequestRuleBackendNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteTCPRequestRuleBackendNotFoundCode is the HTTP code returned for type DeleteTCPRequestRuleBackendNotFound
const DeleteTCPRequestRuleBackendNotFoundCode int = 404

/*
DeleteTCPRequestRuleBackendNotFound The specified resource was not found

swagger:response deleteTcpRequestRuleBackendNotFound
*/
type DeleteTCPRequestRuleBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteTCPRequestRuleBackendNotFound creates DeleteTCPRequestRuleBackendNotFound with default headers values
func NewDeleteTCPRequestRuleBackendNotFound() *DeleteTCPRequestRuleBackendNotFound {

	return &DeleteTCPRequestRuleBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete Tcp request rule backend not found response
func (o *DeleteTCPRequestRuleBackendNotFound) WithConfigurationVersion(configurationVersion string) *DeleteTCPRequestRuleBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete Tcp request rule backend not found response
func (o *DeleteTCPRequestRuleBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete Tcp request rule backend not found response
func (o *DeleteTCPRequestRuleBackendNotFound) WithPayload(payload *models.Error) *DeleteTCPRequestRuleBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete Tcp request rule backend not found response
func (o *DeleteTCPRequestRuleBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteTCPRequestRuleBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteTCPRequestRuleBackendDefault General Error

swagger:response deleteTcpRequestRuleBackendDefault
*/
type DeleteTCPRequestRuleBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteTCPRequestRuleBackendDefault creates DeleteTCPRequestRuleBackendDefault with default headers values
func NewDeleteTCPRequestRuleBackendDefault(code int) *DeleteTCPRequestRuleBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteTCPRequestRuleBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete TCP request rule backend default response
func (o *DeleteTCPRequestRuleBackendDefault) WithStatusCode(code int) *DeleteTCPRequestRuleBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete TCP request rule backend default response
func (o *DeleteTCPRequestRuleBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete TCP request rule backend default response
func (o *DeleteTCPRequestRuleBackendDefault) WithConfigurationVersion(configurationVersion string) *DeleteTCPRequestRuleBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete TCP request rule backend default response
func (o *DeleteTCPRequestRuleBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete TCP request rule backend default response
func (o *DeleteTCPRequestRuleBackendDefault) WithPayload(payload *models.Error) *DeleteTCPRequestRuleBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete TCP request rule backend default response
func (o *DeleteTCPRequestRuleBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteTCPRequestRuleBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
