// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package tcp_request_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateTCPRequestRuleFrontendCreatedCode is the HTTP code returned for type CreateTCPRequestRuleFrontendCreated
const CreateTCPRequestRuleFrontendCreatedCode int = 201

/*
CreateTCPRequestRuleFrontendCreated TCP Request Rule created

swagger:response createTcpRequestRuleFrontendCreated
*/
type CreateTCPRequestRuleFrontendCreated struct {

	/*
	  In: Body
	*/
	Payload *models.TCPRequestRule `json:"body,omitempty"`
}

// NewCreateTCPRequestRuleFrontendCreated creates CreateTCPRequestRuleFrontendCreated with default headers values
func NewCreateTCPRequestRuleFrontendCreated() *CreateTCPRequestRuleFrontendCreated {

	return &CreateTCPRequestRuleFrontendCreated{}
}

// WithPayload adds the payload to the create Tcp request rule frontend created response
func (o *CreateTCPRequestRuleFrontendCreated) WithPayload(payload *models.TCPRequestRule) *CreateTCPRequestRuleFrontendCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Tcp request rule frontend created response
func (o *CreateTCPRequestRuleFrontendCreated) SetPayload(payload *models.TCPRequestRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateTCPRequestRuleFrontendCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateTCPRequestRuleFrontendAcceptedCode is the HTTP code returned for type CreateTCPRequestRuleFrontendAccepted
const CreateTCPRequestRuleFrontendAcceptedCode int = 202

/*
CreateTCPRequestRuleFrontendAccepted Configuration change accepted and reload requested

swagger:response createTcpRequestRuleFrontendAccepted
*/
type CreateTCPRequestRuleFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.TCPRequestRule `json:"body,omitempty"`
}

// NewCreateTCPRequestRuleFrontendAccepted creates CreateTCPRequestRuleFrontendAccepted with default headers values
func NewCreateTCPRequestRuleFrontendAccepted() *CreateTCPRequestRuleFrontendAccepted {

	return &CreateTCPRequestRuleFrontendAccepted{}
}

// WithReloadID adds the reloadId to the create Tcp request rule frontend accepted response
func (o *CreateTCPRequestRuleFrontendAccepted) WithReloadID(reloadID string) *CreateTCPRequestRuleFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create Tcp request rule frontend accepted response
func (o *CreateTCPRequestRuleFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create Tcp request rule frontend accepted response
func (o *CreateTCPRequestRuleFrontendAccepted) WithPayload(payload *models.TCPRequestRule) *CreateTCPRequestRuleFrontendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Tcp request rule frontend accepted response
func (o *CreateTCPRequestRuleFrontendAccepted) SetPayload(payload *models.TCPRequestRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateTCPRequestRuleFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateTCPRequestRuleFrontendBadRequestCode is the HTTP code returned for type CreateTCPRequestRuleFrontendBadRequest
const CreateTCPRequestRuleFrontendBadRequestCode int = 400

/*
CreateTCPRequestRuleFrontendBadRequest Bad request

swagger:response createTcpRequestRuleFrontendBadRequest
*/
type CreateTCPRequestRuleFrontendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateTCPRequestRuleFrontendBadRequest creates CreateTCPRequestRuleFrontendBadRequest with default headers values
func NewCreateTCPRequestRuleFrontendBadRequest() *CreateTCPRequestRuleFrontendBadRequest {

	return &CreateTCPRequestRuleFrontendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create Tcp request rule frontend bad request response
func (o *CreateTCPRequestRuleFrontendBadRequest) WithConfigurationVersion(configurationVersion string) *CreateTCPRequestRuleFrontendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Tcp request rule frontend bad request response
func (o *CreateTCPRequestRuleFrontendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Tcp request rule frontend bad request response
func (o *CreateTCPRequestRuleFrontendBadRequest) WithPayload(payload *models.Error) *CreateTCPRequestRuleFrontendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Tcp request rule frontend bad request response
func (o *CreateTCPRequestRuleFrontendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateTCPRequestRuleFrontendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateTCPRequestRuleFrontendConflictCode is the HTTP code returned for type CreateTCPRequestRuleFrontendConflict
const CreateTCPRequestRuleFrontendConflictCode int = 409

/*
CreateTCPRequestRuleFrontendConflict The specified resource already exists

swagger:response createTcpRequestRuleFrontendConflict
*/
type CreateTCPRequestRuleFrontendConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateTCPRequestRuleFrontendConflict creates CreateTCPRequestRuleFrontendConflict with default headers values
func NewCreateTCPRequestRuleFrontendConflict() *CreateTCPRequestRuleFrontendConflict {

	return &CreateTCPRequestRuleFrontendConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create Tcp request rule frontend conflict response
func (o *CreateTCPRequestRuleFrontendConflict) WithConfigurationVersion(configurationVersion string) *CreateTCPRequestRuleFrontendConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Tcp request rule frontend conflict response
func (o *CreateTCPRequestRuleFrontendConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Tcp request rule frontend conflict response
func (o *CreateTCPRequestRuleFrontendConflict) WithPayload(payload *models.Error) *CreateTCPRequestRuleFrontendConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Tcp request rule frontend conflict response
func (o *CreateTCPRequestRuleFrontendConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateTCPRequestRuleFrontendConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateTCPRequestRuleFrontendDefault General Error

swagger:response createTcpRequestRuleFrontendDefault
*/
type CreateTCPRequestRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateTCPRequestRuleFrontendDefault creates CreateTCPRequestRuleFrontendDefault with default headers values
func NewCreateTCPRequestRuleFrontendDefault(code int) *CreateTCPRequestRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateTCPRequestRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create TCP request rule frontend default response
func (o *CreateTCPRequestRuleFrontendDefault) WithStatusCode(code int) *CreateTCPRequestRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create TCP request rule frontend default response
func (o *CreateTCPRequestRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create TCP request rule frontend default response
func (o *CreateTCPRequestRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *CreateTCPRequestRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create TCP request rule frontend default response
func (o *CreateTCPRequestRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create TCP request rule frontend default response
func (o *CreateTCPRequestRuleFrontendDefault) WithPayload(payload *models.Error) *CreateTCPRequestRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create TCP request rule frontend default response
func (o *CreateTCPRequestRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateTCPRequestRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
