// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package tcp_check

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceTCPCheckBackendOKCode is the HTTP code returned for type ReplaceTCPCheckBackendOK
const ReplaceTCPCheckBackendOKCode int = 200

/*
ReplaceTCPCheckBackendOK TCP check replaced

swagger:response replaceTcpCheckBackendOK
*/
type ReplaceTCPCheckBackendOK struct {

	/*
	  In: Body
	*/
	Payload *models.TCPCheck `json:"body,omitempty"`
}

// NewReplaceTCPCheckBackendOK creates ReplaceTCPCheckBackendOK with default headers values
func NewReplaceTCPCheckBackendOK() *ReplaceTCPCheckBackendOK {

	return &ReplaceTCPCheckBackendOK{}
}

// WithPayload adds the payload to the replace Tcp check backend o k response
func (o *ReplaceTCPCheckBackendOK) WithPayload(payload *models.TCPCheck) *ReplaceTCPCheckBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Tcp check backend o k response
func (o *ReplaceTCPCheckBackendOK) SetPayload(payload *models.TCPCheck) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceTCPCheckBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceTCPCheckBackendAcceptedCode is the HTTP code returned for type ReplaceTCPCheckBackendAccepted
const ReplaceTCPCheckBackendAcceptedCode int = 202

/*
ReplaceTCPCheckBackendAccepted Configuration change accepted and reload requested

swagger:response replaceTcpCheckBackendAccepted
*/
type ReplaceTCPCheckBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.TCPCheck `json:"body,omitempty"`
}

// NewReplaceTCPCheckBackendAccepted creates ReplaceTCPCheckBackendAccepted with default headers values
func NewReplaceTCPCheckBackendAccepted() *ReplaceTCPCheckBackendAccepted {

	return &ReplaceTCPCheckBackendAccepted{}
}

// WithReloadID adds the reloadId to the replace Tcp check backend accepted response
func (o *ReplaceTCPCheckBackendAccepted) WithReloadID(reloadID string) *ReplaceTCPCheckBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace Tcp check backend accepted response
func (o *ReplaceTCPCheckBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace Tcp check backend accepted response
func (o *ReplaceTCPCheckBackendAccepted) WithPayload(payload *models.TCPCheck) *ReplaceTCPCheckBackendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Tcp check backend accepted response
func (o *ReplaceTCPCheckBackendAccepted) SetPayload(payload *models.TCPCheck) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceTCPCheckBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceTCPCheckBackendBadRequestCode is the HTTP code returned for type ReplaceTCPCheckBackendBadRequest
const ReplaceTCPCheckBackendBadRequestCode int = 400

/*
ReplaceTCPCheckBackendBadRequest Bad request

swagger:response replaceTcpCheckBackendBadRequest
*/
type ReplaceTCPCheckBackendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceTCPCheckBackendBadRequest creates ReplaceTCPCheckBackendBadRequest with default headers values
func NewReplaceTCPCheckBackendBadRequest() *ReplaceTCPCheckBackendBadRequest {

	return &ReplaceTCPCheckBackendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Tcp check backend bad request response
func (o *ReplaceTCPCheckBackendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceTCPCheckBackendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Tcp check backend bad request response
func (o *ReplaceTCPCheckBackendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Tcp check backend bad request response
func (o *ReplaceTCPCheckBackendBadRequest) WithPayload(payload *models.Error) *ReplaceTCPCheckBackendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Tcp check backend bad request response
func (o *ReplaceTCPCheckBackendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceTCPCheckBackendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceTCPCheckBackendNotFoundCode is the HTTP code returned for type ReplaceTCPCheckBackendNotFound
const ReplaceTCPCheckBackendNotFoundCode int = 404

/*
ReplaceTCPCheckBackendNotFound The specified resource was not found

swagger:response replaceTcpCheckBackendNotFound
*/
type ReplaceTCPCheckBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceTCPCheckBackendNotFound creates ReplaceTCPCheckBackendNotFound with default headers values
func NewReplaceTCPCheckBackendNotFound() *ReplaceTCPCheckBackendNotFound {

	return &ReplaceTCPCheckBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Tcp check backend not found response
func (o *ReplaceTCPCheckBackendNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceTCPCheckBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Tcp check backend not found response
func (o *ReplaceTCPCheckBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Tcp check backend not found response
func (o *ReplaceTCPCheckBackendNotFound) WithPayload(payload *models.Error) *ReplaceTCPCheckBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Tcp check backend not found response
func (o *ReplaceTCPCheckBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceTCPCheckBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceTCPCheckBackendDefault General Error

swagger:response replaceTcpCheckBackendDefault
*/
type ReplaceTCPCheckBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceTCPCheckBackendDefault creates ReplaceTCPCheckBackendDefault with default headers values
func NewReplaceTCPCheckBackendDefault(code int) *ReplaceTCPCheckBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceTCPCheckBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace TCP check backend default response
func (o *ReplaceTCPCheckBackendDefault) WithStatusCode(code int) *ReplaceTCPCheckBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace TCP check backend default response
func (o *ReplaceTCPCheckBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace TCP check backend default response
func (o *ReplaceTCPCheckBackendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceTCPCheckBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace TCP check backend default response
func (o *ReplaceTCPCheckBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace TCP check backend default response
func (o *ReplaceTCPCheckBackendDefault) WithPayload(payload *models.Error) *ReplaceTCPCheckBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace TCP check backend default response
func (o *ReplaceTCPCheckBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceTCPCheckBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
