// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package server

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetServerRingOKCode is the HTTP code returned for type GetServerRingOK
const GetServerRingOKCode int = 200

/*
GetServerRingOK Successful operation

swagger:response getServerRingOK
*/
type GetServerRingOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Server `json:"body,omitempty"`
}

// NewGetServerRingOK creates GetServerRingOK with default headers values
func NewGetServerRingOK() *GetServerRingOK {

	return &GetServerRingOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get server ring o k response
func (o *GetServerRingOK) WithConfigurationVersion(configurationVersion string) *GetServerRingOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get server ring o k response
func (o *GetServerRingOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get server ring o k response
func (o *GetServerRingOK) WithPayload(payload *models.Server) *GetServerRingOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get server ring o k response
func (o *GetServerRingOK) SetPayload(payload *models.Server) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetServerRingOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetServerRingNotFoundCode is the HTTP code returned for type GetServerRingNotFound
const GetServerRingNotFoundCode int = 404

/*
GetServerRingNotFound The specified resource was not found

swagger:response getServerRingNotFound
*/
type GetServerRingNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetServerRingNotFound creates GetServerRingNotFound with default headers values
func NewGetServerRingNotFound() *GetServerRingNotFound {

	return &GetServerRingNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get server ring not found response
func (o *GetServerRingNotFound) WithConfigurationVersion(configurationVersion string) *GetServerRingNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get server ring not found response
func (o *GetServerRingNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get server ring not found response
func (o *GetServerRingNotFound) WithPayload(payload *models.Error) *GetServerRingNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get server ring not found response
func (o *GetServerRingNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetServerRingNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetServerRingDefault General Error

swagger:response getServerRingDefault
*/
type GetServerRingDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetServerRingDefault creates GetServerRingDefault with default headers values
func NewGetServerRingDefault(code int) *GetServerRingDefault {
	if code <= 0 {
		code = 500
	}

	return &GetServerRingDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get server ring default response
func (o *GetServerRingDefault) WithStatusCode(code int) *GetServerRingDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get server ring default response
func (o *GetServerRingDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get server ring default response
func (o *GetServerRingDefault) WithConfigurationVersion(configurationVersion string) *GetServerRingDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get server ring default response
func (o *GetServerRingDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get server ring default response
func (o *GetServerRingDefault) WithPayload(payload *models.Error) *GetServerRingDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get server ring default response
func (o *GetServerRingDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetServerRingDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
