// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package server

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllServerPeerOKCode is the HTTP code returned for type GetAllServerPeerOK
const GetAllServerPeerOKCode int = 200

/*
GetAllServerPeerOK Successful operation

swagger:response getAllServerPeerOK
*/
type GetAllServerPeerOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.Servers `json:"body,omitempty"`
}

// NewGetAllServerPeerOK creates GetAllServerPeerOK with default headers values
func NewGetAllServerPeerOK() *GetAllServerPeerOK {

	return &GetAllServerPeerOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all server peer o k response
func (o *GetAllServerPeerOK) WithConfigurationVersion(configurationVersion string) *GetAllServerPeerOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all server peer o k response
func (o *GetAllServerPeerOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all server peer o k response
func (o *GetAllServerPeerOK) WithPayload(payload models.Servers) *GetAllServerPeerOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all server peer o k response
func (o *GetAllServerPeerOK) SetPayload(payload models.Servers) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllServerPeerOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.Servers{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllServerPeerDefault General Error

swagger:response getAllServerPeerDefault
*/
type GetAllServerPeerDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllServerPeerDefault creates GetAllServerPeerDefault with default headers values
func NewGetAllServerPeerDefault(code int) *GetAllServerPeerDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllServerPeerDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all server peer default response
func (o *GetAllServerPeerDefault) WithStatusCode(code int) *GetAllServerPeerDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all server peer default response
func (o *GetAllServerPeerDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all server peer default response
func (o *GetAllServerPeerDefault) WithConfigurationVersion(configurationVersion string) *GetAllServerPeerDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all server peer default response
func (o *GetAllServerPeerDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all server peer default response
func (o *GetAllServerPeerDefault) WithPayload(payload *models.Error) *GetAllServerPeerDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all server peer default response
func (o *GetAllServerPeerDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllServerPeerDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
