// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package quic_initial_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteQUICInitialRuleDefaultsAcceptedCode is the HTTP code returned for type DeleteQUICInitialRuleDefaultsAccepted
const DeleteQUICInitialRuleDefaultsAcceptedCode int = 202

/*
DeleteQUICInitialRuleDefaultsAccepted Configuration change accepted and reload requested

swagger:response deleteQuicInitialRuleDefaultsAccepted
*/
type DeleteQUICInitialRuleDefaultsAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteQUICInitialRuleDefaultsAccepted creates DeleteQUICInitialRuleDefaultsAccepted with default headers values
func NewDeleteQUICInitialRuleDefaultsAccepted() *DeleteQUICInitialRuleDefaultsAccepted {

	return &DeleteQUICInitialRuleDefaultsAccepted{}
}

// WithReloadID adds the reloadId to the delete Quic initial rule defaults accepted response
func (o *DeleteQUICInitialRuleDefaultsAccepted) WithReloadID(reloadID string) *DeleteQUICInitialRuleDefaultsAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete Quic initial rule defaults accepted response
func (o *DeleteQUICInitialRuleDefaultsAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteQUICInitialRuleDefaultsAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteQUICInitialRuleDefaultsNoContentCode is the HTTP code returned for type DeleteQUICInitialRuleDefaultsNoContent
const DeleteQUICInitialRuleDefaultsNoContentCode int = 204

/*
DeleteQUICInitialRuleDefaultsNoContent QUIC Initial Rule deleted

swagger:response deleteQuicInitialRuleDefaultsNoContent
*/
type DeleteQUICInitialRuleDefaultsNoContent struct {
}

// NewDeleteQUICInitialRuleDefaultsNoContent creates DeleteQUICInitialRuleDefaultsNoContent with default headers values
func NewDeleteQUICInitialRuleDefaultsNoContent() *DeleteQUICInitialRuleDefaultsNoContent {

	return &DeleteQUICInitialRuleDefaultsNoContent{}
}

// WriteResponse to the client
func (o *DeleteQUICInitialRuleDefaultsNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteQUICInitialRuleDefaultsNotFoundCode is the HTTP code returned for type DeleteQUICInitialRuleDefaultsNotFound
const DeleteQUICInitialRuleDefaultsNotFoundCode int = 404

/*
DeleteQUICInitialRuleDefaultsNotFound The specified resource was not found

swagger:response deleteQuicInitialRuleDefaultsNotFound
*/
type DeleteQUICInitialRuleDefaultsNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteQUICInitialRuleDefaultsNotFound creates DeleteQUICInitialRuleDefaultsNotFound with default headers values
func NewDeleteQUICInitialRuleDefaultsNotFound() *DeleteQUICInitialRuleDefaultsNotFound {

	return &DeleteQUICInitialRuleDefaultsNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete Quic initial rule defaults not found response
func (o *DeleteQUICInitialRuleDefaultsNotFound) WithConfigurationVersion(configurationVersion string) *DeleteQUICInitialRuleDefaultsNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete Quic initial rule defaults not found response
func (o *DeleteQUICInitialRuleDefaultsNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete Quic initial rule defaults not found response
func (o *DeleteQUICInitialRuleDefaultsNotFound) WithPayload(payload *models.Error) *DeleteQUICInitialRuleDefaultsNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete Quic initial rule defaults not found response
func (o *DeleteQUICInitialRuleDefaultsNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteQUICInitialRuleDefaultsNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteQUICInitialRuleDefaultsDefault General Error

swagger:response deleteQuicInitialRuleDefaultsDefault
*/
type DeleteQUICInitialRuleDefaultsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteQUICInitialRuleDefaultsDefault creates DeleteQUICInitialRuleDefaultsDefault with default headers values
func NewDeleteQUICInitialRuleDefaultsDefault(code int) *DeleteQUICInitialRuleDefaultsDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteQUICInitialRuleDefaultsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete QUIC initial rule defaults default response
func (o *DeleteQUICInitialRuleDefaultsDefault) WithStatusCode(code int) *DeleteQUICInitialRuleDefaultsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete QUIC initial rule defaults default response
func (o *DeleteQUICInitialRuleDefaultsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete QUIC initial rule defaults default response
func (o *DeleteQUICInitialRuleDefaultsDefault) WithConfigurationVersion(configurationVersion string) *DeleteQUICInitialRuleDefaultsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete QUIC initial rule defaults default response
func (o *DeleteQUICInitialRuleDefaultsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete QUIC initial rule defaults default response
func (o *DeleteQUICInitialRuleDefaultsDefault) WithPayload(payload *models.Error) *DeleteQUICInitialRuleDefaultsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete QUIC initial rule defaults default response
func (o *DeleteQUICInitialRuleDefaultsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteQUICInitialRuleDefaultsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
