// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_response_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetHTTPResponseRuleFrontendOKCode is the HTTP code returned for type GetHTTPResponseRuleFrontendOK
const GetHTTPResponseRuleFrontendOKCode int = 200

/*
GetHTTPResponseRuleFrontendOK Successful operation

swagger:response getHttpResponseRuleFrontendOK
*/
type GetHTTPResponseRuleFrontendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.HTTPResponseRule `json:"body,omitempty"`
}

// NewGetHTTPResponseRuleFrontendOK creates GetHTTPResponseRuleFrontendOK with default headers values
func NewGetHTTPResponseRuleFrontendOK() *GetHTTPResponseRuleFrontendOK {

	return &GetHTTPResponseRuleFrontendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get Http response rule frontend o k response
func (o *GetHTTPResponseRuleFrontendOK) WithConfigurationVersion(configurationVersion string) *GetHTTPResponseRuleFrontendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Http response rule frontend o k response
func (o *GetHTTPResponseRuleFrontendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Http response rule frontend o k response
func (o *GetHTTPResponseRuleFrontendOK) WithPayload(payload *models.HTTPResponseRule) *GetHTTPResponseRuleFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Http response rule frontend o k response
func (o *GetHTTPResponseRuleFrontendOK) SetPayload(payload *models.HTTPResponseRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHTTPResponseRuleFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetHTTPResponseRuleFrontendNotFoundCode is the HTTP code returned for type GetHTTPResponseRuleFrontendNotFound
const GetHTTPResponseRuleFrontendNotFoundCode int = 404

/*
GetHTTPResponseRuleFrontendNotFound The specified resource was not found

swagger:response getHttpResponseRuleFrontendNotFound
*/
type GetHTTPResponseRuleFrontendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetHTTPResponseRuleFrontendNotFound creates GetHTTPResponseRuleFrontendNotFound with default headers values
func NewGetHTTPResponseRuleFrontendNotFound() *GetHTTPResponseRuleFrontendNotFound {

	return &GetHTTPResponseRuleFrontendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get Http response rule frontend not found response
func (o *GetHTTPResponseRuleFrontendNotFound) WithConfigurationVersion(configurationVersion string) *GetHTTPResponseRuleFrontendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Http response rule frontend not found response
func (o *GetHTTPResponseRuleFrontendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Http response rule frontend not found response
func (o *GetHTTPResponseRuleFrontendNotFound) WithPayload(payload *models.Error) *GetHTTPResponseRuleFrontendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Http response rule frontend not found response
func (o *GetHTTPResponseRuleFrontendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHTTPResponseRuleFrontendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetHTTPResponseRuleFrontendDefault General Error

swagger:response getHttpResponseRuleFrontendDefault
*/
type GetHTTPResponseRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetHTTPResponseRuleFrontendDefault creates GetHTTPResponseRuleFrontendDefault with default headers values
func NewGetHTTPResponseRuleFrontendDefault(code int) *GetHTTPResponseRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetHTTPResponseRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get HTTP response rule frontend default response
func (o *GetHTTPResponseRuleFrontendDefault) WithStatusCode(code int) *GetHTTPResponseRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get HTTP response rule frontend default response
func (o *GetHTTPResponseRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get HTTP response rule frontend default response
func (o *GetHTTPResponseRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *GetHTTPResponseRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get HTTP response rule frontend default response
func (o *GetHTTPResponseRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get HTTP response rule frontend default response
func (o *GetHTTPResponseRuleFrontendDefault) WithPayload(payload *models.Error) *GetHTTPResponseRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get HTTP response rule frontend default response
func (o *GetHTTPResponseRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHTTPResponseRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
