// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_request_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllHTTPRequestRuleFrontendOKCode is the HTTP code returned for type GetAllHTTPRequestRuleFrontendOK
const GetAllHTTPRequestRuleFrontendOKCode int = 200

/*
GetAllHTTPRequestRuleFrontendOK Successful operation

swagger:response getAllHttpRequestRuleFrontendOK
*/
type GetAllHTTPRequestRuleFrontendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.HTTPRequestRules `json:"body,omitempty"`
}

// NewGetAllHTTPRequestRuleFrontendOK creates GetAllHTTPRequestRuleFrontendOK with default headers values
func NewGetAllHTTPRequestRuleFrontendOK() *GetAllHTTPRequestRuleFrontendOK {

	return &GetAllHTTPRequestRuleFrontendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all Http request rule frontend o k response
func (o *GetAllHTTPRequestRuleFrontendOK) WithConfigurationVersion(configurationVersion string) *GetAllHTTPRequestRuleFrontendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all Http request rule frontend o k response
func (o *GetAllHTTPRequestRuleFrontendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all Http request rule frontend o k response
func (o *GetAllHTTPRequestRuleFrontendOK) WithPayload(payload models.HTTPRequestRules) *GetAllHTTPRequestRuleFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all Http request rule frontend o k response
func (o *GetAllHTTPRequestRuleFrontendOK) SetPayload(payload models.HTTPRequestRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllHTTPRequestRuleFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.HTTPRequestRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllHTTPRequestRuleFrontendDefault General Error

swagger:response getAllHttpRequestRuleFrontendDefault
*/
type GetAllHTTPRequestRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllHTTPRequestRuleFrontendDefault creates GetAllHTTPRequestRuleFrontendDefault with default headers values
func NewGetAllHTTPRequestRuleFrontendDefault(code int) *GetAllHTTPRequestRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllHTTPRequestRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all HTTP request rule frontend default response
func (o *GetAllHTTPRequestRuleFrontendDefault) WithStatusCode(code int) *GetAllHTTPRequestRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all HTTP request rule frontend default response
func (o *GetAllHTTPRequestRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all HTTP request rule frontend default response
func (o *GetAllHTTPRequestRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *GetAllHTTPRequestRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all HTTP request rule frontend default response
func (o *GetAllHTTPRequestRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all HTTP request rule frontend default response
func (o *GetAllHTTPRequestRuleFrontendDefault) WithPayload(payload *models.Error) *GetAllHTTPRequestRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all HTTP request rule frontend default response
func (o *GetAllHTTPRequestRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllHTTPRequestRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
