// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_error_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteHTTPErrorRuleFrontendAcceptedCode is the HTTP code returned for type DeleteHTTPErrorRuleFrontendAccepted
const DeleteHTTPErrorRuleFrontendAcceptedCode int = 202

/*
DeleteHTTPErrorRuleFrontendAccepted Configuration change accepted and reload requested

swagger:response deleteHttpErrorRuleFrontendAccepted
*/
type DeleteHTTPErrorRuleFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteHTTPErrorRuleFrontendAccepted creates DeleteHTTPErrorRuleFrontendAccepted with default headers values
func NewDeleteHTTPErrorRuleFrontendAccepted() *DeleteHTTPErrorRuleFrontendAccepted {

	return &DeleteHTTPErrorRuleFrontendAccepted{}
}

// WithReloadID adds the reloadId to the delete Http error rule frontend accepted response
func (o *DeleteHTTPErrorRuleFrontendAccepted) WithReloadID(reloadID string) *DeleteHTTPErrorRuleFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete Http error rule frontend accepted response
func (o *DeleteHTTPErrorRuleFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteHTTPErrorRuleFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteHTTPErrorRuleFrontendNoContentCode is the HTTP code returned for type DeleteHTTPErrorRuleFrontendNoContent
const DeleteHTTPErrorRuleFrontendNoContentCode int = 204

/*
DeleteHTTPErrorRuleFrontendNoContent HTTP Error Rule deleted

swagger:response deleteHttpErrorRuleFrontendNoContent
*/
type DeleteHTTPErrorRuleFrontendNoContent struct {
}

// NewDeleteHTTPErrorRuleFrontendNoContent creates DeleteHTTPErrorRuleFrontendNoContent with default headers values
func NewDeleteHTTPErrorRuleFrontendNoContent() *DeleteHTTPErrorRuleFrontendNoContent {

	return &DeleteHTTPErrorRuleFrontendNoContent{}
}

// WriteResponse to the client
func (o *DeleteHTTPErrorRuleFrontendNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteHTTPErrorRuleFrontendNotFoundCode is the HTTP code returned for type DeleteHTTPErrorRuleFrontendNotFound
const DeleteHTTPErrorRuleFrontendNotFoundCode int = 404

/*
DeleteHTTPErrorRuleFrontendNotFound The specified resource was not found

swagger:response deleteHttpErrorRuleFrontendNotFound
*/
type DeleteHTTPErrorRuleFrontendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteHTTPErrorRuleFrontendNotFound creates DeleteHTTPErrorRuleFrontendNotFound with default headers values
func NewDeleteHTTPErrorRuleFrontendNotFound() *DeleteHTTPErrorRuleFrontendNotFound {

	return &DeleteHTTPErrorRuleFrontendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete Http error rule frontend not found response
func (o *DeleteHTTPErrorRuleFrontendNotFound) WithConfigurationVersion(configurationVersion string) *DeleteHTTPErrorRuleFrontendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete Http error rule frontend not found response
func (o *DeleteHTTPErrorRuleFrontendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete Http error rule frontend not found response
func (o *DeleteHTTPErrorRuleFrontendNotFound) WithPayload(payload *models.Error) *DeleteHTTPErrorRuleFrontendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete Http error rule frontend not found response
func (o *DeleteHTTPErrorRuleFrontendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteHTTPErrorRuleFrontendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteHTTPErrorRuleFrontendDefault General Error

swagger:response deleteHttpErrorRuleFrontendDefault
*/
type DeleteHTTPErrorRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteHTTPErrorRuleFrontendDefault creates DeleteHTTPErrorRuleFrontendDefault with default headers values
func NewDeleteHTTPErrorRuleFrontendDefault(code int) *DeleteHTTPErrorRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteHTTPErrorRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete HTTP error rule frontend default response
func (o *DeleteHTTPErrorRuleFrontendDefault) WithStatusCode(code int) *DeleteHTTPErrorRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete HTTP error rule frontend default response
func (o *DeleteHTTPErrorRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete HTTP error rule frontend default response
func (o *DeleteHTTPErrorRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *DeleteHTTPErrorRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete HTTP error rule frontend default response
func (o *DeleteHTTPErrorRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete HTTP error rule frontend default response
func (o *DeleteHTTPErrorRuleFrontendDefault) WithPayload(payload *models.Error) *DeleteHTTPErrorRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete HTTP error rule frontend default response
func (o *DeleteHTTPErrorRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteHTTPErrorRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
