// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_check

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetHTTPCheckDefaultsOKCode is the HTTP code returned for type GetHTTPCheckDefaultsOK
const GetHTTPCheckDefaultsOKCode int = 200

/*
GetHTTPCheckDefaultsOK Successful operation

swagger:response getHttpCheckDefaultsOK
*/
type GetHTTPCheckDefaultsOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.HTTPCheck `json:"body,omitempty"`
}

// NewGetHTTPCheckDefaultsOK creates GetHTTPCheckDefaultsOK with default headers values
func NewGetHTTPCheckDefaultsOK() *GetHTTPCheckDefaultsOK {

	return &GetHTTPCheckDefaultsOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get Http check defaults o k response
func (o *GetHTTPCheckDefaultsOK) WithConfigurationVersion(configurationVersion string) *GetHTTPCheckDefaultsOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Http check defaults o k response
func (o *GetHTTPCheckDefaultsOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Http check defaults o k response
func (o *GetHTTPCheckDefaultsOK) WithPayload(payload *models.HTTPCheck) *GetHTTPCheckDefaultsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Http check defaults o k response
func (o *GetHTTPCheckDefaultsOK) SetPayload(payload *models.HTTPCheck) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHTTPCheckDefaultsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetHTTPCheckDefaultsNotFoundCode is the HTTP code returned for type GetHTTPCheckDefaultsNotFound
const GetHTTPCheckDefaultsNotFoundCode int = 404

/*
GetHTTPCheckDefaultsNotFound The specified resource was not found

swagger:response getHttpCheckDefaultsNotFound
*/
type GetHTTPCheckDefaultsNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetHTTPCheckDefaultsNotFound creates GetHTTPCheckDefaultsNotFound with default headers values
func NewGetHTTPCheckDefaultsNotFound() *GetHTTPCheckDefaultsNotFound {

	return &GetHTTPCheckDefaultsNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get Http check defaults not found response
func (o *GetHTTPCheckDefaultsNotFound) WithConfigurationVersion(configurationVersion string) *GetHTTPCheckDefaultsNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Http check defaults not found response
func (o *GetHTTPCheckDefaultsNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Http check defaults not found response
func (o *GetHTTPCheckDefaultsNotFound) WithPayload(payload *models.Error) *GetHTTPCheckDefaultsNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Http check defaults not found response
func (o *GetHTTPCheckDefaultsNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHTTPCheckDefaultsNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetHTTPCheckDefaultsDefault General Error

swagger:response getHttpCheckDefaultsDefault
*/
type GetHTTPCheckDefaultsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetHTTPCheckDefaultsDefault creates GetHTTPCheckDefaultsDefault with default headers values
func NewGetHTTPCheckDefaultsDefault(code int) *GetHTTPCheckDefaultsDefault {
	if code <= 0 {
		code = 500
	}

	return &GetHTTPCheckDefaultsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get HTTP check defaults default response
func (o *GetHTTPCheckDefaultsDefault) WithStatusCode(code int) *GetHTTPCheckDefaultsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get HTTP check defaults default response
func (o *GetHTTPCheckDefaultsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get HTTP check defaults default response
func (o *GetHTTPCheckDefaultsDefault) WithConfigurationVersion(configurationVersion string) *GetHTTPCheckDefaultsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get HTTP check defaults default response
func (o *GetHTTPCheckDefaultsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get HTTP check defaults default response
func (o *GetHTTPCheckDefaultsDefault) WithPayload(payload *models.Error) *GetHTTPCheckDefaultsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get HTTP check defaults default response
func (o *GetHTTPCheckDefaultsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHTTPCheckDefaultsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
