// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_after_response_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceHTTPAfterResponseRuleFrontendOKCode is the HTTP code returned for type ReplaceHTTPAfterResponseRuleFrontendOK
const ReplaceHTTPAfterResponseRuleFrontendOKCode int = 200

/*
ReplaceHTTPAfterResponseRuleFrontendOK HTTP After Response Rule replaced

swagger:response replaceHttpAfterResponseRuleFrontendOK
*/
type ReplaceHTTPAfterResponseRuleFrontendOK struct {

	/*
	  In: Body
	*/
	Payload *models.HTTPAfterResponseRule `json:"body,omitempty"`
}

// NewReplaceHTTPAfterResponseRuleFrontendOK creates ReplaceHTTPAfterResponseRuleFrontendOK with default headers values
func NewReplaceHTTPAfterResponseRuleFrontendOK() *ReplaceHTTPAfterResponseRuleFrontendOK {

	return &ReplaceHTTPAfterResponseRuleFrontendOK{}
}

// WithPayload adds the payload to the replace Http after response rule frontend o k response
func (o *ReplaceHTTPAfterResponseRuleFrontendOK) WithPayload(payload *models.HTTPAfterResponseRule) *ReplaceHTTPAfterResponseRuleFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http after response rule frontend o k response
func (o *ReplaceHTTPAfterResponseRuleFrontendOK) SetPayload(payload *models.HTTPAfterResponseRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPAfterResponseRuleFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceHTTPAfterResponseRuleFrontendAcceptedCode is the HTTP code returned for type ReplaceHTTPAfterResponseRuleFrontendAccepted
const ReplaceHTTPAfterResponseRuleFrontendAcceptedCode int = 202

/*
ReplaceHTTPAfterResponseRuleFrontendAccepted Configuration change accepted and reload requested

swagger:response replaceHttpAfterResponseRuleFrontendAccepted
*/
type ReplaceHTTPAfterResponseRuleFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.HTTPAfterResponseRule `json:"body,omitempty"`
}

// NewReplaceHTTPAfterResponseRuleFrontendAccepted creates ReplaceHTTPAfterResponseRuleFrontendAccepted with default headers values
func NewReplaceHTTPAfterResponseRuleFrontendAccepted() *ReplaceHTTPAfterResponseRuleFrontendAccepted {

	return &ReplaceHTTPAfterResponseRuleFrontendAccepted{}
}

// WithReloadID adds the reloadId to the replace Http after response rule frontend accepted response
func (o *ReplaceHTTPAfterResponseRuleFrontendAccepted) WithReloadID(reloadID string) *ReplaceHTTPAfterResponseRuleFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace Http after response rule frontend accepted response
func (o *ReplaceHTTPAfterResponseRuleFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace Http after response rule frontend accepted response
func (o *ReplaceHTTPAfterResponseRuleFrontendAccepted) WithPayload(payload *models.HTTPAfterResponseRule) *ReplaceHTTPAfterResponseRuleFrontendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http after response rule frontend accepted response
func (o *ReplaceHTTPAfterResponseRuleFrontendAccepted) SetPayload(payload *models.HTTPAfterResponseRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPAfterResponseRuleFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceHTTPAfterResponseRuleFrontendBadRequestCode is the HTTP code returned for type ReplaceHTTPAfterResponseRuleFrontendBadRequest
const ReplaceHTTPAfterResponseRuleFrontendBadRequestCode int = 400

/*
ReplaceHTTPAfterResponseRuleFrontendBadRequest Bad request

swagger:response replaceHttpAfterResponseRuleFrontendBadRequest
*/
type ReplaceHTTPAfterResponseRuleFrontendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceHTTPAfterResponseRuleFrontendBadRequest creates ReplaceHTTPAfterResponseRuleFrontendBadRequest with default headers values
func NewReplaceHTTPAfterResponseRuleFrontendBadRequest() *ReplaceHTTPAfterResponseRuleFrontendBadRequest {

	return &ReplaceHTTPAfterResponseRuleFrontendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Http after response rule frontend bad request response
func (o *ReplaceHTTPAfterResponseRuleFrontendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceHTTPAfterResponseRuleFrontendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Http after response rule frontend bad request response
func (o *ReplaceHTTPAfterResponseRuleFrontendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Http after response rule frontend bad request response
func (o *ReplaceHTTPAfterResponseRuleFrontendBadRequest) WithPayload(payload *models.Error) *ReplaceHTTPAfterResponseRuleFrontendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http after response rule frontend bad request response
func (o *ReplaceHTTPAfterResponseRuleFrontendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPAfterResponseRuleFrontendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceHTTPAfterResponseRuleFrontendNotFoundCode is the HTTP code returned for type ReplaceHTTPAfterResponseRuleFrontendNotFound
const ReplaceHTTPAfterResponseRuleFrontendNotFoundCode int = 404

/*
ReplaceHTTPAfterResponseRuleFrontendNotFound The specified resource was not found

swagger:response replaceHttpAfterResponseRuleFrontendNotFound
*/
type ReplaceHTTPAfterResponseRuleFrontendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceHTTPAfterResponseRuleFrontendNotFound creates ReplaceHTTPAfterResponseRuleFrontendNotFound with default headers values
func NewReplaceHTTPAfterResponseRuleFrontendNotFound() *ReplaceHTTPAfterResponseRuleFrontendNotFound {

	return &ReplaceHTTPAfterResponseRuleFrontendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Http after response rule frontend not found response
func (o *ReplaceHTTPAfterResponseRuleFrontendNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceHTTPAfterResponseRuleFrontendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Http after response rule frontend not found response
func (o *ReplaceHTTPAfterResponseRuleFrontendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Http after response rule frontend not found response
func (o *ReplaceHTTPAfterResponseRuleFrontendNotFound) WithPayload(payload *models.Error) *ReplaceHTTPAfterResponseRuleFrontendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http after response rule frontend not found response
func (o *ReplaceHTTPAfterResponseRuleFrontendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPAfterResponseRuleFrontendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceHTTPAfterResponseRuleFrontendDefault General Error

swagger:response replaceHttpAfterResponseRuleFrontendDefault
*/
type ReplaceHTTPAfterResponseRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceHTTPAfterResponseRuleFrontendDefault creates ReplaceHTTPAfterResponseRuleFrontendDefault with default headers values
func NewReplaceHTTPAfterResponseRuleFrontendDefault(code int) *ReplaceHTTPAfterResponseRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceHTTPAfterResponseRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace HTTP after response rule frontend default response
func (o *ReplaceHTTPAfterResponseRuleFrontendDefault) WithStatusCode(code int) *ReplaceHTTPAfterResponseRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace HTTP after response rule frontend default response
func (o *ReplaceHTTPAfterResponseRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace HTTP after response rule frontend default response
func (o *ReplaceHTTPAfterResponseRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceHTTPAfterResponseRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace HTTP after response rule frontend default response
func (o *ReplaceHTTPAfterResponseRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace HTTP after response rule frontend default response
func (o *ReplaceHTTPAfterResponseRuleFrontendDefault) WithPayload(payload *models.Error) *ReplaceHTTPAfterResponseRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace HTTP after response rule frontend default response
func (o *ReplaceHTTPAfterResponseRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPAfterResponseRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
