// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package filter

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceFilterBackendOKCode is the HTTP code returned for type ReplaceFilterBackendOK
const ReplaceFilterBackendOKCode int = 200

/*
ReplaceFilterBackendOK Filter replaced

swagger:response replaceFilterBackendOK
*/
type ReplaceFilterBackendOK struct {

	/*
	  In: Body
	*/
	Payload *models.Filter `json:"body,omitempty"`
}

// NewReplaceFilterBackendOK creates ReplaceFilterBackendOK with default headers values
func NewReplaceFilterBackendOK() *ReplaceFilterBackendOK {

	return &ReplaceFilterBackendOK{}
}

// WithPayload adds the payload to the replace filter backend o k response
func (o *ReplaceFilterBackendOK) WithPayload(payload *models.Filter) *ReplaceFilterBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace filter backend o k response
func (o *ReplaceFilterBackendOK) SetPayload(payload *models.Filter) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceFilterBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceFilterBackendAcceptedCode is the HTTP code returned for type ReplaceFilterBackendAccepted
const ReplaceFilterBackendAcceptedCode int = 202

/*
ReplaceFilterBackendAccepted Configuration change accepted and reload requested

swagger:response replaceFilterBackendAccepted
*/
type ReplaceFilterBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.Filter `json:"body,omitempty"`
}

// NewReplaceFilterBackendAccepted creates ReplaceFilterBackendAccepted with default headers values
func NewReplaceFilterBackendAccepted() *ReplaceFilterBackendAccepted {

	return &ReplaceFilterBackendAccepted{}
}

// WithReloadID adds the reloadId to the replace filter backend accepted response
func (o *ReplaceFilterBackendAccepted) WithReloadID(reloadID string) *ReplaceFilterBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace filter backend accepted response
func (o *ReplaceFilterBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace filter backend accepted response
func (o *ReplaceFilterBackendAccepted) WithPayload(payload *models.Filter) *ReplaceFilterBackendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace filter backend accepted response
func (o *ReplaceFilterBackendAccepted) SetPayload(payload *models.Filter) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceFilterBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceFilterBackendBadRequestCode is the HTTP code returned for type ReplaceFilterBackendBadRequest
const ReplaceFilterBackendBadRequestCode int = 400

/*
ReplaceFilterBackendBadRequest Bad request

swagger:response replaceFilterBackendBadRequest
*/
type ReplaceFilterBackendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceFilterBackendBadRequest creates ReplaceFilterBackendBadRequest with default headers values
func NewReplaceFilterBackendBadRequest() *ReplaceFilterBackendBadRequest {

	return &ReplaceFilterBackendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace filter backend bad request response
func (o *ReplaceFilterBackendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceFilterBackendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace filter backend bad request response
func (o *ReplaceFilterBackendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace filter backend bad request response
func (o *ReplaceFilterBackendBadRequest) WithPayload(payload *models.Error) *ReplaceFilterBackendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace filter backend bad request response
func (o *ReplaceFilterBackendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceFilterBackendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceFilterBackendNotFoundCode is the HTTP code returned for type ReplaceFilterBackendNotFound
const ReplaceFilterBackendNotFoundCode int = 404

/*
ReplaceFilterBackendNotFound The specified resource was not found

swagger:response replaceFilterBackendNotFound
*/
type ReplaceFilterBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceFilterBackendNotFound creates ReplaceFilterBackendNotFound with default headers values
func NewReplaceFilterBackendNotFound() *ReplaceFilterBackendNotFound {

	return &ReplaceFilterBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace filter backend not found response
func (o *ReplaceFilterBackendNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceFilterBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace filter backend not found response
func (o *ReplaceFilterBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace filter backend not found response
func (o *ReplaceFilterBackendNotFound) WithPayload(payload *models.Error) *ReplaceFilterBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace filter backend not found response
func (o *ReplaceFilterBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceFilterBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceFilterBackendDefault General Error

swagger:response replaceFilterBackendDefault
*/
type ReplaceFilterBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceFilterBackendDefault creates ReplaceFilterBackendDefault with default headers values
func NewReplaceFilterBackendDefault(code int) *ReplaceFilterBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceFilterBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace filter backend default response
func (o *ReplaceFilterBackendDefault) WithStatusCode(code int) *ReplaceFilterBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace filter backend default response
func (o *ReplaceFilterBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace filter backend default response
func (o *ReplaceFilterBackendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceFilterBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace filter backend default response
func (o *ReplaceFilterBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace filter backend default response
func (o *ReplaceFilterBackendDefault) WithPayload(payload *models.Error) *ReplaceFilterBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace filter backend default response
func (o *ReplaceFilterBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceFilterBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
