// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package filter

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteFilterFrontendAcceptedCode is the HTTP code returned for type DeleteFilterFrontendAccepted
const DeleteFilterFrontendAcceptedCode int = 202

/*
DeleteFilterFrontendAccepted Configuration change accepted and reload requested

swagger:response deleteFilterFrontendAccepted
*/
type DeleteFilterFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteFilterFrontendAccepted creates DeleteFilterFrontendAccepted with default headers values
func NewDeleteFilterFrontendAccepted() *DeleteFilterFrontendAccepted {

	return &DeleteFilterFrontendAccepted{}
}

// WithReloadID adds the reloadId to the delete filter frontend accepted response
func (o *DeleteFilterFrontendAccepted) WithReloadID(reloadID string) *DeleteFilterFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete filter frontend accepted response
func (o *DeleteFilterFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteFilterFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteFilterFrontendNoContentCode is the HTTP code returned for type DeleteFilterFrontendNoContent
const DeleteFilterFrontendNoContentCode int = 204

/*
DeleteFilterFrontendNoContent Filter deleted

swagger:response deleteFilterFrontendNoContent
*/
type DeleteFilterFrontendNoContent struct {
}

// NewDeleteFilterFrontendNoContent creates DeleteFilterFrontendNoContent with default headers values
func NewDeleteFilterFrontendNoContent() *DeleteFilterFrontendNoContent {

	return &DeleteFilterFrontendNoContent{}
}

// WriteResponse to the client
func (o *DeleteFilterFrontendNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteFilterFrontendNotFoundCode is the HTTP code returned for type DeleteFilterFrontendNotFound
const DeleteFilterFrontendNotFoundCode int = 404

/*
DeleteFilterFrontendNotFound The specified resource was not found

swagger:response deleteFilterFrontendNotFound
*/
type DeleteFilterFrontendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteFilterFrontendNotFound creates DeleteFilterFrontendNotFound with default headers values
func NewDeleteFilterFrontendNotFound() *DeleteFilterFrontendNotFound {

	return &DeleteFilterFrontendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete filter frontend not found response
func (o *DeleteFilterFrontendNotFound) WithConfigurationVersion(configurationVersion string) *DeleteFilterFrontendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete filter frontend not found response
func (o *DeleteFilterFrontendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete filter frontend not found response
func (o *DeleteFilterFrontendNotFound) WithPayload(payload *models.Error) *DeleteFilterFrontendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete filter frontend not found response
func (o *DeleteFilterFrontendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteFilterFrontendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteFilterFrontendDefault General Error

swagger:response deleteFilterFrontendDefault
*/
type DeleteFilterFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteFilterFrontendDefault creates DeleteFilterFrontendDefault with default headers values
func NewDeleteFilterFrontendDefault(code int) *DeleteFilterFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteFilterFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete filter frontend default response
func (o *DeleteFilterFrontendDefault) WithStatusCode(code int) *DeleteFilterFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete filter frontend default response
func (o *DeleteFilterFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete filter frontend default response
func (o *DeleteFilterFrontendDefault) WithConfigurationVersion(configurationVersion string) *DeleteFilterFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete filter frontend default response
func (o *DeleteFilterFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete filter frontend default response
func (o *DeleteFilterFrontendDefault) WithPayload(payload *models.Error) *DeleteFilterFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete filter frontend default response
func (o *DeleteFilterFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteFilterFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
