// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package bind

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetBindPeerOKCode is the HTTP code returned for type GetBindPeerOK
const GetBindPeerOKCode int = 200

/*
GetBindPeerOK Successful operation

swagger:response getBindPeerOK
*/
type GetBindPeerOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Bind `json:"body,omitempty"`
}

// NewGetBindPeerOK creates GetBindPeerOK with default headers values
func NewGetBindPeerOK() *GetBindPeerOK {

	return &GetBindPeerOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get bind peer o k response
func (o *GetBindPeerOK) WithConfigurationVersion(configurationVersion string) *GetBindPeerOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get bind peer o k response
func (o *GetBindPeerOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get bind peer o k response
func (o *GetBindPeerOK) WithPayload(payload *models.Bind) *GetBindPeerOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get bind peer o k response
func (o *GetBindPeerOK) SetPayload(payload *models.Bind) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetBindPeerOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetBindPeerNotFoundCode is the HTTP code returned for type GetBindPeerNotFound
const GetBindPeerNotFoundCode int = 404

/*
GetBindPeerNotFound The specified resource already exists

swagger:response getBindPeerNotFound
*/
type GetBindPeerNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetBindPeerNotFound creates GetBindPeerNotFound with default headers values
func NewGetBindPeerNotFound() *GetBindPeerNotFound {

	return &GetBindPeerNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get bind peer not found response
func (o *GetBindPeerNotFound) WithConfigurationVersion(configurationVersion string) *GetBindPeerNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get bind peer not found response
func (o *GetBindPeerNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get bind peer not found response
func (o *GetBindPeerNotFound) WithPayload(payload *models.Error) *GetBindPeerNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get bind peer not found response
func (o *GetBindPeerNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetBindPeerNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetBindPeerDefault General Error

swagger:response getBindPeerDefault
*/
type GetBindPeerDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetBindPeerDefault creates GetBindPeerDefault with default headers values
func NewGetBindPeerDefault(code int) *GetBindPeerDefault {
	if code <= 0 {
		code = 500
	}

	return &GetBindPeerDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get bind peer default response
func (o *GetBindPeerDefault) WithStatusCode(code int) *GetBindPeerDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get bind peer default response
func (o *GetBindPeerDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get bind peer default response
func (o *GetBindPeerDefault) WithConfigurationVersion(configurationVersion string) *GetBindPeerDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get bind peer default response
func (o *GetBindPeerDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get bind peer default response
func (o *GetBindPeerDefault) WithPayload(payload *models.Error) *GetBindPeerDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get bind peer default response
func (o *GetBindPeerDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetBindPeerDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
