// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package acl

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteACLFCGIAppAcceptedCode is the HTTP code returned for type DeleteACLFCGIAppAccepted
const DeleteACLFCGIAppAcceptedCode int = 202

/*
DeleteACLFCGIAppAccepted Configuration change accepted and reload requested

swagger:response deleteAclFcgiAppAccepted
*/
type DeleteACLFCGIAppAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteACLFCGIAppAccepted creates DeleteACLFCGIAppAccepted with default headers values
func NewDeleteACLFCGIAppAccepted() *DeleteACLFCGIAppAccepted {

	return &DeleteACLFCGIAppAccepted{}
}

// WithReloadID adds the reloadId to the delete Acl Fcgi app accepted response
func (o *DeleteACLFCGIAppAccepted) WithReloadID(reloadID string) *DeleteACLFCGIAppAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete Acl Fcgi app accepted response
func (o *DeleteACLFCGIAppAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteACLFCGIAppAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteACLFCGIAppNoContentCode is the HTTP code returned for type DeleteACLFCGIAppNoContent
const DeleteACLFCGIAppNoContentCode int = 204

/*
DeleteACLFCGIAppNoContent ACL line deleted

swagger:response deleteAclFcgiAppNoContent
*/
type DeleteACLFCGIAppNoContent struct {
}

// NewDeleteACLFCGIAppNoContent creates DeleteACLFCGIAppNoContent with default headers values
func NewDeleteACLFCGIAppNoContent() *DeleteACLFCGIAppNoContent {

	return &DeleteACLFCGIAppNoContent{}
}

// WriteResponse to the client
func (o *DeleteACLFCGIAppNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteACLFCGIAppNotFoundCode is the HTTP code returned for type DeleteACLFCGIAppNotFound
const DeleteACLFCGIAppNotFoundCode int = 404

/*
DeleteACLFCGIAppNotFound The specified resource was not found

swagger:response deleteAclFcgiAppNotFound
*/
type DeleteACLFCGIAppNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteACLFCGIAppNotFound creates DeleteACLFCGIAppNotFound with default headers values
func NewDeleteACLFCGIAppNotFound() *DeleteACLFCGIAppNotFound {

	return &DeleteACLFCGIAppNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete Acl Fcgi app not found response
func (o *DeleteACLFCGIAppNotFound) WithConfigurationVersion(configurationVersion string) *DeleteACLFCGIAppNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete Acl Fcgi app not found response
func (o *DeleteACLFCGIAppNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete Acl Fcgi app not found response
func (o *DeleteACLFCGIAppNotFound) WithPayload(payload *models.Error) *DeleteACLFCGIAppNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete Acl Fcgi app not found response
func (o *DeleteACLFCGIAppNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteACLFCGIAppNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteACLFCGIAppDefault General Error

swagger:response deleteAclFcgiAppDefault
*/
type DeleteACLFCGIAppDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteACLFCGIAppDefault creates DeleteACLFCGIAppDefault with default headers values
func NewDeleteACLFCGIAppDefault(code int) *DeleteACLFCGIAppDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteACLFCGIAppDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete Acl FCGI app default response
func (o *DeleteACLFCGIAppDefault) WithStatusCode(code int) *DeleteACLFCGIAppDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete Acl FCGI app default response
func (o *DeleteACLFCGIAppDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete Acl FCGI app default response
func (o *DeleteACLFCGIAppDefault) WithConfigurationVersion(configurationVersion string) *DeleteACLFCGIAppDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete Acl FCGI app default response
func (o *DeleteACLFCGIAppDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete Acl FCGI app default response
func (o *DeleteACLFCGIAppDefault) WithPayload(payload *models.Error) *DeleteACLFCGIAppDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete Acl FCGI app default response
func (o *DeleteACLFCGIAppDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteACLFCGIAppDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
