/* cluster: basic functions for multi process support */
#include "defs.h" 

#ifdef USE_CLUSTER

int cluster_setpnum(int num);
/*sets number of processes to num*/
 
inline int pnum();
/* returns the set number of processes */

inline int pid();
/* returns the process (internal) pid */

inline size_t cluster_split_min(size_t min, size_t max);
/*if a working region is spilt amongst processes, return boundaries
  for each process */

inline size_t cluster_split_max(size_t min, size_t max);
/*if a working region is spilt amongst processes, return boundaries
  for each process */

inline int cluster_split();
/* Split execution into multiple processes */

inline int cluster_sync_add(int value);
/* return value added up from all processes */

inline int cluster_sync_min(int value);
/* return smallest from all processes */

inline int cluster_sync_max(int value);
/* return biggest value from all processes */

inline int cluster_sync_data_tomaster(void* start,size_t length);
/* syncs data between processes, each process
   writes length data at start to process 0 */

inline int cluster_sync_data_fromslave(void* start,size_t length,int pnum);
/* syncs data between processes, pid 0 reads those data from pid pnum*/

inline int cluster_regroup();
/* re-groups execution to a single thread */

#endif


