#include "defs.h"
#include <stdio.h>
#include "printtext.h"
#include "imageio.h"
#include "blur.h"
#include "arglist.h"
#ifdef USE_CLUSTER
#include "cluster.h"
#endif

void printerrorstring(char* title,char *errormessage) {

   if (errormessage!=NULL) fprintf(stderr,"%s: Error: %s!\n\n",title,errormessage);
   fprintf(stderr,"This program will create an image containing a blurred version of the source\n   with <value> being the brush size for blur calculation,\n   given in 1/100 pixels (default 300) \n\n");
   fprintf(stderr,"Usage: %s [ -v <value> | --value=<value> ] \\\n",title);
#ifdef USE_CLUSTER
   fprintf(stderr,"        [ -j <threads> ] \\\n");
#endif
   fprintf(stderr,"        <source1> [<destination>] [[--help] [-h]\n\n");
}

int main (int argc, char *argv[]) {
   ImagePtr imsource, imdest;	/*Working images*/
   int answer;			/*return value*/
   int value;			/*option parameter*/
   char* valuechar;		/*option chars*/
   struct arglist* carglist;	/*commandline options*/
#ifdef USE_CLUSTER
   int threads;			/*number of threads*/
#endif

   carglist = arglist_new(argc, argv);
   arglist_addarg (carglist,"--help",0);
   arglist_addarg (carglist,"-h",0);
   arglist_addarg (carglist,"-v",1);
   arglist_addarg (carglist,"--value",1);
   arglist_addarg (carglist,"-j",1);

   printwelcomestring();

   if ((arglist_arggiven(carglist,"--help")==0) || (arglist_arggiven(carglist,"-h")==0)) {
      printerrorstring(argv[0],NULL);
      printusagestring();
      return -1;
   }

   if ((arglist_parameter(carglist,"VOIDARGS",2)!=NULL) || (arglist_parameter(carglist,"VOIDARGS",0)==NULL)){
      printerrorstring(argv[0],"Error parsing commandline");
      printusagestring();
      return -1;
   }
   /*Check parameter count*/

#ifdef USE_CLUSTER
   threads=DEFAULT_THREADS;
   if (arglist_arggiven(carglist,"-j")==0) {
      threads=arglist_integer(arglist_parameter(carglist,"-j",0));
   }
   if (threads<1) {
      printerrorstring(argv[0],"Error parsing commandline,\nprocess amount <threads> has to be greater 0.");
      printusagestring();
      return -1;
   }
   /*Check process count */

   cluster_setpnum(threads);
#endif

   if ((arglist_arggiven(carglist,"--value")==0) || (arglist_arggiven(carglist,"-v")==0)) {
      valuechar=arglist_parameter(carglist,"-v",0);
      if (valuechar==NULL) {
         valuechar=arglist_parameter(carglist,"--value",0);
      }
      value=arglist_integer(valuechar);
      if (value<=0) {
         printerrorstring(argv[0],"Error parsing commandline,\n<value> has to be any positive interger");
         printusagestring();
         return -1;
      }
   } else {
      value=300;
   }

   imsource=loadim(arglist_parameter(carglist,"VOIDARGS",0));
   if (imsource==NULL) {
      printerrorstring(argv[0],"Error loading source image 1");
      printusagestring();
      return -1;
   }
   /*Load Sourcefile*/

   answer=blur(&imdest,imsource,value);
   /*Do the main work in blur.h*/

   if (arglist_parameter(carglist,"VOIDARGS",1)!=NULL) {
      if (saveim(imdest,arglist_parameter(carglist,"VOIDARGS",1))!=0) {
         printerrorstring(argv[0],"Error saving destination image");
      }
      /*Save the resulting image*/
   }

   destroyim(imsource);
   destroyim(imdest);
   /*We free our memory*/

   fprintf(stderr,"Total amount of blur data is:\n");
   fprintf(stdout,"%i\n",answer);
   
   arglist_kill(carglist);
   /*i forgot to kill the commandline argument list*/

   return 0;

}
