# Contributing to Ruby Graph Library

Thank you for your interest in contributing to rgl! We welcome all
contributions, whether they're big or small. Here are some guidelines to get you
started.

## Code of Conduct

Please note that this project is released with a Contributor Code of Conduct. By
participating in this project you agree to abide by its terms.

## How to Contribute

1. Fork the repository.
2. Create a branch for your changes: `git checkout -b my-feature-branch`
3. Make your changes and commit them with descriptive commit messages.
4. Ensure that tests pass by running `bundle exec rake` locally.
5. Push your changes to your fork: `git push origin my-feature-branch`
6. Submit a pull request with your changes.

## Commit Guidelines

We follow the [Conventional
Commits](https://www.conventionalcommits.org/en/v1.0.0/) guidelines for commit
messages in this repository. Please ensure that all commit messages follow the
format:

```
<type>[optional scope]: <description>

[optional body]

[optional footer(s)]
```

Where:

- `<type>`: The type of change being made (e.g. feat, fix, docs, style, refactor, test, chore)
- `<scope>` (optional): The scope of the change (e.g. component name, file name)
- `<description>`: A brief description of the change
- `[optional body]`: A more detailed description of the change
- `[optional footer(s)]`: Any important information related to the change, such
  as a breaking change note

By following these guidelines, it will be easier to understand the purpose of
each commit and track changes over time.

Please note that we may ask you to amend your commit message(s) if they do not
follow these guidelines.

## Issue Tracker

If you find a bug or want to request a new feature, please create an issue in
the GitHub issue tracker. Please provide as much detail as possible, including
steps to reproduce the issue (if applicable).

## Code Reviews

All submissions, including submissions by project members, require review. We
use GitHub pull requests for this purpose. Consult [GitHub
Help](https://help.github.com/articles/about-pull-requests/) for more
information on using pull requests.

## License

By contributing, you agree that your contributions will be licensed under the
{file:../LICENSE}.
