#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1892
#define LARGE_STATE_COUNT 14
#define SYMBOL_COUNT 274
#define ALIAS_COUNT 0
#define TOKEN_COUNT 96
#define EXTERNAL_TOKEN_COUNT 1
#define FIELD_COUNT 32
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 80

enum {
  sym_module_comment = 1,
  sym_statement_comment = 2,
  sym_comment = 3,
  anon_sym_if = 4,
  anon_sym_LBRACE = 5,
  anon_sym_RBRACE = 6,
  anon_sym_erlang = 7,
  anon_sym_javascript = 8,
  anon_sym_AT = 9,
  anon_sym_LPAREN = 10,
  anon_sym_COMMA = 11,
  anon_sym_RPAREN = 12,
  anon_sym_COLON = 13,
  anon_sym_import = 14,
  anon_sym_DOT = 15,
  anon_sym_as = 16,
  anon_sym_SLASH = 17,
  anon_sym_type = 18,
  anon_sym_const = 19,
  anon_sym_EQ = 20,
  anon_sym_POUND = 21,
  anon_sym_LBRACK = 22,
  anon_sym_RBRACK = 23,
  anon_sym_LT_LT = 24,
  anon_sym_GT_GT = 25,
  anon_sym_DASH = 26,
  anon_sym_size = 27,
  anon_sym_fn = 28,
  anon_sym_DASH_GT = 29,
  anon_sym_external = 30,
  anon_sym_PIPE_PIPE = 31,
  anon_sym_AMP_AMP = 32,
  anon_sym_EQ_EQ = 33,
  anon_sym_BANG_EQ = 34,
  anon_sym_LT = 35,
  anon_sym_LT_EQ = 36,
  anon_sym_LT_DOT = 37,
  anon_sym_LT_EQ_DOT = 38,
  anon_sym_GT = 39,
  anon_sym_GT_EQ = 40,
  anon_sym_GT_DOT = 41,
  anon_sym_GT_EQ_DOT = 42,
  anon_sym_PIPE_GT = 43,
  anon_sym_PLUS = 44,
  anon_sym_PLUS_DOT = 45,
  anon_sym_DASH_DOT = 46,
  anon_sym_STAR = 47,
  anon_sym_STAR_DOT = 48,
  anon_sym_SLASH_DOT = 49,
  anon_sym_PERCENT = 50,
  anon_sym_LT_GT = 51,
  anon_sym_todo = 52,
  anon_sym_panic = 53,
  anon_sym_echo = 54,
  anon_sym_DOT_DOT = 55,
  anon_sym_case = 56,
  anon_sym_PIPE = 57,
  anon_sym_let = 58,
  anon_sym_assert = 59,
  anon_sym_use = 60,
  anon_sym_LT_DASH = 61,
  anon_sym_BANG = 62,
  sym_visibility_modifier = 63,
  sym_opacity_modifier = 64,
  anon_sym_DQUOTE = 65,
  anon_sym_DQUOTE2 = 66,
  aux_sym_escape_sequence_token1 = 67,
  aux_sym_escape_sequence_token2 = 68,
  sym_float = 69,
  sym__hex = 70,
  sym__decimal = 71,
  sym__octal = 72,
  sym__binary = 73,
  anon_sym_binary = 74,
  anon_sym_bytes = 75,
  anon_sym_int = 76,
  anon_sym_float = 77,
  anon_sym_bit_string = 78,
  anon_sym_bits = 79,
  anon_sym_utf8 = 80,
  anon_sym_utf16 = 81,
  anon_sym_utf32 = 82,
  anon_sym_utf8_codepoint = 83,
  anon_sym_utf16_codepoint = 84,
  anon_sym_utf32_codepoint = 85,
  anon_sym_signed = 86,
  anon_sym_unsigned = 87,
  anon_sym_big = 88,
  anon_sym_little = 89,
  anon_sym_native = 90,
  anon_sym_unit = 91,
  sym__discard_name = 92,
  sym__name = 93,
  sym__upname = 94,
  sym_quoted_content = 95,
  sym_source_file = 96,
  sym__module_statement = 97,
  sym_target_group = 98,
  sym_target = 99,
  sym_attribute = 100,
  sym__attribute_arguments = 101,
  sym_attribute_value = 102,
  sym_import = 103,
  sym_module = 104,
  sym_unqualified_imports = 105,
  sym_unqualified_import = 106,
  sym_constant = 107,
  sym__constant_value = 108,
  sym_constant_tuple = 109,
  sym_constant_list = 110,
  sym__constant_bit_string = 111,
  sym_constant_bit_string_segment = 112,
  sym_constant_bit_string_segment_options = 113,
  sym__constant_bit_string_segment_option = 114,
  sym__constant_bit_string_named_segment_option = 115,
  sym__constant_bit_string_segment_option_size = 116,
  sym_constant_record = 117,
  sym_constant_record_arguments = 118,
  sym_constant_record_argument = 119,
  sym_constant_field_access = 120,
  sym__constant_type = 121,
  sym__constant_type_annotation = 122,
  sym_constant_tuple_type = 123,
  sym_constant_function_type = 124,
  sym_constant_function_parameter_types = 125,
  sym_constant_type = 126,
  sym_constant_type_arguments = 127,
  sym_constant_type_argument = 128,
  sym_external_type = 129,
  sym_external_function = 130,
  sym_external_function_parameters = 131,
  sym_external_function_parameter = 132,
  sym_external_function_body = 133,
  sym_function = 134,
  sym_function_parameters = 135,
  sym_function_parameter = 136,
  sym__labeled_discard_param = 137,
  sym__discard_param = 138,
  sym__labeled_name_param = 139,
  sym__name_param = 140,
  aux_sym__statement_seq = 141,
  sym__statement = 142,
  sym__expression = 143,
  sym_binary_expression = 144,
  sym__expression_unit = 145,
  sym_record = 146,
  sym_todo = 147,
  sym_panic = 148,
  sym_pipeline_echo = 149,
  sym_echo = 150,
  sym_tuple = 151,
  sym_list = 152,
  sym__expression_bit_string = 153,
  sym_expression_bit_string_segment = 154,
  sym_expression_bit_string_segment_options = 155,
  sym__expression_bit_string_segment_option = 156,
  sym__expression_bit_string_named_segment_option = 157,
  sym__expression_bit_string_segment_option_size = 158,
  sym_anonymous_function = 159,
  sym_anonymous_function_parameters = 160,
  sym_anonymous_function_parameter = 161,
  sym_block = 162,
  sym_case = 163,
  sym_case_subjects = 164,
  sym_case_clauses = 165,
  sym_case_clause = 166,
  sym_case_clause_patterns = 167,
  sym_case_clause_pattern = 168,
  sym_case_clause_guard = 169,
  sym__case_clause_guard_expression = 170,
  sym__case_clause_guard_binary_expression = 171,
  sym__case_clause_guard_unit = 172,
  sym__case_clause_tuple_access = 173,
  sym_let_assert = 174,
  sym_assert = 175,
  sym_let = 176,
  sym_use = 177,
  sym_use_assignments = 178,
  sym_use_assignment = 179,
  sym_boolean_negation = 180,
  sym_integer_negation = 181,
  sym__assignment = 182,
  sym_record_update = 183,
  sym_record_update_arguments = 184,
  sym_record_update_argument = 185,
  sym__maybe_tuple_expression = 186,
  sym_tuple_access = 187,
  sym__maybe_record_expression = 188,
  sym_field_access = 189,
  sym__maybe_function_expression = 190,
  sym_arguments = 191,
  sym_argument = 192,
  sym_hole = 193,
  sym_function_call = 194,
  sym__pattern_expression = 195,
  sym__pattern_binary_expression = 196,
  sym__pattern = 197,
  sym_record_pattern = 198,
  sym_record_pattern_arguments = 199,
  sym_record_pattern_argument = 200,
  sym_pattern_spread = 201,
  sym_tuple_pattern = 202,
  sym__pattern_bit_string = 203,
  sym_pattern_bit_string_segment = 204,
  sym_pattern_bit_string_segment_options = 205,
  sym__pattern_bit_string_segment_option = 206,
  sym__pattern_bit_string_named_segment_option = 207,
  sym__pattern_bit_string_segment_option_size = 208,
  sym__pattern_bit_string_segment_argument = 209,
  sym_list_pattern = 210,
  sym_list_pattern_tail = 211,
  sym_type_definition = 212,
  sym_data_constructors = 213,
  sym_data_constructor = 214,
  sym_data_constructor_arguments = 215,
  sym_data_constructor_argument = 216,
  sym_type_alias = 217,
  sym_string = 218,
  sym_escape_sequence = 219,
  sym_integer = 220,
  sym__bit_string_segment_option = 221,
  sym__type = 222,
  sym__type_annotation = 223,
  sym_type_hole = 224,
  sym_tuple_type = 225,
  sym_function_type = 226,
  sym_function_parameter_types = 227,
  sym_type = 228,
  sym_type_arguments = 229,
  sym_type_argument = 230,
  sym_type_var = 231,
  sym_type_name = 232,
  sym_type_parameters = 233,
  sym_type_parameter = 234,
  sym_identifier = 235,
  sym_label = 236,
  sym_discard = 237,
  sym_type_identifier = 238,
  sym_remote_type_identifier = 239,
  sym_constructor_name = 240,
  sym_remote_constructor_name = 241,
  aux_sym_source_file_repeat1 = 242,
  aux_sym_target_group_repeat1 = 243,
  aux_sym__attribute_arguments_repeat1 = 244,
  aux_sym_module_repeat1 = 245,
  aux_sym_unqualified_imports_repeat1 = 246,
  aux_sym_constant_tuple_repeat1 = 247,
  aux_sym__constant_bit_string_repeat1 = 248,
  aux_sym_constant_bit_string_segment_options_repeat1 = 249,
  aux_sym_constant_record_arguments_repeat1 = 250,
  aux_sym_constant_tuple_type_repeat1 = 251,
  aux_sym_constant_type_arguments_repeat1 = 252,
  aux_sym_external_function_parameters_repeat1 = 253,
  aux_sym_function_parameters_repeat1 = 254,
  aux_sym_tuple_repeat1 = 255,
  aux_sym__expression_bit_string_repeat1 = 256,
  aux_sym_expression_bit_string_segment_options_repeat1 = 257,
  aux_sym_anonymous_function_parameters_repeat1 = 258,
  aux_sym_case_clauses_repeat1 = 259,
  aux_sym_case_clause_patterns_repeat1 = 260,
  aux_sym_case_clause_pattern_repeat1 = 261,
  aux_sym_use_assignments_repeat1 = 262,
  aux_sym_record_update_arguments_repeat1 = 263,
  aux_sym_arguments_repeat1 = 264,
  aux_sym_record_pattern_arguments_repeat1 = 265,
  aux_sym__pattern_bit_string_repeat1 = 266,
  aux_sym_pattern_bit_string_segment_options_repeat1 = 267,
  aux_sym_data_constructors_repeat1 = 268,
  aux_sym_data_constructor_arguments_repeat1 = 269,
  aux_sym_string_repeat1 = 270,
  aux_sym_tuple_type_repeat1 = 271,
  aux_sym_type_arguments_repeat1 = 272,
  aux_sym_type_parameters_repeat1 = 273,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_module_comment] = "module_comment",
  [sym_statement_comment] = "statement_comment",
  [sym_comment] = "comment",
  [anon_sym_if] = "if",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_erlang] = "erlang",
  [anon_sym_javascript] = "javascript",
  [anon_sym_AT] = "@",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [anon_sym_COLON] = ":",
  [anon_sym_import] = "import",
  [anon_sym_DOT] = ".",
  [anon_sym_as] = "as",
  [anon_sym_SLASH] = "/",
  [anon_sym_type] = "type",
  [anon_sym_const] = "const",
  [anon_sym_EQ] = "=",
  [anon_sym_POUND] = "#",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_DASH] = "-",
  [anon_sym_size] = "size",
  [anon_sym_fn] = "fn",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_external] = "external",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_LT_DOT] = "<.",
  [anon_sym_LT_EQ_DOT] = "<=.",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT_DOT] = ">.",
  [anon_sym_GT_EQ_DOT] = ">=.",
  [anon_sym_PIPE_GT] = "|>",
  [anon_sym_PLUS] = "+",
  [anon_sym_PLUS_DOT] = "+.",
  [anon_sym_DASH_DOT] = "-.",
  [anon_sym_STAR] = "*",
  [anon_sym_STAR_DOT] = "*.",
  [anon_sym_SLASH_DOT] = "/.",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_todo] = "todo",
  [anon_sym_panic] = "panic",
  [anon_sym_echo] = "echo",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_case] = "case",
  [anon_sym_PIPE] = "|",
  [anon_sym_let] = "let",
  [anon_sym_assert] = "assert",
  [anon_sym_use] = "use",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_BANG] = "!",
  [sym_visibility_modifier] = "visibility_modifier",
  [sym_opacity_modifier] = "opacity_modifier",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_DQUOTE2] = "\"",
  [aux_sym_escape_sequence_token1] = "escape_sequence_token1",
  [aux_sym_escape_sequence_token2] = "escape_sequence_token2",
  [sym_float] = "float",
  [sym__hex] = "_hex",
  [sym__decimal] = "_decimal",
  [sym__octal] = "_octal",
  [sym__binary] = "_binary",
  [anon_sym_binary] = "binary",
  [anon_sym_bytes] = "bytes",
  [anon_sym_int] = "int",
  [anon_sym_float] = "float",
  [anon_sym_bit_string] = "bit_string",
  [anon_sym_bits] = "bits",
  [anon_sym_utf8] = "utf8",
  [anon_sym_utf16] = "utf16",
  [anon_sym_utf32] = "utf32",
  [anon_sym_utf8_codepoint] = "utf8_codepoint",
  [anon_sym_utf16_codepoint] = "utf16_codepoint",
  [anon_sym_utf32_codepoint] = "utf32_codepoint",
  [anon_sym_signed] = "signed",
  [anon_sym_unsigned] = "unsigned",
  [anon_sym_big] = "big",
  [anon_sym_little] = "little",
  [anon_sym_native] = "native",
  [anon_sym_unit] = "unit",
  [sym__discard_name] = "_discard_name",
  [sym__name] = "_name",
  [sym__upname] = "_upname",
  [sym_quoted_content] = "quoted_content",
  [sym_source_file] = "source_file",
  [sym__module_statement] = "_module_statement",
  [sym_target_group] = "target_group",
  [sym_target] = "target",
  [sym_attribute] = "attribute",
  [sym__attribute_arguments] = "arguments",
  [sym_attribute_value] = "attribute_value",
  [sym_import] = "import",
  [sym_module] = "module",
  [sym_unqualified_imports] = "unqualified_imports",
  [sym_unqualified_import] = "unqualified_import",
  [sym_constant] = "constant",
  [sym__constant_value] = "_constant_value",
  [sym_constant_tuple] = "tuple",
  [sym_constant_list] = "list",
  [sym__constant_bit_string] = "bit_string",
  [sym_constant_bit_string_segment] = "bit_string_segment",
  [sym_constant_bit_string_segment_options] = "bit_string_segment_options",
  [sym__constant_bit_string_segment_option] = "_constant_bit_string_segment_option",
  [sym__constant_bit_string_named_segment_option] = "_constant_bit_string_named_segment_option",
  [sym__constant_bit_string_segment_option_size] = "bit_string_segment_option",
  [sym_constant_record] = "record",
  [sym_constant_record_arguments] = "arguments",
  [sym_constant_record_argument] = "argument",
  [sym_constant_field_access] = "field_access",
  [sym__constant_type] = "_constant_type",
  [sym__constant_type_annotation] = "_constant_type_annotation",
  [sym_constant_tuple_type] = "tuple_type",
  [sym_constant_function_type] = "function_type",
  [sym_constant_function_parameter_types] = "function_parameter_types",
  [sym_constant_type] = "type",
  [sym_constant_type_arguments] = "type_arguments",
  [sym_constant_type_argument] = "type_argument",
  [sym_external_type] = "external_type",
  [sym_external_function] = "external_function",
  [sym_external_function_parameters] = "function_parameters",
  [sym_external_function_parameter] = "function_parameter",
  [sym_external_function_body] = "external_function_body",
  [sym_function] = "function",
  [sym_function_parameters] = "function_parameters",
  [sym_function_parameter] = "function_parameter",
  [sym__labeled_discard_param] = "_labeled_discard_param",
  [sym__discard_param] = "_discard_param",
  [sym__labeled_name_param] = "_labeled_name_param",
  [sym__name_param] = "_name_param",
  [aux_sym__statement_seq] = "_statement_seq",
  [sym__statement] = "_statement",
  [sym__expression] = "_expression",
  [sym_binary_expression] = "binary_expression",
  [sym__expression_unit] = "_expression_unit",
  [sym_record] = "record",
  [sym_todo] = "todo",
  [sym_panic] = "panic",
  [sym_pipeline_echo] = "pipeline_echo",
  [sym_echo] = "echo",
  [sym_tuple] = "tuple",
  [sym_list] = "list",
  [sym__expression_bit_string] = "bit_string",
  [sym_expression_bit_string_segment] = "bit_string_segment",
  [sym_expression_bit_string_segment_options] = "bit_string_segment_options",
  [sym__expression_bit_string_segment_option] = "_expression_bit_string_segment_option",
  [sym__expression_bit_string_named_segment_option] = "_expression_bit_string_named_segment_option",
  [sym__expression_bit_string_segment_option_size] = "bit_string_segment_option",
  [sym_anonymous_function] = "anonymous_function",
  [sym_anonymous_function_parameters] = "function_parameters",
  [sym_anonymous_function_parameter] = "function_parameter",
  [sym_block] = "block",
  [sym_case] = "case",
  [sym_case_subjects] = "case_subjects",
  [sym_case_clauses] = "case_clauses",
  [sym_case_clause] = "case_clause",
  [sym_case_clause_patterns] = "case_clause_patterns",
  [sym_case_clause_pattern] = "case_clause_pattern",
  [sym_case_clause_guard] = "case_clause_guard",
  [sym__case_clause_guard_expression] = "_case_clause_guard_expression",
  [sym__case_clause_guard_binary_expression] = "binary_expression",
  [sym__case_clause_guard_unit] = "_case_clause_guard_unit",
  [sym__case_clause_tuple_access] = "tuple_access",
  [sym_let_assert] = "let_assert",
  [sym_assert] = "assert",
  [sym_let] = "let",
  [sym_use] = "use",
  [sym_use_assignments] = "use_assignments",
  [sym_use_assignment] = "use_assignment",
  [sym_boolean_negation] = "boolean_negation",
  [sym_integer_negation] = "integer_negation",
  [sym__assignment] = "_assignment",
  [sym_record_update] = "record_update",
  [sym_record_update_arguments] = "record_update_arguments",
  [sym_record_update_argument] = "record_update_argument",
  [sym__maybe_tuple_expression] = "_maybe_tuple_expression",
  [sym_tuple_access] = "tuple_access",
  [sym__maybe_record_expression] = "_maybe_record_expression",
  [sym_field_access] = "field_access",
  [sym__maybe_function_expression] = "_maybe_function_expression",
  [sym_arguments] = "arguments",
  [sym_argument] = "argument",
  [sym_hole] = "hole",
  [sym_function_call] = "function_call",
  [sym__pattern_expression] = "_pattern_expression",
  [sym__pattern_binary_expression] = "binary_expression",
  [sym__pattern] = "_pattern",
  [sym_record_pattern] = "record_pattern",
  [sym_record_pattern_arguments] = "record_pattern_arguments",
  [sym_record_pattern_argument] = "record_pattern_argument",
  [sym_pattern_spread] = "pattern_spread",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym__pattern_bit_string] = "bit_string_pattern",
  [sym_pattern_bit_string_segment] = "bit_string_segment",
  [sym_pattern_bit_string_segment_options] = "bit_string_segment_options",
  [sym__pattern_bit_string_segment_option] = "_pattern_bit_string_segment_option",
  [sym__pattern_bit_string_named_segment_option] = "_pattern_bit_string_named_segment_option",
  [sym__pattern_bit_string_segment_option_size] = "bit_string_segment_option",
  [sym__pattern_bit_string_segment_argument] = "_pattern_bit_string_segment_argument",
  [sym_list_pattern] = "list_pattern",
  [sym_list_pattern_tail] = "list_pattern_tail",
  [sym_type_definition] = "type_definition",
  [sym_data_constructors] = "data_constructors",
  [sym_data_constructor] = "data_constructor",
  [sym_data_constructor_arguments] = "data_constructor_arguments",
  [sym_data_constructor_argument] = "data_constructor_argument",
  [sym_type_alias] = "type_alias",
  [sym_string] = "string",
  [sym_escape_sequence] = "escape_sequence",
  [sym_integer] = "integer",
  [sym__bit_string_segment_option] = "bit_string_segment_option",
  [sym__type] = "_type",
  [sym__type_annotation] = "_type_annotation",
  [sym_type_hole] = "type_hole",
  [sym_tuple_type] = "tuple_type",
  [sym_function_type] = "function_type",
  [sym_function_parameter_types] = "function_parameter_types",
  [sym_type] = "type",
  [sym_type_arguments] = "type_arguments",
  [sym_type_argument] = "type_argument",
  [sym_type_var] = "type_var",
  [sym_type_name] = "type_name",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_identifier] = "identifier",
  [sym_label] = "label",
  [sym_discard] = "discard",
  [sym_type_identifier] = "type_identifier",
  [sym_remote_type_identifier] = "remote_type_identifier",
  [sym_constructor_name] = "constructor_name",
  [sym_remote_constructor_name] = "remote_constructor_name",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_target_group_repeat1] = "target_group_repeat1",
  [aux_sym__attribute_arguments_repeat1] = "_attribute_arguments_repeat1",
  [aux_sym_module_repeat1] = "module_repeat1",
  [aux_sym_unqualified_imports_repeat1] = "unqualified_imports_repeat1",
  [aux_sym_constant_tuple_repeat1] = "constant_tuple_repeat1",
  [aux_sym__constant_bit_string_repeat1] = "_constant_bit_string_repeat1",
  [aux_sym_constant_bit_string_segment_options_repeat1] = "constant_bit_string_segment_options_repeat1",
  [aux_sym_constant_record_arguments_repeat1] = "constant_record_arguments_repeat1",
  [aux_sym_constant_tuple_type_repeat1] = "constant_tuple_type_repeat1",
  [aux_sym_constant_type_arguments_repeat1] = "constant_type_arguments_repeat1",
  [aux_sym_external_function_parameters_repeat1] = "external_function_parameters_repeat1",
  [aux_sym_function_parameters_repeat1] = "function_parameters_repeat1",
  [aux_sym_tuple_repeat1] = "tuple_repeat1",
  [aux_sym__expression_bit_string_repeat1] = "_expression_bit_string_repeat1",
  [aux_sym_expression_bit_string_segment_options_repeat1] = "expression_bit_string_segment_options_repeat1",
  [aux_sym_anonymous_function_parameters_repeat1] = "anonymous_function_parameters_repeat1",
  [aux_sym_case_clauses_repeat1] = "case_clauses_repeat1",
  [aux_sym_case_clause_patterns_repeat1] = "case_clause_patterns_repeat1",
  [aux_sym_case_clause_pattern_repeat1] = "case_clause_pattern_repeat1",
  [aux_sym_use_assignments_repeat1] = "use_assignments_repeat1",
  [aux_sym_record_update_arguments_repeat1] = "record_update_arguments_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym_record_pattern_arguments_repeat1] = "record_pattern_arguments_repeat1",
  [aux_sym__pattern_bit_string_repeat1] = "_pattern_bit_string_repeat1",
  [aux_sym_pattern_bit_string_segment_options_repeat1] = "pattern_bit_string_segment_options_repeat1",
  [aux_sym_data_constructors_repeat1] = "data_constructors_repeat1",
  [aux_sym_data_constructor_arguments_repeat1] = "data_constructor_arguments_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_module_comment] = sym_module_comment,
  [sym_statement_comment] = sym_statement_comment,
  [sym_comment] = sym_comment,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_erlang] = anon_sym_erlang,
  [anon_sym_javascript] = anon_sym_javascript,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_size] = anon_sym_size,
  [anon_sym_fn] = anon_sym_fn,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_external] = anon_sym_external,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_LT_DOT] = anon_sym_LT_DOT,
  [anon_sym_LT_EQ_DOT] = anon_sym_LT_EQ_DOT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT_DOT] = anon_sym_GT_DOT,
  [anon_sym_GT_EQ_DOT] = anon_sym_GT_EQ_DOT,
  [anon_sym_PIPE_GT] = anon_sym_PIPE_GT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_PLUS_DOT] = anon_sym_PLUS_DOT,
  [anon_sym_DASH_DOT] = anon_sym_DASH_DOT,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_STAR_DOT] = anon_sym_STAR_DOT,
  [anon_sym_SLASH_DOT] = anon_sym_SLASH_DOT,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_todo] = anon_sym_todo,
  [anon_sym_panic] = anon_sym_panic,
  [anon_sym_echo] = anon_sym_echo,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_use] = anon_sym_use,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_BANG] = anon_sym_BANG,
  [sym_visibility_modifier] = sym_visibility_modifier,
  [sym_opacity_modifier] = sym_opacity_modifier,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_DQUOTE2] = anon_sym_DQUOTE,
  [aux_sym_escape_sequence_token1] = aux_sym_escape_sequence_token1,
  [aux_sym_escape_sequence_token2] = aux_sym_escape_sequence_token2,
  [sym_float] = sym_float,
  [sym__hex] = sym__hex,
  [sym__decimal] = sym__decimal,
  [sym__octal] = sym__octal,
  [sym__binary] = sym__binary,
  [anon_sym_binary] = anon_sym_binary,
  [anon_sym_bytes] = anon_sym_bytes,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_bit_string] = anon_sym_bit_string,
  [anon_sym_bits] = anon_sym_bits,
  [anon_sym_utf8] = anon_sym_utf8,
  [anon_sym_utf16] = anon_sym_utf16,
  [anon_sym_utf32] = anon_sym_utf32,
  [anon_sym_utf8_codepoint] = anon_sym_utf8_codepoint,
  [anon_sym_utf16_codepoint] = anon_sym_utf16_codepoint,
  [anon_sym_utf32_codepoint] = anon_sym_utf32_codepoint,
  [anon_sym_signed] = anon_sym_signed,
  [anon_sym_unsigned] = anon_sym_unsigned,
  [anon_sym_big] = anon_sym_big,
  [anon_sym_little] = anon_sym_little,
  [anon_sym_native] = anon_sym_native,
  [anon_sym_unit] = anon_sym_unit,
  [sym__discard_name] = sym__discard_name,
  [sym__name] = sym__name,
  [sym__upname] = sym__upname,
  [sym_quoted_content] = sym_quoted_content,
  [sym_source_file] = sym_source_file,
  [sym__module_statement] = sym__module_statement,
  [sym_target_group] = sym_target_group,
  [sym_target] = sym_target,
  [sym_attribute] = sym_attribute,
  [sym__attribute_arguments] = sym_arguments,
  [sym_attribute_value] = sym_attribute_value,
  [sym_import] = sym_import,
  [sym_module] = sym_module,
  [sym_unqualified_imports] = sym_unqualified_imports,
  [sym_unqualified_import] = sym_unqualified_import,
  [sym_constant] = sym_constant,
  [sym__constant_value] = sym__constant_value,
  [sym_constant_tuple] = sym_tuple,
  [sym_constant_list] = sym_list,
  [sym__constant_bit_string] = sym__constant_bit_string,
  [sym_constant_bit_string_segment] = sym_constant_bit_string_segment,
  [sym_constant_bit_string_segment_options] = sym_constant_bit_string_segment_options,
  [sym__constant_bit_string_segment_option] = sym__constant_bit_string_segment_option,
  [sym__constant_bit_string_named_segment_option] = sym__constant_bit_string_named_segment_option,
  [sym__constant_bit_string_segment_option_size] = sym__constant_bit_string_segment_option_size,
  [sym_constant_record] = sym_record,
  [sym_constant_record_arguments] = sym_arguments,
  [sym_constant_record_argument] = sym_argument,
  [sym_constant_field_access] = sym_field_access,
  [sym__constant_type] = sym__constant_type,
  [sym__constant_type_annotation] = sym__constant_type_annotation,
  [sym_constant_tuple_type] = sym_tuple_type,
  [sym_constant_function_type] = sym_function_type,
  [sym_constant_function_parameter_types] = sym_function_parameter_types,
  [sym_constant_type] = sym_type,
  [sym_constant_type_arguments] = sym_type_arguments,
  [sym_constant_type_argument] = sym_type_argument,
  [sym_external_type] = sym_external_type,
  [sym_external_function] = sym_external_function,
  [sym_external_function_parameters] = sym_function_parameters,
  [sym_external_function_parameter] = sym_function_parameter,
  [sym_external_function_body] = sym_external_function_body,
  [sym_function] = sym_function,
  [sym_function_parameters] = sym_function_parameters,
  [sym_function_parameter] = sym_function_parameter,
  [sym__labeled_discard_param] = sym__labeled_discard_param,
  [sym__discard_param] = sym__discard_param,
  [sym__labeled_name_param] = sym__labeled_name_param,
  [sym__name_param] = sym__name_param,
  [aux_sym__statement_seq] = aux_sym__statement_seq,
  [sym__statement] = sym__statement,
  [sym__expression] = sym__expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym__expression_unit] = sym__expression_unit,
  [sym_record] = sym_record,
  [sym_todo] = sym_todo,
  [sym_panic] = sym_panic,
  [sym_pipeline_echo] = sym_pipeline_echo,
  [sym_echo] = sym_echo,
  [sym_tuple] = sym_tuple,
  [sym_list] = sym_list,
  [sym__expression_bit_string] = sym__constant_bit_string,
  [sym_expression_bit_string_segment] = sym_constant_bit_string_segment,
  [sym_expression_bit_string_segment_options] = sym_constant_bit_string_segment_options,
  [sym__expression_bit_string_segment_option] = sym__expression_bit_string_segment_option,
  [sym__expression_bit_string_named_segment_option] = sym__expression_bit_string_named_segment_option,
  [sym__expression_bit_string_segment_option_size] = sym__constant_bit_string_segment_option_size,
  [sym_anonymous_function] = sym_anonymous_function,
  [sym_anonymous_function_parameters] = sym_function_parameters,
  [sym_anonymous_function_parameter] = sym_function_parameter,
  [sym_block] = sym_block,
  [sym_case] = sym_case,
  [sym_case_subjects] = sym_case_subjects,
  [sym_case_clauses] = sym_case_clauses,
  [sym_case_clause] = sym_case_clause,
  [sym_case_clause_patterns] = sym_case_clause_patterns,
  [sym_case_clause_pattern] = sym_case_clause_pattern,
  [sym_case_clause_guard] = sym_case_clause_guard,
  [sym__case_clause_guard_expression] = sym__case_clause_guard_expression,
  [sym__case_clause_guard_binary_expression] = sym_binary_expression,
  [sym__case_clause_guard_unit] = sym__case_clause_guard_unit,
  [sym__case_clause_tuple_access] = sym_tuple_access,
  [sym_let_assert] = sym_let_assert,
  [sym_assert] = sym_assert,
  [sym_let] = sym_let,
  [sym_use] = sym_use,
  [sym_use_assignments] = sym_use_assignments,
  [sym_use_assignment] = sym_use_assignment,
  [sym_boolean_negation] = sym_boolean_negation,
  [sym_integer_negation] = sym_integer_negation,
  [sym__assignment] = sym__assignment,
  [sym_record_update] = sym_record_update,
  [sym_record_update_arguments] = sym_record_update_arguments,
  [sym_record_update_argument] = sym_record_update_argument,
  [sym__maybe_tuple_expression] = sym__maybe_tuple_expression,
  [sym_tuple_access] = sym_tuple_access,
  [sym__maybe_record_expression] = sym__maybe_record_expression,
  [sym_field_access] = sym_field_access,
  [sym__maybe_function_expression] = sym__maybe_function_expression,
  [sym_arguments] = sym_arguments,
  [sym_argument] = sym_argument,
  [sym_hole] = sym_hole,
  [sym_function_call] = sym_function_call,
  [sym__pattern_expression] = sym__pattern_expression,
  [sym__pattern_binary_expression] = sym_binary_expression,
  [sym__pattern] = sym__pattern,
  [sym_record_pattern] = sym_record_pattern,
  [sym_record_pattern_arguments] = sym_record_pattern_arguments,
  [sym_record_pattern_argument] = sym_record_pattern_argument,
  [sym_pattern_spread] = sym_pattern_spread,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym__pattern_bit_string] = sym__pattern_bit_string,
  [sym_pattern_bit_string_segment] = sym_constant_bit_string_segment,
  [sym_pattern_bit_string_segment_options] = sym_constant_bit_string_segment_options,
  [sym__pattern_bit_string_segment_option] = sym__pattern_bit_string_segment_option,
  [sym__pattern_bit_string_named_segment_option] = sym__pattern_bit_string_named_segment_option,
  [sym__pattern_bit_string_segment_option_size] = sym__constant_bit_string_segment_option_size,
  [sym__pattern_bit_string_segment_argument] = sym__pattern_bit_string_segment_argument,
  [sym_list_pattern] = sym_list_pattern,
  [sym_list_pattern_tail] = sym_list_pattern_tail,
  [sym_type_definition] = sym_type_definition,
  [sym_data_constructors] = sym_data_constructors,
  [sym_data_constructor] = sym_data_constructor,
  [sym_data_constructor_arguments] = sym_data_constructor_arguments,
  [sym_data_constructor_argument] = sym_data_constructor_argument,
  [sym_type_alias] = sym_type_alias,
  [sym_string] = sym_string,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_integer] = sym_integer,
  [sym__bit_string_segment_option] = sym__constant_bit_string_segment_option_size,
  [sym__type] = sym__type,
  [sym__type_annotation] = sym__type_annotation,
  [sym_type_hole] = sym_type_hole,
  [sym_tuple_type] = sym_tuple_type,
  [sym_function_type] = sym_function_type,
  [sym_function_parameter_types] = sym_function_parameter_types,
  [sym_type] = sym_type,
  [sym_type_arguments] = sym_type_arguments,
  [sym_type_argument] = sym_type_argument,
  [sym_type_var] = sym_type_var,
  [sym_type_name] = sym_type_name,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_identifier] = sym_identifier,
  [sym_label] = sym_label,
  [sym_discard] = sym_discard,
  [sym_type_identifier] = sym_type_identifier,
  [sym_remote_type_identifier] = sym_remote_type_identifier,
  [sym_constructor_name] = sym_constructor_name,
  [sym_remote_constructor_name] = sym_remote_constructor_name,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_target_group_repeat1] = aux_sym_target_group_repeat1,
  [aux_sym__attribute_arguments_repeat1] = aux_sym__attribute_arguments_repeat1,
  [aux_sym_module_repeat1] = aux_sym_module_repeat1,
  [aux_sym_unqualified_imports_repeat1] = aux_sym_unqualified_imports_repeat1,
  [aux_sym_constant_tuple_repeat1] = aux_sym_constant_tuple_repeat1,
  [aux_sym__constant_bit_string_repeat1] = aux_sym__constant_bit_string_repeat1,
  [aux_sym_constant_bit_string_segment_options_repeat1] = aux_sym_constant_bit_string_segment_options_repeat1,
  [aux_sym_constant_record_arguments_repeat1] = aux_sym_constant_record_arguments_repeat1,
  [aux_sym_constant_tuple_type_repeat1] = aux_sym_constant_tuple_type_repeat1,
  [aux_sym_constant_type_arguments_repeat1] = aux_sym_constant_type_arguments_repeat1,
  [aux_sym_external_function_parameters_repeat1] = aux_sym_external_function_parameters_repeat1,
  [aux_sym_function_parameters_repeat1] = aux_sym_function_parameters_repeat1,
  [aux_sym_tuple_repeat1] = aux_sym_tuple_repeat1,
  [aux_sym__expression_bit_string_repeat1] = aux_sym__expression_bit_string_repeat1,
  [aux_sym_expression_bit_string_segment_options_repeat1] = aux_sym_expression_bit_string_segment_options_repeat1,
  [aux_sym_anonymous_function_parameters_repeat1] = aux_sym_anonymous_function_parameters_repeat1,
  [aux_sym_case_clauses_repeat1] = aux_sym_case_clauses_repeat1,
  [aux_sym_case_clause_patterns_repeat1] = aux_sym_case_clause_patterns_repeat1,
  [aux_sym_case_clause_pattern_repeat1] = aux_sym_case_clause_pattern_repeat1,
  [aux_sym_use_assignments_repeat1] = aux_sym_use_assignments_repeat1,
  [aux_sym_record_update_arguments_repeat1] = aux_sym_record_update_arguments_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym_record_pattern_arguments_repeat1] = aux_sym_record_pattern_arguments_repeat1,
  [aux_sym__pattern_bit_string_repeat1] = aux_sym__pattern_bit_string_repeat1,
  [aux_sym_pattern_bit_string_segment_options_repeat1] = aux_sym_pattern_bit_string_segment_options_repeat1,
  [aux_sym_data_constructors_repeat1] = aux_sym_data_constructors_repeat1,
  [aux_sym_data_constructor_arguments_repeat1] = aux_sym_data_constructor_arguments_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_module_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_erlang] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_javascript] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_size] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_external] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_todo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_panic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_echo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_use] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [sym_visibility_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_opacity_modifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_escape_sequence_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_escape_sequence_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym__hex] = {
    .visible = false,
    .named = true,
  },
  [sym__decimal] = {
    .visible = false,
    .named = true,
  },
  [sym__octal] = {
    .visible = false,
    .named = true,
  },
  [sym__binary] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_binary] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bit_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bits] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf8_codepoint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf16_codepoint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf32_codepoint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_signed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsigned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_big] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_little] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_native] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unit] = {
    .visible = true,
    .named = false,
  },
  [sym__discard_name] = {
    .visible = false,
    .named = true,
  },
  [sym__name] = {
    .visible = false,
    .named = true,
  },
  [sym__upname] = {
    .visible = false,
    .named = true,
  },
  [sym_quoted_content] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__module_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_target_group] = {
    .visible = true,
    .named = true,
  },
  [sym_target] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym__attribute_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_value] = {
    .visible = true,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_unqualified_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_unqualified_import] = {
    .visible = true,
    .named = true,
  },
  [sym_constant] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_value] = {
    .visible = false,
    .named = true,
  },
  [sym_constant_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_list] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_bit_string] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_bit_string_segment] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_bit_string_segment_options] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_bit_string_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__constant_bit_string_named_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__constant_bit_string_segment_option_size] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_record] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_record_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_record_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_field_access] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_type] = {
    .visible = false,
    .named = true,
  },
  [sym__constant_type_annotation] = {
    .visible = false,
    .named = true,
  },
  [sym_constant_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_function_parameter_types] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_type_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_external_type] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function_body] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__labeled_discard_param] = {
    .visible = false,
    .named = true,
  },
  [sym__discard_param] = {
    .visible = false,
    .named = true,
  },
  [sym__labeled_name_param] = {
    .visible = false,
    .named = true,
  },
  [sym__name_param] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__statement_seq] = {
    .visible = false,
    .named = false,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_unit] = {
    .visible = false,
    .named = true,
  },
  [sym_record] = {
    .visible = true,
    .named = true,
  },
  [sym_todo] = {
    .visible = true,
    .named = true,
  },
  [sym_panic] = {
    .visible = true,
    .named = true,
  },
  [sym_pipeline_echo] = {
    .visible = true,
    .named = true,
  },
  [sym_echo] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_bit_string] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_bit_string_segment] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_bit_string_segment_options] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_bit_string_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__expression_bit_string_named_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__expression_bit_string_segment_option_size] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_function] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_function_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_function_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_case] = {
    .visible = true,
    .named = true,
  },
  [sym_case_subjects] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clauses] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause_patterns] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause_guard] = {
    .visible = true,
    .named = true,
  },
  [sym__case_clause_guard_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__case_clause_guard_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__case_clause_guard_unit] = {
    .visible = false,
    .named = true,
  },
  [sym__case_clause_tuple_access] = {
    .visible = true,
    .named = true,
  },
  [sym_let_assert] = {
    .visible = true,
    .named = true,
  },
  [sym_assert] = {
    .visible = true,
    .named = true,
  },
  [sym_let] = {
    .visible = true,
    .named = true,
  },
  [sym_use] = {
    .visible = true,
    .named = true,
  },
  [sym_use_assignments] = {
    .visible = true,
    .named = true,
  },
  [sym_use_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_negation] = {
    .visible = true,
    .named = true,
  },
  [sym_integer_negation] = {
    .visible = true,
    .named = true,
  },
  [sym__assignment] = {
    .visible = false,
    .named = true,
  },
  [sym_record_update] = {
    .visible = true,
    .named = true,
  },
  [sym_record_update_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_record_update_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__maybe_tuple_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_tuple_access] = {
    .visible = true,
    .named = true,
  },
  [sym__maybe_record_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_field_access] = {
    .visible = true,
    .named = true,
  },
  [sym__maybe_function_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_hole] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__pattern_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_record_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_record_pattern_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_record_pattern_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_spread] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_bit_string] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_bit_string_segment] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_bit_string_segment_options] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_bit_string_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__pattern_bit_string_named_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__pattern_bit_string_segment_option_size] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_bit_string_segment_argument] = {
    .visible = false,
    .named = true,
  },
  [sym_list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_list_pattern_tail] = {
    .visible = true,
    .named = true,
  },
  [sym_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructors] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructor] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructor_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructor_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym__bit_string_segment_option] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym__type_annotation] = {
    .visible = false,
    .named = true,
  },
  [sym_type_hole] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameter_types] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_type_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_type_var] = {
    .visible = true,
    .named = true,
  },
  [sym_type_name] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_label] = {
    .visible = true,
    .named = true,
  },
  [sym_discard] = {
    .visible = true,
    .named = true,
  },
  [sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_remote_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_name] = {
    .visible = true,
    .named = true,
  },
  [sym_remote_constructor_name] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_target_group_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__attribute_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unqualified_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_tuple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__constant_bit_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_bit_string_segment_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_record_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_external_function_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__expression_bit_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expression_bit_string_segment_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_anonymous_function_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clauses_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clause_patterns_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clause_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_use_assignments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_update_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_pattern_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pattern_bit_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pattern_bit_string_segment_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_data_constructors_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_data_constructor_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alias = 1,
  field_arguments = 2,
  field_assign = 3,
  field_assignments = 4,
  field_body = 5,
  field_clauses = 6,
  field_constructor = 7,
  field_field = 8,
  field_function = 9,
  field_guard = 10,
  field_imports = 11,
  field_index = 12,
  field_label = 13,
  field_left = 14,
  field_message = 15,
  field_module = 16,
  field_name = 17,
  field_operator = 18,
  field_options = 19,
  field_parameter_types = 20,
  field_parameters = 21,
  field_pattern = 22,
  field_patterns = 23,
  field_record = 24,
  field_return_type = 25,
  field_right = 26,
  field_spread = 27,
  field_subjects = 28,
  field_target = 29,
  field_tuple = 30,
  field_type = 31,
  field_value = 32,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_arguments] = "arguments",
  [field_assign] = "assign",
  [field_assignments] = "assignments",
  [field_body] = "body",
  [field_clauses] = "clauses",
  [field_constructor] = "constructor",
  [field_field] = "field",
  [field_function] = "function",
  [field_guard] = "guard",
  [field_imports] = "imports",
  [field_index] = "index",
  [field_label] = "label",
  [field_left] = "left",
  [field_message] = "message",
  [field_module] = "module",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_options] = "options",
  [field_parameter_types] = "parameter_types",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_patterns] = "patterns",
  [field_record] = "record",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_spread] = "spread",
  [field_subjects] = "subjects",
  [field_target] = "target",
  [field_tuple] = "tuple",
  [field_type] = "type",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 1},
  [5] = {.index = 4, .length = 4},
  [6] = {.index = 8, .length = 3},
  [7] = {.index = 11, .length = 1},
  [8] = {.index = 12, .length = 1},
  [9] = {.index = 13, .length = 2},
  [10] = {.index = 15, .length = 2},
  [11] = {.index = 17, .length = 2},
  [12] = {.index = 19, .length = 2},
  [13] = {.index = 21, .length = 1},
  [14] = {.index = 22, .length = 2},
  [15] = {.index = 24, .length = 2},
  [16] = {.index = 26, .length = 1},
  [17] = {.index = 27, .length = 2},
  [18] = {.index = 29, .length = 4},
  [19] = {.index = 33, .length = 1},
  [20] = {.index = 34, .length = 2},
  [21] = {.index = 36, .length = 3},
  [22] = {.index = 39, .length = 2},
  [23] = {.index = 41, .length = 2},
  [24] = {.index = 43, .length = 2},
  [25] = {.index = 45, .length = 1},
  [26] = {.index = 46, .length = 2},
  [27] = {.index = 48, .length = 2},
  [28] = {.index = 50, .length = 1},
  [29] = {.index = 51, .length = 2},
  [30] = {.index = 53, .length = 3},
  [31] = {.index = 56, .length = 2},
  [32] = {.index = 58, .length = 2},
  [33] = {.index = 60, .length = 3},
  [34] = {.index = 63, .length = 1},
  [35] = {.index = 64, .length = 1},
  [36] = {.index = 65, .length = 2},
  [37] = {.index = 67, .length = 3},
  [38] = {.index = 70, .length = 2},
  [39] = {.index = 72, .length = 2},
  [40] = {.index = 74, .length = 2},
  [41] = {.index = 76, .length = 2},
  [42] = {.index = 78, .length = 1},
  [43] = {.index = 79, .length = 3},
  [44] = {.index = 82, .length = 1},
  [45] = {.index = 83, .length = 3},
  [46] = {.index = 86, .length = 3},
  [47] = {.index = 89, .length = 2},
  [48] = {.index = 91, .length = 3},
  [49] = {.index = 94, .length = 1},
  [50] = {.index = 95, .length = 2},
  [51] = {.index = 97, .length = 2},
  [52] = {.index = 99, .length = 1},
  [53] = {.index = 100, .length = 2},
  [54] = {.index = 102, .length = 4},
  [55] = {.index = 106, .length = 5},
  [56] = {.index = 111, .length = 4},
  [57] = {.index = 115, .length = 2},
  [58] = {.index = 117, .length = 3},
  [59] = {.index = 120, .length = 2},
  [60] = {.index = 122, .length = 3},
  [61] = {.index = 125, .length = 1},
  [62] = {.index = 126, .length = 1},
  [63] = {.index = 127, .length = 4},
  [64] = {.index = 131, .length = 2},
  [65] = {.index = 133, .length = 2},
  [66] = {.index = 135, .length = 2},
  [67] = {.index = 137, .length = 3},
  [68] = {.index = 140, .length = 3},
  [69] = {.index = 143, .length = 3},
  [70] = {.index = 146, .length = 2},
  [71] = {.index = 148, .length = 2},
  [72] = {.index = 150, .length = 1},
  [73] = {.index = 151, .length = 2},
  [74] = {.index = 153, .length = 3},
  [75] = {.index = 156, .length = 4},
  [76] = {.index = 160, .length = 3},
  [77] = {.index = 163, .length = 2},
  [78] = {.index = 165, .length = 4},
  [79] = {.index = 169, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_name, 1},
  [2] =
    {field_module, 1},
  [3] =
    {field_value, 0},
  [4] =
    {field_assign, 1, .inherited = true},
    {field_pattern, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [8] =
    {field_left, 0, .inherited = true},
    {field_operator, 0, .inherited = true},
    {field_right, 0, .inherited = true},
  [11] =
    {field_value, 1},
  [12] =
    {field_assign, 0, .inherited = true},
  [13] =
    {field_arguments, 1},
    {field_function, 0},
  [15] =
    {field_arguments, 1},
    {field_name, 0},
  [17] =
    {field_arguments, 2},
    {field_name, 1},
  [19] =
    {field_name, 0},
    {field_parameters, 1},
  [21] =
    {field_name, 0, .inherited = true},
  [22] =
    {field_body, 2},
    {field_parameters, 1},
  [24] =
    {field_name, 1},
    {field_parameters, 2},
  [26] =
    {field_message, 2},
  [27] =
    {field_assign, 0, .inherited = true},
    {field_value, 0},
  [29] =
    {field_assign, 2, .inherited = true},
    {field_pattern, 2, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [33] =
    {field_value, 2},
  [34] =
    {field_assign, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [36] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [39] =
    {field_index, 2},
    {field_tuple, 0},
  [41] =
    {field_field, 2},
    {field_record, 0},
  [43] =
    {field_module, 0},
    {field_name, 2},
  [45] =
    {field_target, 1},
  [46] =
    {field_imports, 3},
    {field_module, 1},
  [48] =
    {field_alias, 3},
    {field_module, 1},
  [50] =
    {field_type, 1},
  [51] =
    {field_name, 1},
    {field_value, 3},
  [53] =
    {field_options, 1},
    {field_options, 2},
    {field_value, 0},
  [56] =
    {field_name, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [58] =
    {field_label, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [60] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [63] =
    {field_subjects, 1},
  [64] =
    {field_assign, 1, .inherited = true},
  [65] =
    {field_assign, 1},
    {field_assign, 2},
  [67] =
    {field_assign, 0, .inherited = true},
    {field_pattern, 0},
    {field_value, 2},
  [70] =
    {field_assign, 0, .inherited = true},
    {field_pattern, 0},
  [72] =
    {field_message, 3},
    {field_value, 1},
  [74] =
    {field_assignments, 1},
    {field_value, 3},
  [76] =
    {field_name, 2},
    {field_parameters, 3},
  [78] =
    {field_label, 0},
  [79] =
    {field_name, 1},
    {field_type, 2, .inherited = true},
    {field_value, 4},
  [82] =
    {field_spread, 3},
  [83] =
    {field_body, 4},
    {field_parameters, 1},
    {field_return_type, 3},
  [86] =
    {field_label, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [89] =
    {field_label, 0},
    {field_name, 1},
  [91] =
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [94] =
    {field_type, 0},
  [95] =
    {field_clauses, 3},
    {field_subjects, 1},
  [97] =
    {field_assign, 0, .inherited = true},
    {field_assign, 1, .inherited = true},
  [99] =
    {field_assign, 2, .inherited = true},
  [100] =
    {field_assign, 1, .inherited = true},
    {field_assign, 2, .inherited = true},
  [102] =
    {field_assign, 0, .inherited = true},
    {field_options, 1},
    {field_options, 2},
    {field_value, 0},
  [106] =
    {field_assign, 2, .inherited = true},
    {field_message, 4},
    {field_pattern, 2, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [111] =
    {field_assign, 0, .inherited = true},
    {field_pattern, 0},
    {field_type, 1, .inherited = true},
    {field_value, 3},
  [115] =
    {field_name, 2},
    {field_value, 4},
  [117] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3},
  [120] =
    {field_label, 0},
    {field_value, 2},
  [122] =
    {field_alias, 5},
    {field_imports, 3},
    {field_module, 1},
  [125] =
    {field_return_type, 2},
  [126] =
    {field_spread, 4},
  [127] =
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [131] =
    {field_index, 0, .inherited = true},
    {field_tuple, 0, .inherited = true},
  [133] =
    {field_patterns, 0},
    {field_value, 2},
  [135] =
    {field_assign, 2, .inherited = true},
    {field_assign, 3, .inherited = true},
  [137] =
    {field_assign, 2, .inherited = true},
    {field_label, 0},
    {field_pattern, 2},
  [140] =
    {field_name, 2},
    {field_type, 3, .inherited = true},
    {field_value, 5},
  [143] =
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [146] =
    {field_alias, 2},
    {field_name, 0},
  [148] =
    {field_parameter_types, 1},
    {field_return_type, 3},
  [150] =
    {field_spread, 5},
  [151] =
    {field_name, 0},
    {field_type, 2},
  [153] =
    {field_guard, 1},
    {field_patterns, 0},
    {field_value, 3},
  [156] =
    {field_body, 6},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [160] =
    {field_arguments, 5},
    {field_constructor, 0},
    {field_spread, 3},
  [163] =
    {field_alias, 3},
    {field_name, 1},
  [165] =
    {field_body, 7},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [169] =
    {field_body, 8},
    {field_name, 3},
    {field_parameters, 4},
    {field_return_type, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(175);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(170)
      if (lookahead == '\r') SKIP(170)
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(268);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(216);
      if (lookahead == '.') ADVANCE(197);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == ':') ADVANCE(193);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(207);
      if (lookahead == '>') ADVANCE(237);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == '\\') ADVANCE(127);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == '_') ADVANCE(316);
      if (lookahead == 'a') ADVANCE(430);
      if (lookahead == 'b') ADVANCE(377);
      if (lookahead == 'c') ADVANCE(325);
      if (lookahead == 'e') ADVANCE(336);
      if (lookahead == 'f') ADVANCE(388);
      if (lookahead == 'i') ADVANCE(367);
      if (lookahead == 'j') ADVANCE(323);
      if (lookahead == 'l') ADVANCE(359);
      if (lookahead == 'n') ADVANCE(333);
      if (lookahead == 'o') ADVANCE(416);
      if (lookahead == 'p') ADVANCE(327);
      if (lookahead == 's') ADVANCE(378);
      if (lookahead == 't') ADVANCE(404);
      if (lookahead == 'u') ADVANCE(393);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(256);
      if (lookahead == '}') ADVANCE(184);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('d' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 1:
      if (lookahead == '&') ADVANCE(228);
      END_STATE();
    case 2:
      if (lookahead == '-') ADVANCE(167);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(272);
      END_STATE();
    case 3:
      if (lookahead == '-') ADVANCE(260);
      if (lookahead == '<') ADVANCE(211);
      END_STATE();
    case 4:
      if (lookahead == '-') ADVANCE(260);
      if (lookahead == '>') ADVANCE(249);
      END_STATE();
    case 5:
      if (lookahead == '.') ADVANCE(253);
      END_STATE();
    case 6:
      if (lookahead == '.') ADVANCE(271);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(6);
      END_STATE();
    case 7:
      if (lookahead == '/') ADVANCE(179);
      END_STATE();
    case 8:
      if (lookahead == '1') ADVANCE(10);
      if (lookahead == '3') ADVANCE(9);
      if (lookahead == '8') ADVANCE(292);
      END_STATE();
    case 9:
      if (lookahead == '2') ADVANCE(296);
      END_STATE();
    case 10:
      if (lookahead == '6') ADVANCE(294);
      END_STATE();
    case 11:
      if (lookahead == '<') ADVANCE(211);
      END_STATE();
    case 12:
      if (lookahead == '=') ADVANCE(230);
      END_STATE();
    case 13:
      if (lookahead == '=') ADVANCE(229);
      END_STATE();
    case 14:
      if (lookahead == '>') ADVANCE(224);
      END_STATE();
    case 15:
      if (lookahead == '>') ADVANCE(212);
      END_STATE();
    case 16:
      if (lookahead == '>') ADVANCE(241);
      if (lookahead == '|') ADVANCE(227);
      END_STATE();
    case 17:
      if (lookahead == '_') ADVANCE(111);
      if (lookahead == 's') ADVANCE(290);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(130);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(100);
      END_STATE();
    case 20:
      if (lookahead == 'a') ADVANCE(102);
      END_STATE();
    case 21:
      if (lookahead == 'a') ADVANCE(76);
      END_STATE();
    case 22:
      if (lookahead == 'a') ADVANCE(67);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(109);
      END_STATE();
    case 24:
      if (lookahead == 'a') ADVANCE(124);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(116);
      END_STATE();
    case 26:
      if (lookahead == 'b') ADVANCE(263);
      END_STATE();
    case 27:
      if (lookahead == 'c') ADVANCE(86);
      END_STATE();
    case 28:
      if (lookahead == 'c') ADVANCE(105);
      END_STATE();
    case 29:
      if (lookahead == 'c') ADVANCE(91);
      END_STATE();
    case 30:
      if (lookahead == 'c') ADVANCE(92);
      END_STATE();
    case 31:
      if (lookahead == 'd') ADVANCE(304);
      END_STATE();
    case 32:
      if (lookahead == 'd') ADVANCE(306);
      END_STATE();
    case 33:
      if (lookahead == 'd') ADVANCE(45);
      END_STATE();
    case 34:
      if (lookahead == 'd') ADVANCE(46);
      END_STATE();
    case 35:
      if (lookahead == 'd') ADVANCE(47);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(220);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(202);
      END_STATE();
    case 38:
      if (lookahead == 'e') ADVANCE(31);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(310);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(312);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(265);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(103);
      END_STATE();
    case 43:
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 44:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(96);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(98);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 48:
      if (lookahead == 'f') ADVANCE(8);
      END_STATE();
    case 49:
      if (lookahead == 'f') ADVANCE(181);
      END_STATE();
    case 50:
      if (lookahead == 'f') ADVANCE(181);
      if (lookahead == 'm') ADVANCE(93);
      END_STATE();
    case 51:
      if (lookahead == 'g') ADVANCE(308);
      if (lookahead == 'n') ADVANCE(20);
      if (lookahead == 't') ADVANCE(17);
      END_STATE();
    case 52:
      if (lookahead == 'g') ADVANCE(185);
      END_STATE();
    case 53:
      if (lookahead == 'g') ADVANCE(288);
      END_STATE();
    case 54:
      if (lookahead == 'g') ADVANCE(78);
      if (lookahead == 'z') ADVANCE(36);
      END_STATE();
    case 55:
      if (lookahead == 'g') ADVANCE(80);
      END_STATE();
    case 56:
      if (lookahead == 'i') ADVANCE(51);
      if (lookahead == 'y') ADVANCE(112);
      END_STATE();
    case 57:
      if (lookahead == 'i') ADVANCE(54);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(55);
      END_STATE();
    case 59:
      if (lookahead == 'i') ADVANCE(131);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(126);
      END_STATE();
    case 61:
      if (lookahead == 'i') ADVANCE(97);
      END_STATE();
    case 62:
      if (lookahead == 'i') ADVANCE(77);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(114);
      if (lookahead == 's') ADVANCE(58);
      END_STATE();
    case 64:
      if (lookahead == 'i') ADVANCE(81);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(82);
      END_STATE();
    case 66:
      if (lookahead == 'i') ADVANCE(83);
      END_STATE();
    case 67:
      if (lookahead == 'l') ADVANCE(225);
      END_STATE();
    case 68:
      if (lookahead == 'l') ADVANCE(87);
      if (lookahead == 'n') ADVANCE(222);
      END_STATE();
    case 69:
      if (lookahead == 'l') ADVANCE(21);
      END_STATE();
    case 70:
      if (lookahead == 'l') ADVANCE(39);
      END_STATE();
    case 71:
      if (lookahead == 'm') ADVANCE(93);
      END_STATE();
    case 72:
      if (lookahead == 'm') ADVANCE(93);
      if (lookahead == 'n') ADVANCE(113);
      END_STATE();
    case 73:
      if (lookahead == 'n') ADVANCE(222);
      END_STATE();
    case 74:
      if (lookahead == 'n') ADVANCE(63);
      if (lookahead == 't') ADVANCE(48);
      END_STATE();
    case 75:
      if (lookahead == 'n') ADVANCE(110);
      END_STATE();
    case 76:
      if (lookahead == 'n') ADVANCE(52);
      END_STATE();
    case 77:
      if (lookahead == 'n') ADVANCE(53);
      END_STATE();
    case 78:
      if (lookahead == 'n') ADVANCE(38);
      END_STATE();
    case 79:
      if (lookahead == 'n') ADVANCE(22);
      END_STATE();
    case 80:
      if (lookahead == 'n') ADVANCE(43);
      END_STATE();
    case 81:
      if (lookahead == 'n') ADVANCE(119);
      END_STATE();
    case 82:
      if (lookahead == 'n') ADVANCE(120);
      END_STATE();
    case 83:
      if (lookahead == 'n') ADVANCE(121);
      END_STATE();
    case 84:
      if (lookahead == 'o') ADVANCE(75);
      END_STATE();
    case 85:
      if (lookahead == 'o') ADVANCE(106);
      END_STATE();
    case 86:
      if (lookahead == 'o') ADVANCE(33);
      END_STATE();
    case 87:
      if (lookahead == 'o') ADVANCE(25);
      END_STATE();
    case 88:
      if (lookahead == 'o') ADVANCE(64);
      END_STATE();
    case 89:
      if (lookahead == 'o') ADVANCE(65);
      END_STATE();
    case 90:
      if (lookahead == 'o') ADVANCE(66);
      END_STATE();
    case 91:
      if (lookahead == 'o') ADVANCE(34);
      END_STATE();
    case 92:
      if (lookahead == 'o') ADVANCE(35);
      END_STATE();
    case 93:
      if (lookahead == 'p') ADVANCE(85);
      END_STATE();
    case 94:
      if (lookahead == 'p') ADVANCE(19);
      END_STATE();
    case 95:
      if (lookahead == 'p') ADVANCE(37);
      END_STATE();
    case 96:
      if (lookahead == 'p') ADVANCE(88);
      END_STATE();
    case 97:
      if (lookahead == 'p') ADVANCE(118);
      END_STATE();
    case 98:
      if (lookahead == 'p') ADVANCE(89);
      END_STATE();
    case 99:
      if (lookahead == 'p') ADVANCE(90);
      END_STATE();
    case 100:
      if (lookahead == 'q') ADVANCE(129);
      END_STATE();
    case 101:
      if (lookahead == 'r') ADVANCE(69);
      if (lookahead == 'x') ADVANCE(123);
      END_STATE();
    case 102:
      if (lookahead == 'r') ADVANCE(133);
      END_STATE();
    case 103:
      if (lookahead == 'r') ADVANCE(79);
      END_STATE();
    case 104:
      if (lookahead == 'r') ADVANCE(62);
      END_STATE();
    case 105:
      if (lookahead == 'r') ADVANCE(61);
      END_STATE();
    case 106:
      if (lookahead == 'r') ADVANCE(117);
      END_STATE();
    case 107:
      if (lookahead == 's') ADVANCE(198);
      END_STATE();
    case 108:
      if (lookahead == 's') ADVANCE(282);
      END_STATE();
    case 109:
      if (lookahead == 's') ADVANCE(28);
      END_STATE();
    case 110:
      if (lookahead == 's') ADVANCE(115);
      END_STATE();
    case 111:
      if (lookahead == 's') ADVANCE(125);
      END_STATE();
    case 112:
      if (lookahead == 't') ADVANCE(44);
      END_STATE();
    case 113:
      if (lookahead == 't') ADVANCE(284);
      END_STATE();
    case 114:
      if (lookahead == 't') ADVANCE(314);
      END_STATE();
    case 115:
      if (lookahead == 't') ADVANCE(204);
      END_STATE();
    case 116:
      if (lookahead == 't') ADVANCE(286);
      END_STATE();
    case 117:
      if (lookahead == 't') ADVANCE(194);
      END_STATE();
    case 118:
      if (lookahead == 't') ADVANCE(187);
      END_STATE();
    case 119:
      if (lookahead == 't') ADVANCE(298);
      END_STATE();
    case 120:
      if (lookahead == 't') ADVANCE(300);
      END_STATE();
    case 121:
      if (lookahead == 't') ADVANCE(302);
      END_STATE();
    case 122:
      if (lookahead == 't') ADVANCE(70);
      END_STATE();
    case 123:
      if (lookahead == 't') ADVANCE(42);
      END_STATE();
    case 124:
      if (lookahead == 't') ADVANCE(59);
      END_STATE();
    case 125:
      if (lookahead == 't') ADVANCE(104);
      END_STATE();
    case 126:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 127:
      if (lookahead == 'u') ADVANCE(135);
      if (lookahead == '"' ||
          lookahead == '\\' ||
          lookahead == 'e' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(269);
      END_STATE();
    case 128:
      if (lookahead == 'u') ADVANCE(26);
      END_STATE();
    case 129:
      if (lookahead == 'u') ADVANCE(41);
      END_STATE();
    case 130:
      if (lookahead == 'v') ADVANCE(23);
      END_STATE();
    case 131:
      if (lookahead == 'v') ADVANCE(40);
      END_STATE();
    case 132:
      if (lookahead == 'x') ADVANCE(123);
      END_STATE();
    case 133:
      if (lookahead == 'y') ADVANCE(280);
      END_STATE();
    case 134:
      if (lookahead == 'y') ADVANCE(95);
      END_STATE();
    case 135:
      if (lookahead == '{') ADVANCE(168);
      END_STATE();
    case 136:
      if (lookahead == '}') ADVANCE(270);
      END_STATE();
    case 137:
      if (lookahead == '}') ADVANCE(270);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(136);
      END_STATE();
    case 138:
      if (lookahead == '}') ADVANCE(270);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(137);
      END_STATE();
    case 139:
      if (lookahead == '}') ADVANCE(270);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(138);
      END_STATE();
    case 140:
      if (lookahead == '}') ADVANCE(270);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(139);
      END_STATE();
    case 141:
      if (lookahead == '}') ADVANCE(270);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(140);
      END_STATE();
    case 142:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(142)
      if (lookahead == '\r') SKIP(142)
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '.') ADVANCE(5);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == ':') ADVANCE(193);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(237);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == '_') ADVANCE(318);
      if (lookahead == 'c') ADVANCE(326);
      if (lookahead == 'e') ADVANCE(338);
      if (lookahead == 'f') ADVANCE(392);
      if (lookahead == 'p') ADVANCE(328);
      if (lookahead == 't') ADVANCE(405);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(184);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 143:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(143)
      if (lookahead == '\r') SKIP(143)
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '.') ADVANCE(196);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(236);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == '_') ADVANCE(318);
      if (lookahead == 'a') ADVANCE(430);
      if (lookahead == 'c') ADVANCE(326);
      if (lookahead == 'e') ADVANCE(338);
      if (lookahead == 'f') ADVANCE(392);
      if (lookahead == 'l') ADVANCE(360);
      if (lookahead == 'p') ADVANCE(328);
      if (lookahead == 't') ADVANCE(405);
      if (lookahead == 'u') ADVANCE(431);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(184);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 144:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(144)
      if (lookahead == '\r') SKIP(144)
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '.') ADVANCE(196);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == ':') ADVANCE(193);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(237);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == '_') ADVANCE(318);
      if (lookahead == 'a') ADVANCE(439);
      if (lookahead == 'c') ADVANCE(326);
      if (lookahead == 'e') ADVANCE(338);
      if (lookahead == 'f') ADVANCE(392);
      if (lookahead == 'l') ADVANCE(360);
      if (lookahead == 'p') ADVANCE(328);
      if (lookahead == 't') ADVANCE(405);
      if (lookahead == 'u') ADVANCE(431);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(184);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 145:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(145)
      if (lookahead == '\r') SKIP(145)
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '.') ADVANCE(5);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(236);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == '_') ADVANCE(316);
      if (lookahead == 'c') ADVANCE(326);
      if (lookahead == 'e') ADVANCE(338);
      if (lookahead == 'f') ADVANCE(392);
      if (lookahead == 'p') ADVANCE(328);
      if (lookahead == 't') ADVANCE(405);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(184);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 146:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(146)
      if (lookahead == '\r') SKIP(146)
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == '-') ADVANCE(216);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(236);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == '_') ADVANCE(318);
      if (lookahead == 'c') ADVANCE(326);
      if (lookahead == 'e') ADVANCE(338);
      if (lookahead == 'f') ADVANCE(392);
      if (lookahead == 'p') ADVANCE(328);
      if (lookahead == 't') ADVANCE(405);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(16);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 147:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(147)
      if (lookahead == '\r') SKIP(147)
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '.') ADVANCE(197);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == ':') ADVANCE(193);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(207);
      if (lookahead == '>') ADVANCE(237);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == '_') ADVANCE(318);
      if (lookahead == 'a') ADVANCE(439);
      if (lookahead == 'c') ADVANCE(326);
      if (lookahead == 'e') ADVANCE(338);
      if (lookahead == 'f') ADVANCE(392);
      if (lookahead == 'l') ADVANCE(360);
      if (lookahead == 'p') ADVANCE(328);
      if (lookahead == 't') ADVANCE(405);
      if (lookahead == 'u') ADVANCE(431);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(184);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 148:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(149)
      if (lookahead == '\r') SKIP(149)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '"') ADVANCE(268);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(214);
      if (lookahead == '.') ADVANCE(197);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(276);
      if (lookahead == ':') ADVANCE(193);
      if (lookahead == '<') ADVANCE(232);
      if (lookahead == '=') ADVANCE(207);
      if (lookahead == '>') ADVANCE(237);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '\\') ADVANCE(127);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == 'a') ADVANCE(107);
      if (lookahead == 'b') ADVANCE(56);
      if (lookahead == 'c') ADVANCE(84);
      if (lookahead == 'e') ADVANCE(101);
      if (lookahead == 'f') ADVANCE(68);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'j') ADVANCE(18);
      if (lookahead == 'l') ADVANCE(60);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead == 'o') ADVANCE(94);
      if (lookahead == 'p') ADVANCE(128);
      if (lookahead == 's') ADVANCE(57);
      if (lookahead == 't') ADVANCE(134);
      if (lookahead == 'u') ADVANCE(74);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(184);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(277);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 149:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(149)
      if (lookahead == '\r') SKIP(149)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(214);
      if (lookahead == '.') ADVANCE(197);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(276);
      if (lookahead == ':') ADVANCE(193);
      if (lookahead == '<') ADVANCE(232);
      if (lookahead == '=') ADVANCE(207);
      if (lookahead == '>') ADVANCE(237);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == 'a') ADVANCE(107);
      if (lookahead == 'b') ADVANCE(56);
      if (lookahead == 'c') ADVANCE(84);
      if (lookahead == 'e') ADVANCE(101);
      if (lookahead == 'f') ADVANCE(68);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'j') ADVANCE(18);
      if (lookahead == 'l') ADVANCE(60);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead == 'o') ADVANCE(94);
      if (lookahead == 'p') ADVANCE(128);
      if (lookahead == 's') ADVANCE(57);
      if (lookahead == 't') ADVANCE(134);
      if (lookahead == 'u') ADVANCE(74);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(184);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(277);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 150:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(150)
      if (lookahead == '\r') SKIP(150)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(214);
      if (lookahead == '.') ADVANCE(197);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == ':') ADVANCE(193);
      if (lookahead == '<') ADVANCE(232);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(237);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == 'a') ADVANCE(107);
      if (lookahead == 'c') ADVANCE(84);
      if (lookahead == 'e') ADVANCE(132);
      if (lookahead == 'f') ADVANCE(73);
      if (lookahead == 'i') ADVANCE(71);
      if (lookahead == 'o') ADVANCE(94);
      if (lookahead == 'p') ADVANCE(128);
      if (lookahead == 't') ADVANCE(134);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(184);
      END_STATE();
    case 151:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(151)
      if (lookahead == '\r') SKIP(151)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '.') ADVANCE(197);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(237);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == '_') ADVANCE(316);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(184);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 152:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(152)
      if (lookahead == '\r') SKIP(152)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(236);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == '_') ADVANCE(316);
      if (lookahead == 'a') ADVANCE(433);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(184);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 153:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(153)
      if (lookahead == '\r') SKIP(153)
      if (lookahead == '!') ADVANCE(261);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(219);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == '<') ADVANCE(11);
      if (lookahead == '>') ADVANCE(15);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == '_') ADVANCE(318);
      if (lookahead == '{') ADVANCE(183);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 154:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(154)
      if (lookahead == '\r') SKIP(154)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(215);
      if (lookahead == '.') ADVANCE(196);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '<') ADVANCE(232);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(236);
      if (lookahead == 'a') ADVANCE(107);
      if (lookahead == 'i') ADVANCE(49);
      if (lookahead == '|') ADVANCE(256);
      END_STATE();
    case 155:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(155)
      if (lookahead == '\r') SKIP(155)
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '-') ADVANCE(218);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == '<') ADVANCE(11);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == '_') ADVANCE(316);
      if (lookahead == 'i') ADVANCE(369);
      if (lookahead == '|') ADVANCE(255);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 156:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(156)
      if (lookahead == '\r') SKIP(156)
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '-') ADVANCE(219);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == '<') ADVANCE(3);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == '_') ADVANCE(316);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 157:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(157)
      if (lookahead == '\r') SKIP(157)
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '-') ADVANCE(219);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == '<') ADVANCE(11);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == '_') ADVANCE(316);
      if (lookahead == 'a') ADVANCE(439);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 158:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(158)
      if (lookahead == '\r') SKIP(158)
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(213);
      if (lookahead == '.') ADVANCE(197);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == ':') ADVANCE(193);
      if (lookahead == '<') ADVANCE(4);
      if (lookahead == '=') ADVANCE(206);
      if (lookahead == '>') ADVANCE(15);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == 'a') ADVANCE(107);
      if (lookahead == 'c') ADVANCE(84);
      if (lookahead == 'e') ADVANCE(132);
      if (lookahead == 'f') ADVANCE(73);
      if (lookahead == 'i') ADVANCE(71);
      if (lookahead == 'o') ADVANCE(94);
      if (lookahead == 'p') ADVANCE(128);
      if (lookahead == 't') ADVANCE(134);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '}') ADVANCE(184);
      END_STATE();
    case 159:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(159)
      if (lookahead == '\r') SKIP(159)
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(14);
      if (lookahead == '.') ADVANCE(197);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == ':') ADVANCE(193);
      if (lookahead == '<') ADVANCE(4);
      if (lookahead == '=') ADVANCE(206);
      if (lookahead == '>') ADVANCE(15);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == 'a') ADVANCE(107);
      if (lookahead == 'c') ADVANCE(84);
      if (lookahead == 'e') ADVANCE(132);
      if (lookahead == 'f') ADVANCE(73);
      if (lookahead == 'i') ADVANCE(50);
      if (lookahead == 'o') ADVANCE(94);
      if (lookahead == 'p') ADVANCE(128);
      if (lookahead == 't') ADVANCE(134);
      if (lookahead == '|') ADVANCE(255);
      if (lookahead == '}') ADVANCE(184);
      END_STATE();
    case 160:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(160)
      if (lookahead == '\r') SKIP(160)
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '_') ADVANCE(317);
      if (lookahead == 'f') ADVANCE(392);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 161:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(161)
      if (lookahead == '\r') SKIP(161)
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == ':') ADVANCE(193);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == '_') ADVANCE(317);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 162:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(162)
      if (lookahead == '\r') SKIP(162)
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == '-') ADVANCE(213);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(276);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(277);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 163:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(163)
      if (lookahead == '\r') SKIP(163)
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == 't') ADVANCE(461);
      if (lookahead == '}') ADVANCE(184);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 164:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(164)
      if (lookahead == '\r') SKIP(164)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(215);
      if (lookahead == '.') ADVANCE(196);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == ':') ADVANCE(193);
      if (lookahead == '<') ADVANCE(232);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(237);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == 'a') ADVANCE(107);
      if (lookahead == 'c') ADVANCE(84);
      if (lookahead == 'e') ADVANCE(132);
      if (lookahead == 'f') ADVANCE(73);
      if (lookahead == 'i') ADVANCE(50);
      if (lookahead == 'o') ADVANCE(94);
      if (lookahead == 'p') ADVANCE(128);
      if (lookahead == 't') ADVANCE(134);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(184);
      END_STATE();
    case 165:
      if (lookahead == '0' ||
          lookahead == '1' ||
          lookahead == '_') ADVANCE(279);
      END_STATE();
    case 166:
      if (('0' <= lookahead && lookahead <= '7') ||
          lookahead == '_') ADVANCE(278);
      END_STATE();
    case 167:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(272);
      END_STATE();
    case 168:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(141);
      END_STATE();
    case 169:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(273);
      END_STATE();
    case 170:
      if (eof) ADVANCE(175);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(170)
      if (lookahead == '\r') SKIP(170)
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(216);
      if (lookahead == '.') ADVANCE(197);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == ':') ADVANCE(193);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(207);
      if (lookahead == '>') ADVANCE(237);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == '_') ADVANCE(316);
      if (lookahead == 'a') ADVANCE(430);
      if (lookahead == 'b') ADVANCE(377);
      if (lookahead == 'c') ADVANCE(325);
      if (lookahead == 'e') ADVANCE(336);
      if (lookahead == 'f') ADVANCE(388);
      if (lookahead == 'i') ADVANCE(367);
      if (lookahead == 'j') ADVANCE(323);
      if (lookahead == 'l') ADVANCE(359);
      if (lookahead == 'n') ADVANCE(333);
      if (lookahead == 'o') ADVANCE(416);
      if (lookahead == 'p') ADVANCE(327);
      if (lookahead == 's') ADVANCE(378);
      if (lookahead == 't') ADVANCE(404);
      if (lookahead == 'u') ADVANCE(393);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(256);
      if (lookahead == '}') ADVANCE(184);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('d' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 171:
      if (eof) ADVANCE(175);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(171)
      if (lookahead == '\r') SKIP(171)
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '.') ADVANCE(196);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(236);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == '_') ADVANCE(318);
      if (lookahead == 'a') ADVANCE(439);
      if (lookahead == 'c') ADVANCE(325);
      if (lookahead == 'e') ADVANCE(337);
      if (lookahead == 'f') ADVANCE(392);
      if (lookahead == 'i') ADVANCE(368);
      if (lookahead == 'l') ADVANCE(360);
      if (lookahead == 'o') ADVANCE(416);
      if (lookahead == 'p') ADVANCE(327);
      if (lookahead == 't') ADVANCE(404);
      if (lookahead == 'u') ADVANCE(431);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(16);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 172:
      if (eof) ADVANCE(175);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(172)
      if (lookahead == '\r') SKIP(172)
      if (lookahead == '!') ADVANCE(261);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(219);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == ':') ADVANCE(193);
      if (lookahead == '<') ADVANCE(3);
      if (lookahead == '=') ADVANCE(206);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == '_') ADVANCE(318);
      if (lookahead == 'a') ADVANCE(439);
      if (lookahead == 'c') ADVANCE(325);
      if (lookahead == 'e') ADVANCE(337);
      if (lookahead == 'f') ADVANCE(392);
      if (lookahead == 'i') ADVANCE(368);
      if (lookahead == 'l') ADVANCE(360);
      if (lookahead == 'o') ADVANCE(416);
      if (lookahead == 'p') ADVANCE(327);
      if (lookahead == 't') ADVANCE(404);
      if (lookahead == 'u') ADVANCE(431);
      if (lookahead == '{') ADVANCE(183);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 173:
      if (eof) ADVANCE(175);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(173)
      if (lookahead == '\r') SKIP(173)
      if (lookahead == '!') ADVANCE(261);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '-') ADVANCE(218);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == '<') ADVANCE(11);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == '_') ADVANCE(318);
      if (lookahead == 'a') ADVANCE(439);
      if (lookahead == 'c') ADVANCE(325);
      if (lookahead == 'e') ADVANCE(337);
      if (lookahead == 'f') ADVANCE(392);
      if (lookahead == 'i') ADVANCE(368);
      if (lookahead == 'l') ADVANCE(360);
      if (lookahead == 'o') ADVANCE(416);
      if (lookahead == 'p') ADVANCE(327);
      if (lookahead == 't') ADVANCE(404);
      if (lookahead == 'u') ADVANCE(431);
      if (lookahead == '{') ADVANCE(183);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 174:
      if (eof) ADVANCE(175);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(174)
      if (lookahead == '\r') SKIP(174)
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '.') ADVANCE(196);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(236);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == '_') ADVANCE(318);
      if (lookahead == 'a') ADVANCE(430);
      if (lookahead == 'c') ADVANCE(325);
      if (lookahead == 'e') ADVANCE(337);
      if (lookahead == 'f') ADVANCE(392);
      if (lookahead == 'i') ADVANCE(368);
      if (lookahead == 'l') ADVANCE(360);
      if (lookahead == 'o') ADVANCE(416);
      if (lookahead == 'p') ADVANCE(327);
      if (lookahead == 't') ADVANCE(404);
      if (lookahead == 'u') ADVANCE(431);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(16);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_module_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(176);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_statement_comment);
      if (lookahead == '/') ADVANCE(176);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(178);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_statement_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(178);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '/') ADVANCE(177);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(180);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(180);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_erlang);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_erlang);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_javascript);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_javascript);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_import);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(253);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(351);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_as);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '.') ADVANCE(247);
      if (lookahead == '/') ADVANCE(179);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_type);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_const);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(229);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(244);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(244);
      if (lookahead == '>') ADVANCE(224);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(244);
      if (lookahead == '>') ADVANCE(224);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(6);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(6);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(224);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(6);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(6);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_size);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_size);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_fn);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_fn);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_external);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_external);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '.') ADVANCE(234);
      if (lookahead == '<') ADVANCE(211);
      if (lookahead == '=') ADVANCE(233);
      if (lookahead == '>') ADVANCE(249);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '.') ADVANCE(234);
      if (lookahead == '=') ADVANCE(233);
      if (lookahead == '>') ADVANCE(249);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      if (lookahead == '.') ADVANCE(235);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_LT_DOT);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_LT_EQ_DOT);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '.') ADVANCE(239);
      if (lookahead == '=') ADVANCE(238);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '.') ADVANCE(239);
      if (lookahead == '=') ADVANCE(238);
      if (lookahead == '>') ADVANCE(212);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      if (lookahead == '.') ADVANCE(240);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_GT_DOT);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_GT_EQ_DOT);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_PIPE_GT);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '.') ADVANCE(243);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_PLUS_DOT);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_DASH_DOT);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '.') ADVANCE(246);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_STAR_DOT);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_SLASH_DOT);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_LT_GT);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_todo);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_panic);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_echo);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_case);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '>') ADVANCE(241);
      if (lookahead == '|') ADVANCE(227);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_let);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_assert);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_use);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(230);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_visibility_modifier);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_visibility_modifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_opacity_modifier);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_opacity_modifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_DQUOTE2);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(aux_sym_escape_sequence_token1);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(aux_sym_escape_sequence_token2);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'e') ADVANCE(2);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(271);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(272);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym__hex);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(273);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym__decimal);
      if (lookahead == '.') ADVANCE(271);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(166);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(275);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym__decimal);
      if (lookahead == '.') ADVANCE(271);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(275);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym__decimal);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(166);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(277);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym__decimal);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(277);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym__octal);
      if (('0' <= lookahead && lookahead <= '7') ||
          lookahead == '_') ADVANCE(278);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym__binary);
      if (lookahead == '0' ||
          lookahead == '1' ||
          lookahead == '_') ADVANCE(279);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_binary);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_binary);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_bytes);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_bytes);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_int);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_int);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_float);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_bit_string);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_bit_string);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_bits);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_bits);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_utf8);
      if (lookahead == '_') ADVANCE(27);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_utf8);
      if (lookahead == '_') ADVANCE(340);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_utf16);
      if (lookahead == '_') ADVANCE(29);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_utf16);
      if (lookahead == '_') ADVANCE(342);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_utf32);
      if (lookahead == '_') ADVANCE(30);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_utf32);
      if (lookahead == '_') ADVANCE(343);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_utf8_codepoint);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_utf8_codepoint);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_utf16_codepoint);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_utf16_codepoint);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_utf32_codepoint);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_utf32_codepoint);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_signed);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_signed);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_unsigned);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_unsigned);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_big);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(anon_sym_big);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_little);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_little);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_native);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_native);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_unit);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(anon_sym_unit);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym__discard_name);
      if (lookahead == '.') ADVANCE(271);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(316);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(317);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym__discard_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(317);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '.') ADVANCE(271);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(318);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '1') ADVANCE(321);
      if (lookahead == '3') ADVANCE(320);
      if (lookahead == '8') ADVANCE(293);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '2') ADVANCE(297);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '6') ADVANCE(295);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '_') ADVANCE(438);
      if (lookahead == 's') ADVANCE(291);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(458);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(423);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(436);
      if (lookahead == 'o') ADVANCE(395);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(436);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(396);
      if (lookahead == 'u') ADVANCE(335);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(396);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(424);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(389);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(394);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(435);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(451);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(444);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'b') ADVANCE(264);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(376);
      if (lookahead == 'r') ADVANCE(390);
      if (lookahead == 'x') ADVANCE(455);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(376);
      if (lookahead == 'x') ADVANCE(455);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(376);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(251);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(408);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(427);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(414);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(415);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(305);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(307);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(407);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(364);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(365);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(366);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(259);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(428);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(254);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(221);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(203);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(311);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(313);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(266);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(344);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(441);
      if (lookahead == 'i') ADVANCE(456);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(441);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(345);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(426);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(432);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(418);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(421);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(422);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(182);
      if (lookahead == 'm') ADVANCE(417);
      if (lookahead == 'n') ADVANCE(440);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(182);
      if (lookahead == 'm') ADVANCE(417);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(182);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(319);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(309);
      if (lookahead == 'n') ADVANCE(329);
      if (lookahead == 't') ADVANCE(322);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(186);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(289);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(399);
      if (lookahead == 'z') ADVANCE(353);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(462);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(400);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'h') ADVANCE(406);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(371);
      if (lookahead == 'y') ADVANCE(453);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(374);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(339);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(375);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(459);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(420);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(397);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(442);
      if (lookahead == 's') ADVANCE(380);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(401);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(402);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(403);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(410);
      if (lookahead == 'n') ADVANCE(223);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(226);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(331);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(355);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(223);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(384);
      if (lookahead == 's') ADVANCE(350);
      if (lookahead == 't') ADVANCE(370);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(372);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(437);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(379);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(373);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(330);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(358);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(361);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(448);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(449);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(450);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(346);
      if (lookahead == 'y') ADVANCE(419);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(346);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(252);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(250);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(347);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(429);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(334);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(385);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(386);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(387);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(348);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(349);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(324);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(409);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(411);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(354);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(447);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(412);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(413);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'q') ADVANCE(457);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(460);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(383);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(398);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(382);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(445);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(446);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(199);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(350);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(283);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(200);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(351);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(352);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(443);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(454);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(434);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(285);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(257);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(315);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(205);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(287);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(258);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(195);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(188);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(299);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(301);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(303);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(381);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(391);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(425);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(362);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(452);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'u') ADVANCE(357);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'v') ADVANCE(332);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'v') ADVANCE(356);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'y') ADVANCE(281);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'y') ADVANCE(419);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(sym__name);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(sym__upname);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(463);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 171},
  [2] = {.lex_state = 174},
  [3] = {.lex_state = 171},
  [4] = {.lex_state = 171},
  [5] = {.lex_state = 142},
  [6] = {.lex_state = 171},
  [7] = {.lex_state = 143},
  [8] = {.lex_state = 144},
  [9] = {.lex_state = 145},
  [10] = {.lex_state = 146},
  [11] = {.lex_state = 142},
  [12] = {.lex_state = 171},
  [13] = {.lex_state = 171},
  [14] = {.lex_state = 174},
  [15] = {.lex_state = 174},
  [16] = {.lex_state = 174},
  [17] = {.lex_state = 174},
  [18] = {.lex_state = 174},
  [19] = {.lex_state = 174},
  [20] = {.lex_state = 174},
  [21] = {.lex_state = 174},
  [22] = {.lex_state = 174},
  [23] = {.lex_state = 144},
  [24] = {.lex_state = 174},
  [25] = {.lex_state = 144},
  [26] = {.lex_state = 174},
  [27] = {.lex_state = 174},
  [28] = {.lex_state = 144},
  [29] = {.lex_state = 174},
  [30] = {.lex_state = 144},
  [31] = {.lex_state = 144},
  [32] = {.lex_state = 174},
  [33] = {.lex_state = 144},
  [34] = {.lex_state = 144},
  [35] = {.lex_state = 144},
  [36] = {.lex_state = 144},
  [37] = {.lex_state = 174},
  [38] = {.lex_state = 144},
  [39] = {.lex_state = 171},
  [40] = {.lex_state = 144},
  [41] = {.lex_state = 174},
  [42] = {.lex_state = 174},
  [43] = {.lex_state = 174},
  [44] = {.lex_state = 144},
  [45] = {.lex_state = 144},
  [46] = {.lex_state = 144},
  [47] = {.lex_state = 174},
  [48] = {.lex_state = 174},
  [49] = {.lex_state = 144},
  [50] = {.lex_state = 174},
  [51] = {.lex_state = 171},
  [52] = {.lex_state = 171},
  [53] = {.lex_state = 171},
  [54] = {.lex_state = 171},
  [55] = {.lex_state = 174},
  [56] = {.lex_state = 174},
  [57] = {.lex_state = 171},
  [58] = {.lex_state = 174},
  [59] = {.lex_state = 174},
  [60] = {.lex_state = 174},
  [61] = {.lex_state = 171},
  [62] = {.lex_state = 174},
  [63] = {.lex_state = 174},
  [64] = {.lex_state = 174},
  [65] = {.lex_state = 174},
  [66] = {.lex_state = 174},
  [67] = {.lex_state = 174},
  [68] = {.lex_state = 171},
  [69] = {.lex_state = 174},
  [70] = {.lex_state = 171},
  [71] = {.lex_state = 171},
  [72] = {.lex_state = 171},
  [73] = {.lex_state = 171},
  [74] = {.lex_state = 171},
  [75] = {.lex_state = 171},
  [76] = {.lex_state = 174},
  [77] = {.lex_state = 171},
  [78] = {.lex_state = 174},
  [79] = {.lex_state = 171},
  [80] = {.lex_state = 171},
  [81] = {.lex_state = 171},
  [82] = {.lex_state = 171},
  [83] = {.lex_state = 171},
  [84] = {.lex_state = 174},
  [85] = {.lex_state = 174},
  [86] = {.lex_state = 174},
  [87] = {.lex_state = 174},
  [88] = {.lex_state = 171},
  [89] = {.lex_state = 174},
  [90] = {.lex_state = 174},
  [91] = {.lex_state = 171},
  [92] = {.lex_state = 171},
  [93] = {.lex_state = 171},
  [94] = {.lex_state = 174},
  [95] = {.lex_state = 174},
  [96] = {.lex_state = 171},
  [97] = {.lex_state = 174},
  [98] = {.lex_state = 171},
  [99] = {.lex_state = 174},
  [100] = {.lex_state = 174},
  [101] = {.lex_state = 174},
  [102] = {.lex_state = 174},
  [103] = {.lex_state = 174},
  [104] = {.lex_state = 174},
  [105] = {.lex_state = 174},
  [106] = {.lex_state = 174},
  [107] = {.lex_state = 174},
  [108] = {.lex_state = 171},
  [109] = {.lex_state = 174},
  [110] = {.lex_state = 174},
  [111] = {.lex_state = 174},
  [112] = {.lex_state = 147},
  [113] = {.lex_state = 174},
  [114] = {.lex_state = 171},
  [115] = {.lex_state = 174},
  [116] = {.lex_state = 174},
  [117] = {.lex_state = 174},
  [118] = {.lex_state = 174},
  [119] = {.lex_state = 171},
  [120] = {.lex_state = 174},
  [121] = {.lex_state = 171},
  [122] = {.lex_state = 171},
  [123] = {.lex_state = 174},
  [124] = {.lex_state = 174},
  [125] = {.lex_state = 174},
  [126] = {.lex_state = 174},
  [127] = {.lex_state = 174},
  [128] = {.lex_state = 171},
  [129] = {.lex_state = 171},
  [130] = {.lex_state = 171},
  [131] = {.lex_state = 171},
  [132] = {.lex_state = 171},
  [133] = {.lex_state = 171},
  [134] = {.lex_state = 171},
  [135] = {.lex_state = 171},
  [136] = {.lex_state = 171},
  [137] = {.lex_state = 171},
  [138] = {.lex_state = 171},
  [139] = {.lex_state = 171},
  [140] = {.lex_state = 171},
  [141] = {.lex_state = 171},
  [142] = {.lex_state = 171},
  [143] = {.lex_state = 171},
  [144] = {.lex_state = 171},
  [145] = {.lex_state = 171},
  [146] = {.lex_state = 171},
  [147] = {.lex_state = 171},
  [148] = {.lex_state = 171},
  [149] = {.lex_state = 171},
  [150] = {.lex_state = 171},
  [151] = {.lex_state = 144},
  [152] = {.lex_state = 171},
  [153] = {.lex_state = 171},
  [154] = {.lex_state = 171},
  [155] = {.lex_state = 171},
  [156] = {.lex_state = 171},
  [157] = {.lex_state = 171},
  [158] = {.lex_state = 171},
  [159] = {.lex_state = 171},
  [160] = {.lex_state = 171},
  [161] = {.lex_state = 171},
  [162] = {.lex_state = 171},
  [163] = {.lex_state = 171},
  [164] = {.lex_state = 171},
  [165] = {.lex_state = 145},
  [166] = {.lex_state = 145},
  [167] = {.lex_state = 145},
  [168] = {.lex_state = 145},
  [169] = {.lex_state = 145},
  [170] = {.lex_state = 144},
  [171] = {.lex_state = 144},
  [172] = {.lex_state = 144},
  [173] = {.lex_state = 145},
  [174] = {.lex_state = 145},
  [175] = {.lex_state = 145},
  [176] = {.lex_state = 145},
  [177] = {.lex_state = 145},
  [178] = {.lex_state = 145},
  [179] = {.lex_state = 145},
  [180] = {.lex_state = 145},
  [181] = {.lex_state = 145},
  [182] = {.lex_state = 145},
  [183] = {.lex_state = 145},
  [184] = {.lex_state = 145},
  [185] = {.lex_state = 145},
  [186] = {.lex_state = 145},
  [187] = {.lex_state = 144},
  [188] = {.lex_state = 145},
  [189] = {.lex_state = 145},
  [190] = {.lex_state = 145},
  [191] = {.lex_state = 145},
  [192] = {.lex_state = 145},
  [193] = {.lex_state = 145},
  [194] = {.lex_state = 145},
  [195] = {.lex_state = 145},
  [196] = {.lex_state = 145},
  [197] = {.lex_state = 144},
  [198] = {.lex_state = 145},
  [199] = {.lex_state = 145},
  [200] = {.lex_state = 144},
  [201] = {.lex_state = 144},
  [202] = {.lex_state = 144},
  [203] = {.lex_state = 144},
  [204] = {.lex_state = 144},
  [205] = {.lex_state = 144},
  [206] = {.lex_state = 144},
  [207] = {.lex_state = 144},
  [208] = {.lex_state = 144},
  [209] = {.lex_state = 144},
  [210] = {.lex_state = 144},
  [211] = {.lex_state = 144},
  [212] = {.lex_state = 144},
  [213] = {.lex_state = 144},
  [214] = {.lex_state = 144},
  [215] = {.lex_state = 144},
  [216] = {.lex_state = 144},
  [217] = {.lex_state = 144},
  [218] = {.lex_state = 144},
  [219] = {.lex_state = 144},
  [220] = {.lex_state = 144},
  [221] = {.lex_state = 144},
  [222] = {.lex_state = 143},
  [223] = {.lex_state = 144},
  [224] = {.lex_state = 144},
  [225] = {.lex_state = 144},
  [226] = {.lex_state = 144},
  [227] = {.lex_state = 143},
  [228] = {.lex_state = 142},
  [229] = {.lex_state = 144},
  [230] = {.lex_state = 142},
  [231] = {.lex_state = 142},
  [232] = {.lex_state = 142},
  [233] = {.lex_state = 144},
  [234] = {.lex_state = 144},
  [235] = {.lex_state = 142},
  [236] = {.lex_state = 144},
  [237] = {.lex_state = 142},
  [238] = {.lex_state = 143},
  [239] = {.lex_state = 144},
  [240] = {.lex_state = 144},
  [241] = {.lex_state = 144},
  [242] = {.lex_state = 144},
  [243] = {.lex_state = 142},
  [244] = {.lex_state = 142},
  [245] = {.lex_state = 144},
  [246] = {.lex_state = 144},
  [247] = {.lex_state = 144},
  [248] = {.lex_state = 143},
  [249] = {.lex_state = 143},
  [250] = {.lex_state = 142},
  [251] = {.lex_state = 144},
  [252] = {.lex_state = 143},
  [253] = {.lex_state = 144},
  [254] = {.lex_state = 142},
  [255] = {.lex_state = 143},
  [256] = {.lex_state = 142},
  [257] = {.lex_state = 142},
  [258] = {.lex_state = 142},
  [259] = {.lex_state = 143},
  [260] = {.lex_state = 143},
  [261] = {.lex_state = 142},
  [262] = {.lex_state = 144},
  [263] = {.lex_state = 143},
  [264] = {.lex_state = 143},
  [265] = {.lex_state = 143},
  [266] = {.lex_state = 142},
  [267] = {.lex_state = 143},
  [268] = {.lex_state = 143},
  [269] = {.lex_state = 143},
  [270] = {.lex_state = 143},
  [271] = {.lex_state = 143},
  [272] = {.lex_state = 143},
  [273] = {.lex_state = 143},
  [274] = {.lex_state = 143},
  [275] = {.lex_state = 144},
  [276] = {.lex_state = 142},
  [277] = {.lex_state = 142},
  [278] = {.lex_state = 143},
  [279] = {.lex_state = 142},
  [280] = {.lex_state = 143},
  [281] = {.lex_state = 142},
  [282] = {.lex_state = 142},
  [283] = {.lex_state = 142},
  [284] = {.lex_state = 143},
  [285] = {.lex_state = 142},
  [286] = {.lex_state = 142},
  [287] = {.lex_state = 142},
  [288] = {.lex_state = 143},
  [289] = {.lex_state = 143},
  [290] = {.lex_state = 142},
  [291] = {.lex_state = 142},
  [292] = {.lex_state = 142},
  [293] = {.lex_state = 143},
  [294] = {.lex_state = 142},
  [295] = {.lex_state = 142},
  [296] = {.lex_state = 142},
  [297] = {.lex_state = 142},
  [298] = {.lex_state = 142},
  [299] = {.lex_state = 142},
  [300] = {.lex_state = 142},
  [301] = {.lex_state = 142},
  [302] = {.lex_state = 142},
  [303] = {.lex_state = 142},
  [304] = {.lex_state = 143},
  [305] = {.lex_state = 143},
  [306] = {.lex_state = 142},
  [307] = {.lex_state = 142},
  [308] = {.lex_state = 142},
  [309] = {.lex_state = 142},
  [310] = {.lex_state = 142},
  [311] = {.lex_state = 143},
  [312] = {.lex_state = 143},
  [313] = {.lex_state = 142},
  [314] = {.lex_state = 142},
  [315] = {.lex_state = 143},
  [316] = {.lex_state = 142},
  [317] = {.lex_state = 142},
  [318] = {.lex_state = 142},
  [319] = {.lex_state = 143},
  [320] = {.lex_state = 142},
  [321] = {.lex_state = 144},
  [322] = {.lex_state = 142},
  [323] = {.lex_state = 143},
  [324] = {.lex_state = 142},
  [325] = {.lex_state = 142},
  [326] = {.lex_state = 142},
  [327] = {.lex_state = 142},
  [328] = {.lex_state = 143},
  [329] = {.lex_state = 143},
  [330] = {.lex_state = 142},
  [331] = {.lex_state = 142},
  [332] = {.lex_state = 142},
  [333] = {.lex_state = 142},
  [334] = {.lex_state = 142},
  [335] = {.lex_state = 142},
  [336] = {.lex_state = 143},
  [337] = {.lex_state = 142},
  [338] = {.lex_state = 142},
  [339] = {.lex_state = 143},
  [340] = {.lex_state = 142},
  [341] = {.lex_state = 142},
  [342] = {.lex_state = 142},
  [343] = {.lex_state = 142},
  [344] = {.lex_state = 142},
  [345] = {.lex_state = 142},
  [346] = {.lex_state = 142},
  [347] = {.lex_state = 142},
  [348] = {.lex_state = 142},
  [349] = {.lex_state = 142},
  [350] = {.lex_state = 142},
  [351] = {.lex_state = 142},
  [352] = {.lex_state = 142},
  [353] = {.lex_state = 142},
  [354] = {.lex_state = 142},
  [355] = {.lex_state = 142},
  [356] = {.lex_state = 142},
  [357] = {.lex_state = 142},
  [358] = {.lex_state = 142},
  [359] = {.lex_state = 142},
  [360] = {.lex_state = 142},
  [361] = {.lex_state = 142},
  [362] = {.lex_state = 142},
  [363] = {.lex_state = 142},
  [364] = {.lex_state = 143},
  [365] = {.lex_state = 142},
  [366] = {.lex_state = 142},
  [367] = {.lex_state = 142},
  [368] = {.lex_state = 142},
  [369] = {.lex_state = 142},
  [370] = {.lex_state = 142},
  [371] = {.lex_state = 142},
  [372] = {.lex_state = 142},
  [373] = {.lex_state = 142},
  [374] = {.lex_state = 142},
  [375] = {.lex_state = 142},
  [376] = {.lex_state = 142},
  [377] = {.lex_state = 142},
  [378] = {.lex_state = 142},
  [379] = {.lex_state = 142},
  [380] = {.lex_state = 142},
  [381] = {.lex_state = 142},
  [382] = {.lex_state = 142},
  [383] = {.lex_state = 142},
  [384] = {.lex_state = 142},
  [385] = {.lex_state = 142},
  [386] = {.lex_state = 142},
  [387] = {.lex_state = 142},
  [388] = {.lex_state = 142},
  [389] = {.lex_state = 142},
  [390] = {.lex_state = 142},
  [391] = {.lex_state = 143},
  [392] = {.lex_state = 142},
  [393] = {.lex_state = 142},
  [394] = {.lex_state = 142},
  [395] = {.lex_state = 142},
  [396] = {.lex_state = 142},
  [397] = {.lex_state = 142},
  [398] = {.lex_state = 142},
  [399] = {.lex_state = 142},
  [400] = {.lex_state = 142},
  [401] = {.lex_state = 142},
  [402] = {.lex_state = 143},
  [403] = {.lex_state = 142},
  [404] = {.lex_state = 143},
  [405] = {.lex_state = 142},
  [406] = {.lex_state = 142},
  [407] = {.lex_state = 142},
  [408] = {.lex_state = 142},
  [409] = {.lex_state = 142},
  [410] = {.lex_state = 143},
  [411] = {.lex_state = 143},
  [412] = {.lex_state = 143},
  [413] = {.lex_state = 142},
  [414] = {.lex_state = 142},
  [415] = {.lex_state = 142},
  [416] = {.lex_state = 142},
  [417] = {.lex_state = 142},
  [418] = {.lex_state = 143},
  [419] = {.lex_state = 143},
  [420] = {.lex_state = 143},
  [421] = {.lex_state = 143},
  [422] = {.lex_state = 142},
  [423] = {.lex_state = 142},
  [424] = {.lex_state = 142},
  [425] = {.lex_state = 142},
  [426] = {.lex_state = 142},
  [427] = {.lex_state = 142},
  [428] = {.lex_state = 143},
  [429] = {.lex_state = 143},
  [430] = {.lex_state = 142},
  [431] = {.lex_state = 143},
  [432] = {.lex_state = 142},
  [433] = {.lex_state = 143},
  [434] = {.lex_state = 143},
  [435] = {.lex_state = 143},
  [436] = {.lex_state = 143},
  [437] = {.lex_state = 142},
  [438] = {.lex_state = 143},
  [439] = {.lex_state = 143},
  [440] = {.lex_state = 142},
  [441] = {.lex_state = 143},
  [442] = {.lex_state = 142},
  [443] = {.lex_state = 142},
  [444] = {.lex_state = 143},
  [445] = {.lex_state = 142},
  [446] = {.lex_state = 142},
  [447] = {.lex_state = 142},
  [448] = {.lex_state = 142},
  [449] = {.lex_state = 142},
  [450] = {.lex_state = 142},
  [451] = {.lex_state = 142},
  [452] = {.lex_state = 142},
  [453] = {.lex_state = 142},
  [454] = {.lex_state = 142},
  [455] = {.lex_state = 142},
  [456] = {.lex_state = 142},
  [457] = {.lex_state = 142},
  [458] = {.lex_state = 142},
  [459] = {.lex_state = 142},
  [460] = {.lex_state = 142},
  [461] = {.lex_state = 143},
  [462] = {.lex_state = 142},
  [463] = {.lex_state = 143},
  [464] = {.lex_state = 143},
  [465] = {.lex_state = 143},
  [466] = {.lex_state = 143},
  [467] = {.lex_state = 142},
  [468] = {.lex_state = 143},
  [469] = {.lex_state = 142},
  [470] = {.lex_state = 142},
  [471] = {.lex_state = 142},
  [472] = {.lex_state = 142},
  [473] = {.lex_state = 142},
  [474] = {.lex_state = 142},
  [475] = {.lex_state = 142},
  [476] = {.lex_state = 142},
  [477] = {.lex_state = 142},
  [478] = {.lex_state = 142},
  [479] = {.lex_state = 142},
  [480] = {.lex_state = 142},
  [481] = {.lex_state = 142},
  [482] = {.lex_state = 142},
  [483] = {.lex_state = 142},
  [484] = {.lex_state = 142},
  [485] = {.lex_state = 142},
  [486] = {.lex_state = 142},
  [487] = {.lex_state = 142},
  [488] = {.lex_state = 142},
  [489] = {.lex_state = 142},
  [490] = {.lex_state = 142},
  [491] = {.lex_state = 142},
  [492] = {.lex_state = 142},
  [493] = {.lex_state = 143},
  [494] = {.lex_state = 142},
  [495] = {.lex_state = 142},
  [496] = {.lex_state = 142},
  [497] = {.lex_state = 142},
  [498] = {.lex_state = 142},
  [499] = {.lex_state = 142},
  [500] = {.lex_state = 142},
  [501] = {.lex_state = 142},
  [502] = {.lex_state = 143},
  [503] = {.lex_state = 142},
  [504] = {.lex_state = 142},
  [505] = {.lex_state = 142},
  [506] = {.lex_state = 142},
  [507] = {.lex_state = 142},
  [508] = {.lex_state = 142},
  [509] = {.lex_state = 144},
  [510] = {.lex_state = 144},
  [511] = {.lex_state = 144},
  [512] = {.lex_state = 144},
  [513] = {.lex_state = 144},
  [514] = {.lex_state = 144},
  [515] = {.lex_state = 144},
  [516] = {.lex_state = 144},
  [517] = {.lex_state = 144},
  [518] = {.lex_state = 144},
  [519] = {.lex_state = 144},
  [520] = {.lex_state = 144},
  [521] = {.lex_state = 142},
  [522] = {.lex_state = 144},
  [523] = {.lex_state = 144},
  [524] = {.lex_state = 144},
  [525] = {.lex_state = 144},
  [526] = {.lex_state = 144},
  [527] = {.lex_state = 144},
  [528] = {.lex_state = 142},
  [529] = {.lex_state = 142},
  [530] = {.lex_state = 142},
  [531] = {.lex_state = 142},
  [532] = {.lex_state = 142},
  [533] = {.lex_state = 142},
  [534] = {.lex_state = 142},
  [535] = {.lex_state = 142},
  [536] = {.lex_state = 142},
  [537] = {.lex_state = 142},
  [538] = {.lex_state = 142},
  [539] = {.lex_state = 142},
  [540] = {.lex_state = 142},
  [541] = {.lex_state = 142},
  [542] = {.lex_state = 142},
  [543] = {.lex_state = 142},
  [544] = {.lex_state = 142},
  [545] = {.lex_state = 142},
  [546] = {.lex_state = 148},
  [547] = {.lex_state = 148},
  [548] = {.lex_state = 148},
  [549] = {.lex_state = 148},
  [550] = {.lex_state = 150},
  [551] = {.lex_state = 148},
  [552] = {.lex_state = 150},
  [553] = {.lex_state = 150},
  [554] = {.lex_state = 148},
  [555] = {.lex_state = 151},
  [556] = {.lex_state = 152},
  [557] = {.lex_state = 151},
  [558] = {.lex_state = 151},
  [559] = {.lex_state = 164},
  [560] = {.lex_state = 151},
  [561] = {.lex_state = 151},
  [562] = {.lex_state = 151},
  [563] = {.lex_state = 151},
  [564] = {.lex_state = 151},
  [565] = {.lex_state = 151},
  [566] = {.lex_state = 151},
  [567] = {.lex_state = 151},
  [568] = {.lex_state = 151},
  [569] = {.lex_state = 152},
  [570] = {.lex_state = 151},
  [571] = {.lex_state = 151},
  [572] = {.lex_state = 151},
  [573] = {.lex_state = 151},
  [574] = {.lex_state = 151},
  [575] = {.lex_state = 151},
  [576] = {.lex_state = 151},
  [577] = {.lex_state = 151},
  [578] = {.lex_state = 151},
  [579] = {.lex_state = 151},
  [580] = {.lex_state = 151},
  [581] = {.lex_state = 151},
  [582] = {.lex_state = 151},
  [583] = {.lex_state = 151},
  [584] = {.lex_state = 151},
  [585] = {.lex_state = 151},
  [586] = {.lex_state = 151},
  [587] = {.lex_state = 151},
  [588] = {.lex_state = 151},
  [589] = {.lex_state = 164},
  [590] = {.lex_state = 151},
  [591] = {.lex_state = 151},
  [592] = {.lex_state = 164},
  [593] = {.lex_state = 164},
  [594] = {.lex_state = 164},
  [595] = {.lex_state = 151},
  [596] = {.lex_state = 151},
  [597] = {.lex_state = 151},
  [598] = {.lex_state = 151},
  [599] = {.lex_state = 164},
  [600] = {.lex_state = 164},
  [601] = {.lex_state = 151},
  [602] = {.lex_state = 151},
  [603] = {.lex_state = 164},
  [604] = {.lex_state = 164},
  [605] = {.lex_state = 151},
  [606] = {.lex_state = 151},
  [607] = {.lex_state = 164},
  [608] = {.lex_state = 151},
  [609] = {.lex_state = 151},
  [610] = {.lex_state = 164},
  [611] = {.lex_state = 151},
  [612] = {.lex_state = 151},
  [613] = {.lex_state = 164},
  [614] = {.lex_state = 151},
  [615] = {.lex_state = 164},
  [616] = {.lex_state = 151},
  [617] = {.lex_state = 164},
  [618] = {.lex_state = 151},
  [619] = {.lex_state = 151},
  [620] = {.lex_state = 151},
  [621] = {.lex_state = 151},
  [622] = {.lex_state = 151},
  [623] = {.lex_state = 164},
  [624] = {.lex_state = 151},
  [625] = {.lex_state = 151},
  [626] = {.lex_state = 151},
  [627] = {.lex_state = 164},
  [628] = {.lex_state = 151},
  [629] = {.lex_state = 151},
  [630] = {.lex_state = 164},
  [631] = {.lex_state = 151},
  [632] = {.lex_state = 151},
  [633] = {.lex_state = 151},
  [634] = {.lex_state = 164},
  [635] = {.lex_state = 151},
  [636] = {.lex_state = 164},
  [637] = {.lex_state = 151},
  [638] = {.lex_state = 174},
  [639] = {.lex_state = 174},
  [640] = {.lex_state = 174},
  [641] = {.lex_state = 172},
  [642] = {.lex_state = 150},
  [643] = {.lex_state = 174},
  [644] = {.lex_state = 150},
  [645] = {.lex_state = 172},
  [646] = {.lex_state = 150},
  [647] = {.lex_state = 150},
  [648] = {.lex_state = 150},
  [649] = {.lex_state = 150},
  [650] = {.lex_state = 150},
  [651] = {.lex_state = 171},
  [652] = {.lex_state = 171},
  [653] = {.lex_state = 150},
  [654] = {.lex_state = 171},
  [655] = {.lex_state = 173},
  [656] = {.lex_state = 172},
  [657] = {.lex_state = 174},
  [658] = {.lex_state = 150},
  [659] = {.lex_state = 150},
  [660] = {.lex_state = 173},
  [661] = {.lex_state = 150},
  [662] = {.lex_state = 150},
  [663] = {.lex_state = 150},
  [664] = {.lex_state = 150},
  [665] = {.lex_state = 171},
  [666] = {.lex_state = 173},
  [667] = {.lex_state = 172},
  [668] = {.lex_state = 174},
  [669] = {.lex_state = 172},
  [670] = {.lex_state = 151},
  [671] = {.lex_state = 151},
  [672] = {.lex_state = 172},
  [673] = {.lex_state = 151},
  [674] = {.lex_state = 151},
  [675] = {.lex_state = 171},
  [676] = {.lex_state = 150},
  [677] = {.lex_state = 174},
  [678] = {.lex_state = 151},
  [679] = {.lex_state = 150},
  [680] = {.lex_state = 172},
  [681] = {.lex_state = 150},
  [682] = {.lex_state = 173},
  [683] = {.lex_state = 151},
  [684] = {.lex_state = 172},
  [685] = {.lex_state = 150},
  [686] = {.lex_state = 174},
  [687] = {.lex_state = 174},
  [688] = {.lex_state = 171},
  [689] = {.lex_state = 172},
  [690] = {.lex_state = 151},
  [691] = {.lex_state = 171},
  [692] = {.lex_state = 150},
  [693] = {.lex_state = 150},
  [694] = {.lex_state = 174},
  [695] = {.lex_state = 150},
  [696] = {.lex_state = 173},
  [697] = {.lex_state = 150},
  [698] = {.lex_state = 150},
  [699] = {.lex_state = 173},
  [700] = {.lex_state = 174},
  [701] = {.lex_state = 150},
  [702] = {.lex_state = 150},
  [703] = {.lex_state = 150},
  [704] = {.lex_state = 172},
  [705] = {.lex_state = 171},
  [706] = {.lex_state = 171},
  [707] = {.lex_state = 150},
  [708] = {.lex_state = 171},
  [709] = {.lex_state = 171},
  [710] = {.lex_state = 150},
  [711] = {.lex_state = 171},
  [712] = {.lex_state = 171},
  [713] = {.lex_state = 171},
  [714] = {.lex_state = 150},
  [715] = {.lex_state = 171},
  [716] = {.lex_state = 171},
  [717] = {.lex_state = 150},
  [718] = {.lex_state = 150},
  [719] = {.lex_state = 171},
  [720] = {.lex_state = 171},
  [721] = {.lex_state = 150},
  [722] = {.lex_state = 150},
  [723] = {.lex_state = 150},
  [724] = {.lex_state = 150},
  [725] = {.lex_state = 171},
  [726] = {.lex_state = 151},
  [727] = {.lex_state = 150},
  [728] = {.lex_state = 171},
  [729] = {.lex_state = 150},
  [730] = {.lex_state = 171},
  [731] = {.lex_state = 150},
  [732] = {.lex_state = 150},
  [733] = {.lex_state = 150},
  [734] = {.lex_state = 171},
  [735] = {.lex_state = 150},
  [736] = {.lex_state = 150},
  [737] = {.lex_state = 148},
  [738] = {.lex_state = 171},
  [739] = {.lex_state = 171},
  [740] = {.lex_state = 171},
  [741] = {.lex_state = 171},
  [742] = {.lex_state = 171},
  [743] = {.lex_state = 171},
  [744] = {.lex_state = 171},
  [745] = {.lex_state = 171},
  [746] = {.lex_state = 171},
  [747] = {.lex_state = 171},
  [748] = {.lex_state = 171},
  [749] = {.lex_state = 171},
  [750] = {.lex_state = 171},
  [751] = {.lex_state = 171},
  [752] = {.lex_state = 171},
  [753] = {.lex_state = 171},
  [754] = {.lex_state = 171},
  [755] = {.lex_state = 171},
  [756] = {.lex_state = 150},
  [757] = {.lex_state = 151},
  [758] = {.lex_state = 150},
  [759] = {.lex_state = 148},
  [760] = {.lex_state = 171},
  [761] = {.lex_state = 148},
  [762] = {.lex_state = 171},
  [763] = {.lex_state = 171},
  [764] = {.lex_state = 171},
  [765] = {.lex_state = 171},
  [766] = {.lex_state = 151},
  [767] = {.lex_state = 171},
  [768] = {.lex_state = 171},
  [769] = {.lex_state = 148},
  [770] = {.lex_state = 171},
  [771] = {.lex_state = 171},
  [772] = {.lex_state = 151},
  [773] = {.lex_state = 148},
  [774] = {.lex_state = 151},
  [775] = {.lex_state = 171},
  [776] = {.lex_state = 171},
  [777] = {.lex_state = 171},
  [778] = {.lex_state = 171},
  [779] = {.lex_state = 171},
  [780] = {.lex_state = 171},
  [781] = {.lex_state = 171},
  [782] = {.lex_state = 171},
  [783] = {.lex_state = 171},
  [784] = {.lex_state = 171},
  [785] = {.lex_state = 171},
  [786] = {.lex_state = 171},
  [787] = {.lex_state = 171},
  [788] = {.lex_state = 171},
  [789] = {.lex_state = 171},
  [790] = {.lex_state = 171},
  [791] = {.lex_state = 148},
  [792] = {.lex_state = 171},
  [793] = {.lex_state = 153},
  [794] = {.lex_state = 153},
  [795] = {.lex_state = 154},
  [796] = {.lex_state = 153},
  [797] = {.lex_state = 153},
  [798] = {.lex_state = 153},
  [799] = {.lex_state = 153},
  [800] = {.lex_state = 153},
  [801] = {.lex_state = 148},
  [802] = {.lex_state = 153},
  [803] = {.lex_state = 153},
  [804] = {.lex_state = 150},
  [805] = {.lex_state = 153},
  [806] = {.lex_state = 153},
  [807] = {.lex_state = 150},
  [808] = {.lex_state = 150},
  [809] = {.lex_state = 153},
  [810] = {.lex_state = 150},
  [811] = {.lex_state = 153},
  [812] = {.lex_state = 148},
  [813] = {.lex_state = 150},
  [814] = {.lex_state = 150},
  [815] = {.lex_state = 150},
  [816] = {.lex_state = 153},
  [817] = {.lex_state = 150},
  [818] = {.lex_state = 153},
  [819] = {.lex_state = 148},
  [820] = {.lex_state = 150},
  [821] = {.lex_state = 150},
  [822] = {.lex_state = 148},
  [823] = {.lex_state = 151},
  [824] = {.lex_state = 151},
  [825] = {.lex_state = 151},
  [826] = {.lex_state = 155},
  [827] = {.lex_state = 148},
  [828] = {.lex_state = 155},
  [829] = {.lex_state = 155},
  [830] = {.lex_state = 155},
  [831] = {.lex_state = 156},
  [832] = {.lex_state = 151},
  [833] = {.lex_state = 156},
  [834] = {.lex_state = 148},
  [835] = {.lex_state = 151},
  [836] = {.lex_state = 151},
  [837] = {.lex_state = 156},
  [838] = {.lex_state = 151},
  [839] = {.lex_state = 151},
  [840] = {.lex_state = 156},
  [841] = {.lex_state = 157},
  [842] = {.lex_state = 157},
  [843] = {.lex_state = 150},
  [844] = {.lex_state = 150},
  [845] = {.lex_state = 150},
  [846] = {.lex_state = 150},
  [847] = {.lex_state = 151},
  [848] = {.lex_state = 150},
  [849] = {.lex_state = 151},
  [850] = {.lex_state = 151},
  [851] = {.lex_state = 150},
  [852] = {.lex_state = 150},
  [853] = {.lex_state = 150},
  [854] = {.lex_state = 150},
  [855] = {.lex_state = 151},
  [856] = {.lex_state = 164},
  [857] = {.lex_state = 151},
  [858] = {.lex_state = 151},
  [859] = {.lex_state = 151},
  [860] = {.lex_state = 150},
  [861] = {.lex_state = 151},
  [862] = {.lex_state = 164},
  [863] = {.lex_state = 153},
  [864] = {.lex_state = 153},
  [865] = {.lex_state = 150},
  [866] = {.lex_state = 153},
  [867] = {.lex_state = 164},
  [868] = {.lex_state = 164},
  [869] = {.lex_state = 164},
  [870] = {.lex_state = 164},
  [871] = {.lex_state = 164},
  [872] = {.lex_state = 150},
  [873] = {.lex_state = 164},
  [874] = {.lex_state = 153},
  [875] = {.lex_state = 164},
  [876] = {.lex_state = 164},
  [877] = {.lex_state = 164},
  [878] = {.lex_state = 150},
  [879] = {.lex_state = 150},
  [880] = {.lex_state = 153},
  [881] = {.lex_state = 150},
  [882] = {.lex_state = 153},
  [883] = {.lex_state = 164},
  [884] = {.lex_state = 153},
  [885] = {.lex_state = 153},
  [886] = {.lex_state = 151},
  [887] = {.lex_state = 164},
  [888] = {.lex_state = 153},
  [889] = {.lex_state = 164},
  [890] = {.lex_state = 164},
  [891] = {.lex_state = 164},
  [892] = {.lex_state = 153},
  [893] = {.lex_state = 153},
  [894] = {.lex_state = 164},
  [895] = {.lex_state = 164},
  [896] = {.lex_state = 164},
  [897] = {.lex_state = 151},
  [898] = {.lex_state = 153},
  [899] = {.lex_state = 150},
  [900] = {.lex_state = 150},
  [901] = {.lex_state = 150},
  [902] = {.lex_state = 153},
  [903] = {.lex_state = 164},
  [904] = {.lex_state = 164},
  [905] = {.lex_state = 164},
  [906] = {.lex_state = 153},
  [907] = {.lex_state = 151},
  [908] = {.lex_state = 153},
  [909] = {.lex_state = 153},
  [910] = {.lex_state = 150},
  [911] = {.lex_state = 164},
  [912] = {.lex_state = 150},
  [913] = {.lex_state = 150},
  [914] = {.lex_state = 164},
  [915] = {.lex_state = 150},
  [916] = {.lex_state = 153},
  [917] = {.lex_state = 153},
  [918] = {.lex_state = 153},
  [919] = {.lex_state = 150},
  [920] = {.lex_state = 164},
  [921] = {.lex_state = 153},
  [922] = {.lex_state = 153},
  [923] = {.lex_state = 150},
  [924] = {.lex_state = 151},
  [925] = {.lex_state = 153},
  [926] = {.lex_state = 153},
  [927] = {.lex_state = 150},
  [928] = {.lex_state = 164},
  [929] = {.lex_state = 153},
  [930] = {.lex_state = 151},
  [931] = {.lex_state = 164},
  [932] = {.lex_state = 153},
  [933] = {.lex_state = 164},
  [934] = {.lex_state = 153},
  [935] = {.lex_state = 164},
  [936] = {.lex_state = 150},
  [937] = {.lex_state = 150},
  [938] = {.lex_state = 150},
  [939] = {.lex_state = 150},
  [940] = {.lex_state = 164},
  [941] = {.lex_state = 150},
  [942] = {.lex_state = 164},
  [943] = {.lex_state = 164},
  [944] = {.lex_state = 150},
  [945] = {.lex_state = 153},
  [946] = {.lex_state = 153},
  [947] = {.lex_state = 150},
  [948] = {.lex_state = 153},
  [949] = {.lex_state = 153},
  [950] = {.lex_state = 164},
  [951] = {.lex_state = 153},
  [952] = {.lex_state = 164},
  [953] = {.lex_state = 164},
  [954] = {.lex_state = 150},
  [955] = {.lex_state = 153},
  [956] = {.lex_state = 164},
  [957] = {.lex_state = 164},
  [958] = {.lex_state = 164},
  [959] = {.lex_state = 164},
  [960] = {.lex_state = 164},
  [961] = {.lex_state = 164},
  [962] = {.lex_state = 164},
  [963] = {.lex_state = 164},
  [964] = {.lex_state = 164},
  [965] = {.lex_state = 164},
  [966] = {.lex_state = 164},
  [967] = {.lex_state = 150},
  [968] = {.lex_state = 164},
  [969] = {.lex_state = 164},
  [970] = {.lex_state = 150},
  [971] = {.lex_state = 164},
  [972] = {.lex_state = 164},
  [973] = {.lex_state = 153},
  [974] = {.lex_state = 153},
  [975] = {.lex_state = 150},
  [976] = {.lex_state = 153},
  [977] = {.lex_state = 153},
  [978] = {.lex_state = 150},
  [979] = {.lex_state = 150},
  [980] = {.lex_state = 153},
  [981] = {.lex_state = 150},
  [982] = {.lex_state = 153},
  [983] = {.lex_state = 153},
  [984] = {.lex_state = 164},
  [985] = {.lex_state = 150},
  [986] = {.lex_state = 153},
  [987] = {.lex_state = 153},
  [988] = {.lex_state = 164},
  [989] = {.lex_state = 153},
  [990] = {.lex_state = 153},
  [991] = {.lex_state = 150},
  [992] = {.lex_state = 150},
  [993] = {.lex_state = 164},
  [994] = {.lex_state = 164},
  [995] = {.lex_state = 150},
  [996] = {.lex_state = 150},
  [997] = {.lex_state = 150},
  [998] = {.lex_state = 150},
  [999] = {.lex_state = 164},
  [1000] = {.lex_state = 150},
  [1001] = {.lex_state = 150},
  [1002] = {.lex_state = 150},
  [1003] = {.lex_state = 150},
  [1004] = {.lex_state = 164},
  [1005] = {.lex_state = 153},
  [1006] = {.lex_state = 150},
  [1007] = {.lex_state = 150},
  [1008] = {.lex_state = 150},
  [1009] = {.lex_state = 150},
  [1010] = {.lex_state = 150},
  [1011] = {.lex_state = 164},
  [1012] = {.lex_state = 153},
  [1013] = {.lex_state = 153},
  [1014] = {.lex_state = 164},
  [1015] = {.lex_state = 143},
  [1016] = {.lex_state = 150},
  [1017] = {.lex_state = 150},
  [1018] = {.lex_state = 150},
  [1019] = {.lex_state = 150},
  [1020] = {.lex_state = 164},
  [1021] = {.lex_state = 164},
  [1022] = {.lex_state = 150},
  [1023] = {.lex_state = 164},
  [1024] = {.lex_state = 150},
  [1025] = {.lex_state = 153},
  [1026] = {.lex_state = 164},
  [1027] = {.lex_state = 153},
  [1028] = {.lex_state = 153},
  [1029] = {.lex_state = 153},
  [1030] = {.lex_state = 150},
  [1031] = {.lex_state = 144},
  [1032] = {.lex_state = 153},
  [1033] = {.lex_state = 153},
  [1034] = {.lex_state = 153},
  [1035] = {.lex_state = 153},
  [1036] = {.lex_state = 153},
  [1037] = {.lex_state = 153},
  [1038] = {.lex_state = 150},
  [1039] = {.lex_state = 150},
  [1040] = {.lex_state = 150},
  [1041] = {.lex_state = 150},
  [1042] = {.lex_state = 164},
  [1043] = {.lex_state = 150},
  [1044] = {.lex_state = 150},
  [1045] = {.lex_state = 150},
  [1046] = {.lex_state = 150},
  [1047] = {.lex_state = 150},
  [1048] = {.lex_state = 150},
  [1049] = {.lex_state = 150},
  [1050] = {.lex_state = 150},
  [1051] = {.lex_state = 150},
  [1052] = {.lex_state = 150},
  [1053] = {.lex_state = 150},
  [1054] = {.lex_state = 150},
  [1055] = {.lex_state = 150},
  [1056] = {.lex_state = 150},
  [1057] = {.lex_state = 150},
  [1058] = {.lex_state = 150},
  [1059] = {.lex_state = 150},
  [1060] = {.lex_state = 164},
  [1061] = {.lex_state = 164},
  [1062] = {.lex_state = 164},
  [1063] = {.lex_state = 150},
  [1064] = {.lex_state = 150},
  [1065] = {.lex_state = 150},
  [1066] = {.lex_state = 150},
  [1067] = {.lex_state = 164},
  [1068] = {.lex_state = 164},
  [1069] = {.lex_state = 164},
  [1070] = {.lex_state = 150},
  [1071] = {.lex_state = 150},
  [1072] = {.lex_state = 150},
  [1073] = {.lex_state = 150},
  [1074] = {.lex_state = 150},
  [1075] = {.lex_state = 158},
  [1076] = {.lex_state = 164},
  [1077] = {.lex_state = 159},
  [1078] = {.lex_state = 164},
  [1079] = {.lex_state = 164},
  [1080] = {.lex_state = 164},
  [1081] = {.lex_state = 148},
  [1082] = {.lex_state = 148},
  [1083] = {.lex_state = 148},
  [1084] = {.lex_state = 160},
  [1085] = {.lex_state = 160},
  [1086] = {.lex_state = 160},
  [1087] = {.lex_state = 158},
  [1088] = {.lex_state = 160},
  [1089] = {.lex_state = 160},
  [1090] = {.lex_state = 160},
  [1091] = {.lex_state = 160},
  [1092] = {.lex_state = 160},
  [1093] = {.lex_state = 158},
  [1094] = {.lex_state = 160},
  [1095] = {.lex_state = 160},
  [1096] = {.lex_state = 160},
  [1097] = {.lex_state = 158},
  [1098] = {.lex_state = 160},
  [1099] = {.lex_state = 160},
  [1100] = {.lex_state = 160},
  [1101] = {.lex_state = 160},
  [1102] = {.lex_state = 160},
  [1103] = {.lex_state = 158},
  [1104] = {.lex_state = 160},
  [1105] = {.lex_state = 160},
  [1106] = {.lex_state = 160},
  [1107] = {.lex_state = 160},
  [1108] = {.lex_state = 160},
  [1109] = {.lex_state = 160},
  [1110] = {.lex_state = 160},
  [1111] = {.lex_state = 160},
  [1112] = {.lex_state = 160},
  [1113] = {.lex_state = 159},
  [1114] = {.lex_state = 160},
  [1115] = {.lex_state = 160},
  [1116] = {.lex_state = 160},
  [1117] = {.lex_state = 160},
  [1118] = {.lex_state = 160},
  [1119] = {.lex_state = 160},
  [1120] = {.lex_state = 160},
  [1121] = {.lex_state = 160},
  [1122] = {.lex_state = 160},
  [1123] = {.lex_state = 160},
  [1124] = {.lex_state = 160},
  [1125] = {.lex_state = 160},
  [1126] = {.lex_state = 160},
  [1127] = {.lex_state = 160},
  [1128] = {.lex_state = 160},
  [1129] = {.lex_state = 160},
  [1130] = {.lex_state = 160},
  [1131] = {.lex_state = 158},
  [1132] = {.lex_state = 160},
  [1133] = {.lex_state = 158},
  [1134] = {.lex_state = 160},
  [1135] = {.lex_state = 160},
  [1136] = {.lex_state = 160},
  [1137] = {.lex_state = 160},
  [1138] = {.lex_state = 160},
  [1139] = {.lex_state = 160},
  [1140] = {.lex_state = 158},
  [1141] = {.lex_state = 160},
  [1142] = {.lex_state = 160},
  [1143] = {.lex_state = 160},
  [1144] = {.lex_state = 158},
  [1145] = {.lex_state = 160},
  [1146] = {.lex_state = 158},
  [1147] = {.lex_state = 160},
  [1148] = {.lex_state = 160},
  [1149] = {.lex_state = 160},
  [1150] = {.lex_state = 160},
  [1151] = {.lex_state = 158},
  [1152] = {.lex_state = 160},
  [1153] = {.lex_state = 158},
  [1154] = {.lex_state = 158},
  [1155] = {.lex_state = 160},
  [1156] = {.lex_state = 160},
  [1157] = {.lex_state = 158},
  [1158] = {.lex_state = 160},
  [1159] = {.lex_state = 158},
  [1160] = {.lex_state = 158},
  [1161] = {.lex_state = 160},
  [1162] = {.lex_state = 160},
  [1163] = {.lex_state = 158},
  [1164] = {.lex_state = 159},
  [1165] = {.lex_state = 160},
  [1166] = {.lex_state = 159},
  [1167] = {.lex_state = 158},
  [1168] = {.lex_state = 159},
  [1169] = {.lex_state = 159},
  [1170] = {.lex_state = 148},
  [1171] = {.lex_state = 159},
  [1172] = {.lex_state = 159},
  [1173] = {.lex_state = 160},
  [1174] = {.lex_state = 159},
  [1175] = {.lex_state = 148},
  [1176] = {.lex_state = 159},
  [1177] = {.lex_state = 160},
  [1178] = {.lex_state = 159},
  [1179] = {.lex_state = 159},
  [1180] = {.lex_state = 159},
  [1181] = {.lex_state = 159},
  [1182] = {.lex_state = 159},
  [1183] = {.lex_state = 159},
  [1184] = {.lex_state = 159},
  [1185] = {.lex_state = 160},
  [1186] = {.lex_state = 159},
  [1187] = {.lex_state = 159},
  [1188] = {.lex_state = 159},
  [1189] = {.lex_state = 159},
  [1190] = {.lex_state = 159},
  [1191] = {.lex_state = 159},
  [1192] = {.lex_state = 159},
  [1193] = {.lex_state = 159},
  [1194] = {.lex_state = 159},
  [1195] = {.lex_state = 148},
  [1196] = {.lex_state = 159},
  [1197] = {.lex_state = 159},
  [1198] = {.lex_state = 159},
  [1199] = {.lex_state = 159},
  [1200] = {.lex_state = 164},
  [1201] = {.lex_state = 148},
  [1202] = {.lex_state = 164},
  [1203] = {.lex_state = 148},
  [1204] = {.lex_state = 148},
  [1205] = {.lex_state = 161},
  [1206] = {.lex_state = 148},
  [1207] = {.lex_state = 158},
  [1208] = {.lex_state = 161},
  [1209] = {.lex_state = 158},
  [1210] = {.lex_state = 159},
  [1211] = {.lex_state = 158},
  [1212] = {.lex_state = 158},
  [1213] = {.lex_state = 164},
  [1214] = {.lex_state = 164},
  [1215] = {.lex_state = 158},
  [1216] = {.lex_state = 148},
  [1217] = {.lex_state = 161},
  [1218] = {.lex_state = 164},
  [1219] = {.lex_state = 158},
  [1220] = {.lex_state = 161},
  [1221] = {.lex_state = 161},
  [1222] = {.lex_state = 158},
  [1223] = {.lex_state = 161},
  [1224] = {.lex_state = 164},
  [1225] = {.lex_state = 148},
  [1226] = {.lex_state = 148},
  [1227] = {.lex_state = 148},
  [1228] = {.lex_state = 148},
  [1229] = {.lex_state = 161},
  [1230] = {.lex_state = 148},
  [1231] = {.lex_state = 148},
  [1232] = {.lex_state = 162},
  [1233] = {.lex_state = 158},
  [1234] = {.lex_state = 148},
  [1235] = {.lex_state = 148},
  [1236] = {.lex_state = 148},
  [1237] = {.lex_state = 162},
  [1238] = {.lex_state = 148},
  [1239] = {.lex_state = 148},
  [1240] = {.lex_state = 148},
  [1241] = {.lex_state = 158},
  [1242] = {.lex_state = 162},
  [1243] = {.lex_state = 159},
  [1244] = {.lex_state = 159},
  [1245] = {.lex_state = 148},
  [1246] = {.lex_state = 148},
  [1247] = {.lex_state = 148},
  [1248] = {.lex_state = 148},
  [1249] = {.lex_state = 148},
  [1250] = {.lex_state = 148},
  [1251] = {.lex_state = 148},
  [1252] = {.lex_state = 148},
  [1253] = {.lex_state = 148},
  [1254] = {.lex_state = 148},
  [1255] = {.lex_state = 148},
  [1256] = {.lex_state = 148},
  [1257] = {.lex_state = 148},
  [1258] = {.lex_state = 159},
  [1259] = {.lex_state = 148},
  [1260] = {.lex_state = 148},
  [1261] = {.lex_state = 148},
  [1262] = {.lex_state = 148},
  [1263] = {.lex_state = 159},
  [1264] = {.lex_state = 148},
  [1265] = {.lex_state = 158},
  [1266] = {.lex_state = 148},
  [1267] = {.lex_state = 161},
  [1268] = {.lex_state = 159},
  [1269] = {.lex_state = 159},
  [1270] = {.lex_state = 161},
  [1271] = {.lex_state = 159},
  [1272] = {.lex_state = 159},
  [1273] = {.lex_state = 161},
  [1274] = {.lex_state = 0},
  [1275] = {.lex_state = 163},
  [1276] = {.lex_state = 161},
  [1277] = {.lex_state = 0},
  [1278] = {.lex_state = 163},
  [1279] = {.lex_state = 0},
  [1280] = {.lex_state = 0},
  [1281] = {.lex_state = 163},
  [1282] = {.lex_state = 0},
  [1283] = {.lex_state = 0},
  [1284] = {.lex_state = 159},
  [1285] = {.lex_state = 163},
  [1286] = {.lex_state = 0},
  [1287] = {.lex_state = 0},
  [1288] = {.lex_state = 163},
  [1289] = {.lex_state = 163},
  [1290] = {.lex_state = 163},
  [1291] = {.lex_state = 148},
  [1292] = {.lex_state = 148, .external_lex_state = 1},
  [1293] = {.lex_state = 148, .external_lex_state = 1},
  [1294] = {.lex_state = 148, .external_lex_state = 1},
  [1295] = {.lex_state = 148, .external_lex_state = 1},
  [1296] = {.lex_state = 159},
  [1297] = {.lex_state = 162},
  [1298] = {.lex_state = 148, .external_lex_state = 1},
  [1299] = {.lex_state = 148, .external_lex_state = 1},
  [1300] = {.lex_state = 148, .external_lex_state = 1},
  [1301] = {.lex_state = 148},
  [1302] = {.lex_state = 162},
  [1303] = {.lex_state = 148},
  [1304] = {.lex_state = 162},
  [1305] = {.lex_state = 162},
  [1306] = {.lex_state = 162},
  [1307] = {.lex_state = 148},
  [1308] = {.lex_state = 148},
  [1309] = {.lex_state = 162},
  [1310] = {.lex_state = 162},
  [1311] = {.lex_state = 148},
  [1312] = {.lex_state = 148},
  [1313] = {.lex_state = 148, .external_lex_state = 1},
  [1314] = {.lex_state = 162},
  [1315] = {.lex_state = 162},
  [1316] = {.lex_state = 162},
  [1317] = {.lex_state = 148},
  [1318] = {.lex_state = 148, .external_lex_state = 1},
  [1319] = {.lex_state = 148, .external_lex_state = 1},
  [1320] = {.lex_state = 148, .external_lex_state = 1},
  [1321] = {.lex_state = 148, .external_lex_state = 1},
  [1322] = {.lex_state = 0},
  [1323] = {.lex_state = 148, .external_lex_state = 1},
  [1324] = {.lex_state = 148},
  [1325] = {.lex_state = 148, .external_lex_state = 1},
  [1326] = {.lex_state = 162},
  [1327] = {.lex_state = 162},
  [1328] = {.lex_state = 148},
  [1329] = {.lex_state = 148, .external_lex_state = 1},
  [1330] = {.lex_state = 148, .external_lex_state = 1},
  [1331] = {.lex_state = 148, .external_lex_state = 1},
  [1332] = {.lex_state = 0},
  [1333] = {.lex_state = 172},
  [1334] = {.lex_state = 148},
  [1335] = {.lex_state = 161},
  [1336] = {.lex_state = 0},
  [1337] = {.lex_state = 0},
  [1338] = {.lex_state = 148},
  [1339] = {.lex_state = 0},
  [1340] = {.lex_state = 161},
  [1341] = {.lex_state = 0},
  [1342] = {.lex_state = 159},
  [1343] = {.lex_state = 148},
  [1344] = {.lex_state = 0},
  [1345] = {.lex_state = 159},
  [1346] = {.lex_state = 0},
  [1347] = {.lex_state = 148},
  [1348] = {.lex_state = 159},
  [1349] = {.lex_state = 0},
  [1350] = {.lex_state = 158},
  [1351] = {.lex_state = 148},
  [1352] = {.lex_state = 148},
  [1353] = {.lex_state = 0},
  [1354] = {.lex_state = 0},
  [1355] = {.lex_state = 161},
  [1356] = {.lex_state = 148, .external_lex_state = 1},
  [1357] = {.lex_state = 162},
  [1358] = {.lex_state = 0},
  [1359] = {.lex_state = 159},
  [1360] = {.lex_state = 159},
  [1361] = {.lex_state = 162},
  [1362] = {.lex_state = 148},
  [1363] = {.lex_state = 162},
  [1364] = {.lex_state = 148},
  [1365] = {.lex_state = 162},
  [1366] = {.lex_state = 148},
  [1367] = {.lex_state = 162},
  [1368] = {.lex_state = 161},
  [1369] = {.lex_state = 161},
  [1370] = {.lex_state = 148},
  [1371] = {.lex_state = 162},
  [1372] = {.lex_state = 162},
  [1373] = {.lex_state = 161},
  [1374] = {.lex_state = 162},
  [1375] = {.lex_state = 0},
  [1376] = {.lex_state = 148},
  [1377] = {.lex_state = 0},
  [1378] = {.lex_state = 162},
  [1379] = {.lex_state = 148},
  [1380] = {.lex_state = 0},
  [1381] = {.lex_state = 148},
  [1382] = {.lex_state = 172},
  [1383] = {.lex_state = 148},
  [1384] = {.lex_state = 148},
  [1385] = {.lex_state = 148},
  [1386] = {.lex_state = 162},
  [1387] = {.lex_state = 161},
  [1388] = {.lex_state = 0},
  [1389] = {.lex_state = 0},
  [1390] = {.lex_state = 0},
  [1391] = {.lex_state = 162},
  [1392] = {.lex_state = 162},
  [1393] = {.lex_state = 148},
  [1394] = {.lex_state = 0},
  [1395] = {.lex_state = 148},
  [1396] = {.lex_state = 148},
  [1397] = {.lex_state = 0},
  [1398] = {.lex_state = 148},
  [1399] = {.lex_state = 0},
  [1400] = {.lex_state = 0},
  [1401] = {.lex_state = 172},
  [1402] = {.lex_state = 0},
  [1403] = {.lex_state = 159},
  [1404] = {.lex_state = 0},
  [1405] = {.lex_state = 0},
  [1406] = {.lex_state = 148},
  [1407] = {.lex_state = 162},
  [1408] = {.lex_state = 0},
  [1409] = {.lex_state = 0},
  [1410] = {.lex_state = 172},
  [1411] = {.lex_state = 0},
  [1412] = {.lex_state = 0},
  [1413] = {.lex_state = 0},
  [1414] = {.lex_state = 172},
  [1415] = {.lex_state = 0},
  [1416] = {.lex_state = 0},
  [1417] = {.lex_state = 0},
  [1418] = {.lex_state = 0},
  [1419] = {.lex_state = 0},
  [1420] = {.lex_state = 0},
  [1421] = {.lex_state = 162},
  [1422] = {.lex_state = 0},
  [1423] = {.lex_state = 0},
  [1424] = {.lex_state = 0},
  [1425] = {.lex_state = 0},
  [1426] = {.lex_state = 0},
  [1427] = {.lex_state = 0},
  [1428] = {.lex_state = 0},
  [1429] = {.lex_state = 0},
  [1430] = {.lex_state = 0},
  [1431] = {.lex_state = 0},
  [1432] = {.lex_state = 159},
  [1433] = {.lex_state = 172},
  [1434] = {.lex_state = 0},
  [1435] = {.lex_state = 172},
  [1436] = {.lex_state = 0},
  [1437] = {.lex_state = 0},
  [1438] = {.lex_state = 0},
  [1439] = {.lex_state = 0},
  [1440] = {.lex_state = 0},
  [1441] = {.lex_state = 0},
  [1442] = {.lex_state = 0},
  [1443] = {.lex_state = 148},
  [1444] = {.lex_state = 0},
  [1445] = {.lex_state = 0},
  [1446] = {.lex_state = 148},
  [1447] = {.lex_state = 0},
  [1448] = {.lex_state = 148},
  [1449] = {.lex_state = 0},
  [1450] = {.lex_state = 162},
  [1451] = {.lex_state = 148},
  [1452] = {.lex_state = 0},
  [1453] = {.lex_state = 0},
  [1454] = {.lex_state = 172},
  [1455] = {.lex_state = 172},
  [1456] = {.lex_state = 0},
  [1457] = {.lex_state = 0},
  [1458] = {.lex_state = 172},
  [1459] = {.lex_state = 0},
  [1460] = {.lex_state = 0},
  [1461] = {.lex_state = 0},
  [1462] = {.lex_state = 0},
  [1463] = {.lex_state = 0},
  [1464] = {.lex_state = 172},
  [1465] = {.lex_state = 0},
  [1466] = {.lex_state = 0},
  [1467] = {.lex_state = 162},
  [1468] = {.lex_state = 0},
  [1469] = {.lex_state = 162},
  [1470] = {.lex_state = 0},
  [1471] = {.lex_state = 148},
  [1472] = {.lex_state = 172},
  [1473] = {.lex_state = 0},
  [1474] = {.lex_state = 0},
  [1475] = {.lex_state = 0},
  [1476] = {.lex_state = 0},
  [1477] = {.lex_state = 0},
  [1478] = {.lex_state = 0},
  [1479] = {.lex_state = 0},
  [1480] = {.lex_state = 0},
  [1481] = {.lex_state = 0},
  [1482] = {.lex_state = 0},
  [1483] = {.lex_state = 0},
  [1484] = {.lex_state = 148},
  [1485] = {.lex_state = 0},
  [1486] = {.lex_state = 0},
  [1487] = {.lex_state = 0},
  [1488] = {.lex_state = 162},
  [1489] = {.lex_state = 0},
  [1490] = {.lex_state = 0},
  [1491] = {.lex_state = 0},
  [1492] = {.lex_state = 172},
  [1493] = {.lex_state = 172},
  [1494] = {.lex_state = 0},
  [1495] = {.lex_state = 0},
  [1496] = {.lex_state = 0},
  [1497] = {.lex_state = 0},
  [1498] = {.lex_state = 0},
  [1499] = {.lex_state = 0},
  [1500] = {.lex_state = 0},
  [1501] = {.lex_state = 0},
  [1502] = {.lex_state = 0},
  [1503] = {.lex_state = 0},
  [1504] = {.lex_state = 0},
  [1505] = {.lex_state = 171},
  [1506] = {.lex_state = 0},
  [1507] = {.lex_state = 0},
  [1508] = {.lex_state = 0},
  [1509] = {.lex_state = 0},
  [1510] = {.lex_state = 0},
  [1511] = {.lex_state = 164},
  [1512] = {.lex_state = 0},
  [1513] = {.lex_state = 171},
  [1514] = {.lex_state = 172},
  [1515] = {.lex_state = 0},
  [1516] = {.lex_state = 0},
  [1517] = {.lex_state = 0},
  [1518] = {.lex_state = 0},
  [1519] = {.lex_state = 0},
  [1520] = {.lex_state = 148},
  [1521] = {.lex_state = 0},
  [1522] = {.lex_state = 0},
  [1523] = {.lex_state = 0},
  [1524] = {.lex_state = 0},
  [1525] = {.lex_state = 0},
  [1526] = {.lex_state = 162},
  [1527] = {.lex_state = 172},
  [1528] = {.lex_state = 0},
  [1529] = {.lex_state = 0},
  [1530] = {.lex_state = 0},
  [1531] = {.lex_state = 0},
  [1532] = {.lex_state = 0},
  [1533] = {.lex_state = 0},
  [1534] = {.lex_state = 172},
  [1535] = {.lex_state = 148},
  [1536] = {.lex_state = 0},
  [1537] = {.lex_state = 0},
  [1538] = {.lex_state = 0},
  [1539] = {.lex_state = 172},
  [1540] = {.lex_state = 0},
  [1541] = {.lex_state = 0},
  [1542] = {.lex_state = 0},
  [1543] = {.lex_state = 0},
  [1544] = {.lex_state = 0},
  [1545] = {.lex_state = 0},
  [1546] = {.lex_state = 172},
  [1547] = {.lex_state = 0},
  [1548] = {.lex_state = 0},
  [1549] = {.lex_state = 0},
  [1550] = {.lex_state = 171},
  [1551] = {.lex_state = 0},
  [1552] = {.lex_state = 172},
  [1553] = {.lex_state = 0},
  [1554] = {.lex_state = 0},
  [1555] = {.lex_state = 0},
  [1556] = {.lex_state = 0},
  [1557] = {.lex_state = 0},
  [1558] = {.lex_state = 0},
  [1559] = {.lex_state = 171},
  [1560] = {.lex_state = 0},
  [1561] = {.lex_state = 148},
  [1562] = {.lex_state = 172},
  [1563] = {.lex_state = 0},
  [1564] = {.lex_state = 0},
  [1565] = {.lex_state = 0},
  [1566] = {.lex_state = 0},
  [1567] = {.lex_state = 0},
  [1568] = {.lex_state = 0},
  [1569] = {.lex_state = 0},
  [1570] = {.lex_state = 0},
  [1571] = {.lex_state = 0},
  [1572] = {.lex_state = 0},
  [1573] = {.lex_state = 0},
  [1574] = {.lex_state = 0},
  [1575] = {.lex_state = 0},
  [1576] = {.lex_state = 0},
  [1577] = {.lex_state = 0},
  [1578] = {.lex_state = 0},
  [1579] = {.lex_state = 0},
  [1580] = {.lex_state = 0},
  [1581] = {.lex_state = 0},
  [1582] = {.lex_state = 0},
  [1583] = {.lex_state = 0},
  [1584] = {.lex_state = 0},
  [1585] = {.lex_state = 0},
  [1586] = {.lex_state = 0},
  [1587] = {.lex_state = 0},
  [1588] = {.lex_state = 148},
  [1589] = {.lex_state = 148},
  [1590] = {.lex_state = 0},
  [1591] = {.lex_state = 0},
  [1592] = {.lex_state = 0},
  [1593] = {.lex_state = 0},
  [1594] = {.lex_state = 162},
  [1595] = {.lex_state = 0},
  [1596] = {.lex_state = 148},
  [1597] = {.lex_state = 172},
  [1598] = {.lex_state = 172},
  [1599] = {.lex_state = 0},
  [1600] = {.lex_state = 0},
  [1601] = {.lex_state = 0},
  [1602] = {.lex_state = 172},
  [1603] = {.lex_state = 172},
  [1604] = {.lex_state = 0},
  [1605] = {.lex_state = 171},
  [1606] = {.lex_state = 172},
  [1607] = {.lex_state = 0},
  [1608] = {.lex_state = 0},
  [1609] = {.lex_state = 162},
  [1610] = {.lex_state = 0},
  [1611] = {.lex_state = 0},
  [1612] = {.lex_state = 162},
  [1613] = {.lex_state = 0},
  [1614] = {.lex_state = 0},
  [1615] = {.lex_state = 162},
  [1616] = {.lex_state = 162},
  [1617] = {.lex_state = 162},
  [1618] = {.lex_state = 162},
  [1619] = {.lex_state = 0},
  [1620] = {.lex_state = 172},
  [1621] = {.lex_state = 0},
  [1622] = {.lex_state = 0},
  [1623] = {.lex_state = 0},
  [1624] = {.lex_state = 0},
  [1625] = {.lex_state = 162},
  [1626] = {.lex_state = 0},
  [1627] = {.lex_state = 0},
  [1628] = {.lex_state = 0},
  [1629] = {.lex_state = 162},
  [1630] = {.lex_state = 0},
  [1631] = {.lex_state = 0},
  [1632] = {.lex_state = 0},
  [1633] = {.lex_state = 0},
  [1634] = {.lex_state = 148},
  [1635] = {.lex_state = 148},
  [1636] = {.lex_state = 0},
  [1637] = {.lex_state = 0},
  [1638] = {.lex_state = 0},
  [1639] = {.lex_state = 0},
  [1640] = {.lex_state = 0},
  [1641] = {.lex_state = 0},
  [1642] = {.lex_state = 0},
  [1643] = {.lex_state = 162},
  [1644] = {.lex_state = 0},
  [1645] = {.lex_state = 0},
  [1646] = {.lex_state = 162},
  [1647] = {.lex_state = 0},
  [1648] = {.lex_state = 0},
  [1649] = {.lex_state = 171},
  [1650] = {.lex_state = 0},
  [1651] = {.lex_state = 0},
  [1652] = {.lex_state = 0},
  [1653] = {.lex_state = 0},
  [1654] = {.lex_state = 0},
  [1655] = {.lex_state = 162},
  [1656] = {.lex_state = 0},
  [1657] = {.lex_state = 171},
  [1658] = {.lex_state = 171},
  [1659] = {.lex_state = 0},
  [1660] = {.lex_state = 0},
  [1661] = {.lex_state = 162},
  [1662] = {.lex_state = 171},
  [1663] = {.lex_state = 0},
  [1664] = {.lex_state = 171},
  [1665] = {.lex_state = 162},
  [1666] = {.lex_state = 172},
  [1667] = {.lex_state = 0},
  [1668] = {.lex_state = 0},
  [1669] = {.lex_state = 0},
  [1670] = {.lex_state = 0},
  [1671] = {.lex_state = 172},
  [1672] = {.lex_state = 0},
  [1673] = {.lex_state = 0},
  [1674] = {.lex_state = 148},
  [1675] = {.lex_state = 162},
  [1676] = {.lex_state = 0},
  [1677] = {.lex_state = 0},
  [1678] = {.lex_state = 0},
  [1679] = {.lex_state = 171},
  [1680] = {.lex_state = 0},
  [1681] = {.lex_state = 0},
  [1682] = {.lex_state = 0},
  [1683] = {.lex_state = 0},
  [1684] = {.lex_state = 0},
  [1685] = {.lex_state = 162},
  [1686] = {.lex_state = 162},
  [1687] = {.lex_state = 171},
  [1688] = {.lex_state = 0},
  [1689] = {.lex_state = 0},
  [1690] = {.lex_state = 171},
  [1691] = {.lex_state = 0},
  [1692] = {.lex_state = 162},
  [1693] = {.lex_state = 0},
  [1694] = {.lex_state = 0},
  [1695] = {.lex_state = 171},
  [1696] = {.lex_state = 0},
  [1697] = {.lex_state = 0},
  [1698] = {.lex_state = 171},
  [1699] = {.lex_state = 0},
  [1700] = {.lex_state = 0},
  [1701] = {.lex_state = 171},
  [1702] = {.lex_state = 0},
  [1703] = {.lex_state = 0},
  [1704] = {.lex_state = 171},
  [1705] = {.lex_state = 0},
  [1706] = {.lex_state = 0},
  [1707] = {.lex_state = 0},
  [1708] = {.lex_state = 0},
  [1709] = {.lex_state = 0},
  [1710] = {.lex_state = 0},
  [1711] = {.lex_state = 0},
  [1712] = {.lex_state = 172},
  [1713] = {.lex_state = 0},
  [1714] = {.lex_state = 162},
  [1715] = {.lex_state = 0},
  [1716] = {.lex_state = 171},
  [1717] = {.lex_state = 162},
  [1718] = {.lex_state = 0},
  [1719] = {.lex_state = 162},
  [1720] = {.lex_state = 162},
  [1721] = {.lex_state = 0},
  [1722] = {.lex_state = 0},
  [1723] = {.lex_state = 0},
  [1724] = {.lex_state = 0},
  [1725] = {.lex_state = 0},
  [1726] = {.lex_state = 162},
  [1727] = {.lex_state = 0},
  [1728] = {.lex_state = 0},
  [1729] = {.lex_state = 0},
  [1730] = {.lex_state = 148},
  [1731] = {.lex_state = 0},
  [1732] = {.lex_state = 162},
  [1733] = {.lex_state = 0},
  [1734] = {.lex_state = 162},
  [1735] = {.lex_state = 162},
  [1736] = {.lex_state = 162},
  [1737] = {.lex_state = 0},
  [1738] = {.lex_state = 0},
  [1739] = {.lex_state = 0},
  [1740] = {.lex_state = 0},
  [1741] = {.lex_state = 0},
  [1742] = {.lex_state = 0},
  [1743] = {.lex_state = 0},
  [1744] = {.lex_state = 0},
  [1745] = {.lex_state = 0},
  [1746] = {.lex_state = 162},
  [1747] = {.lex_state = 162},
  [1748] = {.lex_state = 172},
  [1749] = {.lex_state = 162},
  [1750] = {.lex_state = 171},
  [1751] = {.lex_state = 171},
  [1752] = {.lex_state = 0},
  [1753] = {.lex_state = 0},
  [1754] = {.lex_state = 0},
  [1755] = {.lex_state = 0},
  [1756] = {.lex_state = 172},
  [1757] = {.lex_state = 162},
  [1758] = {.lex_state = 0},
  [1759] = {.lex_state = 0},
  [1760] = {.lex_state = 0},
  [1761] = {.lex_state = 0},
  [1762] = {.lex_state = 0},
  [1763] = {.lex_state = 0},
  [1764] = {.lex_state = 0},
  [1765] = {.lex_state = 0},
  [1766] = {.lex_state = 0},
  [1767] = {.lex_state = 0},
  [1768] = {.lex_state = 0},
  [1769] = {.lex_state = 0},
  [1770] = {.lex_state = 0},
  [1771] = {.lex_state = 0},
  [1772] = {.lex_state = 0},
  [1773] = {.lex_state = 148},
  [1774] = {.lex_state = 0},
  [1775] = {.lex_state = 0},
  [1776] = {.lex_state = 0},
  [1777] = {.lex_state = 0},
  [1778] = {.lex_state = 0},
  [1779] = {.lex_state = 0},
  [1780] = {.lex_state = 0},
  [1781] = {.lex_state = 0},
  [1782] = {.lex_state = 0},
  [1783] = {.lex_state = 172},
  [1784] = {.lex_state = 0},
  [1785] = {.lex_state = 172},
  [1786] = {.lex_state = 172},
  [1787] = {.lex_state = 172},
  [1788] = {.lex_state = 0},
  [1789] = {.lex_state = 0},
  [1790] = {.lex_state = 0},
  [1791] = {.lex_state = 0},
  [1792] = {.lex_state = 0},
  [1793] = {.lex_state = 0},
  [1794] = {.lex_state = 0},
  [1795] = {.lex_state = 0},
  [1796] = {.lex_state = 0},
  [1797] = {.lex_state = 0},
  [1798] = {.lex_state = 0},
  [1799] = {.lex_state = 0},
  [1800] = {.lex_state = 0},
  [1801] = {.lex_state = 0},
  [1802] = {.lex_state = 0},
  [1803] = {.lex_state = 0},
  [1804] = {.lex_state = 0},
  [1805] = {.lex_state = 0},
  [1806] = {.lex_state = 0},
  [1807] = {.lex_state = 0},
  [1808] = {.lex_state = 0},
  [1809] = {.lex_state = 0},
  [1810] = {.lex_state = 0},
  [1811] = {.lex_state = 0},
  [1812] = {.lex_state = 0},
  [1813] = {.lex_state = 0},
  [1814] = {.lex_state = 172},
  [1815] = {.lex_state = 0},
  [1816] = {.lex_state = 0},
  [1817] = {.lex_state = 0},
  [1818] = {.lex_state = 0},
  [1819] = {.lex_state = 0},
  [1820] = {.lex_state = 0},
  [1821] = {.lex_state = 0},
  [1822] = {.lex_state = 0},
  [1823] = {.lex_state = 0},
  [1824] = {.lex_state = 0},
  [1825] = {.lex_state = 0},
  [1826] = {.lex_state = 0},
  [1827] = {.lex_state = 172},
  [1828] = {.lex_state = 0},
  [1829] = {.lex_state = 0},
  [1830] = {.lex_state = 0},
  [1831] = {.lex_state = 0},
  [1832] = {.lex_state = 0},
  [1833] = {.lex_state = 0},
  [1834] = {.lex_state = 0},
  [1835] = {.lex_state = 0},
  [1836] = {.lex_state = 0},
  [1837] = {.lex_state = 0},
  [1838] = {.lex_state = 0},
  [1839] = {.lex_state = 172},
  [1840] = {.lex_state = 0},
  [1841] = {.lex_state = 0},
  [1842] = {.lex_state = 0},
  [1843] = {.lex_state = 0},
  [1844] = {.lex_state = 0},
  [1845] = {.lex_state = 0},
  [1846] = {.lex_state = 0},
  [1847] = {.lex_state = 0},
  [1848] = {.lex_state = 172},
  [1849] = {.lex_state = 0},
  [1850] = {.lex_state = 0},
  [1851] = {.lex_state = 0},
  [1852] = {.lex_state = 0},
  [1853] = {.lex_state = 148},
  [1854] = {.lex_state = 148},
  [1855] = {.lex_state = 0},
  [1856] = {.lex_state = 0},
  [1857] = {.lex_state = 0},
  [1858] = {.lex_state = 0},
  [1859] = {.lex_state = 172},
  [1860] = {.lex_state = 0},
  [1861] = {.lex_state = 172},
  [1862] = {.lex_state = 0},
  [1863] = {.lex_state = 0},
  [1864] = {.lex_state = 0},
  [1865] = {.lex_state = 0},
  [1866] = {.lex_state = 172},
  [1867] = {.lex_state = 0},
  [1868] = {.lex_state = 148},
  [1869] = {.lex_state = 0},
  [1870] = {.lex_state = 0},
  [1871] = {.lex_state = 162},
  [1872] = {.lex_state = 0},
  [1873] = {.lex_state = 0},
  [1874] = {.lex_state = 0},
  [1875] = {.lex_state = 0},
  [1876] = {.lex_state = 0},
  [1877] = {.lex_state = 172},
  [1878] = {.lex_state = 0},
  [1879] = {.lex_state = 0},
  [1880] = {.lex_state = 0},
  [1881] = {.lex_state = 0},
  [1882] = {.lex_state = 0},
  [1883] = {.lex_state = 0},
  [1884] = {.lex_state = 0},
  [1885] = {.lex_state = 0},
  [1886] = {.lex_state = 0},
  [1887] = {.lex_state = 172},
  [1888] = {.lex_state = 172},
  [1889] = {.lex_state = 0},
  [1890] = {.lex_state = 0},
  [1891] = {.lex_state = 0},
};

enum {
  ts_external_token_quoted_content = 0,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_quoted_content] = sym_quoted_content,
};

static const bool ts_external_scanner_states[2][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_quoted_content] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_erlang] = ACTIONS(1),
    [anon_sym_javascript] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_size] = ACTIONS(1),
    [anon_sym_fn] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_external] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_LT_DOT] = ACTIONS(1),
    [anon_sym_LT_EQ_DOT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_DOT] = ACTIONS(1),
    [anon_sym_GT_EQ_DOT] = ACTIONS(1),
    [anon_sym_PIPE_GT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_PLUS_DOT] = ACTIONS(1),
    [anon_sym_DASH_DOT] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_STAR_DOT] = ACTIONS(1),
    [anon_sym_SLASH_DOT] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LT_GT] = ACTIONS(1),
    [anon_sym_todo] = ACTIONS(1),
    [anon_sym_panic] = ACTIONS(1),
    [anon_sym_echo] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_use] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [sym_visibility_modifier] = ACTIONS(1),
    [sym_opacity_modifier] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE2] = ACTIONS(1),
    [aux_sym_escape_sequence_token1] = ACTIONS(1),
    [aux_sym_escape_sequence_token2] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [sym__hex] = ACTIONS(1),
    [sym__decimal] = ACTIONS(1),
    [sym__octal] = ACTIONS(1),
    [sym__binary] = ACTIONS(1),
    [anon_sym_binary] = ACTIONS(1),
    [anon_sym_bytes] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_bit_string] = ACTIONS(1),
    [anon_sym_bits] = ACTIONS(1),
    [anon_sym_utf8] = ACTIONS(1),
    [anon_sym_utf16] = ACTIONS(1),
    [anon_sym_utf32] = ACTIONS(1),
    [anon_sym_utf8_codepoint] = ACTIONS(1),
    [anon_sym_utf16_codepoint] = ACTIONS(1),
    [anon_sym_utf32_codepoint] = ACTIONS(1),
    [anon_sym_signed] = ACTIONS(1),
    [anon_sym_unsigned] = ACTIONS(1),
    [anon_sym_big] = ACTIONS(1),
    [anon_sym_little] = ACTIONS(1),
    [anon_sym_native] = ACTIONS(1),
    [anon_sym_unit] = ACTIONS(1),
    [sym__discard_name] = ACTIONS(1),
    [sym__name] = ACTIONS(1),
    [sym__upname] = ACTIONS(1),
    [sym_quoted_content] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(1864),
    [sym__module_statement] = STATE(4),
    [sym_target_group] = STATE(4),
    [sym_attribute] = STATE(4),
    [sym_import] = STATE(4),
    [sym_constant] = STATE(4),
    [sym_external_type] = STATE(4),
    [sym_external_function] = STATE(4),
    [sym_function] = STATE(4),
    [aux_sym__statement_seq] = STATE(13),
    [sym__statement] = STATE(13),
    [sym__expression] = STATE(134),
    [sym_binary_expression] = STATE(134),
    [sym__expression_unit] = STATE(134),
    [sym_record] = STATE(93),
    [sym_todo] = STATE(134),
    [sym_panic] = STATE(134),
    [sym_echo] = STATE(134),
    [sym_tuple] = STATE(92),
    [sym_list] = STATE(134),
    [sym__expression_bit_string] = STATE(134),
    [sym_anonymous_function] = STATE(91),
    [sym_block] = STATE(81),
    [sym_case] = STATE(81),
    [sym_let_assert] = STATE(13),
    [sym_assert] = STATE(13),
    [sym_let] = STATE(13),
    [sym_use] = STATE(13),
    [sym_boolean_negation] = STATE(134),
    [sym_integer_negation] = STATE(134),
    [sym_record_update] = STATE(93),
    [sym__maybe_tuple_expression] = STATE(1863),
    [sym_tuple_access] = STATE(81),
    [sym__maybe_record_expression] = STATE(1862),
    [sym_field_access] = STATE(81),
    [sym__maybe_function_expression] = STATE(1652),
    [sym_function_call] = STATE(81),
    [sym_type_definition] = STATE(4),
    [sym_type_alias] = STATE(4),
    [sym_string] = STATE(134),
    [sym_integer] = STATE(134),
    [sym_identifier] = STATE(74),
    [sym_constructor_name] = STATE(39),
    [sym_remote_constructor_name] = STATE(39),
    [aux_sym_source_file_repeat1] = STATE(4),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(11),
    [anon_sym_AT] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LT_LT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_fn] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_todo] = ACTIONS(33),
    [anon_sym_panic] = ACTIONS(35),
    [anon_sym_echo] = ACTIONS(37),
    [anon_sym_case] = ACTIONS(39),
    [anon_sym_let] = ACTIONS(41),
    [anon_sym_assert] = ACTIONS(43),
    [anon_sym_use] = ACTIONS(45),
    [anon_sym_BANG] = ACTIONS(47),
    [sym_visibility_modifier] = ACTIONS(49),
    [sym_opacity_modifier] = ACTIONS(51),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [sym__hex] = ACTIONS(57),
    [sym__decimal] = ACTIONS(59),
    [sym__octal] = ACTIONS(57),
    [sym__binary] = ACTIONS(57),
    [sym__name] = ACTIONS(61),
    [sym__upname] = ACTIONS(63),
  },
  [2] = {
    [sym__expression] = STATE(97),
    [sym_binary_expression] = STATE(97),
    [sym__expression_unit] = STATE(97),
    [sym_record] = STATE(69),
    [sym_todo] = STATE(97),
    [sym_panic] = STATE(97),
    [sym_echo] = STATE(97),
    [sym_tuple] = STATE(76),
    [sym_list] = STATE(97),
    [sym__expression_bit_string] = STATE(97),
    [sym_anonymous_function] = STATE(78),
    [sym_block] = STATE(26),
    [sym_case] = STATE(26),
    [sym_boolean_negation] = STATE(97),
    [sym_integer_negation] = STATE(97),
    [sym_record_update] = STATE(69),
    [sym__maybe_tuple_expression] = STATE(1876),
    [sym_tuple_access] = STATE(26),
    [sym__maybe_record_expression] = STATE(1809),
    [sym_field_access] = STATE(26),
    [sym__maybe_function_expression] = STATE(1608),
    [sym_function_call] = STATE(26),
    [sym_string] = STATE(97),
    [sym_integer] = STATE(97),
    [sym_identifier] = STATE(27),
    [sym_constructor_name] = STATE(14),
    [sym_remote_constructor_name] = STATE(14),
    [ts_builtin_sym_end] = ACTIONS(65),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(65),
    [anon_sym_import] = ACTIONS(67),
    [anon_sym_as] = ACTIONS(67),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_type] = ACTIONS(67),
    [anon_sym_const] = ACTIONS(67),
    [anon_sym_POUND] = ACTIONS(65),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_fn] = ACTIONS(67),
    [anon_sym_external] = ACTIONS(67),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_AMP_AMP] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_LT_EQ] = ACTIONS(67),
    [anon_sym_LT_DOT] = ACTIONS(65),
    [anon_sym_LT_EQ_DOT] = ACTIONS(65),
    [anon_sym_GT] = ACTIONS(67),
    [anon_sym_GT_EQ] = ACTIONS(67),
    [anon_sym_GT_DOT] = ACTIONS(65),
    [anon_sym_GT_EQ_DOT] = ACTIONS(65),
    [anon_sym_PIPE_GT] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_PLUS_DOT] = ACTIONS(65),
    [anon_sym_DASH_DOT] = ACTIONS(65),
    [anon_sym_STAR] = ACTIONS(67),
    [anon_sym_STAR_DOT] = ACTIONS(65),
    [anon_sym_SLASH_DOT] = ACTIONS(65),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_LT_GT] = ACTIONS(65),
    [anon_sym_todo] = ACTIONS(67),
    [anon_sym_panic] = ACTIONS(67),
    [anon_sym_echo] = ACTIONS(67),
    [anon_sym_case] = ACTIONS(67),
    [anon_sym_let] = ACTIONS(67),
    [anon_sym_assert] = ACTIONS(67),
    [anon_sym_use] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [sym_visibility_modifier] = ACTIONS(67),
    [sym_opacity_modifier] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(65),
    [sym_float] = ACTIONS(65),
    [sym__hex] = ACTIONS(65),
    [sym__decimal] = ACTIONS(67),
    [sym__octal] = ACTIONS(65),
    [sym__binary] = ACTIONS(65),
    [sym__name] = ACTIONS(67),
    [sym__upname] = ACTIONS(65),
  },
  [3] = {
    [sym__expression] = STATE(133),
    [sym_binary_expression] = STATE(133),
    [sym__expression_unit] = STATE(133),
    [sym_record] = STATE(93),
    [sym_todo] = STATE(133),
    [sym_panic] = STATE(133),
    [sym_echo] = STATE(133),
    [sym_tuple] = STATE(92),
    [sym_list] = STATE(133),
    [sym__expression_bit_string] = STATE(133),
    [sym_anonymous_function] = STATE(91),
    [sym_block] = STATE(81),
    [sym_case] = STATE(81),
    [sym_boolean_negation] = STATE(133),
    [sym_integer_negation] = STATE(133),
    [sym_record_update] = STATE(93),
    [sym__maybe_tuple_expression] = STATE(1863),
    [sym_tuple_access] = STATE(81),
    [sym__maybe_record_expression] = STATE(1862),
    [sym_field_access] = STATE(81),
    [sym__maybe_function_expression] = STATE(1652),
    [sym_function_call] = STATE(81),
    [sym_string] = STATE(133),
    [sym_integer] = STATE(133),
    [sym_identifier] = STATE(74),
    [sym_constructor_name] = STATE(39),
    [sym_remote_constructor_name] = STATE(39),
    [ts_builtin_sym_end] = ACTIONS(65),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(65),
    [anon_sym_import] = ACTIONS(67),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_type] = ACTIONS(67),
    [anon_sym_const] = ACTIONS(67),
    [anon_sym_POUND] = ACTIONS(65),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_fn] = ACTIONS(67),
    [anon_sym_external] = ACTIONS(67),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_AMP_AMP] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_LT_EQ] = ACTIONS(67),
    [anon_sym_LT_DOT] = ACTIONS(65),
    [anon_sym_LT_EQ_DOT] = ACTIONS(65),
    [anon_sym_GT] = ACTIONS(67),
    [anon_sym_GT_EQ] = ACTIONS(67),
    [anon_sym_GT_DOT] = ACTIONS(65),
    [anon_sym_GT_EQ_DOT] = ACTIONS(65),
    [anon_sym_PIPE_GT] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_PLUS_DOT] = ACTIONS(65),
    [anon_sym_DASH_DOT] = ACTIONS(65),
    [anon_sym_STAR] = ACTIONS(67),
    [anon_sym_STAR_DOT] = ACTIONS(65),
    [anon_sym_SLASH_DOT] = ACTIONS(65),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_LT_GT] = ACTIONS(65),
    [anon_sym_todo] = ACTIONS(67),
    [anon_sym_panic] = ACTIONS(67),
    [anon_sym_echo] = ACTIONS(67),
    [anon_sym_case] = ACTIONS(67),
    [anon_sym_let] = ACTIONS(67),
    [anon_sym_assert] = ACTIONS(67),
    [anon_sym_use] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [sym_visibility_modifier] = ACTIONS(67),
    [sym_opacity_modifier] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(65),
    [sym_float] = ACTIONS(65),
    [sym__hex] = ACTIONS(65),
    [sym__decimal] = ACTIONS(67),
    [sym__octal] = ACTIONS(65),
    [sym__binary] = ACTIONS(65),
    [sym__name] = ACTIONS(67),
    [sym__upname] = ACTIONS(65),
  },
  [4] = {
    [sym__module_statement] = STATE(6),
    [sym_target_group] = STATE(6),
    [sym_attribute] = STATE(6),
    [sym_import] = STATE(6),
    [sym_constant] = STATE(6),
    [sym_external_type] = STATE(6),
    [sym_external_function] = STATE(6),
    [sym_function] = STATE(6),
    [aux_sym__statement_seq] = STATE(13),
    [sym__statement] = STATE(13),
    [sym__expression] = STATE(134),
    [sym_binary_expression] = STATE(134),
    [sym__expression_unit] = STATE(134),
    [sym_record] = STATE(93),
    [sym_todo] = STATE(134),
    [sym_panic] = STATE(134),
    [sym_echo] = STATE(134),
    [sym_tuple] = STATE(92),
    [sym_list] = STATE(134),
    [sym__expression_bit_string] = STATE(134),
    [sym_anonymous_function] = STATE(91),
    [sym_block] = STATE(81),
    [sym_case] = STATE(81),
    [sym_let_assert] = STATE(13),
    [sym_assert] = STATE(13),
    [sym_let] = STATE(13),
    [sym_use] = STATE(13),
    [sym_boolean_negation] = STATE(134),
    [sym_integer_negation] = STATE(134),
    [sym_record_update] = STATE(93),
    [sym__maybe_tuple_expression] = STATE(1863),
    [sym_tuple_access] = STATE(81),
    [sym__maybe_record_expression] = STATE(1862),
    [sym_field_access] = STATE(81),
    [sym__maybe_function_expression] = STATE(1652),
    [sym_function_call] = STATE(81),
    [sym_type_definition] = STATE(6),
    [sym_type_alias] = STATE(6),
    [sym_string] = STATE(134),
    [sym_integer] = STATE(134),
    [sym_identifier] = STATE(74),
    [sym_constructor_name] = STATE(39),
    [sym_remote_constructor_name] = STATE(39),
    [aux_sym_source_file_repeat1] = STATE(6),
    [ts_builtin_sym_end] = ACTIONS(69),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(11),
    [anon_sym_AT] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LT_LT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_fn] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_todo] = ACTIONS(33),
    [anon_sym_panic] = ACTIONS(35),
    [anon_sym_echo] = ACTIONS(37),
    [anon_sym_case] = ACTIONS(39),
    [anon_sym_let] = ACTIONS(41),
    [anon_sym_assert] = ACTIONS(43),
    [anon_sym_use] = ACTIONS(45),
    [anon_sym_BANG] = ACTIONS(47),
    [sym_visibility_modifier] = ACTIONS(49),
    [sym_opacity_modifier] = ACTIONS(51),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [sym__hex] = ACTIONS(57),
    [sym__decimal] = ACTIONS(59),
    [sym__octal] = ACTIONS(57),
    [sym__binary] = ACTIONS(57),
    [sym__name] = ACTIONS(61),
    [sym__upname] = ACTIONS(63),
  },
  [5] = {
    [sym__expression] = STATE(810),
    [sym_binary_expression] = STATE(810),
    [sym__expression_unit] = STATE(810),
    [sym_record] = STATE(679),
    [sym_todo] = STATE(810),
    [sym_panic] = STATE(810),
    [sym_echo] = STATE(810),
    [sym_tuple] = STATE(681),
    [sym_list] = STATE(810),
    [sym__expression_bit_string] = STATE(810),
    [sym_anonymous_function] = STATE(685),
    [sym_block] = STATE(644),
    [sym_case] = STATE(644),
    [sym_boolean_negation] = STATE(810),
    [sym_integer_negation] = STATE(810),
    [sym_record_update] = STATE(679),
    [sym__maybe_tuple_expression] = STATE(1821),
    [sym_tuple_access] = STATE(644),
    [sym__maybe_record_expression] = STATE(1796),
    [sym_field_access] = STATE(644),
    [sym__maybe_function_expression] = STATE(1682),
    [sym_function_call] = STATE(644),
    [sym_string] = STATE(810),
    [sym_integer] = STATE(810),
    [sym_identifier] = STATE(649),
    [sym_constructor_name] = STATE(642),
    [sym_remote_constructor_name] = STATE(642),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_LBRACE] = ACTIONS(71),
    [anon_sym_RBRACE] = ACTIONS(65),
    [anon_sym_COMMA] = ACTIONS(65),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_COLON] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_POUND] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_RBRACK] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(77),
    [anon_sym_GT_GT] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_fn] = ACTIONS(79),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_AMP_AMP] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_LT_EQ] = ACTIONS(67),
    [anon_sym_LT_DOT] = ACTIONS(65),
    [anon_sym_LT_EQ_DOT] = ACTIONS(65),
    [anon_sym_GT] = ACTIONS(67),
    [anon_sym_GT_EQ] = ACTIONS(67),
    [anon_sym_GT_DOT] = ACTIONS(65),
    [anon_sym_GT_EQ_DOT] = ACTIONS(65),
    [anon_sym_PIPE_GT] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_PLUS_DOT] = ACTIONS(65),
    [anon_sym_DASH_DOT] = ACTIONS(65),
    [anon_sym_STAR] = ACTIONS(67),
    [anon_sym_STAR_DOT] = ACTIONS(65),
    [anon_sym_SLASH_DOT] = ACTIONS(65),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_LT_GT] = ACTIONS(65),
    [anon_sym_todo] = ACTIONS(81),
    [anon_sym_panic] = ACTIONS(83),
    [anon_sym_echo] = ACTIONS(85),
    [anon_sym_DOT_DOT] = ACTIONS(65),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_BANG] = ACTIONS(89),
    [anon_sym_DQUOTE] = ACTIONS(91),
    [sym_float] = ACTIONS(93),
    [sym__hex] = ACTIONS(95),
    [sym__decimal] = ACTIONS(97),
    [sym__octal] = ACTIONS(95),
    [sym__binary] = ACTIONS(95),
    [sym__name] = ACTIONS(99),
    [sym__upname] = ACTIONS(101),
  },
  [6] = {
    [sym__module_statement] = STATE(6),
    [sym_target_group] = STATE(6),
    [sym_attribute] = STATE(6),
    [sym_import] = STATE(6),
    [sym_constant] = STATE(6),
    [sym_external_type] = STATE(6),
    [sym_external_function] = STATE(6),
    [sym_function] = STATE(6),
    [aux_sym__statement_seq] = STATE(13),
    [sym__statement] = STATE(13),
    [sym__expression] = STATE(134),
    [sym_binary_expression] = STATE(134),
    [sym__expression_unit] = STATE(134),
    [sym_record] = STATE(93),
    [sym_todo] = STATE(134),
    [sym_panic] = STATE(134),
    [sym_echo] = STATE(134),
    [sym_tuple] = STATE(92),
    [sym_list] = STATE(134),
    [sym__expression_bit_string] = STATE(134),
    [sym_anonymous_function] = STATE(91),
    [sym_block] = STATE(81),
    [sym_case] = STATE(81),
    [sym_let_assert] = STATE(13),
    [sym_assert] = STATE(13),
    [sym_let] = STATE(13),
    [sym_use] = STATE(13),
    [sym_boolean_negation] = STATE(134),
    [sym_integer_negation] = STATE(134),
    [sym_record_update] = STATE(93),
    [sym__maybe_tuple_expression] = STATE(1863),
    [sym_tuple_access] = STATE(81),
    [sym__maybe_record_expression] = STATE(1862),
    [sym_field_access] = STATE(81),
    [sym__maybe_function_expression] = STATE(1652),
    [sym_function_call] = STATE(81),
    [sym_type_definition] = STATE(6),
    [sym_type_alias] = STATE(6),
    [sym_string] = STATE(134),
    [sym_integer] = STATE(134),
    [sym_identifier] = STATE(74),
    [sym_constructor_name] = STATE(39),
    [sym_remote_constructor_name] = STATE(39),
    [aux_sym_source_file_repeat1] = STATE(6),
    [ts_builtin_sym_end] = ACTIONS(103),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(108),
    [anon_sym_AT] = ACTIONS(111),
    [anon_sym_import] = ACTIONS(114),
    [anon_sym_type] = ACTIONS(117),
    [anon_sym_const] = ACTIONS(120),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_LBRACK] = ACTIONS(126),
    [anon_sym_LT_LT] = ACTIONS(129),
    [anon_sym_DASH] = ACTIONS(132),
    [anon_sym_fn] = ACTIONS(135),
    [anon_sym_external] = ACTIONS(138),
    [anon_sym_todo] = ACTIONS(141),
    [anon_sym_panic] = ACTIONS(144),
    [anon_sym_echo] = ACTIONS(147),
    [anon_sym_case] = ACTIONS(150),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_assert] = ACTIONS(156),
    [anon_sym_use] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(162),
    [sym_visibility_modifier] = ACTIONS(165),
    [sym_opacity_modifier] = ACTIONS(168),
    [anon_sym_DQUOTE] = ACTIONS(171),
    [sym_float] = ACTIONS(174),
    [sym__hex] = ACTIONS(177),
    [sym__decimal] = ACTIONS(180),
    [sym__octal] = ACTIONS(177),
    [sym__binary] = ACTIONS(177),
    [sym__name] = ACTIONS(183),
    [sym__upname] = ACTIONS(186),
  },
  [7] = {
    [sym__expression] = STATE(463),
    [sym_binary_expression] = STATE(463),
    [sym__expression_unit] = STATE(463),
    [sym_record] = STATE(319),
    [sym_todo] = STATE(463),
    [sym_panic] = STATE(463),
    [sym_echo] = STATE(463),
    [sym_tuple] = STATE(312),
    [sym_list] = STATE(463),
    [sym__expression_bit_string] = STATE(463),
    [sym_anonymous_function] = STATE(311),
    [sym_block] = STATE(248),
    [sym_case] = STATE(248),
    [sym_boolean_negation] = STATE(463),
    [sym_integer_negation] = STATE(463),
    [sym_record_update] = STATE(319),
    [sym__maybe_tuple_expression] = STATE(1825),
    [sym_tuple_access] = STATE(248),
    [sym__maybe_record_expression] = STATE(1820),
    [sym_field_access] = STATE(248),
    [sym__maybe_function_expression] = STATE(1638),
    [sym_function_call] = STATE(248),
    [sym_string] = STATE(463),
    [sym_integer] = STATE(463),
    [sym_identifier] = STATE(249),
    [sym_constructor_name] = STATE(222),
    [sym_remote_constructor_name] = STATE(222),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_LBRACE] = ACTIONS(65),
    [anon_sym_RBRACE] = ACTIONS(65),
    [anon_sym_as] = ACTIONS(67),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_POUND] = ACTIONS(65),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_fn] = ACTIONS(67),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_AMP_AMP] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_LT_EQ] = ACTIONS(67),
    [anon_sym_LT_DOT] = ACTIONS(65),
    [anon_sym_LT_EQ_DOT] = ACTIONS(65),
    [anon_sym_GT] = ACTIONS(67),
    [anon_sym_GT_EQ] = ACTIONS(67),
    [anon_sym_GT_DOT] = ACTIONS(65),
    [anon_sym_GT_EQ_DOT] = ACTIONS(65),
    [anon_sym_PIPE_GT] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_PLUS_DOT] = ACTIONS(65),
    [anon_sym_DASH_DOT] = ACTIONS(65),
    [anon_sym_STAR] = ACTIONS(67),
    [anon_sym_STAR_DOT] = ACTIONS(65),
    [anon_sym_SLASH_DOT] = ACTIONS(65),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_LT_GT] = ACTIONS(65),
    [anon_sym_todo] = ACTIONS(67),
    [anon_sym_panic] = ACTIONS(67),
    [anon_sym_echo] = ACTIONS(67),
    [anon_sym_case] = ACTIONS(67),
    [anon_sym_let] = ACTIONS(67),
    [anon_sym_assert] = ACTIONS(67),
    [anon_sym_use] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(65),
    [sym_float] = ACTIONS(65),
    [sym__hex] = ACTIONS(65),
    [sym__decimal] = ACTIONS(67),
    [sym__octal] = ACTIONS(65),
    [sym__binary] = ACTIONS(65),
    [sym__name] = ACTIONS(67),
    [sym__upname] = ACTIONS(65),
  },
  [8] = {
    [sym__expression] = STATE(522),
    [sym_binary_expression] = STATE(522),
    [sym__expression_unit] = STATE(522),
    [sym_record] = STATE(214),
    [sym_todo] = STATE(522),
    [sym_panic] = STATE(522),
    [sym_echo] = STATE(522),
    [sym_tuple] = STATE(218),
    [sym_list] = STATE(522),
    [sym__expression_bit_string] = STATE(522),
    [sym_anonymous_function] = STATE(220),
    [sym_block] = STATE(202),
    [sym_case] = STATE(202),
    [sym_boolean_negation] = STATE(522),
    [sym_integer_negation] = STATE(522),
    [sym_record_update] = STATE(214),
    [sym__maybe_tuple_expression] = STATE(1826),
    [sym_tuple_access] = STATE(202),
    [sym__maybe_record_expression] = STATE(1762),
    [sym_field_access] = STATE(202),
    [sym__maybe_function_expression] = STATE(1653),
    [sym_function_call] = STATE(202),
    [sym_string] = STATE(522),
    [sym_integer] = STATE(522),
    [sym_identifier] = STATE(211),
    [sym_constructor_name] = STATE(187),
    [sym_remote_constructor_name] = STATE(187),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_LBRACE] = ACTIONS(65),
    [anon_sym_RBRACE] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_POUND] = ACTIONS(65),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_fn] = ACTIONS(67),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_AMP_AMP] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_LT_EQ] = ACTIONS(67),
    [anon_sym_LT_DOT] = ACTIONS(65),
    [anon_sym_LT_EQ_DOT] = ACTIONS(65),
    [anon_sym_GT] = ACTIONS(67),
    [anon_sym_GT_EQ] = ACTIONS(67),
    [anon_sym_GT_DOT] = ACTIONS(65),
    [anon_sym_GT_EQ_DOT] = ACTIONS(65),
    [anon_sym_PIPE_GT] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_PLUS_DOT] = ACTIONS(65),
    [anon_sym_DASH_DOT] = ACTIONS(65),
    [anon_sym_STAR] = ACTIONS(67),
    [anon_sym_STAR_DOT] = ACTIONS(65),
    [anon_sym_SLASH_DOT] = ACTIONS(65),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_LT_GT] = ACTIONS(65),
    [anon_sym_todo] = ACTIONS(67),
    [anon_sym_panic] = ACTIONS(67),
    [anon_sym_echo] = ACTIONS(67),
    [anon_sym_case] = ACTIONS(67),
    [anon_sym_let] = ACTIONS(67),
    [anon_sym_assert] = ACTIONS(67),
    [anon_sym_use] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(65),
    [sym_float] = ACTIONS(65),
    [sym__hex] = ACTIONS(65),
    [sym__decimal] = ACTIONS(67),
    [sym__octal] = ACTIONS(65),
    [sym__binary] = ACTIONS(65),
    [sym__name] = ACTIONS(67),
    [sym__upname] = ACTIONS(65),
  },
  [9] = {
    [sym__expression] = STATE(620),
    [sym_binary_expression] = STATE(620),
    [sym__expression_unit] = STATE(620),
    [sym_record] = STATE(584),
    [sym_todo] = STATE(620),
    [sym_panic] = STATE(620),
    [sym_echo] = STATE(620),
    [sym_tuple] = STATE(585),
    [sym_list] = STATE(620),
    [sym__expression_bit_string] = STATE(620),
    [sym_anonymous_function] = STATE(588),
    [sym_block] = STATE(562),
    [sym_case] = STATE(562),
    [sym_boolean_negation] = STATE(620),
    [sym_integer_negation] = STATE(620),
    [sym_record_update] = STATE(584),
    [sym__maybe_tuple_expression] = STATE(1782),
    [sym_tuple_access] = STATE(562),
    [sym__maybe_record_expression] = STATE(1831),
    [sym_field_access] = STATE(562),
    [sym__maybe_function_expression] = STATE(1678),
    [sym_function_call] = STATE(562),
    [sym_string] = STATE(620),
    [sym_integer] = STATE(620),
    [sym_identifier] = STATE(563),
    [sym_constructor_name] = STATE(555),
    [sym_remote_constructor_name] = STATE(555),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_LBRACE] = ACTIONS(189),
    [anon_sym_RBRACE] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_POUND] = ACTIONS(65),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_fn] = ACTIONS(191),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_AMP_AMP] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_LT_EQ] = ACTIONS(67),
    [anon_sym_LT_DOT] = ACTIONS(65),
    [anon_sym_LT_EQ_DOT] = ACTIONS(65),
    [anon_sym_GT] = ACTIONS(67),
    [anon_sym_GT_EQ] = ACTIONS(67),
    [anon_sym_GT_DOT] = ACTIONS(65),
    [anon_sym_GT_EQ_DOT] = ACTIONS(65),
    [anon_sym_PIPE_GT] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_PLUS_DOT] = ACTIONS(65),
    [anon_sym_DASH_DOT] = ACTIONS(65),
    [anon_sym_STAR] = ACTIONS(67),
    [anon_sym_STAR_DOT] = ACTIONS(65),
    [anon_sym_SLASH_DOT] = ACTIONS(65),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_LT_GT] = ACTIONS(65),
    [anon_sym_todo] = ACTIONS(193),
    [anon_sym_panic] = ACTIONS(195),
    [anon_sym_echo] = ACTIONS(197),
    [anon_sym_case] = ACTIONS(199),
    [anon_sym_BANG] = ACTIONS(201),
    [anon_sym_DQUOTE] = ACTIONS(65),
    [sym_float] = ACTIONS(65),
    [sym__hex] = ACTIONS(65),
    [sym__decimal] = ACTIONS(67),
    [sym__octal] = ACTIONS(65),
    [sym__binary] = ACTIONS(65),
    [sym__discard_name] = ACTIONS(67),
    [sym__name] = ACTIONS(67),
    [sym__upname] = ACTIONS(65),
  },
  [10] = {
    [sym__expression] = STATE(961),
    [sym_binary_expression] = STATE(961),
    [sym__expression_unit] = STATE(961),
    [sym_record] = STATE(931),
    [sym_todo] = STATE(961),
    [sym_panic] = STATE(961),
    [sym_echo] = STATE(961),
    [sym_tuple] = STATE(933),
    [sym_list] = STATE(961),
    [sym__expression_bit_string] = STATE(961),
    [sym_anonymous_function] = STATE(935),
    [sym_block] = STATE(873),
    [sym_case] = STATE(873),
    [sym_boolean_negation] = STATE(961),
    [sym_integer_negation] = STATE(961),
    [sym_record_update] = STATE(931),
    [sym__maybe_tuple_expression] = STATE(1760),
    [sym_tuple_access] = STATE(873),
    [sym__maybe_record_expression] = STATE(1842),
    [sym_field_access] = STATE(873),
    [sym__maybe_function_expression] = STATE(1718),
    [sym_function_call] = STATE(873),
    [sym_string] = STATE(961),
    [sym_integer] = STATE(961),
    [sym_identifier] = STATE(862),
    [sym_constructor_name] = STATE(856),
    [sym_remote_constructor_name] = STATE(856),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_LBRACE] = ACTIONS(203),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_POUND] = ACTIONS(205),
    [anon_sym_LBRACK] = ACTIONS(207),
    [anon_sym_LT_LT] = ACTIONS(209),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_fn] = ACTIONS(211),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_AMP_AMP] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_LT_EQ] = ACTIONS(67),
    [anon_sym_LT_DOT] = ACTIONS(65),
    [anon_sym_LT_EQ_DOT] = ACTIONS(65),
    [anon_sym_GT] = ACTIONS(67),
    [anon_sym_GT_EQ] = ACTIONS(67),
    [anon_sym_GT_DOT] = ACTIONS(65),
    [anon_sym_GT_EQ_DOT] = ACTIONS(65),
    [anon_sym_PIPE_GT] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_PLUS_DOT] = ACTIONS(65),
    [anon_sym_DASH_DOT] = ACTIONS(65),
    [anon_sym_STAR] = ACTIONS(67),
    [anon_sym_STAR_DOT] = ACTIONS(65),
    [anon_sym_SLASH_DOT] = ACTIONS(65),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_LT_GT] = ACTIONS(65),
    [anon_sym_todo] = ACTIONS(213),
    [anon_sym_panic] = ACTIONS(215),
    [anon_sym_echo] = ACTIONS(217),
    [anon_sym_case] = ACTIONS(219),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DQUOTE] = ACTIONS(223),
    [sym_float] = ACTIONS(225),
    [sym__hex] = ACTIONS(227),
    [sym__decimal] = ACTIONS(229),
    [sym__octal] = ACTIONS(227),
    [sym__binary] = ACTIONS(227),
    [sym__name] = ACTIONS(231),
    [sym__upname] = ACTIONS(233),
  },
  [11] = {
    [sym__expression] = STATE(913),
    [sym_binary_expression] = STATE(913),
    [sym__expression_unit] = STATE(913),
    [sym_record] = STATE(679),
    [sym_todo] = STATE(913),
    [sym_panic] = STATE(913),
    [sym_echo] = STATE(913),
    [sym_tuple] = STATE(681),
    [sym_list] = STATE(913),
    [sym__expression_bit_string] = STATE(913),
    [sym_anonymous_function] = STATE(685),
    [sym_block] = STATE(644),
    [sym_case] = STATE(644),
    [sym_boolean_negation] = STATE(913),
    [sym_integer_negation] = STATE(913),
    [sym_record_update] = STATE(679),
    [sym__maybe_tuple_expression] = STATE(1821),
    [sym_tuple_access] = STATE(644),
    [sym__maybe_record_expression] = STATE(1796),
    [sym_field_access] = STATE(644),
    [sym__maybe_function_expression] = STATE(1682),
    [sym_function_call] = STATE(644),
    [sym_string] = STATE(913),
    [sym_integer] = STATE(913),
    [sym_identifier] = STATE(649),
    [sym_constructor_name] = STATE(642),
    [sym_remote_constructor_name] = STATE(642),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_LBRACE] = ACTIONS(65),
    [anon_sym_COMMA] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_POUND] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LT_LT] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_fn] = ACTIONS(79),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_AMP_AMP] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_LT_EQ] = ACTIONS(67),
    [anon_sym_LT_DOT] = ACTIONS(65),
    [anon_sym_LT_EQ_DOT] = ACTIONS(65),
    [anon_sym_GT] = ACTIONS(67),
    [anon_sym_GT_EQ] = ACTIONS(67),
    [anon_sym_GT_DOT] = ACTIONS(65),
    [anon_sym_GT_EQ_DOT] = ACTIONS(65),
    [anon_sym_PIPE_GT] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_PLUS_DOT] = ACTIONS(65),
    [anon_sym_DASH_DOT] = ACTIONS(65),
    [anon_sym_STAR] = ACTIONS(67),
    [anon_sym_STAR_DOT] = ACTIONS(65),
    [anon_sym_SLASH_DOT] = ACTIONS(65),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_LT_GT] = ACTIONS(65),
    [anon_sym_todo] = ACTIONS(235),
    [anon_sym_panic] = ACTIONS(237),
    [anon_sym_echo] = ACTIONS(239),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_BANG] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(91),
    [sym_float] = ACTIONS(243),
    [sym__hex] = ACTIONS(95),
    [sym__decimal] = ACTIONS(97),
    [sym__octal] = ACTIONS(95),
    [sym__binary] = ACTIONS(95),
    [sym__name] = ACTIONS(99),
    [sym__upname] = ACTIONS(101),
  },
  [12] = {
    [aux_sym__statement_seq] = STATE(12),
    [sym__statement] = STATE(12),
    [sym__expression] = STATE(134),
    [sym_binary_expression] = STATE(134),
    [sym__expression_unit] = STATE(134),
    [sym_record] = STATE(93),
    [sym_todo] = STATE(134),
    [sym_panic] = STATE(134),
    [sym_echo] = STATE(134),
    [sym_tuple] = STATE(92),
    [sym_list] = STATE(134),
    [sym__expression_bit_string] = STATE(134),
    [sym_anonymous_function] = STATE(91),
    [sym_block] = STATE(81),
    [sym_case] = STATE(81),
    [sym_let_assert] = STATE(12),
    [sym_assert] = STATE(12),
    [sym_let] = STATE(12),
    [sym_use] = STATE(12),
    [sym_boolean_negation] = STATE(134),
    [sym_integer_negation] = STATE(134),
    [sym_record_update] = STATE(93),
    [sym__maybe_tuple_expression] = STATE(1863),
    [sym_tuple_access] = STATE(81),
    [sym__maybe_record_expression] = STATE(1862),
    [sym_field_access] = STATE(81),
    [sym__maybe_function_expression] = STATE(1652),
    [sym_function_call] = STATE(81),
    [sym_string] = STATE(134),
    [sym_integer] = STATE(134),
    [sym_identifier] = STATE(74),
    [sym_constructor_name] = STATE(39),
    [sym_remote_constructor_name] = STATE(39),
    [ts_builtin_sym_end] = ACTIONS(245),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(247),
    [anon_sym_LBRACE] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(245),
    [anon_sym_import] = ACTIONS(247),
    [anon_sym_type] = ACTIONS(247),
    [anon_sym_const] = ACTIONS(247),
    [anon_sym_POUND] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(255),
    [anon_sym_LT_LT] = ACTIONS(258),
    [anon_sym_DASH] = ACTIONS(261),
    [anon_sym_fn] = ACTIONS(264),
    [anon_sym_external] = ACTIONS(247),
    [anon_sym_todo] = ACTIONS(267),
    [anon_sym_panic] = ACTIONS(270),
    [anon_sym_echo] = ACTIONS(273),
    [anon_sym_case] = ACTIONS(276),
    [anon_sym_let] = ACTIONS(279),
    [anon_sym_assert] = ACTIONS(282),
    [anon_sym_use] = ACTIONS(285),
    [anon_sym_BANG] = ACTIONS(288),
    [sym_visibility_modifier] = ACTIONS(247),
    [sym_opacity_modifier] = ACTIONS(247),
    [anon_sym_DQUOTE] = ACTIONS(291),
    [sym_float] = ACTIONS(294),
    [sym__hex] = ACTIONS(297),
    [sym__decimal] = ACTIONS(300),
    [sym__octal] = ACTIONS(297),
    [sym__binary] = ACTIONS(297),
    [sym__name] = ACTIONS(303),
    [sym__upname] = ACTIONS(306),
  },
  [13] = {
    [aux_sym__statement_seq] = STATE(12),
    [sym__statement] = STATE(12),
    [sym__expression] = STATE(134),
    [sym_binary_expression] = STATE(134),
    [sym__expression_unit] = STATE(134),
    [sym_record] = STATE(93),
    [sym_todo] = STATE(134),
    [sym_panic] = STATE(134),
    [sym_echo] = STATE(134),
    [sym_tuple] = STATE(92),
    [sym_list] = STATE(134),
    [sym__expression_bit_string] = STATE(134),
    [sym_anonymous_function] = STATE(91),
    [sym_block] = STATE(81),
    [sym_case] = STATE(81),
    [sym_let_assert] = STATE(12),
    [sym_assert] = STATE(12),
    [sym_let] = STATE(12),
    [sym_use] = STATE(12),
    [sym_boolean_negation] = STATE(134),
    [sym_integer_negation] = STATE(134),
    [sym_record_update] = STATE(93),
    [sym__maybe_tuple_expression] = STATE(1863),
    [sym_tuple_access] = STATE(81),
    [sym__maybe_record_expression] = STATE(1862),
    [sym_field_access] = STATE(81),
    [sym__maybe_function_expression] = STATE(1652),
    [sym_function_call] = STATE(81),
    [sym_string] = STATE(134),
    [sym_integer] = STATE(134),
    [sym_identifier] = STATE(74),
    [sym_constructor_name] = STATE(39),
    [sym_remote_constructor_name] = STATE(39),
    [ts_builtin_sym_end] = ACTIONS(309),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(311),
    [anon_sym_LBRACE] = ACTIONS(313),
    [anon_sym_AT] = ACTIONS(309),
    [anon_sym_import] = ACTIONS(311),
    [anon_sym_type] = ACTIONS(311),
    [anon_sym_const] = ACTIONS(311),
    [anon_sym_POUND] = ACTIONS(316),
    [anon_sym_LBRACK] = ACTIONS(319),
    [anon_sym_LT_LT] = ACTIONS(322),
    [anon_sym_DASH] = ACTIONS(325),
    [anon_sym_fn] = ACTIONS(328),
    [anon_sym_external] = ACTIONS(311),
    [anon_sym_todo] = ACTIONS(331),
    [anon_sym_panic] = ACTIONS(334),
    [anon_sym_echo] = ACTIONS(337),
    [anon_sym_case] = ACTIONS(340),
    [anon_sym_let] = ACTIONS(343),
    [anon_sym_assert] = ACTIONS(346),
    [anon_sym_use] = ACTIONS(349),
    [anon_sym_BANG] = ACTIONS(352),
    [sym_visibility_modifier] = ACTIONS(311),
    [sym_opacity_modifier] = ACTIONS(311),
    [anon_sym_DQUOTE] = ACTIONS(355),
    [sym_float] = ACTIONS(358),
    [sym__hex] = ACTIONS(361),
    [sym__decimal] = ACTIONS(364),
    [sym__octal] = ACTIONS(361),
    [sym__binary] = ACTIONS(361),
    [sym__name] = ACTIONS(367),
    [sym__upname] = ACTIONS(370),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(377), 1,
      anon_sym_LPAREN,
    STATE(67), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(375), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(373), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [73] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(381), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(379), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [141] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(385), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(383), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [209] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(389), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(387), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [277] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(393), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(391), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [345] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(397), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(395), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [413] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(401), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(399), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [481] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(405), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(403), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [549] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(409), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(407), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [617] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(413), 1,
      anon_sym_RBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(421), 1,
      anon_sym_DASH,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(425), 1,
      anon_sym_todo,
    ACTIONS(427), 1,
      anon_sym_panic,
    ACTIONS(429), 1,
      anon_sym_echo,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(433), 1,
      anon_sym_let,
    ACTIONS(435), 1,
      anon_sym_assert,
    ACTIONS(437), 1,
      anon_sym_use,
    ACTIONS(439), 1,
      anon_sym_BANG,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(443), 1,
      sym_float,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1826), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(49), 6,
      aux_sym__statement_seq,
      sym__statement,
      sym_let_assert,
      sym_assert,
      sym_let,
      sym_use,
    STATE(515), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [745] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(455), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(453), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [813] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(421), 1,
      anon_sym_DASH,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(425), 1,
      anon_sym_todo,
    ACTIONS(427), 1,
      anon_sym_panic,
    ACTIONS(429), 1,
      anon_sym_echo,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(433), 1,
      anon_sym_let,
    ACTIONS(435), 1,
      anon_sym_assert,
    ACTIONS(437), 1,
      anon_sym_use,
    ACTIONS(439), 1,
      anon_sym_BANG,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(443), 1,
      sym_float,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(457), 1,
      anon_sym_RBRACE,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1826), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(31), 6,
      aux_sym__statement_seq,
      sym__statement,
      sym_let_assert,
      sym_assert,
      sym_let,
      sym_use,
    STATE(515), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [941] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(459), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(461), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [1013] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(468), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(459), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(461), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [1085] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(421), 1,
      anon_sym_DASH,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(425), 1,
      anon_sym_todo,
    ACTIONS(427), 1,
      anon_sym_panic,
    ACTIONS(429), 1,
      anon_sym_echo,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(433), 1,
      anon_sym_let,
    ACTIONS(435), 1,
      anon_sym_assert,
    ACTIONS(437), 1,
      anon_sym_use,
    ACTIONS(439), 1,
      anon_sym_BANG,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(443), 1,
      sym_float,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(472), 1,
      anon_sym_RBRACE,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1826), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(40), 6,
      aux_sym__statement_seq,
      sym__statement,
      sym_let_assert,
      sym_assert,
      sym_let,
      sym_use,
    STATE(515), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1213] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(476), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(474), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1281] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(421), 1,
      anon_sym_DASH,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(425), 1,
      anon_sym_todo,
    ACTIONS(427), 1,
      anon_sym_panic,
    ACTIONS(429), 1,
      anon_sym_echo,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(433), 1,
      anon_sym_let,
    ACTIONS(435), 1,
      anon_sym_assert,
    ACTIONS(437), 1,
      anon_sym_use,
    ACTIONS(439), 1,
      anon_sym_BANG,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(443), 1,
      sym_float,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(478), 1,
      anon_sym_RBRACE,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1826), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(46), 6,
      aux_sym__statement_seq,
      sym__statement,
      sym_let_assert,
      sym_assert,
      sym_let,
      sym_use,
    STATE(515), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1409] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(421), 1,
      anon_sym_DASH,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(425), 1,
      anon_sym_todo,
    ACTIONS(427), 1,
      anon_sym_panic,
    ACTIONS(429), 1,
      anon_sym_echo,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(433), 1,
      anon_sym_let,
    ACTIONS(435), 1,
      anon_sym_assert,
    ACTIONS(437), 1,
      anon_sym_use,
    ACTIONS(439), 1,
      anon_sym_BANG,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(443), 1,
      sym_float,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(480), 1,
      anon_sym_RBRACE,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1826), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(49), 6,
      aux_sym__statement_seq,
      sym__statement,
      sym_let_assert,
      sym_assert,
      sym_let,
      sym_use,
    STATE(515), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1537] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(484), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(482), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1605] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(421), 1,
      anon_sym_DASH,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(425), 1,
      anon_sym_todo,
    ACTIONS(427), 1,
      anon_sym_panic,
    ACTIONS(429), 1,
      anon_sym_echo,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(433), 1,
      anon_sym_let,
    ACTIONS(435), 1,
      anon_sym_assert,
    ACTIONS(437), 1,
      anon_sym_use,
    ACTIONS(439), 1,
      anon_sym_BANG,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(443), 1,
      sym_float,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(486), 1,
      anon_sym_RBRACE,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1826), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(23), 6,
      aux_sym__statement_seq,
      sym__statement,
      sym_let_assert,
      sym_assert,
      sym_let,
      sym_use,
    STATE(515), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1733] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(421), 1,
      anon_sym_DASH,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(425), 1,
      anon_sym_todo,
    ACTIONS(427), 1,
      anon_sym_panic,
    ACTIONS(429), 1,
      anon_sym_echo,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(433), 1,
      anon_sym_let,
    ACTIONS(435), 1,
      anon_sym_assert,
    ACTIONS(437), 1,
      anon_sym_use,
    ACTIONS(439), 1,
      anon_sym_BANG,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(443), 1,
      sym_float,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(488), 1,
      anon_sym_RBRACE,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1826), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(49), 6,
      aux_sym__statement_seq,
      sym__statement,
      sym_let_assert,
      sym_assert,
      sym_let,
      sym_use,
    STATE(515), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1861] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(421), 1,
      anon_sym_DASH,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(425), 1,
      anon_sym_todo,
    ACTIONS(427), 1,
      anon_sym_panic,
    ACTIONS(429), 1,
      anon_sym_echo,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(433), 1,
      anon_sym_let,
    ACTIONS(435), 1,
      anon_sym_assert,
    ACTIONS(437), 1,
      anon_sym_use,
    ACTIONS(439), 1,
      anon_sym_BANG,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(443), 1,
      sym_float,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(490), 1,
      anon_sym_RBRACE,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1826), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(34), 6,
      aux_sym__statement_seq,
      sym__statement,
      sym_let_assert,
      sym_assert,
      sym_let,
      sym_use,
    STATE(515), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1989] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(421), 1,
      anon_sym_DASH,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(425), 1,
      anon_sym_todo,
    ACTIONS(427), 1,
      anon_sym_panic,
    ACTIONS(429), 1,
      anon_sym_echo,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(433), 1,
      anon_sym_let,
    ACTIONS(435), 1,
      anon_sym_assert,
    ACTIONS(437), 1,
      anon_sym_use,
    ACTIONS(439), 1,
      anon_sym_BANG,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(443), 1,
      sym_float,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(492), 1,
      anon_sym_RBRACE,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1826), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(49), 6,
      aux_sym__statement_seq,
      sym__statement,
      sym_let_assert,
      sym_assert,
      sym_let,
      sym_use,
    STATE(515), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2117] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(496), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(494), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [2185] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(421), 1,
      anon_sym_DASH,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(425), 1,
      anon_sym_todo,
    ACTIONS(427), 1,
      anon_sym_panic,
    ACTIONS(429), 1,
      anon_sym_echo,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(433), 1,
      anon_sym_let,
    ACTIONS(435), 1,
      anon_sym_assert,
    ACTIONS(437), 1,
      anon_sym_use,
    ACTIONS(439), 1,
      anon_sym_BANG,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(443), 1,
      sym_float,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(498), 1,
      anon_sym_RBRACE,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1826), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(36), 6,
      aux_sym__statement_seq,
      sym__statement,
      sym_let_assert,
      sym_assert,
      sym_let,
      sym_use,
    STATE(515), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2313] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(500), 1,
      anon_sym_LPAREN,
    STATE(114), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(375), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(373), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [2385] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(421), 1,
      anon_sym_DASH,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(425), 1,
      anon_sym_todo,
    ACTIONS(427), 1,
      anon_sym_panic,
    ACTIONS(429), 1,
      anon_sym_echo,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(433), 1,
      anon_sym_let,
    ACTIONS(435), 1,
      anon_sym_assert,
    ACTIONS(437), 1,
      anon_sym_use,
    ACTIONS(439), 1,
      anon_sym_BANG,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(443), 1,
      sym_float,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(502), 1,
      anon_sym_RBRACE,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1826), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(49), 6,
      aux_sym__statement_seq,
      sym__statement,
      sym_let_assert,
      sym_assert,
      sym_let,
      sym_use,
    STATE(515), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2513] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(506), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(504), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [2581] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(510), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(508), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [2649] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(514), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(512), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [2717] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(421), 1,
      anon_sym_DASH,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(425), 1,
      anon_sym_todo,
    ACTIONS(427), 1,
      anon_sym_panic,
    ACTIONS(429), 1,
      anon_sym_echo,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(433), 1,
      anon_sym_let,
    ACTIONS(435), 1,
      anon_sym_assert,
    ACTIONS(437), 1,
      anon_sym_use,
    ACTIONS(439), 1,
      anon_sym_BANG,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(443), 1,
      sym_float,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(516), 1,
      anon_sym_RBRACE,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1826), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(45), 6,
      aux_sym__statement_seq,
      sym__statement,
      sym_let_assert,
      sym_assert,
      sym_let,
      sym_use,
    STATE(515), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2845] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(421), 1,
      anon_sym_DASH,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(425), 1,
      anon_sym_todo,
    ACTIONS(427), 1,
      anon_sym_panic,
    ACTIONS(429), 1,
      anon_sym_echo,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(433), 1,
      anon_sym_let,
    ACTIONS(435), 1,
      anon_sym_assert,
    ACTIONS(437), 1,
      anon_sym_use,
    ACTIONS(439), 1,
      anon_sym_BANG,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(443), 1,
      sym_float,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(518), 1,
      anon_sym_RBRACE,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1826), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(49), 6,
      aux_sym__statement_seq,
      sym__statement,
      sym_let_assert,
      sym_assert,
      sym_let,
      sym_use,
    STATE(515), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2973] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(421), 1,
      anon_sym_DASH,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(425), 1,
      anon_sym_todo,
    ACTIONS(427), 1,
      anon_sym_panic,
    ACTIONS(429), 1,
      anon_sym_echo,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(433), 1,
      anon_sym_let,
    ACTIONS(435), 1,
      anon_sym_assert,
    ACTIONS(437), 1,
      anon_sym_use,
    ACTIONS(439), 1,
      anon_sym_BANG,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(443), 1,
      sym_float,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(520), 1,
      anon_sym_RBRACE,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1826), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(49), 6,
      aux_sym__statement_seq,
      sym__statement,
      sym_let_assert,
      sym_assert,
      sym_let,
      sym_use,
    STATE(515), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [3101] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(524), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(522), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3169] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(528), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(526), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3237] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(245), 1,
      anon_sym_RBRACE,
    ACTIONS(530), 1,
      anon_sym_LBRACE,
    ACTIONS(533), 1,
      anon_sym_POUND,
    ACTIONS(536), 1,
      anon_sym_LBRACK,
    ACTIONS(539), 1,
      anon_sym_LT_LT,
    ACTIONS(542), 1,
      anon_sym_DASH,
    ACTIONS(545), 1,
      anon_sym_fn,
    ACTIONS(548), 1,
      anon_sym_todo,
    ACTIONS(551), 1,
      anon_sym_panic,
    ACTIONS(554), 1,
      anon_sym_echo,
    ACTIONS(557), 1,
      anon_sym_case,
    ACTIONS(560), 1,
      anon_sym_let,
    ACTIONS(563), 1,
      anon_sym_assert,
    ACTIONS(566), 1,
      anon_sym_use,
    ACTIONS(569), 1,
      anon_sym_BANG,
    ACTIONS(572), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_float,
    ACTIONS(581), 1,
      sym__decimal,
    ACTIONS(584), 1,
      sym__name,
    ACTIONS(587), 1,
      sym__upname,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1826), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(578), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(49), 6,
      aux_sym__statement_seq,
      sym__statement,
      sym_let_assert,
      sym_assert,
      sym_let,
      sym_use,
    STATE(515), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [3365] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(592), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(590), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3432] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(528), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(526), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3499] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(496), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(494), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3566] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(510), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(508), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3633] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(514), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(512), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3700] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(596), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(594), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3767] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(602), 1,
      anon_sym_LPAREN,
    ACTIONS(604), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(600), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(598), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3838] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(506), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(504), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3905] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(608), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(606), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3972] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(610), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(598), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(600), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [4041] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(614), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(612), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4108] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(405), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(403), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4175] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(620), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(616), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(618), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [4244] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(622), 1,
      anon_sym_LPAREN,
    ACTIONS(624), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(618), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(616), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4315] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(628), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(626), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4382] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(632), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(630), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4449] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(636), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(634), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4516] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(640), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(638), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4583] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(385), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(383), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4650] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(642), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(459), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(461), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [4719] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(455), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(453), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4786] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(381), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(379), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4853] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(401), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(399), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4920] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(397), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(395), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4987] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(644), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(461), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(459), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5058] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(524), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(522), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5125] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(648), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(459), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(461), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [5194] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(476), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(474), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5261] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(459), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(461), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [5330] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(484), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(482), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5397] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(409), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(407), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5464] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(461), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(459), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5535] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(389), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(387), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5602] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(393), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(391), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5669] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(650), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(652), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [5735] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(654), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(656), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [5801] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(666), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(668), 1,
      anon_sym_AMP_AMP,
    ACTIONS(676), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(662), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(664), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(670), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(678), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(672), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(674), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(680), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(658), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(660), 19,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [5887] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(682), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(684), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [5953] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(636), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(634), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6019] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(686), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(688), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [6085] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(690), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(692), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [6151] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(461), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(459), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6219] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(648), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(461), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(459), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6287] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(642), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(461), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(459), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6355] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(694), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(696), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [6421] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(698), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(700), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [6487] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(614), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(612), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6553] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(666), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(668), 1,
      anon_sym_AMP_AMP,
    ACTIONS(676), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(662), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(664), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(670), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(678), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(672), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(674), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(680), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(702), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(704), 19,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [6639] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(596), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(594), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6705] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(706), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(708), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [6771] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(710), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(712), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [6837] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(714), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(716), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [6903] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(718), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(720), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [6969] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(666), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(668), 1,
      anon_sym_AMP_AMP,
    ACTIONS(676), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(662), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(664), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(670), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(678), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(672), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(674), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(680), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(722), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(724), 19,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [7055] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(666), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(668), 1,
      anon_sym_AMP_AMP,
    ACTIONS(676), 1,
      anon_sym_PIPE_GT,
    ACTIONS(730), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(662), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(664), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(670), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(678), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(672), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(674), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(680), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(726), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(728), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [7143] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(732), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(734), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [7209] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(676), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(662), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(664), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(678), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(672), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(674), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(680), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(710), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(712), 19,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [7289] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(736), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(738), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [7355] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(632), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(630), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7421] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(740), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(742), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [7487] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(666), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(668), 1,
      anon_sym_AMP_AMP,
    ACTIONS(676), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(662), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(664), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(670), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(678), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(672), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(674), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(680), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(744), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(746), 19,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [7573] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(666), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(668), 1,
      anon_sym_AMP_AMP,
    ACTIONS(676), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(662), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(664), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(670), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(678), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(672), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(674), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(680), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(748), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(750), 19,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [7659] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(484), 21,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(482), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7725] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(752), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(754), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [7791] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(640), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(638), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7857] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(710), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(712), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [7923] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(756), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(758), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [7989] = 8,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(662), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(664), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(678), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(680), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(710), 21,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(712), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8063] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(760), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(762), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8129] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(628), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(626), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8195] = 9,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(676), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(662), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(664), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(678), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(680), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(710), 20,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(712), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8271] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(608), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(606), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8337] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(592), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(590), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8403] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(764), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(767), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8469] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(770), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(772), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8535] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(676), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(662), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(664), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(670), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(678), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(672), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(674), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(680), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(710), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(712), 19,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8617] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(668), 1,
      anon_sym_AMP_AMP,
    ACTIONS(676), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(662), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(664), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(670), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(678), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(672), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(674), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(680), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(710), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(712), 19,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8701] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(662), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(680), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(710), 23,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(712), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8771] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(716), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(714), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8836] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(656), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(654), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8901] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(778), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(780), 1,
      anon_sym_AMP_AMP,
    ACTIONS(788), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(774), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(776), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(782), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(790), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(784), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(786), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(792), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(748), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(750), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8986] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(778), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(780), 1,
      anon_sym_AMP_AMP,
    ACTIONS(788), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(774), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(776), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(782), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(790), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(784), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(786), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(792), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(794), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(796), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [9071] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(712), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(710), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9136] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(778), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(780), 1,
      anon_sym_AMP_AMP,
    ACTIONS(788), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(774), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(776), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(782), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(790), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(784), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(786), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(792), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(702), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(704), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [9221] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(778), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(780), 1,
      anon_sym_AMP_AMP,
    ACTIONS(788), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(774), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(776), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(782), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(790), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(784), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(786), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(792), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(798), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(800), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [9306] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(708), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(706), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9371] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(692), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(690), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9436] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(738), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(736), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9501] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(734), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(732), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9566] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(696), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(694), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9631] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(684), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(682), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9696] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(688), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(686), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9761] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(754), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(752), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9826] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(778), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(780), 1,
      anon_sym_AMP_AMP,
    ACTIONS(788), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(774), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(776), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(782), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(790), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(784), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(786), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(792), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(744), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(746), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [9911] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(652), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(650), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9976] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(778), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(780), 1,
      anon_sym_AMP_AMP,
    ACTIONS(788), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(774), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(776), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(782), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(790), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(784), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(786), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(792), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(802), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(804), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [10061] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(720), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(718), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10126] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(767), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(764), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10191] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(778), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(780), 1,
      anon_sym_AMP_AMP,
    ACTIONS(788), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(774), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(776), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(782), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(790), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(784), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(786), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(792), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(806), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(808), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [10276] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(742), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(740), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10341] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(774), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(792), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(710), 23,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(712), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [10410] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(409), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(407), 34,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10475] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(778), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(780), 1,
      anon_sym_AMP_AMP,
    ACTIONS(788), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(774), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(776), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(782), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(790), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(784), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(786), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(792), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(810), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(812), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [10560] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(758), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(756), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10625] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(780), 1,
      anon_sym_AMP_AMP,
    ACTIONS(788), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(774), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(776), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(782), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(790), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(784), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(786), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(792), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(710), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(712), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [10708] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(788), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(774), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(776), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(782), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(790), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(784), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(786), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(792), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(710), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(712), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [10789] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(788), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(774), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(776), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(790), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(784), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(786), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(792), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(710), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(712), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [10868] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(778), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(780), 1,
      anon_sym_AMP_AMP,
    ACTIONS(788), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(774), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(776), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(782), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(790), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(784), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(786), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(792), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(722), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(724), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [10953] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(762), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(760), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11018] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(778), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(780), 1,
      anon_sym_AMP_AMP,
    ACTIONS(788), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(774), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(776), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(782), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(790), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(784), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(786), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(792), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(658), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(660), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [11103] = 9,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(788), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(774), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(776), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(790), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(792), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(710), 20,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(712), 22,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [11178] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(772), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(770), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11243] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(700), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(698), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11308] = 8,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(774), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(776), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(790), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(792), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(710), 21,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(712), 22,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [11381] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(712), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(710), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11446] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(814), 1,
      anon_sym_RPAREN,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(818), 1,
      anon_sym_DOT_DOT,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1592), 1,
      sym_argument,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [11572] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    ACTIONS(828), 1,
      anon_sym_RPAREN,
    ACTIONS(830), 1,
      anon_sym_DOT_DOT,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1553), 1,
      sym_argument,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [11698] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    ACTIONS(832), 1,
      anon_sym_RPAREN,
    ACTIONS(834), 1,
      anon_sym_DOT_DOT,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1554), 1,
      sym_argument,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [11824] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    ACTIONS(836), 1,
      anon_sym_RPAREN,
    ACTIONS(838), 1,
      anon_sym_DOT_DOT,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1498), 1,
      sym_argument,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [11950] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    ACTIONS(840), 1,
      anon_sym_RPAREN,
    ACTIONS(842), 1,
      anon_sym_DOT_DOT,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1560), 1,
      sym_argument,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [12076] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(393), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(391), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12140] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(476), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(474), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12204] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(405), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(403), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12268] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    ACTIONS(844), 1,
      anon_sym_RPAREN,
    ACTIONS(846), 1,
      anon_sym_DOT_DOT,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1438), 1,
      sym_argument,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [12394] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    ACTIONS(848), 1,
      anon_sym_RPAREN,
    ACTIONS(850), 1,
      anon_sym_DOT_DOT,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1524), 1,
      sym_argument,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [12520] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    ACTIONS(852), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1702), 1,
      sym_argument,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [12643] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    ACTIONS(854), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1702), 1,
      sym_argument,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [12766] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    ACTIONS(856), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1702), 1,
      sym_argument,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [12889] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    ACTIONS(858), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1702), 1,
      sym_argument,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [13012] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    ACTIONS(860), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1702), 1,
      sym_argument,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [13135] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    ACTIONS(862), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1702), 1,
      sym_argument,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [13258] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    ACTIONS(864), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1702), 1,
      sym_argument,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [13381] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    ACTIONS(866), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1702), 1,
      sym_argument,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [13504] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    ACTIONS(844), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1438), 1,
      sym_argument,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [13627] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    ACTIONS(848), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1524), 1,
      sym_argument,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [13750] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(814), 1,
      anon_sym_RPAREN,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1592), 1,
      sym_argument,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [13873] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    ACTIONS(828), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1553), 1,
      sym_argument,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [13996] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(868), 1,
      anon_sym_LPAREN,
    STATE(223), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(375), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(373), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14063] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    ACTIONS(836), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1498), 1,
      sym_argument,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [14186] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    ACTIONS(870), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1702), 1,
      sym_argument,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [14309] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    ACTIONS(832), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1554), 1,
      sym_argument,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [14432] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    ACTIONS(872), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1702), 1,
      sym_argument,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [14555] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    ACTIONS(840), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1560), 1,
      sym_argument,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [14678] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    ACTIONS(874), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1702), 1,
      sym_argument,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [14801] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    ACTIONS(876), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1702), 1,
      sym_argument,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [14924] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    ACTIONS(878), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1702), 1,
      sym_argument,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [15047] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    ACTIONS(880), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1702), 1,
      sym_argument,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [15170] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(708), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(706), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15232] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(822), 1,
      sym_float,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(826), 1,
      sym__name,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1648), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1702), 1,
      sym_argument,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1844), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(927), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [15352] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(824), 1,
      sym__discard_name,
    ACTIONS(884), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1630), 1,
      sym_hole,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(882), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(919), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [15470] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(385), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(383), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15532] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(528), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(526), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15594] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(461), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(459), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15660] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(514), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(512), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15722] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(716), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(714), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15784] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(455), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(453), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15846] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(524), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(522), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15908] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(389), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(387), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15970] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(506), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(504), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16032] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(397), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(395), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16094] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(510), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(508), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16156] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(886), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(461), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(459), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16222] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(401), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(399), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16284] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(496), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(494), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16346] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(642), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(461), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(459), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16409] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(632), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(630), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16470] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(592), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(590), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16531] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(636), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(634), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16592] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(648), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(461), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(459), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16655] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(596), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(594), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16716] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(461), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(459), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16779] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(614), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(612), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16840] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(890), 1,
      anon_sym_LPAREN,
    STATE(293), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(375), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(373), 27,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16905] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(640), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(638), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16966] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(608), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(606), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [17027] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(628), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(626), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [17088] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(720), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(718), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [17148] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(455), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(453), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [17208] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(892), 1,
      anon_sym_RBRACK,
    ACTIONS(894), 1,
      anon_sym_DOT_DOT,
    ACTIONS(896), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17322] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(656), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(654), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [17382] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(898), 1,
      anon_sym_RBRACK,
    ACTIONS(900), 1,
      anon_sym_DOT_DOT,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17496] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(902), 1,
      anon_sym_RBRACK,
    ACTIONS(904), 1,
      anon_sym_DOT_DOT,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17610] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(908), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(906), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(923), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17722] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(767), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(764), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [17782] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(652), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(650), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [17842] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(910), 1,
      anon_sym_RBRACK,
    ACTIONS(912), 1,
      anon_sym_DOT_DOT,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17956] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(742), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(740), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [18016] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(914), 1,
      anon_sym_RBRACK,
    ACTIONS(916), 1,
      anon_sym_DOT_DOT,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18130] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(405), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(403), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [18190] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(758), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(756), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [18250] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(762), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(760), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [18310] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(772), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(770), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [18370] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(738), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(736), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [18430] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(918), 1,
      anon_sym_RBRACK,
    ACTIONS(920), 1,
      anon_sym_DOT_DOT,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18544] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(922), 1,
      anon_sym_RBRACK,
    ACTIONS(924), 1,
      anon_sym_DOT_DOT,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18658] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(734), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(732), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [18718] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(696), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(694), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [18778] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(754), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(752), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [18838] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(465), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(461), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(459), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [18902] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(926), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(461), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(459), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [18966] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(930), 1,
      anon_sym_RBRACK,
    ACTIONS(932), 1,
      anon_sym_DOT_DOT,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19080] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(700), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(698), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [19140] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(385), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(383), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [19200] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(684), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(682), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [19260] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(934), 1,
      anon_sym_RBRACK,
    ACTIONS(936), 1,
      anon_sym_DOT_DOT,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19374] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(506), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(504), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [19434] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(938), 1,
      anon_sym_RBRACK,
    ACTIONS(940), 1,
      anon_sym_DOT_DOT,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19548] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(942), 1,
      anon_sym_RBRACK,
    ACTIONS(944), 1,
      anon_sym_DOT_DOT,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19662] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(946), 1,
      anon_sym_RBRACK,
    ACTIONS(948), 1,
      anon_sym_DOT_DOT,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19776] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(409), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(407), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [19836] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(514), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(512), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [19896] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(950), 1,
      anon_sym_RBRACK,
    ACTIONS(952), 1,
      anon_sym_DOT_DOT,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20010] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(692), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(690), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [20070] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(484), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(482), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [20130] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(476), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(474), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [20190] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(528), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(526), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [20250] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(954), 1,
      anon_sym_RBRACK,
    ACTIONS(956), 1,
      anon_sym_DOT_DOT,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20364] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(381), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(379), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [20424] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(389), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(387), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [20484] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(393), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(391), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [20544] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(397), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(395), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [20604] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(401), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(399), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [20664] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(524), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(522), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [20724] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(496), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(494), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [20784] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(510), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(508), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [20844] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(688), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(686), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [20904] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(235), 1,
      anon_sym_todo,
    ACTIONS(237), 1,
      anon_sym_panic,
    ACTIONS(958), 1,
      anon_sym_DASH,
    ACTIONS(960), 1,
      anon_sym_echo,
    ACTIONS(962), 1,
      anon_sym_BANG,
    ACTIONS(964), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(718), 1,
      sym_pipeline_echo,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(910), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21015] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(235), 1,
      anon_sym_todo,
    ACTIONS(237), 1,
      anon_sym_panic,
    ACTIONS(239), 1,
      anon_sym_echo,
    ACTIONS(958), 1,
      anon_sym_DASH,
    ACTIONS(962), 1,
      anon_sym_BANG,
    ACTIONS(966), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1813), 1,
      sym_case_subjects,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(878), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21126] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(596), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(594), 27,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [21185] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_POUND,
    ACTIONS(207), 1,
      anon_sym_LBRACK,
    ACTIONS(209), 1,
      anon_sym_LT_LT,
    ACTIONS(211), 1,
      anon_sym_fn,
    ACTIONS(213), 1,
      anon_sym_todo,
    ACTIONS(215), 1,
      anon_sym_panic,
    ACTIONS(219), 1,
      anon_sym_case,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(229), 1,
      sym__decimal,
    ACTIONS(231), 1,
      sym__name,
    ACTIONS(233), 1,
      sym__upname,
    ACTIONS(968), 1,
      anon_sym_DASH,
    ACTIONS(970), 1,
      anon_sym_echo,
    ACTIONS(972), 1,
      anon_sym_BANG,
    ACTIONS(974), 1,
      sym_float,
    STATE(862), 1,
      sym_identifier,
    STATE(933), 1,
      sym_tuple,
    STATE(935), 1,
      sym_anonymous_function,
    STATE(972), 1,
      sym_pipeline_echo,
    STATE(1718), 1,
      sym__maybe_function_expression,
    STATE(1760), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(856), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(931), 2,
      sym_record,
      sym_record_update,
    ACTIONS(227), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(873), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(971), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21296] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(632), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(630), 27,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [21355] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(976), 1,
      anon_sym_RBRACK,
    ACTIONS(978), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(843), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21466] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(980), 1,
      anon_sym_RBRACK,
    ACTIONS(982), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(854), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21577] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(984), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21688] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(628), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(626), 27,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [21747] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(986), 1,
      anon_sym_RBRACK,
    ACTIONS(988), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(853), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21858] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(990), 1,
      anon_sym_RPAREN,
    ACTIONS(992), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(901), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21969] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(994), 1,
      anon_sym_RBRACK,
    ACTIONS(996), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(846), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22080] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(614), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(612), 27,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [22139] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(592), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(590), 27,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [22198] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(998), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22309] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(1000), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22420] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(1002), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22531] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(640), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(638), 27,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [22590] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(235), 1,
      anon_sym_todo,
    ACTIONS(237), 1,
      anon_sym_panic,
    ACTIONS(239), 1,
      anon_sym_echo,
    ACTIONS(958), 1,
      anon_sym_DASH,
    ACTIONS(962), 1,
      anon_sym_BANG,
    ACTIONS(966), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1763), 1,
      sym_case_subjects,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(878), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22701] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(1004), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22812] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(235), 1,
      anon_sym_todo,
    ACTIONS(237), 1,
      anon_sym_panic,
    ACTIONS(239), 1,
      anon_sym_echo,
    ACTIONS(958), 1,
      anon_sym_DASH,
    ACTIONS(962), 1,
      anon_sym_BANG,
    ACTIONS(966), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1800), 1,
      sym_case_subjects,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(878), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22923] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1006), 1,
      anon_sym_RPAREN,
    ACTIONS(1008), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(899), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23034] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(1010), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23145] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1012), 1,
      anon_sym_LBRACE,
    ACTIONS(1014), 1,
      anon_sym_POUND,
    ACTIONS(1016), 1,
      anon_sym_LBRACK,
    ACTIONS(1018), 1,
      anon_sym_LT_LT,
    ACTIONS(1020), 1,
      anon_sym_DASH,
    ACTIONS(1022), 1,
      anon_sym_fn,
    ACTIONS(1024), 1,
      anon_sym_todo,
    ACTIONS(1026), 1,
      anon_sym_panic,
    ACTIONS(1028), 1,
      anon_sym_echo,
    ACTIONS(1030), 1,
      anon_sym_case,
    ACTIONS(1032), 1,
      anon_sym_BANG,
    ACTIONS(1034), 1,
      anon_sym_DQUOTE,
    ACTIONS(1036), 1,
      sym_float,
    ACTIONS(1040), 1,
      sym__decimal,
    ACTIONS(1042), 1,
      sym__name,
    ACTIONS(1044), 1,
      sym__upname,
    STATE(249), 1,
      sym_identifier,
    STATE(311), 1,
      sym_anonymous_function,
    STATE(312), 1,
      sym_tuple,
    STATE(428), 1,
      sym_pipeline_echo,
    STATE(1638), 1,
      sym__maybe_function_expression,
    STATE(1820), 1,
      sym__maybe_record_expression,
    STATE(1825), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(222), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(319), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1038), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(248), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(429), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23256] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(1046), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23367] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1048), 1,
      anon_sym_LBRACE,
    ACTIONS(1050), 1,
      anon_sym_POUND,
    ACTIONS(1052), 1,
      anon_sym_LBRACK,
    ACTIONS(1054), 1,
      anon_sym_LT_LT,
    ACTIONS(1056), 1,
      anon_sym_DASH,
    ACTIONS(1058), 1,
      anon_sym_fn,
    ACTIONS(1060), 1,
      anon_sym_todo,
    ACTIONS(1062), 1,
      anon_sym_panic,
    ACTIONS(1064), 1,
      anon_sym_echo,
    ACTIONS(1066), 1,
      anon_sym_case,
    ACTIONS(1068), 1,
      anon_sym_BANG,
    ACTIONS(1070), 1,
      anon_sym_DQUOTE,
    ACTIONS(1072), 1,
      sym_float,
    ACTIONS(1076), 1,
      sym__decimal,
    ACTIONS(1078), 1,
      sym__name,
    ACTIONS(1080), 1,
      sym__upname,
    STATE(27), 1,
      sym_identifier,
    STATE(76), 1,
      sym_tuple,
    STATE(78), 1,
      sym_anonymous_function,
    STATE(115), 1,
      sym_pipeline_echo,
    STATE(1608), 1,
      sym__maybe_function_expression,
    STATE(1809), 1,
      sym__maybe_record_expression,
    STATE(1876), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(14), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(69), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1074), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(26), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(117), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23478] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(1082), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23589] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1084), 1,
      anon_sym_RPAREN,
    ACTIONS(1086), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(865), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23700] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(608), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(606), 27,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [23759] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(636), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(634), 27,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [23818] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1088), 1,
      anon_sym_RPAREN,
    ACTIONS(1090), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(900), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23929] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(235), 1,
      anon_sym_todo,
    ACTIONS(237), 1,
      anon_sym_panic,
    ACTIONS(239), 1,
      anon_sym_echo,
    ACTIONS(958), 1,
      anon_sym_DASH,
    ACTIONS(962), 1,
      anon_sym_BANG,
    ACTIONS(966), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1824), 1,
      sym_case_subjects,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(878), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24040] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(235), 1,
      anon_sym_todo,
    ACTIONS(237), 1,
      anon_sym_panic,
    ACTIONS(239), 1,
      anon_sym_echo,
    ACTIONS(958), 1,
      anon_sym_DASH,
    ACTIONS(962), 1,
      anon_sym_BANG,
    ACTIONS(966), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1794), 1,
      sym_case_subjects,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(878), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24151] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(189), 1,
      anon_sym_LBRACE,
    ACTIONS(191), 1,
      anon_sym_fn,
    ACTIONS(193), 1,
      anon_sym_todo,
    ACTIONS(195), 1,
      anon_sym_panic,
    ACTIONS(199), 1,
      anon_sym_case,
    ACTIONS(1092), 1,
      anon_sym_POUND,
    ACTIONS(1094), 1,
      anon_sym_LBRACK,
    ACTIONS(1096), 1,
      anon_sym_LT_LT,
    ACTIONS(1098), 1,
      anon_sym_DASH,
    ACTIONS(1100), 1,
      anon_sym_echo,
    ACTIONS(1102), 1,
      anon_sym_BANG,
    ACTIONS(1104), 1,
      anon_sym_DQUOTE,
    ACTIONS(1106), 1,
      sym_float,
    ACTIONS(1110), 1,
      sym__decimal,
    ACTIONS(1112), 1,
      sym__name,
    ACTIONS(1114), 1,
      sym__upname,
    STATE(563), 1,
      sym_identifier,
    STATE(585), 1,
      sym_tuple,
    STATE(588), 1,
      sym_anonymous_function,
    STATE(612), 1,
      sym_pipeline_echo,
    STATE(1678), 1,
      sym__maybe_function_expression,
    STATE(1782), 1,
      sym__maybe_tuple_expression,
    STATE(1831), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(555), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(584), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1108), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(562), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(590), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24262] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(1116), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24373] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(461), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(459), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [24434] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(648), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(461), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(459), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [24495] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1118), 1,
      anon_sym_RPAREN,
    ACTIONS(1120), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(879), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24606] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1122), 1,
      anon_sym_RBRACK,
    ACTIONS(1124), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(860), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24717] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1126), 1,
      anon_sym_LPAREN,
    ACTIONS(1128), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(600), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(598), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [24780] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1130), 1,
      anon_sym_RBRACK,
    ACTIONS(1132), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(844), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24891] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(235), 1,
      anon_sym_todo,
    ACTIONS(237), 1,
      anon_sym_panic,
    ACTIONS(239), 1,
      anon_sym_echo,
    ACTIONS(958), 1,
      anon_sym_DASH,
    ACTIONS(962), 1,
      anon_sym_BANG,
    ACTIONS(966), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1835), 1,
      sym_case_subjects,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(878), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25002] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(1134), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25113] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(642), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(461), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(459), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [25174] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(1136), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25285] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(381), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(379), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [25344] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1138), 1,
      anon_sym_echo,
    ACTIONS(1140), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(718), 1,
      sym_pipeline_echo,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(804), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25455] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1142), 1,
      anon_sym_LPAREN,
    ACTIONS(1144), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(618), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(616), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [25518] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1146), 1,
      anon_sym_RBRACK,
    ACTIONS(1148), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(845), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25629] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(235), 1,
      anon_sym_todo,
    ACTIONS(237), 1,
      anon_sym_panic,
    ACTIONS(239), 1,
      anon_sym_echo,
    ACTIONS(958), 1,
      anon_sym_DASH,
    ACTIONS(962), 1,
      anon_sym_BANG,
    ACTIONS(966), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    STATE(1846), 1,
      sym_case_subjects,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(878), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25740] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1150), 1,
      anon_sym_RPAREN,
    ACTIONS(1152), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(872), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25851] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1154), 1,
      anon_sym_fn,
    ACTIONS(1156), 1,
      anon_sym_echo,
    ACTIONS(1158), 1,
      sym_float,
    STATE(74), 1,
      sym_identifier,
    STATE(91), 1,
      sym_anonymous_function,
    STATE(92), 1,
      sym_tuple,
    STATE(164), 1,
      sym_pipeline_echo,
    STATE(1652), 1,
      sym__maybe_function_expression,
    STATE(1862), 1,
      sym__maybe_record_expression,
    STATE(1863), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(39), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(93), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(81), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(163), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25962] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1160), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(618), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(616), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26023] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1162), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(600), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(598), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26084] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(421), 1,
      anon_sym_DASH,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(425), 1,
      anon_sym_todo,
    ACTIONS(427), 1,
      anon_sym_panic,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(439), 1,
      anon_sym_BANG,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1164), 1,
      anon_sym_echo,
    ACTIONS(1166), 1,
      sym_float,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(520), 1,
      sym_pipeline_echo,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1826), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(519), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26195] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1168), 1,
      anon_sym_RPAREN,
    ACTIONS(1170), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(881), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26306] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(1172), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26417] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(1174), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26528] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(1176), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26639] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(189), 1,
      anon_sym_LBRACE,
    ACTIONS(191), 1,
      anon_sym_fn,
    ACTIONS(193), 1,
      anon_sym_todo,
    ACTIONS(195), 1,
      anon_sym_panic,
    ACTIONS(197), 1,
      anon_sym_echo,
    ACTIONS(199), 1,
      anon_sym_case,
    ACTIONS(1092), 1,
      anon_sym_POUND,
    ACTIONS(1094), 1,
      anon_sym_LBRACK,
    ACTIONS(1096), 1,
      anon_sym_LT_LT,
    ACTIONS(1098), 1,
      anon_sym_DASH,
    ACTIONS(1102), 1,
      anon_sym_BANG,
    ACTIONS(1104), 1,
      anon_sym_DQUOTE,
    ACTIONS(1110), 1,
      sym__decimal,
    ACTIONS(1112), 1,
      sym__name,
    ACTIONS(1114), 1,
      sym__upname,
    ACTIONS(1178), 1,
      sym_float,
    STATE(563), 1,
      sym_identifier,
    STATE(585), 1,
      sym_tuple,
    STATE(588), 1,
      sym_anonymous_function,
    STATE(1678), 1,
      sym__maybe_function_expression,
    STATE(1782), 1,
      sym__maybe_tuple_expression,
    STATE(1831), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(555), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(584), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1108), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(562), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(622), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26747] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1188), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1180), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1182), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1190), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1184), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1186), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1192), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(712), 12,
      anon_sym_as,
      anon_sym_fn,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(710), 15,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26819] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1194), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(821), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26927] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(93), 1,
      sym_float,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(810), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27035] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(708), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(706), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27093] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1196), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(820), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27201] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1198), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(717), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27309] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1200), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(817), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27417] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1202), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(814), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27525] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1204), 1,
      anon_sym_GT_GT,
    ACTIONS(1206), 1,
      anon_sym_DASH,
    ACTIONS(1208), 1,
      anon_sym_todo,
    ACTIONS(1210), 1,
      anon_sym_panic,
    ACTIONS(1212), 1,
      anon_sym_BANG,
    ACTIONS(1214), 1,
      sym_float,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1727), 1,
      sym_expression_bit_string_segment,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1766), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1434), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27637] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1216), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(813), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27745] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1218), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(808), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27853] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1220), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(807), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27961] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1206), 1,
      anon_sym_DASH,
    ACTIONS(1208), 1,
      anon_sym_todo,
    ACTIONS(1210), 1,
      anon_sym_panic,
    ACTIONS(1212), 1,
      anon_sym_BANG,
    ACTIONS(1214), 1,
      sym_float,
    ACTIONS(1222), 1,
      anon_sym_GT_GT,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1727), 1,
      sym_expression_bit_string_segment,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1766), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1434), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28073] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(235), 1,
      anon_sym_todo,
    ACTIONS(237), 1,
      anon_sym_panic,
    ACTIONS(239), 1,
      anon_sym_echo,
    ACTIONS(958), 1,
      anon_sym_DASH,
    ACTIONS(962), 1,
      anon_sym_BANG,
    ACTIONS(1224), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(915), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28181] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1048), 1,
      anon_sym_LBRACE,
    ACTIONS(1050), 1,
      anon_sym_POUND,
    ACTIONS(1052), 1,
      anon_sym_LBRACK,
    ACTIONS(1054), 1,
      anon_sym_LT_LT,
    ACTIONS(1056), 1,
      anon_sym_DASH,
    ACTIONS(1058), 1,
      anon_sym_fn,
    ACTIONS(1060), 1,
      anon_sym_todo,
    ACTIONS(1062), 1,
      anon_sym_panic,
    ACTIONS(1066), 1,
      anon_sym_case,
    ACTIONS(1068), 1,
      anon_sym_BANG,
    ACTIONS(1070), 1,
      anon_sym_DQUOTE,
    ACTIONS(1076), 1,
      sym__decimal,
    ACTIONS(1078), 1,
      sym__name,
    ACTIONS(1080), 1,
      sym__upname,
    ACTIONS(1226), 1,
      anon_sym_echo,
    ACTIONS(1228), 1,
      sym_float,
    STATE(27), 1,
      sym_identifier,
    STATE(76), 1,
      sym_tuple,
    STATE(78), 1,
      sym_anonymous_function,
    STATE(1608), 1,
      sym__maybe_function_expression,
    STATE(1809), 1,
      sym__maybe_record_expression,
    STATE(1876), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(14), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(69), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1074), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(26), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(111), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28289] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(421), 1,
      anon_sym_DASH,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(425), 1,
      anon_sym_todo,
    ACTIONS(427), 1,
      anon_sym_panic,
    ACTIONS(429), 1,
      anon_sym_echo,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(439), 1,
      anon_sym_BANG,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1230), 1,
      sym_float,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1826), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(509), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28397] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1232), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(954), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28505] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1048), 1,
      anon_sym_LBRACE,
    ACTIONS(1050), 1,
      anon_sym_POUND,
    ACTIONS(1052), 1,
      anon_sym_LBRACK,
    ACTIONS(1054), 1,
      anon_sym_LT_LT,
    ACTIONS(1056), 1,
      anon_sym_DASH,
    ACTIONS(1058), 1,
      anon_sym_fn,
    ACTIONS(1060), 1,
      anon_sym_todo,
    ACTIONS(1062), 1,
      anon_sym_panic,
    ACTIONS(1066), 1,
      anon_sym_case,
    ACTIONS(1068), 1,
      anon_sym_BANG,
    ACTIONS(1070), 1,
      anon_sym_DQUOTE,
    ACTIONS(1076), 1,
      sym__decimal,
    ACTIONS(1078), 1,
      sym__name,
    ACTIONS(1080), 1,
      sym__upname,
    ACTIONS(1226), 1,
      anon_sym_echo,
    ACTIONS(1234), 1,
      sym_float,
    STATE(27), 1,
      sym_identifier,
    STATE(76), 1,
      sym_tuple,
    STATE(78), 1,
      sym_anonymous_function,
    STATE(1608), 1,
      sym__maybe_function_expression,
    STATE(1809), 1,
      sym__maybe_record_expression,
    STATE(1876), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(14), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(69), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1074), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(26), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(110), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28613] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1236), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(991), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28721] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1206), 1,
      anon_sym_DASH,
    ACTIONS(1208), 1,
      anon_sym_todo,
    ACTIONS(1210), 1,
      anon_sym_panic,
    ACTIONS(1212), 1,
      anon_sym_BANG,
    ACTIONS(1214), 1,
      sym_float,
    ACTIONS(1238), 1,
      anon_sym_GT_GT,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1509), 1,
      sym_expression_bit_string_segment,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1766), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1434), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28833] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_echo,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1154), 1,
      anon_sym_fn,
    ACTIONS(1240), 1,
      sym_float,
    STATE(74), 1,
      sym_identifier,
    STATE(91), 1,
      sym_anonymous_function,
    STATE(92), 1,
      sym_tuple,
    STATE(1652), 1,
      sym__maybe_function_expression,
    STATE(1862), 1,
      sym__maybe_record_expression,
    STATE(1863), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(39), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(93), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(81), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(143), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28941] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(189), 1,
      anon_sym_LBRACE,
    ACTIONS(191), 1,
      anon_sym_fn,
    ACTIONS(193), 1,
      anon_sym_todo,
    ACTIONS(195), 1,
      anon_sym_panic,
    ACTIONS(197), 1,
      anon_sym_echo,
    ACTIONS(199), 1,
      anon_sym_case,
    ACTIONS(1092), 1,
      anon_sym_POUND,
    ACTIONS(1094), 1,
      anon_sym_LBRACK,
    ACTIONS(1096), 1,
      anon_sym_LT_LT,
    ACTIONS(1098), 1,
      anon_sym_DASH,
    ACTIONS(1102), 1,
      anon_sym_BANG,
    ACTIONS(1104), 1,
      anon_sym_DQUOTE,
    ACTIONS(1110), 1,
      sym__decimal,
    ACTIONS(1112), 1,
      sym__name,
    ACTIONS(1114), 1,
      sym__upname,
    ACTIONS(1242), 1,
      sym_float,
    STATE(563), 1,
      sym_identifier,
    STATE(585), 1,
      sym_tuple,
    STATE(588), 1,
      sym_anonymous_function,
    STATE(1678), 1,
      sym__maybe_function_expression,
    STATE(1782), 1,
      sym__maybe_tuple_expression,
    STATE(1831), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(555), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(584), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1108), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(562), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(609), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29049] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(189), 1,
      anon_sym_LBRACE,
    ACTIONS(191), 1,
      anon_sym_fn,
    ACTIONS(193), 1,
      anon_sym_todo,
    ACTIONS(195), 1,
      anon_sym_panic,
    ACTIONS(197), 1,
      anon_sym_echo,
    ACTIONS(199), 1,
      anon_sym_case,
    ACTIONS(1092), 1,
      anon_sym_POUND,
    ACTIONS(1094), 1,
      anon_sym_LBRACK,
    ACTIONS(1096), 1,
      anon_sym_LT_LT,
    ACTIONS(1098), 1,
      anon_sym_DASH,
    ACTIONS(1102), 1,
      anon_sym_BANG,
    ACTIONS(1104), 1,
      anon_sym_DQUOTE,
    ACTIONS(1110), 1,
      sym__decimal,
    ACTIONS(1112), 1,
      sym__name,
    ACTIONS(1114), 1,
      sym__upname,
    ACTIONS(1244), 1,
      sym_float,
    STATE(563), 1,
      sym_identifier,
    STATE(585), 1,
      sym_tuple,
    STATE(588), 1,
      sym_anonymous_function,
    STATE(1678), 1,
      sym__maybe_function_expression,
    STATE(1782), 1,
      sym__maybe_tuple_expression,
    STATE(1831), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(555), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(584), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1108), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(562), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(608), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29157] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(189), 1,
      anon_sym_LBRACE,
    ACTIONS(191), 1,
      anon_sym_fn,
    ACTIONS(193), 1,
      anon_sym_todo,
    ACTIONS(195), 1,
      anon_sym_panic,
    ACTIONS(197), 1,
      anon_sym_echo,
    ACTIONS(199), 1,
      anon_sym_case,
    ACTIONS(1092), 1,
      anon_sym_POUND,
    ACTIONS(1094), 1,
      anon_sym_LBRACK,
    ACTIONS(1096), 1,
      anon_sym_LT_LT,
    ACTIONS(1098), 1,
      anon_sym_DASH,
    ACTIONS(1102), 1,
      anon_sym_BANG,
    ACTIONS(1104), 1,
      anon_sym_DQUOTE,
    ACTIONS(1110), 1,
      sym__decimal,
    ACTIONS(1112), 1,
      sym__name,
    ACTIONS(1114), 1,
      sym__upname,
    ACTIONS(1246), 1,
      sym_float,
    STATE(563), 1,
      sym_identifier,
    STATE(585), 1,
      sym_tuple,
    STATE(588), 1,
      sym_anonymous_function,
    STATE(1678), 1,
      sym__maybe_function_expression,
    STATE(1782), 1,
      sym__maybe_tuple_expression,
    STATE(1831), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(555), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(584), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1108), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(562), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(602), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29265] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(189), 1,
      anon_sym_LBRACE,
    ACTIONS(191), 1,
      anon_sym_fn,
    ACTIONS(193), 1,
      anon_sym_todo,
    ACTIONS(195), 1,
      anon_sym_panic,
    ACTIONS(197), 1,
      anon_sym_echo,
    ACTIONS(199), 1,
      anon_sym_case,
    ACTIONS(1092), 1,
      anon_sym_POUND,
    ACTIONS(1094), 1,
      anon_sym_LBRACK,
    ACTIONS(1096), 1,
      anon_sym_LT_LT,
    ACTIONS(1098), 1,
      anon_sym_DASH,
    ACTIONS(1102), 1,
      anon_sym_BANG,
    ACTIONS(1104), 1,
      anon_sym_DQUOTE,
    ACTIONS(1110), 1,
      sym__decimal,
    ACTIONS(1112), 1,
      sym__name,
    ACTIONS(1114), 1,
      sym__upname,
    ACTIONS(1248), 1,
      sym_float,
    STATE(563), 1,
      sym_identifier,
    STATE(585), 1,
      sym_tuple,
    STATE(588), 1,
      sym_anonymous_function,
    STATE(1678), 1,
      sym__maybe_function_expression,
    STATE(1782), 1,
      sym__maybe_tuple_expression,
    STATE(1831), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(555), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(584), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1108), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(562), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(591), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29373] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_echo,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1154), 1,
      anon_sym_fn,
    ACTIONS(1250), 1,
      sym_float,
    STATE(74), 1,
      sym_identifier,
    STATE(91), 1,
      sym_anonymous_function,
    STATE(92), 1,
      sym_tuple,
    STATE(1652), 1,
      sym__maybe_function_expression,
    STATE(1862), 1,
      sym__maybe_record_expression,
    STATE(1863), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(39), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(93), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(81), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(152), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29481] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1252), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(992), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29589] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(189), 1,
      anon_sym_LBRACE,
    ACTIONS(191), 1,
      anon_sym_fn,
    ACTIONS(193), 1,
      anon_sym_todo,
    ACTIONS(195), 1,
      anon_sym_panic,
    ACTIONS(197), 1,
      anon_sym_echo,
    ACTIONS(199), 1,
      anon_sym_case,
    ACTIONS(1092), 1,
      anon_sym_POUND,
    ACTIONS(1094), 1,
      anon_sym_LBRACK,
    ACTIONS(1096), 1,
      anon_sym_LT_LT,
    ACTIONS(1098), 1,
      anon_sym_DASH,
    ACTIONS(1102), 1,
      anon_sym_BANG,
    ACTIONS(1104), 1,
      anon_sym_DQUOTE,
    ACTIONS(1110), 1,
      sym__decimal,
    ACTIONS(1112), 1,
      sym__name,
    ACTIONS(1114), 1,
      sym__upname,
    ACTIONS(1254), 1,
      sym_float,
    STATE(563), 1,
      sym_identifier,
    STATE(585), 1,
      sym_tuple,
    STATE(588), 1,
      sym_anonymous_function,
    STATE(1678), 1,
      sym__maybe_function_expression,
    STATE(1782), 1,
      sym__maybe_tuple_expression,
    STATE(1831), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(555), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(584), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1108), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(562), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(598), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29697] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(716), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(714), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [29755] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1256), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(997), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29863] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(189), 1,
      anon_sym_LBRACE,
    ACTIONS(191), 1,
      anon_sym_fn,
    ACTIONS(193), 1,
      anon_sym_todo,
    ACTIONS(195), 1,
      anon_sym_panic,
    ACTIONS(197), 1,
      anon_sym_echo,
    ACTIONS(199), 1,
      anon_sym_case,
    ACTIONS(1092), 1,
      anon_sym_POUND,
    ACTIONS(1094), 1,
      anon_sym_LBRACK,
    ACTIONS(1096), 1,
      anon_sym_LT_LT,
    ACTIONS(1098), 1,
      anon_sym_DASH,
    ACTIONS(1102), 1,
      anon_sym_BANG,
    ACTIONS(1104), 1,
      anon_sym_DQUOTE,
    ACTIONS(1110), 1,
      sym__decimal,
    ACTIONS(1112), 1,
      sym__name,
    ACTIONS(1114), 1,
      sym__upname,
    ACTIONS(1258), 1,
      sym_float,
    STATE(563), 1,
      sym_identifier,
    STATE(585), 1,
      sym_tuple,
    STATE(588), 1,
      sym_anonymous_function,
    STATE(1678), 1,
      sym__maybe_function_expression,
    STATE(1782), 1,
      sym__maybe_tuple_expression,
    STATE(1831), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(555), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(584), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1108), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(562), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(637), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29971] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(189), 1,
      anon_sym_LBRACE,
    ACTIONS(191), 1,
      anon_sym_fn,
    ACTIONS(193), 1,
      anon_sym_todo,
    ACTIONS(195), 1,
      anon_sym_panic,
    ACTIONS(197), 1,
      anon_sym_echo,
    ACTIONS(199), 1,
      anon_sym_case,
    ACTIONS(1092), 1,
      anon_sym_POUND,
    ACTIONS(1094), 1,
      anon_sym_LBRACK,
    ACTIONS(1096), 1,
      anon_sym_LT_LT,
    ACTIONS(1098), 1,
      anon_sym_DASH,
    ACTIONS(1102), 1,
      anon_sym_BANG,
    ACTIONS(1104), 1,
      anon_sym_DQUOTE,
    ACTIONS(1110), 1,
      sym__decimal,
    ACTIONS(1112), 1,
      sym__name,
    ACTIONS(1114), 1,
      sym__upname,
    ACTIONS(1260), 1,
      sym_float,
    STATE(563), 1,
      sym_identifier,
    STATE(585), 1,
      sym_tuple,
    STATE(588), 1,
      sym_anonymous_function,
    STATE(1678), 1,
      sym__maybe_function_expression,
    STATE(1782), 1,
      sym__maybe_tuple_expression,
    STATE(1831), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(555), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(584), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1108), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(562), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(635), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30079] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_echo,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1154), 1,
      anon_sym_fn,
    ACTIONS(1262), 1,
      sym_float,
    STATE(74), 1,
      sym_identifier,
    STATE(91), 1,
      sym_anonymous_function,
    STATE(92), 1,
      sym_tuple,
    STATE(1652), 1,
      sym__maybe_function_expression,
    STATE(1862), 1,
      sym__maybe_record_expression,
    STATE(1863), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(39), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(93), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(81), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(160), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30187] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1048), 1,
      anon_sym_LBRACE,
    ACTIONS(1050), 1,
      anon_sym_POUND,
    ACTIONS(1052), 1,
      anon_sym_LBRACK,
    ACTIONS(1054), 1,
      anon_sym_LT_LT,
    ACTIONS(1056), 1,
      anon_sym_DASH,
    ACTIONS(1058), 1,
      anon_sym_fn,
    ACTIONS(1060), 1,
      anon_sym_todo,
    ACTIONS(1062), 1,
      anon_sym_panic,
    ACTIONS(1066), 1,
      anon_sym_case,
    ACTIONS(1068), 1,
      anon_sym_BANG,
    ACTIONS(1070), 1,
      anon_sym_DQUOTE,
    ACTIONS(1076), 1,
      sym__decimal,
    ACTIONS(1078), 1,
      sym__name,
    ACTIONS(1080), 1,
      sym__upname,
    ACTIONS(1226), 1,
      anon_sym_echo,
    ACTIONS(1264), 1,
      sym_float,
    STATE(27), 1,
      sym_identifier,
    STATE(76), 1,
      sym_tuple,
    STATE(78), 1,
      sym_anonymous_function,
    STATE(1608), 1,
      sym__maybe_function_expression,
    STATE(1809), 1,
      sym__maybe_record_expression,
    STATE(1876), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(14), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(69), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1074), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(26), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(97), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30295] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_echo,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1154), 1,
      anon_sym_fn,
    ACTIONS(1266), 1,
      sym_float,
    STATE(74), 1,
      sym_identifier,
    STATE(91), 1,
      sym_anonymous_function,
    STATE(92), 1,
      sym_tuple,
    STATE(1652), 1,
      sym__maybe_function_expression,
    STATE(1862), 1,
      sym__maybe_record_expression,
    STATE(1863), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(39), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(93), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(81), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(156), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30403] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_echo,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1154), 1,
      anon_sym_fn,
    ACTIONS(1268), 1,
      sym_float,
    STATE(74), 1,
      sym_identifier,
    STATE(91), 1,
      sym_anonymous_function,
    STATE(92), 1,
      sym_tuple,
    STATE(1652), 1,
      sym__maybe_function_expression,
    STATE(1862), 1,
      sym__maybe_record_expression,
    STATE(1863), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(39), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(93), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(81), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(155), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30511] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_echo,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1154), 1,
      anon_sym_fn,
    ACTIONS(1270), 1,
      sym_float,
    STATE(74), 1,
      sym_identifier,
    STATE(91), 1,
      sym_anonymous_function,
    STATE(92), 1,
      sym_tuple,
    STATE(1652), 1,
      sym__maybe_function_expression,
    STATE(1862), 1,
      sym__maybe_record_expression,
    STATE(1863), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(39), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(93), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(81), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(154), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30619] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_echo,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1154), 1,
      anon_sym_fn,
    ACTIONS(1272), 1,
      sym_float,
    STATE(74), 1,
      sym_identifier,
    STATE(91), 1,
      sym_anonymous_function,
    STATE(92), 1,
      sym_tuple,
    STATE(1652), 1,
      sym__maybe_function_expression,
    STATE(1862), 1,
      sym__maybe_record_expression,
    STATE(1863), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(39), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(93), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(81), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(150), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30727] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_echo,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1154), 1,
      anon_sym_fn,
    ACTIONS(1274), 1,
      sym_float,
    STATE(74), 1,
      sym_identifier,
    STATE(91), 1,
      sym_anonymous_function,
    STATE(92), 1,
      sym_tuple,
    STATE(1652), 1,
      sym__maybe_function_expression,
    STATE(1862), 1,
      sym__maybe_record_expression,
    STATE(1863), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(39), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(93), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(81), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(132), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30835] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(421), 1,
      anon_sym_DASH,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(425), 1,
      anon_sym_todo,
    ACTIONS(427), 1,
      anon_sym_panic,
    ACTIONS(429), 1,
      anon_sym_echo,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(439), 1,
      anon_sym_BANG,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1276), 1,
      sym_float,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1826), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(510), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30943] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(421), 1,
      anon_sym_DASH,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(425), 1,
      anon_sym_todo,
    ACTIONS(427), 1,
      anon_sym_panic,
    ACTIONS(429), 1,
      anon_sym_echo,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(439), 1,
      anon_sym_BANG,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1278), 1,
      sym_float,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1826), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(527), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31051] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1280), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1024), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31159] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1206), 1,
      anon_sym_DASH,
    ACTIONS(1208), 1,
      anon_sym_todo,
    ACTIONS(1210), 1,
      anon_sym_panic,
    ACTIONS(1212), 1,
      anon_sym_BANG,
    ACTIONS(1214), 1,
      sym_float,
    ACTIONS(1282), 1,
      anon_sym_GT_GT,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1727), 1,
      sym_expression_bit_string_segment,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1766), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1434), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31271] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(235), 1,
      anon_sym_todo,
    ACTIONS(237), 1,
      anon_sym_panic,
    ACTIONS(239), 1,
      anon_sym_echo,
    ACTIONS(958), 1,
      anon_sym_DASH,
    ACTIONS(962), 1,
      anon_sym_BANG,
    ACTIONS(1224), 1,
      sym_float,
    ACTIONS(1284), 1,
      anon_sym_LBRACE,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(915), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31379] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(421), 1,
      anon_sym_DASH,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(425), 1,
      anon_sym_todo,
    ACTIONS(427), 1,
      anon_sym_panic,
    ACTIONS(429), 1,
      anon_sym_echo,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(439), 1,
      anon_sym_BANG,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1287), 1,
      sym_float,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1826), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(526), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31487] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_POUND,
    ACTIONS(207), 1,
      anon_sym_LBRACK,
    ACTIONS(209), 1,
      anon_sym_LT_LT,
    ACTIONS(211), 1,
      anon_sym_fn,
    ACTIONS(213), 1,
      anon_sym_todo,
    ACTIONS(215), 1,
      anon_sym_panic,
    ACTIONS(217), 1,
      anon_sym_echo,
    ACTIONS(219), 1,
      anon_sym_case,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(225), 1,
      sym_float,
    ACTIONS(229), 1,
      sym__decimal,
    ACTIONS(231), 1,
      sym__name,
    ACTIONS(233), 1,
      sym__upname,
    ACTIONS(968), 1,
      anon_sym_DASH,
    ACTIONS(972), 1,
      anon_sym_BANG,
    STATE(862), 1,
      sym_identifier,
    STATE(933), 1,
      sym_tuple,
    STATE(935), 1,
      sym_anonymous_function,
    STATE(1718), 1,
      sym__maybe_function_expression,
    STATE(1760), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(856), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(931), 2,
      sym_record,
      sym_record_update,
    ACTIONS(227), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(873), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(961), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31595] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1206), 1,
      anon_sym_DASH,
    ACTIONS(1208), 1,
      anon_sym_todo,
    ACTIONS(1210), 1,
      anon_sym_panic,
    ACTIONS(1212), 1,
      anon_sym_BANG,
    ACTIONS(1214), 1,
      sym_float,
    ACTIONS(1289), 1,
      anon_sym_GT_GT,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1727), 1,
      sym_expression_bit_string_segment,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1766), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1434), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31707] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_POUND,
    ACTIONS(207), 1,
      anon_sym_LBRACK,
    ACTIONS(209), 1,
      anon_sym_LT_LT,
    ACTIONS(211), 1,
      anon_sym_fn,
    ACTIONS(213), 1,
      anon_sym_todo,
    ACTIONS(215), 1,
      anon_sym_panic,
    ACTIONS(217), 1,
      anon_sym_echo,
    ACTIONS(219), 1,
      anon_sym_case,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(229), 1,
      sym__decimal,
    ACTIONS(231), 1,
      sym__name,
    ACTIONS(233), 1,
      sym__upname,
    ACTIONS(968), 1,
      anon_sym_DASH,
    ACTIONS(972), 1,
      anon_sym_BANG,
    ACTIONS(1291), 1,
      sym_float,
    STATE(862), 1,
      sym_identifier,
    STATE(933), 1,
      sym_tuple,
    STATE(935), 1,
      sym_anonymous_function,
    STATE(1718), 1,
      sym__maybe_function_expression,
    STATE(1760), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(856), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(931), 2,
      sym_record,
      sym_record_update,
    ACTIONS(227), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(873), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(993), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31815] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_POUND,
    ACTIONS(207), 1,
      anon_sym_LBRACK,
    ACTIONS(209), 1,
      anon_sym_LT_LT,
    ACTIONS(211), 1,
      anon_sym_fn,
    ACTIONS(213), 1,
      anon_sym_todo,
    ACTIONS(215), 1,
      anon_sym_panic,
    ACTIONS(217), 1,
      anon_sym_echo,
    ACTIONS(219), 1,
      anon_sym_case,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(229), 1,
      sym__decimal,
    ACTIONS(231), 1,
      sym__name,
    ACTIONS(233), 1,
      sym__upname,
    ACTIONS(968), 1,
      anon_sym_DASH,
    ACTIONS(972), 1,
      anon_sym_BANG,
    ACTIONS(1293), 1,
      sym_float,
    STATE(862), 1,
      sym_identifier,
    STATE(933), 1,
      sym_tuple,
    STATE(935), 1,
      sym_anonymous_function,
    STATE(1718), 1,
      sym__maybe_function_expression,
    STATE(1760), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(856), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(931), 2,
      sym_record,
      sym_record_update,
    ACTIONS(227), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(873), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(950), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31923] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_echo,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1154), 1,
      anon_sym_fn,
    ACTIONS(1295), 1,
      sym_float,
    STATE(74), 1,
      sym_identifier,
    STATE(91), 1,
      sym_anonymous_function,
    STATE(92), 1,
      sym_tuple,
    STATE(1652), 1,
      sym__maybe_function_expression,
    STATE(1862), 1,
      sym__maybe_record_expression,
    STATE(1863), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(39), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(93), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(81), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(131), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [32031] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1297), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1006), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [32139] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1299), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1018), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [32247] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(896), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(848), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [32355] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1301), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [32463] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(235), 1,
      anon_sym_todo,
    ACTIONS(237), 1,
      anon_sym_panic,
    ACTIONS(239), 1,
      anon_sym_echo,
    ACTIONS(958), 1,
      anon_sym_DASH,
    ACTIONS(962), 1,
      anon_sym_BANG,
    ACTIONS(1224), 1,
      sym_float,
    ACTIONS(1303), 1,
      anon_sym_LBRACE,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(915), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [32571] = 15,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1188), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1306), 1,
      anon_sym_as,
    ACTIONS(1308), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1310), 1,
      anon_sym_AMP_AMP,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1180), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1182), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1190), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1312), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1184), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1186), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1192), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(726), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(728), 11,
      anon_sym_fn,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
  [32651] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1206), 1,
      anon_sym_DASH,
    ACTIONS(1208), 1,
      anon_sym_todo,
    ACTIONS(1210), 1,
      anon_sym_panic,
    ACTIONS(1212), 1,
      anon_sym_BANG,
    ACTIONS(1214), 1,
      sym_float,
    ACTIONS(1314), 1,
      anon_sym_GT_GT,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1532), 1,
      sym_expression_bit_string_segment,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1766), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1434), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [32763] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1316), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1009), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [32871] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1206), 1,
      anon_sym_DASH,
    ACTIONS(1208), 1,
      anon_sym_todo,
    ACTIONS(1210), 1,
      anon_sym_panic,
    ACTIONS(1212), 1,
      anon_sym_BANG,
    ACTIONS(1214), 1,
      sym_float,
    ACTIONS(1318), 1,
      anon_sym_GT_GT,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1437), 1,
      sym_expression_bit_string_segment,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1766), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1434), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [32983] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1206), 1,
      anon_sym_DASH,
    ACTIONS(1208), 1,
      anon_sym_todo,
    ACTIONS(1210), 1,
      anon_sym_panic,
    ACTIONS(1212), 1,
      anon_sym_BANG,
    ACTIONS(1214), 1,
      sym_float,
    ACTIONS(1320), 1,
      anon_sym_GT_GT,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1727), 1,
      sym_expression_bit_string_segment,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1766), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1434), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [33095] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(189), 1,
      anon_sym_LBRACE,
    ACTIONS(191), 1,
      anon_sym_fn,
    ACTIONS(193), 1,
      anon_sym_todo,
    ACTIONS(195), 1,
      anon_sym_panic,
    ACTIONS(197), 1,
      anon_sym_echo,
    ACTIONS(199), 1,
      anon_sym_case,
    ACTIONS(1092), 1,
      anon_sym_POUND,
    ACTIONS(1094), 1,
      anon_sym_LBRACK,
    ACTIONS(1096), 1,
      anon_sym_LT_LT,
    ACTIONS(1098), 1,
      anon_sym_DASH,
    ACTIONS(1102), 1,
      anon_sym_BANG,
    ACTIONS(1104), 1,
      anon_sym_DQUOTE,
    ACTIONS(1110), 1,
      sym__decimal,
    ACTIONS(1112), 1,
      sym__name,
    ACTIONS(1114), 1,
      sym__upname,
    ACTIONS(1322), 1,
      sym_float,
    STATE(563), 1,
      sym_identifier,
    STATE(585), 1,
      sym_tuple,
    STATE(588), 1,
      sym_anonymous_function,
    STATE(1678), 1,
      sym__maybe_function_expression,
    STATE(1782), 1,
      sym__maybe_tuple_expression,
    STATE(1831), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(555), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(584), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1108), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(562), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(620), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [33203] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1324), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(975), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [33311] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(421), 1,
      anon_sym_DASH,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(425), 1,
      anon_sym_todo,
    ACTIONS(427), 1,
      anon_sym_panic,
    ACTIONS(429), 1,
      anon_sym_echo,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(439), 1,
      anon_sym_BANG,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1326), 1,
      sym_float,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1826), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(511), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [33419] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1328), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(970), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [33527] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_POUND,
    ACTIONS(207), 1,
      anon_sym_LBRACK,
    ACTIONS(209), 1,
      anon_sym_LT_LT,
    ACTIONS(211), 1,
      anon_sym_fn,
    ACTIONS(213), 1,
      anon_sym_todo,
    ACTIONS(215), 1,
      anon_sym_panic,
    ACTIONS(217), 1,
      anon_sym_echo,
    ACTIONS(219), 1,
      anon_sym_case,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(229), 1,
      sym__decimal,
    ACTIONS(231), 1,
      sym__name,
    ACTIONS(233), 1,
      sym__upname,
    ACTIONS(968), 1,
      anon_sym_DASH,
    ACTIONS(972), 1,
      anon_sym_BANG,
    ACTIONS(1330), 1,
      sym_float,
    STATE(862), 1,
      sym_identifier,
    STATE(933), 1,
      sym_tuple,
    STATE(935), 1,
      sym_anonymous_function,
    STATE(1718), 1,
      sym__maybe_function_expression,
    STATE(1760), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(856), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(931), 2,
      sym_record,
      sym_record_update,
    ACTIONS(227), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(873), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(957), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [33635] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1332), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1022), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [33743] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(652), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(650), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33801] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_POUND,
    ACTIONS(207), 1,
      anon_sym_LBRACK,
    ACTIONS(209), 1,
      anon_sym_LT_LT,
    ACTIONS(211), 1,
      anon_sym_fn,
    ACTIONS(213), 1,
      anon_sym_todo,
    ACTIONS(215), 1,
      anon_sym_panic,
    ACTIONS(217), 1,
      anon_sym_echo,
    ACTIONS(219), 1,
      anon_sym_case,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(229), 1,
      sym__decimal,
    ACTIONS(231), 1,
      sym__name,
    ACTIONS(233), 1,
      sym__upname,
    ACTIONS(968), 1,
      anon_sym_DASH,
    ACTIONS(972), 1,
      anon_sym_BANG,
    ACTIONS(1334), 1,
      sym_float,
    STATE(862), 1,
      sym_identifier,
    STATE(933), 1,
      sym_tuple,
    STATE(935), 1,
      sym_anonymous_function,
    STATE(1718), 1,
      sym__maybe_function_expression,
    STATE(1760), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(856), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(931), 2,
      sym_record,
      sym_record_update,
    ACTIONS(227), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(873), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(958), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [33909] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(742), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(740), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33967] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_POUND,
    ACTIONS(207), 1,
      anon_sym_LBRACK,
    ACTIONS(209), 1,
      anon_sym_LT_LT,
    ACTIONS(211), 1,
      anon_sym_fn,
    ACTIONS(213), 1,
      anon_sym_todo,
    ACTIONS(215), 1,
      anon_sym_panic,
    ACTIONS(217), 1,
      anon_sym_echo,
    ACTIONS(219), 1,
      anon_sym_case,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(229), 1,
      sym__decimal,
    ACTIONS(231), 1,
      sym__name,
    ACTIONS(233), 1,
      sym__upname,
    ACTIONS(968), 1,
      anon_sym_DASH,
    ACTIONS(972), 1,
      anon_sym_BANG,
    ACTIONS(1336), 1,
      sym_float,
    STATE(862), 1,
      sym_identifier,
    STATE(933), 1,
      sym_tuple,
    STATE(935), 1,
      sym_anonymous_function,
    STATE(1718), 1,
      sym__maybe_function_expression,
    STATE(1760), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(856), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(931), 2,
      sym_record,
      sym_record_update,
    ACTIONS(227), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(873), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(959), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [34075] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_POUND,
    ACTIONS(207), 1,
      anon_sym_LBRACK,
    ACTIONS(209), 1,
      anon_sym_LT_LT,
    ACTIONS(211), 1,
      anon_sym_fn,
    ACTIONS(213), 1,
      anon_sym_todo,
    ACTIONS(215), 1,
      anon_sym_panic,
    ACTIONS(217), 1,
      anon_sym_echo,
    ACTIONS(219), 1,
      anon_sym_case,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(229), 1,
      sym__decimal,
    ACTIONS(231), 1,
      sym__name,
    ACTIONS(233), 1,
      sym__upname,
    ACTIONS(968), 1,
      anon_sym_DASH,
    ACTIONS(972), 1,
      anon_sym_BANG,
    ACTIONS(1338), 1,
      sym_float,
    STATE(862), 1,
      sym_identifier,
    STATE(933), 1,
      sym_tuple,
    STATE(935), 1,
      sym_anonymous_function,
    STATE(1718), 1,
      sym__maybe_function_expression,
    STATE(1760), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(856), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(931), 2,
      sym_record,
      sym_record_update,
    ACTIONS(227), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(873), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(966), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [34183] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_POUND,
    ACTIONS(207), 1,
      anon_sym_LBRACK,
    ACTIONS(209), 1,
      anon_sym_LT_LT,
    ACTIONS(211), 1,
      anon_sym_fn,
    ACTIONS(213), 1,
      anon_sym_todo,
    ACTIONS(215), 1,
      anon_sym_panic,
    ACTIONS(217), 1,
      anon_sym_echo,
    ACTIONS(219), 1,
      anon_sym_case,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(229), 1,
      sym__decimal,
    ACTIONS(231), 1,
      sym__name,
    ACTIONS(233), 1,
      sym__upname,
    ACTIONS(968), 1,
      anon_sym_DASH,
    ACTIONS(972), 1,
      anon_sym_BANG,
    ACTIONS(1340), 1,
      sym_float,
    STATE(862), 1,
      sym_identifier,
    STATE(933), 1,
      sym_tuple,
    STATE(935), 1,
      sym_anonymous_function,
    STATE(1718), 1,
      sym__maybe_function_expression,
    STATE(1760), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(856), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(931), 2,
      sym_record,
      sym_record_update,
    ACTIONS(227), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(873), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(968), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [34291] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_POUND,
    ACTIONS(207), 1,
      anon_sym_LBRACK,
    ACTIONS(209), 1,
      anon_sym_LT_LT,
    ACTIONS(211), 1,
      anon_sym_fn,
    ACTIONS(213), 1,
      anon_sym_todo,
    ACTIONS(215), 1,
      anon_sym_panic,
    ACTIONS(217), 1,
      anon_sym_echo,
    ACTIONS(219), 1,
      anon_sym_case,
    ACTIONS(223), 1,
      anon_sym_DQUOTE,
    ACTIONS(229), 1,
      sym__decimal,
    ACTIONS(231), 1,
      sym__name,
    ACTIONS(233), 1,
      sym__upname,
    ACTIONS(968), 1,
      anon_sym_DASH,
    ACTIONS(972), 1,
      anon_sym_BANG,
    ACTIONS(1342), 1,
      sym_float,
    STATE(862), 1,
      sym_identifier,
    STATE(933), 1,
      sym_tuple,
    STATE(935), 1,
      sym_anonymous_function,
    STATE(1718), 1,
      sym__maybe_function_expression,
    STATE(1760), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(856), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(931), 2,
      sym_record,
      sym_record_update,
    ACTIONS(227), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(873), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(969), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [34399] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(235), 1,
      anon_sym_todo,
    ACTIONS(237), 1,
      anon_sym_panic,
    ACTIONS(239), 1,
      anon_sym_echo,
    ACTIONS(958), 1,
      anon_sym_DASH,
    ACTIONS(962), 1,
      anon_sym_BANG,
    ACTIONS(1344), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(944), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [34507] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(758), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(756), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34565] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(762), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(760), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34623] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(772), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(770), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34681] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1206), 1,
      anon_sym_DASH,
    ACTIONS(1208), 1,
      anon_sym_todo,
    ACTIONS(1210), 1,
      anon_sym_panic,
    ACTIONS(1212), 1,
      anon_sym_BANG,
    ACTIONS(1214), 1,
      sym_float,
    ACTIONS(1346), 1,
      anon_sym_GT_GT,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1564), 1,
      sym_expression_bit_string_segment,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1766), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1434), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [34793] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1206), 1,
      anon_sym_DASH,
    ACTIONS(1208), 1,
      anon_sym_todo,
    ACTIONS(1210), 1,
      anon_sym_panic,
    ACTIONS(1212), 1,
      anon_sym_BANG,
    ACTIONS(1214), 1,
      sym_float,
    ACTIONS(1348), 1,
      anon_sym_GT_GT,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1727), 1,
      sym_expression_bit_string_segment,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1766), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1434), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [34905] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(235), 1,
      anon_sym_todo,
    ACTIONS(237), 1,
      anon_sym_panic,
    ACTIONS(239), 1,
      anon_sym_echo,
    ACTIONS(958), 1,
      anon_sym_DASH,
    ACTIONS(962), 1,
      anon_sym_BANG,
    ACTIONS(1350), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(941), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [35013] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_echo,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1154), 1,
      anon_sym_fn,
    ACTIONS(1352), 1,
      sym_float,
    STATE(74), 1,
      sym_identifier,
    STATE(91), 1,
      sym_anonymous_function,
    STATE(92), 1,
      sym_tuple,
    STATE(1652), 1,
      sym__maybe_function_expression,
    STATE(1862), 1,
      sym__maybe_record_expression,
    STATE(1863), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(39), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(93), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(81), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(130), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [35121] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(189), 1,
      anon_sym_LBRACE,
    ACTIONS(191), 1,
      anon_sym_fn,
    ACTIONS(193), 1,
      anon_sym_todo,
    ACTIONS(195), 1,
      anon_sym_panic,
    ACTIONS(197), 1,
      anon_sym_echo,
    ACTIONS(199), 1,
      anon_sym_case,
    ACTIONS(1092), 1,
      anon_sym_POUND,
    ACTIONS(1094), 1,
      anon_sym_LBRACK,
    ACTIONS(1096), 1,
      anon_sym_LT_LT,
    ACTIONS(1098), 1,
      anon_sym_DASH,
    ACTIONS(1102), 1,
      anon_sym_BANG,
    ACTIONS(1104), 1,
      anon_sym_DQUOTE,
    ACTIONS(1110), 1,
      sym__decimal,
    ACTIONS(1112), 1,
      sym__name,
    ACTIONS(1114), 1,
      sym__upname,
    ACTIONS(1354), 1,
      sym_float,
    STATE(563), 1,
      sym_identifier,
    STATE(585), 1,
      sym_tuple,
    STATE(588), 1,
      sym_anonymous_function,
    STATE(1678), 1,
      sym__maybe_function_expression,
    STATE(1782), 1,
      sym__maybe_tuple_expression,
    STATE(1831), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(555), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(584), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1108), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(562), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(629), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [35229] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(734), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(732), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35287] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(696), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(694), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35345] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(720), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(718), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35403] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(684), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(682), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35461] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_echo,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1154), 1,
      anon_sym_fn,
    ACTIONS(1356), 1,
      sym_float,
    STATE(74), 1,
      sym_identifier,
    STATE(91), 1,
      sym_anonymous_function,
    STATE(92), 1,
      sym_tuple,
    STATE(1652), 1,
      sym__maybe_function_expression,
    STATE(1862), 1,
      sym__maybe_record_expression,
    STATE(1863), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(39), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(93), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(81), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(133), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [35569] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1048), 1,
      anon_sym_LBRACE,
    ACTIONS(1050), 1,
      anon_sym_POUND,
    ACTIONS(1052), 1,
      anon_sym_LBRACK,
    ACTIONS(1054), 1,
      anon_sym_LT_LT,
    ACTIONS(1056), 1,
      anon_sym_DASH,
    ACTIONS(1058), 1,
      anon_sym_fn,
    ACTIONS(1060), 1,
      anon_sym_todo,
    ACTIONS(1062), 1,
      anon_sym_panic,
    ACTIONS(1066), 1,
      anon_sym_case,
    ACTIONS(1068), 1,
      anon_sym_BANG,
    ACTIONS(1070), 1,
      anon_sym_DQUOTE,
    ACTIONS(1076), 1,
      sym__decimal,
    ACTIONS(1078), 1,
      sym__name,
    ACTIONS(1080), 1,
      sym__upname,
    ACTIONS(1226), 1,
      anon_sym_echo,
    ACTIONS(1358), 1,
      sym_float,
    STATE(27), 1,
      sym_identifier,
    STATE(76), 1,
      sym_tuple,
    STATE(78), 1,
      sym_anonymous_function,
    STATE(1608), 1,
      sym__maybe_function_expression,
    STATE(1809), 1,
      sym__maybe_record_expression,
    STATE(1876), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(14), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(69), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1074), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(26), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(100), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [35677] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1206), 1,
      anon_sym_DASH,
    ACTIONS(1208), 1,
      anon_sym_todo,
    ACTIONS(1210), 1,
      anon_sym_panic,
    ACTIONS(1212), 1,
      anon_sym_BANG,
    ACTIONS(1214), 1,
      sym_float,
    ACTIONS(1360), 1,
      anon_sym_GT_GT,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1727), 1,
      sym_expression_bit_string_segment,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1766), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1434), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [35789] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1048), 1,
      anon_sym_LBRACE,
    ACTIONS(1050), 1,
      anon_sym_POUND,
    ACTIONS(1052), 1,
      anon_sym_LBRACK,
    ACTIONS(1054), 1,
      anon_sym_LT_LT,
    ACTIONS(1056), 1,
      anon_sym_DASH,
    ACTIONS(1058), 1,
      anon_sym_fn,
    ACTIONS(1060), 1,
      anon_sym_todo,
    ACTIONS(1062), 1,
      anon_sym_panic,
    ACTIONS(1066), 1,
      anon_sym_case,
    ACTIONS(1068), 1,
      anon_sym_BANG,
    ACTIONS(1070), 1,
      anon_sym_DQUOTE,
    ACTIONS(1076), 1,
      sym__decimal,
    ACTIONS(1078), 1,
      sym__name,
    ACTIONS(1080), 1,
      sym__upname,
    ACTIONS(1226), 1,
      anon_sym_echo,
    ACTIONS(1362), 1,
      sym_float,
    STATE(27), 1,
      sym_identifier,
    STATE(76), 1,
      sym_tuple,
    STATE(78), 1,
      sym_anonymous_function,
    STATE(1608), 1,
      sym__maybe_function_expression,
    STATE(1809), 1,
      sym__maybe_record_expression,
    STATE(1876), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(14), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(69), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1074), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(26), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(104), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [35897] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_echo,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1154), 1,
      anon_sym_fn,
    ACTIONS(1364), 1,
      sym_float,
    STATE(74), 1,
      sym_identifier,
    STATE(91), 1,
      sym_anonymous_function,
    STATE(92), 1,
      sym_tuple,
    STATE(1652), 1,
      sym__maybe_function_expression,
    STATE(1862), 1,
      sym__maybe_record_expression,
    STATE(1863), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(39), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(93), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(81), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(145), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [36005] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1206), 1,
      anon_sym_DASH,
    ACTIONS(1208), 1,
      anon_sym_todo,
    ACTIONS(1210), 1,
      anon_sym_panic,
    ACTIONS(1212), 1,
      anon_sym_BANG,
    ACTIONS(1214), 1,
      sym_float,
    ACTIONS(1366), 1,
      anon_sym_GT_GT,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1727), 1,
      sym_expression_bit_string_segment,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1766), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1434), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [36117] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(712), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(710), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36175] = 8,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1180), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1182), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1190), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1192), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(712), 16,
      anon_sym_as,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(710), 20,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36241] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(235), 1,
      anon_sym_todo,
    ACTIONS(237), 1,
      anon_sym_panic,
    ACTIONS(239), 1,
      anon_sym_echo,
    ACTIONS(958), 1,
      anon_sym_DASH,
    ACTIONS(962), 1,
      anon_sym_BANG,
    ACTIONS(1368), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(939), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [36349] = 9,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1188), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1180), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1182), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1190), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1192), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(712), 16,
      anon_sym_as,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(710), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36417] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1206), 1,
      anon_sym_DASH,
    ACTIONS(1208), 1,
      anon_sym_todo,
    ACTIONS(1210), 1,
      anon_sym_panic,
    ACTIONS(1212), 1,
      anon_sym_BANG,
    ACTIONS(1214), 1,
      sym_float,
    ACTIONS(1370), 1,
      anon_sym_GT_GT,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1727), 1,
      sym_expression_bit_string_segment,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1766), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1434), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [36529] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1188), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1180), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1182), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1190), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1312), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1184), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1186), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1192), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(712), 12,
      anon_sym_as,
      anon_sym_fn,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(710), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36603] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1188), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1310), 1,
      anon_sym_AMP_AMP,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1180), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1182), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1190), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1312), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1184), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1186), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1192), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(710), 12,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(712), 12,
      anon_sym_as,
      anon_sym_fn,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
  [36679] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1180), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1192), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(712), 18,
      anon_sym_as,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(710), 22,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36741] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(712), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(710), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36799] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(421), 1,
      anon_sym_DASH,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(425), 1,
      anon_sym_todo,
    ACTIONS(427), 1,
      anon_sym_panic,
    ACTIONS(429), 1,
      anon_sym_echo,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(439), 1,
      anon_sym_BANG,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1372), 1,
      sym_float,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1826), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(518), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [36907] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1188), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1308), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1310), 1,
      anon_sym_AMP_AMP,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1180), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1182), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1190), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1312), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1184), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1186), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1192), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(658), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(660), 12,
      anon_sym_as,
      anon_sym_fn,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
  [36985] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1188), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1308), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1310), 1,
      anon_sym_AMP_AMP,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1180), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1182), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1190), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1312), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1184), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1186), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1192), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(722), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(724), 12,
      anon_sym_as,
      anon_sym_fn,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
  [37063] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1206), 1,
      anon_sym_DASH,
    ACTIONS(1208), 1,
      anon_sym_todo,
    ACTIONS(1210), 1,
      anon_sym_panic,
    ACTIONS(1212), 1,
      anon_sym_BANG,
    ACTIONS(1214), 1,
      sym_float,
    ACTIONS(1374), 1,
      anon_sym_GT_GT,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1727), 1,
      sym_expression_bit_string_segment,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1766), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1434), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [37175] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(754), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(752), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [37233] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(235), 1,
      anon_sym_todo,
    ACTIONS(237), 1,
      anon_sym_panic,
    ACTIONS(239), 1,
      anon_sym_echo,
    ACTIONS(958), 1,
      anon_sym_DASH,
    ACTIONS(962), 1,
      anon_sym_BANG,
    ACTIONS(1376), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(938), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [37341] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(235), 1,
      anon_sym_todo,
    ACTIONS(237), 1,
      anon_sym_panic,
    ACTIONS(239), 1,
      anon_sym_echo,
    ACTIONS(958), 1,
      anon_sym_DASH,
    ACTIONS(962), 1,
      anon_sym_BANG,
    ACTIONS(1378), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(937), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [37449] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(738), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(736), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [37507] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1048), 1,
      anon_sym_LBRACE,
    ACTIONS(1050), 1,
      anon_sym_POUND,
    ACTIONS(1052), 1,
      anon_sym_LBRACK,
    ACTIONS(1054), 1,
      anon_sym_LT_LT,
    ACTIONS(1056), 1,
      anon_sym_DASH,
    ACTIONS(1058), 1,
      anon_sym_fn,
    ACTIONS(1060), 1,
      anon_sym_todo,
    ACTIONS(1062), 1,
      anon_sym_panic,
    ACTIONS(1066), 1,
      anon_sym_case,
    ACTIONS(1068), 1,
      anon_sym_BANG,
    ACTIONS(1070), 1,
      anon_sym_DQUOTE,
    ACTIONS(1076), 1,
      sym__decimal,
    ACTIONS(1078), 1,
      sym__name,
    ACTIONS(1080), 1,
      sym__upname,
    ACTIONS(1226), 1,
      anon_sym_echo,
    ACTIONS(1380), 1,
      sym_float,
    STATE(27), 1,
      sym_identifier,
    STATE(76), 1,
      sym_tuple,
    STATE(78), 1,
      sym_anonymous_function,
    STATE(1608), 1,
      sym__maybe_function_expression,
    STATE(1809), 1,
      sym__maybe_record_expression,
    STATE(1876), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(14), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(69), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1074), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(26), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(127), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [37615] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1206), 1,
      anon_sym_DASH,
    ACTIONS(1208), 1,
      anon_sym_todo,
    ACTIONS(1210), 1,
      anon_sym_panic,
    ACTIONS(1212), 1,
      anon_sym_BANG,
    ACTIONS(1214), 1,
      sym_float,
    ACTIONS(1382), 1,
      anon_sym_GT_GT,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1411), 1,
      sym_expression_bit_string_segment,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1766), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1434), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [37727] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(421), 1,
      anon_sym_DASH,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(425), 1,
      anon_sym_todo,
    ACTIONS(427), 1,
      anon_sym_panic,
    ACTIONS(429), 1,
      anon_sym_echo,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(439), 1,
      anon_sym_BANG,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1384), 1,
      sym_float,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1826), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(525), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [37835] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1012), 1,
      anon_sym_LBRACE,
    ACTIONS(1014), 1,
      anon_sym_POUND,
    ACTIONS(1016), 1,
      anon_sym_LBRACK,
    ACTIONS(1018), 1,
      anon_sym_LT_LT,
    ACTIONS(1020), 1,
      anon_sym_DASH,
    ACTIONS(1022), 1,
      anon_sym_fn,
    ACTIONS(1024), 1,
      anon_sym_todo,
    ACTIONS(1026), 1,
      anon_sym_panic,
    ACTIONS(1030), 1,
      anon_sym_case,
    ACTIONS(1032), 1,
      anon_sym_BANG,
    ACTIONS(1034), 1,
      anon_sym_DQUOTE,
    ACTIONS(1040), 1,
      sym__decimal,
    ACTIONS(1042), 1,
      sym__name,
    ACTIONS(1044), 1,
      sym__upname,
    ACTIONS(1386), 1,
      anon_sym_echo,
    ACTIONS(1388), 1,
      sym_float,
    STATE(249), 1,
      sym_identifier,
    STATE(311), 1,
      sym_anonymous_function,
    STATE(312), 1,
      sym_tuple,
    STATE(1638), 1,
      sym__maybe_function_expression,
    STATE(1820), 1,
      sym__maybe_record_expression,
    STATE(1825), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(222), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(319), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1038), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(248), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(391), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [37943] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1390), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1001), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [38051] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_echo,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1154), 1,
      anon_sym_fn,
    ACTIONS(1392), 1,
      sym_float,
    STATE(74), 1,
      sym_identifier,
    STATE(91), 1,
      sym_anonymous_function,
    STATE(92), 1,
      sym_tuple,
    STATE(1652), 1,
      sym__maybe_function_expression,
    STATE(1862), 1,
      sym__maybe_record_expression,
    STATE(1863), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(39), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(93), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(81), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(148), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [38159] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1012), 1,
      anon_sym_LBRACE,
    ACTIONS(1014), 1,
      anon_sym_POUND,
    ACTIONS(1016), 1,
      anon_sym_LBRACK,
    ACTIONS(1018), 1,
      anon_sym_LT_LT,
    ACTIONS(1020), 1,
      anon_sym_DASH,
    ACTIONS(1022), 1,
      anon_sym_fn,
    ACTIONS(1024), 1,
      anon_sym_todo,
    ACTIONS(1026), 1,
      anon_sym_panic,
    ACTIONS(1030), 1,
      anon_sym_case,
    ACTIONS(1032), 1,
      anon_sym_BANG,
    ACTIONS(1034), 1,
      anon_sym_DQUOTE,
    ACTIONS(1040), 1,
      sym__decimal,
    ACTIONS(1042), 1,
      sym__name,
    ACTIONS(1044), 1,
      sym__upname,
    ACTIONS(1386), 1,
      anon_sym_echo,
    ACTIONS(1394), 1,
      sym_float,
    STATE(249), 1,
      sym_identifier,
    STATE(311), 1,
      sym_anonymous_function,
    STATE(312), 1,
      sym_tuple,
    STATE(1638), 1,
      sym__maybe_function_expression,
    STATE(1820), 1,
      sym__maybe_record_expression,
    STATE(1825), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(222), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(319), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1038), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(248), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(431), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [38267] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1048), 1,
      anon_sym_LBRACE,
    ACTIONS(1050), 1,
      anon_sym_POUND,
    ACTIONS(1052), 1,
      anon_sym_LBRACK,
    ACTIONS(1054), 1,
      anon_sym_LT_LT,
    ACTIONS(1056), 1,
      anon_sym_DASH,
    ACTIONS(1058), 1,
      anon_sym_fn,
    ACTIONS(1060), 1,
      anon_sym_todo,
    ACTIONS(1062), 1,
      anon_sym_panic,
    ACTIONS(1066), 1,
      anon_sym_case,
    ACTIONS(1068), 1,
      anon_sym_BANG,
    ACTIONS(1070), 1,
      anon_sym_DQUOTE,
    ACTIONS(1076), 1,
      sym__decimal,
    ACTIONS(1078), 1,
      sym__name,
    ACTIONS(1080), 1,
      sym__upname,
    ACTIONS(1226), 1,
      anon_sym_echo,
    ACTIONS(1396), 1,
      sym_float,
    STATE(27), 1,
      sym_identifier,
    STATE(76), 1,
      sym_tuple,
    STATE(78), 1,
      sym_anonymous_function,
    STATE(1608), 1,
      sym__maybe_function_expression,
    STATE(1809), 1,
      sym__maybe_record_expression,
    STATE(1876), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(14), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(69), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1074), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(26), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(126), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [38375] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(189), 1,
      anon_sym_LBRACE,
    ACTIONS(191), 1,
      anon_sym_fn,
    ACTIONS(193), 1,
      anon_sym_todo,
    ACTIONS(195), 1,
      anon_sym_panic,
    ACTIONS(197), 1,
      anon_sym_echo,
    ACTIONS(199), 1,
      anon_sym_case,
    ACTIONS(1092), 1,
      anon_sym_POUND,
    ACTIONS(1094), 1,
      anon_sym_LBRACK,
    ACTIONS(1096), 1,
      anon_sym_LT_LT,
    ACTIONS(1098), 1,
      anon_sym_DASH,
    ACTIONS(1102), 1,
      anon_sym_BANG,
    ACTIONS(1104), 1,
      anon_sym_DQUOTE,
    ACTIONS(1110), 1,
      sym__decimal,
    ACTIONS(1112), 1,
      sym__name,
    ACTIONS(1114), 1,
      sym__upname,
    ACTIONS(1398), 1,
      sym_float,
    STATE(563), 1,
      sym_identifier,
    STATE(585), 1,
      sym_tuple,
    STATE(588), 1,
      sym_anonymous_function,
    STATE(1678), 1,
      sym__maybe_function_expression,
    STATE(1782), 1,
      sym__maybe_tuple_expression,
    STATE(1831), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(555), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(584), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1108), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(562), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(601), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [38483] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1012), 1,
      anon_sym_LBRACE,
    ACTIONS(1014), 1,
      anon_sym_POUND,
    ACTIONS(1016), 1,
      anon_sym_LBRACK,
    ACTIONS(1018), 1,
      anon_sym_LT_LT,
    ACTIONS(1020), 1,
      anon_sym_DASH,
    ACTIONS(1022), 1,
      anon_sym_fn,
    ACTIONS(1024), 1,
      anon_sym_todo,
    ACTIONS(1026), 1,
      anon_sym_panic,
    ACTIONS(1030), 1,
      anon_sym_case,
    ACTIONS(1032), 1,
      anon_sym_BANG,
    ACTIONS(1034), 1,
      anon_sym_DQUOTE,
    ACTIONS(1040), 1,
      sym__decimal,
    ACTIONS(1042), 1,
      sym__name,
    ACTIONS(1044), 1,
      sym__upname,
    ACTIONS(1386), 1,
      anon_sym_echo,
    ACTIONS(1400), 1,
      sym_float,
    STATE(249), 1,
      sym_identifier,
    STATE(311), 1,
      sym_anonymous_function,
    STATE(312), 1,
      sym_tuple,
    STATE(1638), 1,
      sym__maybe_function_expression,
    STATE(1820), 1,
      sym__maybe_record_expression,
    STATE(1825), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(222), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(319), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1038), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(248), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(336), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [38591] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1012), 1,
      anon_sym_LBRACE,
    ACTIONS(1014), 1,
      anon_sym_POUND,
    ACTIONS(1016), 1,
      anon_sym_LBRACK,
    ACTIONS(1018), 1,
      anon_sym_LT_LT,
    ACTIONS(1020), 1,
      anon_sym_DASH,
    ACTIONS(1022), 1,
      anon_sym_fn,
    ACTIONS(1024), 1,
      anon_sym_todo,
    ACTIONS(1026), 1,
      anon_sym_panic,
    ACTIONS(1030), 1,
      anon_sym_case,
    ACTIONS(1032), 1,
      anon_sym_BANG,
    ACTIONS(1034), 1,
      anon_sym_DQUOTE,
    ACTIONS(1040), 1,
      sym__decimal,
    ACTIONS(1042), 1,
      sym__name,
    ACTIONS(1044), 1,
      sym__upname,
    ACTIONS(1386), 1,
      anon_sym_echo,
    ACTIONS(1402), 1,
      sym_float,
    STATE(249), 1,
      sym_identifier,
    STATE(311), 1,
      sym_anonymous_function,
    STATE(312), 1,
      sym_tuple,
    STATE(1638), 1,
      sym__maybe_function_expression,
    STATE(1820), 1,
      sym__maybe_record_expression,
    STATE(1825), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(222), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(319), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1038), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(248), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(433), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [38699] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1048), 1,
      anon_sym_LBRACE,
    ACTIONS(1050), 1,
      anon_sym_POUND,
    ACTIONS(1052), 1,
      anon_sym_LBRACK,
    ACTIONS(1054), 1,
      anon_sym_LT_LT,
    ACTIONS(1056), 1,
      anon_sym_DASH,
    ACTIONS(1058), 1,
      anon_sym_fn,
    ACTIONS(1060), 1,
      anon_sym_todo,
    ACTIONS(1062), 1,
      anon_sym_panic,
    ACTIONS(1066), 1,
      anon_sym_case,
    ACTIONS(1068), 1,
      anon_sym_BANG,
    ACTIONS(1070), 1,
      anon_sym_DQUOTE,
    ACTIONS(1076), 1,
      sym__decimal,
    ACTIONS(1078), 1,
      sym__name,
    ACTIONS(1080), 1,
      sym__upname,
    ACTIONS(1226), 1,
      anon_sym_echo,
    ACTIONS(1404), 1,
      sym_float,
    STATE(27), 1,
      sym_identifier,
    STATE(76), 1,
      sym_tuple,
    STATE(78), 1,
      sym_anonymous_function,
    STATE(1608), 1,
      sym__maybe_function_expression,
    STATE(1809), 1,
      sym__maybe_record_expression,
    STATE(1876), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(14), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(69), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1074), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(26), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(125), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [38807] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1012), 1,
      anon_sym_LBRACE,
    ACTIONS(1014), 1,
      anon_sym_POUND,
    ACTIONS(1016), 1,
      anon_sym_LBRACK,
    ACTIONS(1018), 1,
      anon_sym_LT_LT,
    ACTIONS(1020), 1,
      anon_sym_DASH,
    ACTIONS(1022), 1,
      anon_sym_fn,
    ACTIONS(1024), 1,
      anon_sym_todo,
    ACTIONS(1026), 1,
      anon_sym_panic,
    ACTIONS(1030), 1,
      anon_sym_case,
    ACTIONS(1032), 1,
      anon_sym_BANG,
    ACTIONS(1034), 1,
      anon_sym_DQUOTE,
    ACTIONS(1040), 1,
      sym__decimal,
    ACTIONS(1042), 1,
      sym__name,
    ACTIONS(1044), 1,
      sym__upname,
    ACTIONS(1386), 1,
      anon_sym_echo,
    ACTIONS(1406), 1,
      sym_float,
    STATE(249), 1,
      sym_identifier,
    STATE(311), 1,
      sym_anonymous_function,
    STATE(312), 1,
      sym_tuple,
    STATE(1638), 1,
      sym__maybe_function_expression,
    STATE(1820), 1,
      sym__maybe_record_expression,
    STATE(1825), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(222), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(319), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1038), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(248), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(434), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [38915] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1012), 1,
      anon_sym_LBRACE,
    ACTIONS(1014), 1,
      anon_sym_POUND,
    ACTIONS(1016), 1,
      anon_sym_LBRACK,
    ACTIONS(1018), 1,
      anon_sym_LT_LT,
    ACTIONS(1020), 1,
      anon_sym_DASH,
    ACTIONS(1022), 1,
      anon_sym_fn,
    ACTIONS(1024), 1,
      anon_sym_todo,
    ACTIONS(1026), 1,
      anon_sym_panic,
    ACTIONS(1030), 1,
      anon_sym_case,
    ACTIONS(1032), 1,
      anon_sym_BANG,
    ACTIONS(1034), 1,
      anon_sym_DQUOTE,
    ACTIONS(1040), 1,
      sym__decimal,
    ACTIONS(1042), 1,
      sym__name,
    ACTIONS(1044), 1,
      sym__upname,
    ACTIONS(1386), 1,
      anon_sym_echo,
    ACTIONS(1408), 1,
      sym_float,
    STATE(249), 1,
      sym_identifier,
    STATE(311), 1,
      sym_anonymous_function,
    STATE(312), 1,
      sym_tuple,
    STATE(1638), 1,
      sym__maybe_function_expression,
    STATE(1820), 1,
      sym__maybe_record_expression,
    STATE(1825), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(222), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(319), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1038), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(248), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(435), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [39023] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1012), 1,
      anon_sym_LBRACE,
    ACTIONS(1014), 1,
      anon_sym_POUND,
    ACTIONS(1016), 1,
      anon_sym_LBRACK,
    ACTIONS(1018), 1,
      anon_sym_LT_LT,
    ACTIONS(1020), 1,
      anon_sym_DASH,
    ACTIONS(1022), 1,
      anon_sym_fn,
    ACTIONS(1024), 1,
      anon_sym_todo,
    ACTIONS(1026), 1,
      anon_sym_panic,
    ACTIONS(1030), 1,
      anon_sym_case,
    ACTIONS(1032), 1,
      anon_sym_BANG,
    ACTIONS(1034), 1,
      anon_sym_DQUOTE,
    ACTIONS(1040), 1,
      sym__decimal,
    ACTIONS(1042), 1,
      sym__name,
    ACTIONS(1044), 1,
      sym__upname,
    ACTIONS(1386), 1,
      anon_sym_echo,
    ACTIONS(1410), 1,
      sym_float,
    STATE(249), 1,
      sym_identifier,
    STATE(311), 1,
      sym_anonymous_function,
    STATE(312), 1,
      sym_tuple,
    STATE(1638), 1,
      sym__maybe_function_expression,
    STATE(1820), 1,
      sym__maybe_record_expression,
    STATE(1825), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(222), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(319), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1038), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(248), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(436), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [39131] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(235), 1,
      anon_sym_todo,
    ACTIONS(237), 1,
      anon_sym_panic,
    ACTIONS(239), 1,
      anon_sym_echo,
    ACTIONS(958), 1,
      anon_sym_DASH,
    ACTIONS(962), 1,
      anon_sym_BANG,
    ACTIONS(1412), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(936), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [39239] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(656), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(654), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [39297] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_echo,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1154), 1,
      anon_sym_fn,
    ACTIONS(1414), 1,
      sym_float,
    STATE(74), 1,
      sym_identifier,
    STATE(91), 1,
      sym_anonymous_function,
    STATE(92), 1,
      sym_tuple,
    STATE(1652), 1,
      sym__maybe_function_expression,
    STATE(1862), 1,
      sym__maybe_record_expression,
    STATE(1863), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(39), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(93), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(81), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(159), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [39405] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1188), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1308), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1310), 1,
      anon_sym_AMP_AMP,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1180), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1182), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1190), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1312), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1184), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1186), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1192), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(702), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(704), 12,
      anon_sym_as,
      anon_sym_fn,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
  [39483] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(700), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(698), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [39541] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(767), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(764), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [39599] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(688), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(686), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [39657] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1048), 1,
      anon_sym_LBRACE,
    ACTIONS(1050), 1,
      anon_sym_POUND,
    ACTIONS(1052), 1,
      anon_sym_LBRACK,
    ACTIONS(1054), 1,
      anon_sym_LT_LT,
    ACTIONS(1056), 1,
      anon_sym_DASH,
    ACTIONS(1058), 1,
      anon_sym_fn,
    ACTIONS(1060), 1,
      anon_sym_todo,
    ACTIONS(1062), 1,
      anon_sym_panic,
    ACTIONS(1066), 1,
      anon_sym_case,
    ACTIONS(1068), 1,
      anon_sym_BANG,
    ACTIONS(1070), 1,
      anon_sym_DQUOTE,
    ACTIONS(1076), 1,
      sym__decimal,
    ACTIONS(1078), 1,
      sym__name,
    ACTIONS(1080), 1,
      sym__upname,
    ACTIONS(1226), 1,
      anon_sym_echo,
    ACTIONS(1416), 1,
      sym_float,
    STATE(27), 1,
      sym_identifier,
    STATE(76), 1,
      sym_tuple,
    STATE(78), 1,
      sym_anonymous_function,
    STATE(1608), 1,
      sym__maybe_function_expression,
    STATE(1809), 1,
      sym__maybe_record_expression,
    STATE(1876), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(14), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(69), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1074), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(26), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(106), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [39765] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(692), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(690), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [39823] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1206), 1,
      anon_sym_DASH,
    ACTIONS(1208), 1,
      anon_sym_todo,
    ACTIONS(1210), 1,
      anon_sym_panic,
    ACTIONS(1212), 1,
      anon_sym_BANG,
    ACTIONS(1214), 1,
      sym_float,
    ACTIONS(1418), 1,
      anon_sym_GT_GT,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1727), 1,
      sym_expression_bit_string_segment,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1766), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1434), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [39935] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1048), 1,
      anon_sym_LBRACE,
    ACTIONS(1050), 1,
      anon_sym_POUND,
    ACTIONS(1052), 1,
      anon_sym_LBRACK,
    ACTIONS(1054), 1,
      anon_sym_LT_LT,
    ACTIONS(1056), 1,
      anon_sym_DASH,
    ACTIONS(1058), 1,
      anon_sym_fn,
    ACTIONS(1060), 1,
      anon_sym_todo,
    ACTIONS(1062), 1,
      anon_sym_panic,
    ACTIONS(1066), 1,
      anon_sym_case,
    ACTIONS(1068), 1,
      anon_sym_BANG,
    ACTIONS(1070), 1,
      anon_sym_DQUOTE,
    ACTIONS(1076), 1,
      sym__decimal,
    ACTIONS(1078), 1,
      sym__name,
    ACTIONS(1080), 1,
      sym__upname,
    ACTIONS(1226), 1,
      anon_sym_echo,
    ACTIONS(1420), 1,
      sym_float,
    STATE(27), 1,
      sym_identifier,
    STATE(76), 1,
      sym_tuple,
    STATE(78), 1,
      sym_anonymous_function,
    STATE(1608), 1,
      sym__maybe_function_expression,
    STATE(1809), 1,
      sym__maybe_record_expression,
    STATE(1876), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(14), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(69), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1074), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(26), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(120), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [40043] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(421), 1,
      anon_sym_DASH,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(425), 1,
      anon_sym_todo,
    ACTIONS(427), 1,
      anon_sym_panic,
    ACTIONS(429), 1,
      anon_sym_echo,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(439), 1,
      anon_sym_BANG,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1422), 1,
      sym_float,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1826), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(524), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [40151] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(421), 1,
      anon_sym_DASH,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(425), 1,
      anon_sym_todo,
    ACTIONS(427), 1,
      anon_sym_panic,
    ACTIONS(429), 1,
      anon_sym_echo,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(439), 1,
      anon_sym_BANG,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1424), 1,
      sym_float,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1826), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(523), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [40259] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(421), 1,
      anon_sym_DASH,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(425), 1,
      anon_sym_todo,
    ACTIONS(427), 1,
      anon_sym_panic,
    ACTIONS(429), 1,
      anon_sym_echo,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(439), 1,
      anon_sym_BANG,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1426), 1,
      sym_float,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1826), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(517), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [40367] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(235), 1,
      anon_sym_todo,
    ACTIONS(237), 1,
      anon_sym_panic,
    ACTIONS(239), 1,
      anon_sym_echo,
    ACTIONS(958), 1,
      anon_sym_DASH,
    ACTIONS(962), 1,
      anon_sym_BANG,
    ACTIONS(1428), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(912), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [40475] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1206), 1,
      anon_sym_DASH,
    ACTIONS(1208), 1,
      anon_sym_todo,
    ACTIONS(1210), 1,
      anon_sym_panic,
    ACTIONS(1212), 1,
      anon_sym_BANG,
    ACTIONS(1214), 1,
      sym_float,
    ACTIONS(1430), 1,
      anon_sym_GT_GT,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1727), 1,
      sym_expression_bit_string_segment,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1766), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1434), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [40587] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1432), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(978), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [40695] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1012), 1,
      anon_sym_LBRACE,
    ACTIONS(1014), 1,
      anon_sym_POUND,
    ACTIONS(1016), 1,
      anon_sym_LBRACK,
    ACTIONS(1018), 1,
      anon_sym_LT_LT,
    ACTIONS(1020), 1,
      anon_sym_DASH,
    ACTIONS(1022), 1,
      anon_sym_fn,
    ACTIONS(1024), 1,
      anon_sym_todo,
    ACTIONS(1026), 1,
      anon_sym_panic,
    ACTIONS(1030), 1,
      anon_sym_case,
    ACTIONS(1032), 1,
      anon_sym_BANG,
    ACTIONS(1034), 1,
      anon_sym_DQUOTE,
    ACTIONS(1040), 1,
      sym__decimal,
    ACTIONS(1042), 1,
      sym__name,
    ACTIONS(1044), 1,
      sym__upname,
    ACTIONS(1386), 1,
      anon_sym_echo,
    ACTIONS(1434), 1,
      sym_float,
    STATE(249), 1,
      sym_identifier,
    STATE(311), 1,
      sym_anonymous_function,
    STATE(312), 1,
      sym_tuple,
    STATE(1638), 1,
      sym__maybe_function_expression,
    STATE(1820), 1,
      sym__maybe_record_expression,
    STATE(1825), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(222), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(319), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1038), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(248), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(502), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [40803] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1012), 1,
      anon_sym_LBRACE,
    ACTIONS(1014), 1,
      anon_sym_POUND,
    ACTIONS(1016), 1,
      anon_sym_LBRACK,
    ACTIONS(1018), 1,
      anon_sym_LT_LT,
    ACTIONS(1020), 1,
      anon_sym_DASH,
    ACTIONS(1022), 1,
      anon_sym_fn,
    ACTIONS(1024), 1,
      anon_sym_todo,
    ACTIONS(1026), 1,
      anon_sym_panic,
    ACTIONS(1030), 1,
      anon_sym_case,
    ACTIONS(1032), 1,
      anon_sym_BANG,
    ACTIONS(1034), 1,
      anon_sym_DQUOTE,
    ACTIONS(1040), 1,
      sym__decimal,
    ACTIONS(1042), 1,
      sym__name,
    ACTIONS(1044), 1,
      sym__upname,
    ACTIONS(1386), 1,
      anon_sym_echo,
    ACTIONS(1436), 1,
      sym_float,
    STATE(249), 1,
      sym_identifier,
    STATE(311), 1,
      sym_anonymous_function,
    STATE(312), 1,
      sym_tuple,
    STATE(1638), 1,
      sym__maybe_function_expression,
    STATE(1820), 1,
      sym__maybe_record_expression,
    STATE(1825), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(222), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(319), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1038), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(248), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(493), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [40911] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_echo,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1154), 1,
      anon_sym_fn,
    ACTIONS(1438), 1,
      sym_float,
    STATE(74), 1,
      sym_identifier,
    STATE(91), 1,
      sym_anonymous_function,
    STATE(92), 1,
      sym_tuple,
    STATE(1652), 1,
      sym__maybe_function_expression,
    STATE(1862), 1,
      sym__maybe_record_expression,
    STATE(1863), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(39), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(93), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(81), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(157), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [41019] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1440), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(981), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [41127] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1012), 1,
      anon_sym_LBRACE,
    ACTIONS(1014), 1,
      anon_sym_POUND,
    ACTIONS(1016), 1,
      anon_sym_LBRACK,
    ACTIONS(1018), 1,
      anon_sym_LT_LT,
    ACTIONS(1020), 1,
      anon_sym_DASH,
    ACTIONS(1022), 1,
      anon_sym_fn,
    ACTIONS(1024), 1,
      anon_sym_todo,
    ACTIONS(1026), 1,
      anon_sym_panic,
    ACTIONS(1030), 1,
      anon_sym_case,
    ACTIONS(1032), 1,
      anon_sym_BANG,
    ACTIONS(1034), 1,
      anon_sym_DQUOTE,
    ACTIONS(1040), 1,
      sym__decimal,
    ACTIONS(1042), 1,
      sym__name,
    ACTIONS(1044), 1,
      sym__upname,
    ACTIONS(1386), 1,
      anon_sym_echo,
    ACTIONS(1442), 1,
      sym_float,
    STATE(249), 1,
      sym_identifier,
    STATE(311), 1,
      sym_anonymous_function,
    STATE(312), 1,
      sym_tuple,
    STATE(1638), 1,
      sym__maybe_function_expression,
    STATE(1820), 1,
      sym__maybe_record_expression,
    STATE(1825), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(222), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(319), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1038), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(248), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(463), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [41235] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1444), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(679), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(644), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(985), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [41343] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1206), 1,
      anon_sym_DASH,
    ACTIONS(1208), 1,
      anon_sym_todo,
    ACTIONS(1210), 1,
      anon_sym_panic,
    ACTIONS(1212), 1,
      anon_sym_BANG,
    ACTIONS(1214), 1,
      sym_float,
    ACTIONS(1446), 1,
      anon_sym_GT_GT,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1536), 1,
      sym_expression_bit_string_segment,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1766), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1434), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [41455] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(411), 1,
      anon_sym_LBRACE,
    ACTIONS(415), 1,
      anon_sym_POUND,
    ACTIONS(417), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_LT_LT,
    ACTIONS(421), 1,
      anon_sym_DASH,
    ACTIONS(423), 1,
      anon_sym_fn,
    ACTIONS(425), 1,
      anon_sym_todo,
    ACTIONS(427), 1,
      anon_sym_panic,
    ACTIONS(429), 1,
      anon_sym_echo,
    ACTIONS(431), 1,
      anon_sym_case,
    ACTIONS(439), 1,
      anon_sym_BANG,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(447), 1,
      sym__decimal,
    ACTIONS(449), 1,
      sym__name,
    ACTIONS(451), 1,
      sym__upname,
    ACTIONS(1448), 1,
      sym_float,
    STATE(211), 1,
      sym_identifier,
    STATE(218), 1,
      sym_tuple,
    STATE(220), 1,
      sym_anonymous_function,
    STATE(1653), 1,
      sym__maybe_function_expression,
    STATE(1762), 1,
      sym__maybe_record_expression,
    STATE(1826), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(187), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(214), 2,
      sym_record,
      sym_record_update,
    ACTIONS(445), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(202), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(522), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [41563] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_LT_LT,
    ACTIONS(79), 1,
      anon_sym_fn,
    ACTIONS(81), 1,
      anon_sym_todo,
    ACTIONS(83), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_echo,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(816), 1,
      anon_sym_DASH,
    ACTIONS(820), 1,
      anon_sym_BANG,
    ACTIONS(1450), 1,
      sym_float,
    STATE(649), 1,
      sym_identifier,
    STATE(681), 1,
      sym_tuple,
    STATE(685), 1,
      sym_anonymous_function,
    STATE(1682), 1,
      sym__maybe_function_expression,
    STATE(1796), 1,
      sym__maybe_record_expression,
    STATE(1821), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(642), 2,
    