# Go SDK for Google Generative AI

![Go](https://github.com/google/generative-ai-go/actions/workflows/go.yml/badge.svg?event=push) [![Go Reference](https://pkg.go.dev/badge/github.com/google/generative-ai-go.svg)](https://pkg.go.dev/github.com/google/generative-ai-go)

This SDK enables developers to use Google's state-of-the-art generative
AI models (like Gemini) to build AI-powered features and applications. It
supports use cases like:

- Generate text from text-only input
- Generate text from text-and-images input (multimodal)
- Build multi-turn conversations (chat)
- Embedding

## Try out the API

1.  [Obtain an API key](https://makersuite.google.com/app/apikey) to use with the Google AI SDKs.
2.  Add the SDK to your module with `go get github.com/google/generative-ai-go`
3.  Follow [the examples](https://pkg.go.dev/github.com/google/generative-ai-go/genai#pkg-examples)

## Documentation

The documentation of the Google AI Go SDK is [on pkg.go.dev](https://pkg.go.dev/github.com/google/generative-ai-go/genai)

Find complete documentation for the Google AI SDKs and the Gemini model in the
Google documentation: https://ai.google.dev/docs

For a list of the supported models and their capabilities, see https://ai.google.dev/models/gemini

## Getting help

For general Gemini API questions (not specific to the Go SDK), check out the
[public discussion forum](https://discuss.ai.google.dev/).

For questions specific to the Go SDK, create a new issue and tag it with
a `question` label.

## Contributing

See [Contributing](https://github.com/google/generative-ai-go/blob/main/CONTRIBUTING.md) for
more information on contributing to the Google AI Go SDK.

## License

The contents of this repository are licensed under the
[Apache License, version 2.0](http://www.apache.org/licenses/LICENSE-2.0).
