/*
 * Decompiled with CFR 0.152.
 */
package mill.util;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import mill.api.WorkspaceRoot$;
import mill.moduledefs.Scaladoc;
import os.Path;
import os.Path$;
import os.PathConvertible$NioPathConvertible$;
import os.PathConvertible$StringConvertible$;
import os.exists$;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.matching.Regex;

@Scaladoc(value="/**\n * Loads the jars that make up the classpath of the scala-js-fiddle\n * compiler and re-shapes it into the correct structure to satisfy\n * scala-compile and scalajs-tools\n */")
public final class Classpath$ {
    public static final Classpath$ MODULE$ = new Classpath$();
    private static final boolean traceClasspathIssues = package$.MODULE$.props().get("ammonite.trace-classpath").exists((Function1<String, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(Classpath$.$anonfun$traceClasspathIssues$1(x$1)));
    private static final Regex simpleNameRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[a-zA-Z0-9_]+"));

    public boolean traceClasspathIssues() {
        return traceClasspathIssues;
    }

    @Scaladoc(value="/**\n   * In memory cache of all the jars used in the compiler. This takes up some\n   * memory but is better than reaching all over the filesystem every time we\n   * want to do something.\n   */")
    public Vector<Path> classpath(ClassLoader classLoader) {
        Object object;
        Buffer files2 = (Buffer)Buffer$.MODULE$.empty();
        Buffer seenClassLoaders = (Buffer)Buffer$.MODULE$.empty();
        for (ClassLoader current = classLoader; current != null; current = current.getParent()) {
            seenClassLoaders.append(current);
            ClassLoader classLoader2 = current;
            if (!(classLoader2 instanceof URLClassLoader)) continue;
            URLClassLoader uRLClassLoader = (URLClassLoader)classLoader2;
            files2.appendAll(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.collect$extension(Predef$.MODULE$.refArrayOps(uRLClassLoader.getURLs()), new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends URL, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    String string = A1.getProtocol();
                    String string2 = "file";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return (B1)Path$.MODULE$.apply(Paths.get(A1.toURI()), PathConvertible$NioPathConvertible$.MODULE$);
                    }
                    return function1.apply(x1);
                }

                public final boolean isDefinedAt(URL x1) {
                    URL uRL = x1;
                    String string = uRL.getProtocol();
                    String string2 = "file";
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }
            }, ClassTag$.MODULE$.apply(Path.class))));
        }
        String sunBoot = System.getProperty("sun.boot.class.path");
        if (sunBoot != null) {
            object = files2.appendAll(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(sunBoot.split(File.pathSeparator)), (Function1<String, Path> & Serializable)x$2 -> Path$.MODULE$.apply(x$2, PathConvertible$StringConvertible$.MODULE$), ClassTag$.MODULE$.apply(Path.class))), (Function1<Path, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(exists$.MODULE$.apply(x$3)))));
        } else {
            if (seenClassLoaders.contains(ClassLoader.getSystemClassLoader())) {
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(System.getProperty("java.class.path")), File.pathSeparatorChar)), (Function1<String, Object> & Serializable)p -> {
                    Path f = Path$.MODULE$.apply(p, WorkspaceRoot$.MODULE$.workspaceRoot(), PathConvertible$StringConvertible$.MODULE$);
                    if (exists$.MODULE$.apply(f)) {
                        return files2.append(f);
                    }
                    return BoxedUnit.UNIT;
                });
            }
            object = BoxedUnit.UNIT;
        }
        return files2.toVector();
    }

    public Regex simpleNameRegex() {
        return simpleNameRegex;
    }

    public Seq<URL> allJars(ClassLoader classloader) {
        return ((IterableOnceOps)((IterableOps)this.allClassloaders(classloader).collect(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends ClassLoader, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof URLClassLoader) {
                    URLClassLoader uRLClassLoader = (URLClassLoader)A1;
                    return (B1)uRLClassLoader.getURLs();
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(ClassLoader x1) {
                ClassLoader classLoader = x1;
                return classLoader instanceof URLClassLoader;
            }
        })).flatten((Function1<URL[], ArraySeq.ofRef> & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs))).toSeq();
    }

    public Buffer<ClassLoader> allClassloaders(ClassLoader classloader) {
        Buffer all = (Buffer)Buffer$.MODULE$.empty();
        for (ClassLoader current = classloader; current != null; current = current.getParent()) {
            ClassLoader classLoader = current;
            ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
            if (!(classLoader == null ? classLoader2 != null : !classLoader.equals(classLoader2))) break;
            all.append(current);
        }
        return all;
    }

    public static final /* synthetic */ boolean $anonfun$traceClasspathIssues$1(String x$1) {
        String string = x$1.toLowerCase();
        String string2 = "true";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private Classpath$() {
    }
}

