/*
 * Decompiled with CFR 0.152.
 */
package coursier.paths;

import coursier.cache.shaded.dirs.ProjectDirectories;
import coursier.cache.shaded.dirs.impl.Windows;
import coursier.cache.shaded.dirs.jni.WindowsJni;
import coursier.paths.Util;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;

public final class CoursierPaths {
    private static final Object coursierDirectoriesLock = new Object();
    private static ProjectDirectories coursierDirectories0;
    private static final Object cacheDirectoryLock;
    private static volatile File cacheDirectory0;
    private static volatile File archiveCacheDirectory0;
    private static volatile File priviledgedArchiveCacheDirectory0;
    private static volatile File digestBasedCacheDirectory0;
    private static volatile File jvmCacheDirectory0;
    private static final Object configDirectoryLock;
    private static volatile File[] configDirectories0;
    private static final Object dataLocalDirectoryLock;
    private static volatile File dataLocalDirectory0;
    private static Path scalaConfigFile0;

    private CoursierPaths() {
        throw new Error();
    }

    private static String computeCacheDirectory() throws IOException {
        return CoursierPaths.computeCacheDirectory("COURSIER_CACHE", "coursier.cache", "v1");
    }

    private static String computeArchiveCacheDirectory() throws IOException {
        return CoursierPaths.computeCacheDirectory("COURSIER_ARCHIVE_CACHE", "coursier.archive.cache", "arc");
    }

    private static String computePriviledgedArchiveCacheDirectory() throws IOException {
        return CoursierPaths.computeCacheDirectory("COURSIER_PRIVILEDGED_ARCHIVE_CACHE", "coursier.priviledged.archive.cache", "priv");
    }

    private static String computeDigestBasedCacheDirectory() throws IOException {
        return CoursierPaths.computeCacheDirectory("COURSIER_DIGEST_BASED_CACHE", "coursier.digest-based.cache", "digest");
    }

    private static String computeJvmCacheDirectory() throws IOException {
        return CoursierPaths.computeCacheDirectory("COURSIER_JVM_CACHE", "coursier.jvm.cache", "jvm");
    }

    private static String computeCacheDirectory(String string, String string2, String string3) throws IOException {
        String string4 = System.getenv(string);
        if (string4 == null) {
            string4 = System.getProperty(string2);
        }
        if (string4 != null) {
            return string4;
        }
        File file = new File(CoursierPaths.coursierDirectories().cacheDir);
        File file2 = new File(file, string3);
        Util.createDirectories(file2.toPath());
        return file2.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File cacheDirectory() throws IOException {
        if (cacheDirectory0 == null) {
            Object object = cacheDirectoryLock;
            synchronized (object) {
                if (cacheDirectory0 == null) {
                    cacheDirectory0 = new File(CoursierPaths.computeCacheDirectory()).getAbsoluteFile();
                }
            }
        }
        return cacheDirectory0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File archiveCacheDirectory() throws IOException {
        if (archiveCacheDirectory0 == null) {
            Object object = cacheDirectoryLock;
            synchronized (object) {
                if (archiveCacheDirectory0 == null) {
                    archiveCacheDirectory0 = new File(CoursierPaths.computeArchiveCacheDirectory()).getAbsoluteFile();
                }
            }
        }
        return archiveCacheDirectory0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File priviledgedArchiveCacheDirectory() throws IOException {
        if (priviledgedArchiveCacheDirectory0 == null) {
            Object object = cacheDirectoryLock;
            synchronized (object) {
                if (priviledgedArchiveCacheDirectory0 == null) {
                    priviledgedArchiveCacheDirectory0 = new File(CoursierPaths.computePriviledgedArchiveCacheDirectory()).getAbsoluteFile();
                }
            }
        }
        return priviledgedArchiveCacheDirectory0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File digestBasedCacheDirectory() throws IOException {
        if (digestBasedCacheDirectory0 == null) {
            Object object = cacheDirectoryLock;
            synchronized (object) {
                if (digestBasedCacheDirectory0 == null) {
                    digestBasedCacheDirectory0 = new File(CoursierPaths.computeDigestBasedCacheDirectory()).getAbsoluteFile();
                }
            }
        }
        return digestBasedCacheDirectory0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File jvmCacheDirectory() throws IOException {
        if (jvmCacheDirectory0 == null) {
            Object object = cacheDirectoryLock;
            synchronized (object) {
                if (jvmCacheDirectory0 == null) {
                    jvmCacheDirectory0 = new File(CoursierPaths.computeJvmCacheDirectory()).getAbsoluteFile();
                }
            }
        }
        return jvmCacheDirectory0;
    }

    public static ProjectDirectories directoriesInstance(String string) {
        Supplier<Windows> supplier = Util.useJni() ? WindowsJni.getJdkAwareSupplier() : Windows.getDefaultSupplier();
        return ProjectDirectories.from(null, null, string, supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProjectDirectories coursierDirectories() throws IOException {
        if (coursierDirectories0 == null) {
            Object object = coursierDirectoriesLock;
            synchronized (object) {
                if (coursierDirectories0 == null) {
                    coursierDirectories0 = CoursierPaths.directoriesInstance("Coursier");
                }
            }
        }
        return coursierDirectories0;
    }

    private static File[] computeConfigDirectories() throws IOException {
        String string = System.getenv("COURSIER_CONFIG_DIR");
        if (string == null) {
            string = System.getProperty("coursier.config-dir");
        }
        if (string != null) {
            return new File[]{new File(string).getAbsoluteFile()};
        }
        String string2 = CoursierPaths.coursierDirectories().configDir;
        String string3 = CoursierPaths.coursierDirectories().preferenceDir;
        if (string2.equals(string3)) {
            return new File[]{new File(string2).getAbsoluteFile()};
        }
        return new File[]{new File(string2).getAbsoluteFile(), new File(string3).getAbsoluteFile()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File[] configDirectories() throws IOException {
        if (configDirectories0 == null) {
            Object object = configDirectoryLock;
            synchronized (object) {
                if (configDirectories0 == null) {
                    configDirectories0 = CoursierPaths.computeConfigDirectories();
                }
            }
        }
        return (File[])configDirectories0.clone();
    }

    @Deprecated
    public static File configDirectory() throws IOException {
        return CoursierPaths.configDirectories()[0];
    }

    public static File defaultConfigDirectory() throws IOException {
        return CoursierPaths.configDirectories()[0];
    }

    private static String computeDataLocalDirectory() throws IOException {
        String string = System.getenv("COURSIER_DATA_DIR");
        if (string == null) {
            string = System.getProperty("coursier.data-dir");
        }
        if (string != null) {
            return string;
        }
        return CoursierPaths.coursierDirectories().dataLocalDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File dataLocalDirectory() throws IOException {
        if (dataLocalDirectory0 == null) {
            Object object = dataLocalDirectoryLock;
            synchronized (object) {
                if (dataLocalDirectory0 == null) {
                    dataLocalDirectory0 = new File(CoursierPaths.computeDataLocalDirectory()).getAbsoluteFile();
                }
            }
        }
        return dataLocalDirectory0;
    }

    public static File projectCacheDirectory() throws IOException {
        return new File(CoursierPaths.coursierDirectories().cacheDir);
    }

    public static Path scalaConfigFile() throws Throwable {
        if (scalaConfigFile0 == null) {
            Object object;
            Path path = null;
            String string = System.getenv("SCALA_CLI_CONFIG");
            if (string != null && string.length() > 0) {
                path = Paths.get(string, new String[0]);
            }
            if (path == null && (object = System.getProperty("scala-cli.config")) != null && ((String)object).length() > 0) {
                path = Paths.get((String)object, new String[0]);
            }
            if (path == null) {
                object = CoursierPaths.directoriesInstance("ScalaCli");
                path = Paths.get(((ProjectDirectories)object).dataLocalDir, new String[0]).resolve("secrets/config.json");
            }
            scalaConfigFile0 = path;
        }
        return scalaConfigFile0;
    }

    static {
        cacheDirectoryLock = new Object();
        cacheDirectory0 = null;
        archiveCacheDirectory0 = null;
        priviledgedArchiveCacheDirectory0 = null;
        digestBasedCacheDirectory0 = null;
        jvmCacheDirectory0 = null;
        configDirectoryLock = new Object();
        configDirectories0 = null;
        dataLocalDirectoryLock = new Object();
        dataLocalDirectory0 = null;
        scalaConfigFile0 = null;
    }
}

