//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uinavigationitemlargetitledisplaymode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UINavigationItemLargeTitleDisplayMode(pub NSInteger);
impl UINavigationItemLargeTitleDisplayMode {
    /// Automatically use the large out-of-line title based on the state of the previous item in the navigation bar. An item with largeTitleDisplayMode=Automatic will show or hide the large title based on the request of the previous navigation item. If the first item pushed is set to Automatic, then it will show the large title if the navigation bar has prefersLargeTitles=YES.
    #[doc(alias = "UINavigationItemLargeTitleDisplayModeAutomatic")]
    pub const Automatic: Self = Self(0);
    /// Always use a larger title when this item is topmost.
    #[doc(alias = "UINavigationItemLargeTitleDisplayModeAlways")]
    pub const Always: Self = Self(1);
    /// Never use a larger title when this item is topmost.
    #[doc(alias = "UINavigationItemLargeTitleDisplayModeNever")]
    pub const Never: Self = Self(2);
    /// Always use a large title when this item is topmost. If there is a back button present, this will revert to `Always`. Leading
    /// &
    /// center items will move to the overflow menu if present.
    #[doc(alias = "UINavigationItemLargeTitleDisplayModeInline")]
    pub const Inline: Self = Self(3);
}

unsafe impl Encode for UINavigationItemLargeTitleDisplayMode {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UINavigationItemLargeTitleDisplayMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uinavigationitembackbuttondisplaymode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UINavigationItemBackButtonDisplayMode(pub NSInteger);
impl UINavigationItemBackButtonDisplayMode {
    /// Default mode, uses an appropriate title, followed by a generic title (typically 'Back'), then no title.
    #[doc(alias = "UINavigationItemBackButtonDisplayModeDefault")]
    pub const Default: Self = Self(0);
    /// Generic titles only. Ignores .title and .backButtonTitle (but *not* .backBarButtonItem.title).
    #[doc(alias = "UINavigationItemBackButtonDisplayModeGeneric")]
    pub const Generic: Self = Self(1);
    /// Don't use a title, just the back button indicator image.
    #[doc(alias = "UINavigationItemBackButtonDisplayModeMinimal")]
    pub const Minimal: Self = Self(2);
}

unsafe impl Encode for UINavigationItemBackButtonDisplayMode {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UINavigationItemBackButtonDisplayMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uinavigationitemsearchbarplacement?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UINavigationItemSearchBarPlacement(pub NSInteger);
impl UINavigationItemSearchBarPlacement {
    /// The navigation bar will choose a placement for the search bar that is appropriate for the current layout
    #[doc(alias = "UINavigationItemSearchBarPlacementAutomatic")]
    pub const Automatic: Self = Self(0);
    /// The navigation bar will place the search bar inline with other content, on the trailing edge.
    /// On iPhone, when the navigation bar belongs to a UINavigationController, the search bar may be integrated into the toolbar.
    #[doc(alias = "UINavigationItemSearchBarPlacementIntegrated")]
    pub const Integrated: Self = Self(1);
    /// The navigation bar will place the search bar vertically stacked with other content.
    #[doc(alias = "UINavigationItemSearchBarPlacementStacked")]
    pub const Stacked: Self = Self(2);
    /// Placement is the same as Integrated, except that in regular width on iPad, the search bar is centered in the navigation bar.
    /// Only respected when used in a view controller that is a descendant of a tab bar controller or when using a navigation item style that requires a leading aligned title
    #[doc(alias = "UINavigationItemSearchBarPlacementIntegratedCentered")]
    pub const IntegratedCentered: Self = Self(3);
    /// Placement is the same as Integrated, except that the inactive search bar is always shown as a button even when space permits a search field.
    #[doc(alias = "UINavigationItemSearchBarPlacementIntegratedButton")]
    pub const IntegratedButton: Self = Self(4);
    /// Placement is the same as Integrated, except that the inactive search bar is always shown as a button even when space permits a search field.
    #[doc(alias = "UINavigationItemSearchBarPlacementInline")]
    #[deprecated]
    pub const Inline: Self = Self(UINavigationItemSearchBarPlacement::Integrated.0);
}

unsafe impl Encode for UINavigationItemSearchBarPlacement {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UINavigationItemSearchBarPlacement {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uinavigationitemstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UINavigationItemStyle(pub NSInteger);
impl UINavigationItemStyle {
    /// Traditional navigation bar behavior. Center items are placed in the overflow menu.
    #[doc(alias = "UINavigationItemStyleNavigator")]
    pub const Navigator: Self = Self(0);
    /// A style designed for use as a browser. Title is leading aligned, center items are displayed. Typically used with history-based navigation.
    #[doc(alias = "UINavigationItemStyleBrowser")]
    pub const Browser: Self = Self(1);
    /// A style designed for use as an editor. The back button will always present as chevron-only, title is leading aligned, center items are displayed. Typically used without navigation.
    #[doc(alias = "UINavigationItemStyleEditor")]
    pub const Editor: Self = Self(2);
}

unsafe impl Encode for UINavigationItemStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UINavigationItemStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uinavigationitemrenamedelegate?language=objc)
    pub unsafe trait UINavigationItemRenameDelegate:
        NSObjectProtocol + MainThreadOnly
    {
        /// This method is called when renaming has ended. The title on the navigation item has already been changed when this method is called but
        /// clients can make further adjustments to it when necessary.
        #[unsafe(method(navigationItem:didEndRenamingWithTitle:))]
        #[unsafe(method_family = none)]
        fn navigationItem_didEndRenamingWithTitle(
            &self,
            navigation_item: &UINavigationItem,
            title: &NSString,
        );

        /// Controls whether the rename action is supported for the given navigation item. For example this method is called when the navigation bar's
        /// document menu is shown to validate if the rename action should be part of that menu.
        #[optional]
        #[unsafe(method(navigationItemShouldBeginRenaming:))]
        #[unsafe(method_family = none)]
        fn navigationItemShouldBeginRenaming(&self, navigation_item: &UINavigationItem) -> bool;

        /// Called when we begin renaming. Implementing this method allows for customizing the initial text that will show up in the text field as well as the
        /// selected range of that text.
        ///
        /// # Safety
        ///
        /// `selected_range` must be a valid pointer.
        #[optional]
        #[unsafe(method(navigationItem:willBeginRenamingWithSuggestedTitle:selectedRange:))]
        #[unsafe(method_family = none)]
        unsafe fn navigationItem_willBeginRenamingWithSuggestedTitle_selectedRange(
            &self,
            navigation_item: &UINavigationItem,
            title: &NSString,
            selected_range: NonNull<NSRange>,
        ) -> Retained<NSString>;

        /// This method can be used to prevent renaming from happening. However there are cases (e.g. when a new navigation item is pushed on the navigation
        /// bar) where this method will not be called and instead navigationItem:didEndRenamingWithTitle: is called right away. Clients are therefore expected to
        /// handle titles in navigationItem:didEndRenamingWithTitle: for which they would return NO from navigationItem:shouldEndRenamingWithTitle:.
        #[optional]
        #[unsafe(method(navigationItem:shouldEndRenamingWithTitle:))]
        #[unsafe(method_family = none)]
        fn navigationItem_shouldEndRenamingWithTitle(
            &self,
            navigation_item: &UINavigationItem,
            title: &NSString,
        ) -> bool;
    }
);

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uinavigationitem?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UINavigationItem;
);

extern_conformance!(
    unsafe impl NSCoding for UINavigationItem {}
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UINavigationItem {}
);

impl UINavigationItem {
    extern_methods!(
        #[unsafe(method(initWithTitle:))]
        #[unsafe(method_family = init)]
        pub fn initWithTitle(this: Allocated<Self>, title: &NSString) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        /// Title when topmost on the stack. default is nil
        #[unsafe(method(title))]
        #[unsafe(method_family = none)]
        pub fn title(&self) -> Option<Retained<NSString>>;

        /// Setter for [`title`][Self::title].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setTitle:))]
        #[unsafe(method_family = none)]
        pub fn setTitle(&self, title: Option<&NSString>);

        /// An attributed string that is rendered as the title in the navigation bar.
        ///
        /// If `titleView` is non-nil, this property is ignored.
        #[unsafe(method(attributedTitle))]
        #[unsafe(method_family = none)]
        pub fn attributedTitle(&self) -> Option<Retained<NSAttributedString>>;

        /// Setter for [`attributedTitle`][Self::attributedTitle].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAttributedTitle:))]
        #[unsafe(method_family = none)]
        pub fn setAttributedTitle(&self, attributed_title: Option<&NSAttributedString>);

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        /// Custom view to use in lieu of a title. May be sized horizontally. Only used when item is topmost on the stack.
        #[unsafe(method(titleView))]
        #[unsafe(method_family = none)]
        pub fn titleView(&self) -> Option<Retained<UIView>>;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        /// Setter for [`titleView`][Self::titleView].
        #[unsafe(method(setTitleView:))]
        #[unsafe(method_family = none)]
        pub fn setTitleView(&self, title_view: Option<&UIView>);

        /// A string to display as the subtitle in the navigation bar.
        ///
        /// If `attributedSubtitle` is `non-nil`, this property just returns the `String`
        /// representation of the `attributedString`.
        /// If `subtitleView` is non-nil, this property is ignored.
        #[unsafe(method(subtitle))]
        #[unsafe(method_family = none)]
        pub fn subtitle(&self) -> Option<Retained<NSString>>;

        /// Setter for [`subtitle`][Self::subtitle].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setSubtitle:))]
        #[unsafe(method_family = none)]
        pub fn setSubtitle(&self, subtitle: Option<&NSString>);

        /// An attributed string to display as the subtitle in the navigation bar.
        ///
        /// If non-nil, this property takes precedence over the `subtitle` property.
        /// If `subtitleView` is non-nil, this property is ignored.
        /// If `titleView` is non-nil, this property is ignored.
        #[unsafe(method(attributedSubtitle))]
        #[unsafe(method_family = none)]
        pub fn attributedSubtitle(&self) -> Option<Retained<NSAttributedString>>;

        /// Setter for [`attributedSubtitle`][Self::attributedSubtitle].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAttributedSubtitle:))]
        #[unsafe(method_family = none)]
        pub fn setAttributedSubtitle(&self, attributed_subtitle: Option<&NSAttributedString>);

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        /// A custom view to display below the title in the navigation bar.
        ///
        /// If non-nil, this property takes precedence over the `subtitle` and `attributedSubtitle` properties.
        /// The view's layout constraints will determine its size, or the view may override `sizeThatFits(_:)`
        /// to return its desired size.
        #[unsafe(method(subtitleView))]
        #[unsafe(method_family = none)]
        pub fn subtitleView(&self) -> Option<Retained<UIView>>;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        /// Setter for [`subtitleView`][Self::subtitleView].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setSubtitleView:))]
        #[unsafe(method_family = none)]
        pub fn setSubtitleView(&self, subtitle_view: Option<&UIView>);

        /// String to be used as the large title.
        ///
        /// When `nil`, the navigation bar will use the navigation item's current title.
        #[unsafe(method(largeTitle))]
        #[unsafe(method_family = none)]
        pub fn largeTitle(&self) -> Option<Retained<NSString>>;

        /// Setter for [`largeTitle`][Self::largeTitle].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setLargeTitle:))]
        #[unsafe(method_family = none)]
        pub fn setLargeTitle(&self, large_title: Option<&NSString>);

        /// String to be rendered below the large title.
        ///
        /// When `nil`, the navigation bar will fall back to the `subtitle`.
        #[unsafe(method(largeSubtitle))]
        #[unsafe(method_family = none)]
        pub fn largeSubtitle(&self) -> Option<Retained<NSString>>;

        /// Setter for [`largeSubtitle`][Self::largeSubtitle].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setLargeSubtitle:))]
        #[unsafe(method_family = none)]
        pub fn setLargeSubtitle(&self, large_subtitle: Option<&NSString>);

        /// An attributed string to be rendered below the large title.
        ///
        /// When `nil`, the navigation bar will fall back to the `largeSubtitle`.
        /// If a `largeSubtitleView` is set, this property is ignored.
        #[unsafe(method(largeAttributedSubtitle))]
        #[unsafe(method_family = none)]
        pub fn largeAttributedSubtitle(&self) -> Option<Retained<NSAttributedString>>;

        /// Setter for [`largeAttributedSubtitle`][Self::largeAttributedSubtitle].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setLargeAttributedSubtitle:))]
        #[unsafe(method_family = none)]
        pub fn setLargeAttributedSubtitle(
            &self,
            large_attributed_subtitle: Option<&NSAttributedString>,
        );

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        /// A custom view to display below the large title.
        ///
        /// When non-nil, this takes precedence over any other subtitle.
        /// The view's layout constraints will determine its size, or the view may override `sizeThatFits(_:)`
        /// to return its desired size.
        #[unsafe(method(largeSubtitleView))]
        #[unsafe(method_family = none)]
        pub fn largeSubtitleView(&self) -> Option<Retained<UIView>>;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        /// Setter for [`largeSubtitleView`][Self::largeSubtitleView].
        #[unsafe(method(setLargeSubtitleView:))]
        #[unsafe(method_family = none)]
        pub fn setLargeSubtitleView(&self, large_subtitle_view: Option<&UIView>);

        /// Explanatory text to display above the navigation bar buttons.
        #[unsafe(method(prompt))]
        #[unsafe(method_family = none)]
        pub fn prompt(&self) -> Option<Retained<NSString>>;

        /// Setter for [`prompt`][Self::prompt].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setPrompt:))]
        #[unsafe(method_family = none)]
        pub fn setPrompt(&self, prompt: Option<&NSString>);

        #[cfg(all(feature = "UIBarButtonItem", feature = "UIBarItem"))]
        /// Bar button item to use for the back button when this item is the navigation bar's backItem.
        #[unsafe(method(backBarButtonItem))]
        #[unsafe(method_family = none)]
        pub fn backBarButtonItem(&self) -> Option<Retained<UIBarButtonItem>>;

        #[cfg(all(feature = "UIBarButtonItem", feature = "UIBarItem"))]
        /// Setter for [`backBarButtonItem`][Self::backBarButtonItem].
        #[unsafe(method(setBackBarButtonItem:))]
        #[unsafe(method_family = none)]
        pub fn setBackBarButtonItem(&self, back_bar_button_item: Option<&UIBarButtonItem>);

        /// Title to use when this item is the navigation bar's backItem. Default is nil. backBarButtonItem takes precedence if both are specified.
        #[unsafe(method(backButtonTitle))]
        #[unsafe(method_family = none)]
        pub fn backButtonTitle(&self) -> Option<Retained<NSString>>;

        /// Setter for [`backButtonTitle`][Self::backButtonTitle].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setBackButtonTitle:))]
        #[unsafe(method_family = none)]
        pub fn setBackButtonTitle(&self, back_button_title: Option<&NSString>);

        /// If YES, this navigation item will hide the back button when it's on top of the stack.
        #[unsafe(method(hidesBackButton))]
        #[unsafe(method_family = none)]
        pub fn hidesBackButton(&self) -> bool;

        /// Setter for [`hidesBackButton`][Self::hidesBackButton].
        #[unsafe(method(setHidesBackButton:))]
        #[unsafe(method_family = none)]
        pub fn setHidesBackButton(&self, hides_back_button: bool);

        #[unsafe(method(setHidesBackButton:animated:))]
        #[unsafe(method_family = none)]
        pub fn setHidesBackButton_animated(&self, hides_back_button: bool, animated: bool);

        /// Controls how the back button sources its title.
        #[unsafe(method(backButtonDisplayMode))]
        #[unsafe(method_family = none)]
        pub fn backButtonDisplayMode(&self) -> UINavigationItemBackButtonDisplayMode;

        /// Setter for [`backButtonDisplayMode`][Self::backButtonDisplayMode].
        #[unsafe(method(setBackButtonDisplayMode:))]
        #[unsafe(method_family = none)]
        pub fn setBackButtonDisplayMode(
            &self,
            back_button_display_mode: UINavigationItemBackButtonDisplayMode,
        );

        #[cfg(all(feature = "UIAction", feature = "UIMenuElement"))]
        /// Replaces the back action for the navigation bar. if a back button is naturally present, this replaces only its action, otherwise a back button will be synthesized with the image or title from the action.
        #[unsafe(method(backAction))]
        #[unsafe(method_family = none)]
        pub fn backAction(&self) -> Option<Retained<UIAction>>;

        #[cfg(all(feature = "UIAction", feature = "UIMenuElement"))]
        /// Setter for [`backAction`][Self::backAction].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setBackAction:))]
        #[unsafe(method_family = none)]
        pub fn setBackAction(&self, back_action: Option<&UIAction>);

        #[cfg(all(feature = "UIMenu", feature = "UIMenuElement", feature = "block2"))]
        /// When non-nil, UIKit will generate suggestedActions and call this block to generate a menu that is displayed from the title.
        ///
        /// # Safety
        ///
        /// The returned block's argument must be a valid pointer.
        #[unsafe(method(titleMenuProvider))]
        #[unsafe(method_family = none)]
        pub unsafe fn titleMenuProvider(
            &self,
        ) -> *mut block2::DynBlock<dyn Fn(NonNull<NSArray<UIMenuElement>>) -> *mut UIMenu>;

        #[cfg(all(feature = "UIMenu", feature = "UIMenuElement", feature = "block2"))]
        /// Setter for [`titleMenuProvider`][Self::titleMenuProvider].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `title_menu_provider` block's return must be a valid pointer or null.
        #[unsafe(method(setTitleMenuProvider:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTitleMenuProvider(
            &self,
            title_menu_provider: Option<
                &block2::DynBlock<dyn Fn(NonNull<NSArray<UIMenuElement>>) -> *mut UIMenu>,
            >,
        );

        /// When non-nil, enables the UINavigationBar to respond to the rename: action by providing an inline UI.
        /// Setting this property to nil while a rename operation is in progress will cancel the operation immediately.
        #[unsafe(method(renameDelegate))]
        #[unsafe(method_family = none)]
        pub fn renameDelegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn UINavigationItemRenameDelegate>>>;

        /// Setter for [`renameDelegate`][Self::renameDelegate].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setRenameDelegate:))]
        #[unsafe(method_family = none)]
        pub fn setRenameDelegate(
            &self,
            rename_delegate: Option<&ProtocolObject<dyn UINavigationItemRenameDelegate>>,
        );

        #[cfg(feature = "UIDocumentProperties")]
        /// When non-nil, UIKit will use the metadata provided to generate additional controls displayed from the title.
        #[unsafe(method(documentProperties))]
        #[unsafe(method_family = none)]
        pub fn documentProperties(&self) -> Option<Retained<UIDocumentProperties>>;

        #[cfg(feature = "UIDocumentProperties")]
        /// Setter for [`documentProperties`][Self::documentProperties].
        #[unsafe(method(setDocumentProperties:))]
        #[unsafe(method_family = none)]
        pub fn setDocumentProperties(&self, document_properties: Option<&UIDocumentProperties>);

        #[cfg(all(feature = "UIBarButtonItem", feature = "UIBarItem"))]
        #[unsafe(method(leftBarButtonItems))]
        #[unsafe(method_family = none)]
        pub fn leftBarButtonItems(&self) -> Option<Retained<NSArray<UIBarButtonItem>>>;

        #[cfg(all(feature = "UIBarButtonItem", feature = "UIBarItem"))]
        /// Setter for [`leftBarButtonItems`][Self::leftBarButtonItems].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setLeftBarButtonItems:))]
        #[unsafe(method_family = none)]
        pub fn setLeftBarButtonItems(
            &self,
            left_bar_button_items: Option<&NSArray<UIBarButtonItem>>,
        );

        #[cfg(all(feature = "UIBarButtonItem", feature = "UIBarItem"))]
        #[unsafe(method(rightBarButtonItems))]
        #[unsafe(method_family = none)]
        pub fn rightBarButtonItems(&self) -> Option<Retained<NSArray<UIBarButtonItem>>>;

        #[cfg(all(feature = "UIBarButtonItem", feature = "UIBarItem"))]
        /// Setter for [`rightBarButtonItems`][Self::rightBarButtonItems].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setRightBarButtonItems:))]
        #[unsafe(method_family = none)]
        pub fn setRightBarButtonItems(
            &self,
            right_bar_button_items: Option<&NSArray<UIBarButtonItem>>,
        );

        #[cfg(all(feature = "UIBarButtonItem", feature = "UIBarItem"))]
        #[unsafe(method(setLeftBarButtonItems:animated:))]
        #[unsafe(method_family = none)]
        pub fn setLeftBarButtonItems_animated(
            &self,
            items: Option<&NSArray<UIBarButtonItem>>,
            animated: bool,
        );

        #[cfg(all(feature = "UIBarButtonItem", feature = "UIBarItem"))]
        #[unsafe(method(setRightBarButtonItems:animated:))]
        #[unsafe(method_family = none)]
        pub fn setRightBarButtonItems_animated(
            &self,
            items: Option<&NSArray<UIBarButtonItem>>,
            animated: bool,
        );

        #[unsafe(method(leftItemsSupplementBackButton))]
        #[unsafe(method_family = none)]
        pub fn leftItemsSupplementBackButton(&self) -> bool;

        /// Setter for [`leftItemsSupplementBackButton`][Self::leftItemsSupplementBackButton].
        #[unsafe(method(setLeftItemsSupplementBackButton:))]
        #[unsafe(method_family = none)]
        pub fn setLeftItemsSupplementBackButton(&self, left_items_supplement_back_button: bool);

        #[cfg(all(feature = "UIBarButtonItem", feature = "UIBarItem"))]
        /// Some navigation items want to display a custom left or right item when they're on top of the stack. A custom left item replaces the regular back button unless you set leftItemsSupplementBackButton to YES
        #[unsafe(method(leftBarButtonItem))]
        #[unsafe(method_family = none)]
        pub fn leftBarButtonItem(&self) -> Option<Retained<UIBarButtonItem>>;

        #[cfg(all(feature = "UIBarButtonItem", feature = "UIBarItem"))]
        /// Setter for [`leftBarButtonItem`][Self::leftBarButtonItem].
        #[unsafe(method(setLeftBarButtonItem:))]
        #[unsafe(method_family = none)]
        pub fn setLeftBarButtonItem(&self, left_bar_button_item: Option<&UIBarButtonItem>);

        #[cfg(all(feature = "UIBarButtonItem", feature = "UIBarItem"))]
        #[unsafe(method(rightBarButtonItem))]
        #[unsafe(method_family = none)]
        pub fn rightBarButtonItem(&self) -> Option<Retained<UIBarButtonItem>>;

        #[cfg(all(feature = "UIBarButtonItem", feature = "UIBarItem"))]
        /// Setter for [`rightBarButtonItem`][Self::rightBarButtonItem].
        #[unsafe(method(setRightBarButtonItem:))]
        #[unsafe(method_family = none)]
        pub fn setRightBarButtonItem(&self, right_bar_button_item: Option<&UIBarButtonItem>);

        #[cfg(all(feature = "UIBarButtonItem", feature = "UIBarItem"))]
        #[unsafe(method(setLeftBarButtonItem:animated:))]
        #[unsafe(method_family = none)]
        pub fn setLeftBarButtonItem_animated(&self, item: Option<&UIBarButtonItem>, animated: bool);

        #[cfg(all(feature = "UIBarButtonItem", feature = "UIBarItem"))]
        #[unsafe(method(setRightBarButtonItem:animated:))]
        #[unsafe(method_family = none)]
        pub fn setRightBarButtonItem_animated(
            &self,
            item: Option<&UIBarButtonItem>,
            animated: bool,
        );

        /// Setting a non-nil customizationIdentifier enables customization and UIKit will automatically save
        /// &
        /// restore customizations based on this identifier. The identifier must be unique within the scope of the application.
        #[unsafe(method(customizationIdentifier))]
        #[unsafe(method_family = none)]
        pub fn customizationIdentifier(&self) -> Option<Retained<NSString>>;

        /// Setter for [`customizationIdentifier`][Self::customizationIdentifier].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setCustomizationIdentifier:))]
        #[unsafe(method_family = none)]
        pub fn setCustomizationIdentifier(&self, customization_identifier: Option<&NSString>);

        #[cfg(feature = "UIBarButtonItemGroup")]
        /// UIBarButtonItemGroups to be displayed in the leading section of the navigation bar. Items set via this method will replace items set via .leftBarButtonItem or .leftBarButtonItems.
        #[unsafe(method(leadingItemGroups))]
        #[unsafe(method_family = none)]
        pub fn leadingItemGroups(&self) -> Retained<NSArray<UIBarButtonItemGroup>>;

        #[cfg(feature = "UIBarButtonItemGroup")]
        /// Setter for [`leadingItemGroups`][Self::leadingItemGroups].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setLeadingItemGroups:))]
        #[unsafe(method_family = none)]
        pub fn setLeadingItemGroups(&self, leading_item_groups: &NSArray<UIBarButtonItemGroup>);

        #[cfg(feature = "UIBarButtonItemGroup")]
        /// Customizable UIBarButtonItemGroups that will be placed in the center region when the navigation bar is the browser or editor modes. In navigation mode, these items will be placed in the overflow.
        #[unsafe(method(centerItemGroups))]
        #[unsafe(method_family = none)]
        pub fn centerItemGroups(&self) -> Retained<NSArray<UIBarButtonItemGroup>>;

        #[cfg(feature = "UIBarButtonItemGroup")]
        /// Setter for [`centerItemGroups`][Self::centerItemGroups].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setCenterItemGroups:))]
        #[unsafe(method_family = none)]
        pub fn setCenterItemGroups(&self, center_item_groups: &NSArray<UIBarButtonItemGroup>);

        #[cfg(feature = "UIBarButtonItemGroup")]
        /// UIBarButtonItemGroups to be displayed in the trailing section of the navigation bar. Items set via this method will replace items set via .rightBarButtonItem or .rightBarButtonItems.
        #[unsafe(method(trailingItemGroups))]
        #[unsafe(method_family = none)]
        pub fn trailingItemGroups(&self) -> Retained<NSArray<UIBarButtonItemGroup>>;

        #[cfg(feature = "UIBarButtonItemGroup")]
        /// Setter for [`trailingItemGroups`][Self::trailingItemGroups].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setTrailingItemGroups:))]
        #[unsafe(method_family = none)]
        pub fn setTrailingItemGroups(&self, trailing_item_groups: &NSArray<UIBarButtonItemGroup>);

        #[cfg(feature = "UIBarButtonItemGroup")]
        /// Set a group of items to be placed on the trailing edge of the bar, past the overflow
        /// &
        /// search items (if present). If you wish to have more than 1 item, it is HIGHLY recommended to assign a representative item to the group to avoid overflowing the bar as this group cannot move to the overflow.
        #[unsafe(method(pinnedTrailingGroup))]
        #[unsafe(method_family = none)]
        pub fn pinnedTrailingGroup(&self) -> Option<Retained<UIBarButtonItemGroup>>;

        #[cfg(feature = "UIBarButtonItemGroup")]
        /// Setter for [`pinnedTrailingGroup`][Self::pinnedTrailingGroup].
        #[unsafe(method(setPinnedTrailingGroup:))]
        #[unsafe(method_family = none)]
        pub fn setPinnedTrailingGroup(&self, pinned_trailing_group: Option<&UIBarButtonItemGroup>);

        #[cfg(all(feature = "UIDeferredMenuElement", feature = "UIMenuElement"))]
        /// Additional items to add to the overflow menu. Setting this property to a non-nil value will force the overflow button to appear, regardless of if you provide any content in the element's callback. Items returned are displayed directly in the presented menu.
        #[unsafe(method(additionalOverflowItems))]
        #[unsafe(method_family = none)]
        pub fn additionalOverflowItems(&self) -> Option<Retained<UIDeferredMenuElement>>;

        #[cfg(all(feature = "UIDeferredMenuElement", feature = "UIMenuElement"))]
        /// Setter for [`additionalOverflowItems`][Self::additionalOverflowItems].
        #[unsafe(method(setAdditionalOverflowItems:))]
        #[unsafe(method_family = none)]
        pub fn setAdditionalOverflowItems(
            &self,
            additional_overflow_items: Option<&UIDeferredMenuElement>,
        );

        #[cfg(feature = "UIPopoverPresentationControllerSourceItem")]
        /// If the overflow button for this item is currently present, then this will return a non-nil item that can be used as a presentation source (e.g. for popovers). Otherwise it will return nil.
        #[unsafe(method(overflowPresentationSource))]
        #[unsafe(method_family = none)]
        pub fn overflowPresentationSource(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn UIPopoverPresentationControllerSourceItem>>>;

        /// When UINavigationBar.prefersLargeTitles=YES, this property controls when the larger out-of-line title is displayed. If prefersLargeTitles=NO, this property has no effect. The default value is Automatic.
        #[unsafe(method(largeTitleDisplayMode))]
        #[unsafe(method_family = none)]
        pub fn largeTitleDisplayMode(&self) -> UINavigationItemLargeTitleDisplayMode;

        /// Setter for [`largeTitleDisplayMode`][Self::largeTitleDisplayMode].
        #[unsafe(method(setLargeTitleDisplayMode:))]
        #[unsafe(method_family = none)]
        pub fn setLargeTitleDisplayMode(
            &self,
            large_title_display_mode: UINavigationItemLargeTitleDisplayMode,
        );

        /// Controls how content defined by this item is laid out in the navigation bar.
        #[unsafe(method(style))]
        #[unsafe(method_family = none)]
        pub fn style(&self) -> UINavigationItemStyle;

        /// Setter for [`style`][Self::style].
        #[unsafe(method(setStyle:))]
        #[unsafe(method_family = none)]
        pub fn setStyle(&self, style: UINavigationItemStyle);

        #[cfg(all(
            feature = "UIResponder",
            feature = "UISearchController",
            feature = "UIViewController"
        ))]
        /// A view controller that will be shown inside of a navigation controller can assign a UISearchController to this property to display the search controller’s search bar in its containing navigation controller’s navigation bar.
        #[unsafe(method(searchController))]
        #[unsafe(method_family = none)]
        pub fn searchController(&self) -> Option<Retained<UISearchController>>;

        #[cfg(all(
            feature = "UIResponder",
            feature = "UISearchController",
            feature = "UIViewController"
        ))]
        /// Setter for [`searchController`][Self::searchController].
        #[unsafe(method(setSearchController:))]
        #[unsafe(method_family = none)]
        pub fn setSearchController(&self, search_controller: Option<&UISearchController>);

        /// If this property is true (the default), the searchController’s search bar will hide as the user scrolls in the top view controller’s scroll view. If false, the search bar will remain visible and pinned underneath the navigation bar.
        /// Not applicable and ignored for `UINavigationItemSearchBarPlacementIntegrated`
        #[unsafe(method(hidesSearchBarWhenScrolling))]
        #[unsafe(method_family = none)]
        pub fn hidesSearchBarWhenScrolling(&self) -> bool;

        /// Setter for [`hidesSearchBarWhenScrolling`][Self::hidesSearchBarWhenScrolling].
        #[unsafe(method(setHidesSearchBarWhenScrolling:))]
        #[unsafe(method_family = none)]
        pub fn setHidesSearchBarWhenScrolling(&self, hides_search_bar_when_scrolling: bool);

        /// The preferred search bar placement, when a search controller is assigned to this item.
        #[unsafe(method(preferredSearchBarPlacement))]
        #[unsafe(method_family = none)]
        pub fn preferredSearchBarPlacement(&self) -> UINavigationItemSearchBarPlacement;

        /// Setter for [`preferredSearchBarPlacement`][Self::preferredSearchBarPlacement].
        #[unsafe(method(setPreferredSearchBarPlacement:))]
        #[unsafe(method_family = none)]
        pub fn setPreferredSearchBarPlacement(
            &self,
            preferred_search_bar_placement: UINavigationItemSearchBarPlacement,
        );

        /// The realized placement. Only valid if a search controller has been assigned to this item.
        #[unsafe(method(searchBarPlacement))]
        #[unsafe(method_family = none)]
        pub fn searchBarPlacement(&self) -> UINavigationItemSearchBarPlacement;

        #[cfg(all(feature = "UIBarButtonItem", feature = "UIBarItem"))]
        /// When `searchBarPlacement` is `.integrated` or `.integratedButton` and a search controller is present, use this bar button item in the view controller's `toolbarItems` to control the placement of the search bar among them when the search bar is appearing in the UIToolbar on iPhone.
        /// Without this bar button item, the positioning for the search bar defaults to trailingmost for the UIToolbar case.
        /// This bar button item will be ignored during toolbar layout if `searchController` is `nil`.
        /// UIBarButtonItemGroup will throw an NSInvalidArgumentException when this bar button item is included in its initialization.
        /// UINavigationItem will throw an NSInvalidArgumentException when this bar button item is included in leftBarButtonItems or rightBarButtonItems.
        #[unsafe(method(searchBarPlacementBarButtonItem))]
        #[unsafe(method_family = none)]
        pub fn searchBarPlacementBarButtonItem(&self) -> Retained<UIBarButtonItem>;

        /// Defaults to `YES`
        /// Set to `NO` to prevent the search bar from being placed among other UIToolbar items on iPhone
        #[unsafe(method(searchBarPlacementAllowsToolbarIntegration))]
        #[unsafe(method_family = none)]
        pub fn searchBarPlacementAllowsToolbarIntegration(&self) -> bool;

        /// Setter for [`searchBarPlacementAllowsToolbarIntegration`][Self::searchBarPlacementAllowsToolbarIntegration].
        #[unsafe(method(setSearchBarPlacementAllowsToolbarIntegration:))]
        #[unsafe(method_family = none)]
        pub fn setSearchBarPlacementAllowsToolbarIntegration(
            &self,
            search_bar_placement_allows_toolbar_integration: bool,
        );

        /// `AllowsExternalIntegration` means that something at a higher scope may take the search bar and integrate it somewhere other than the navigation bar (or toolbar) directly associated with this navigation item.
        /// On iOS 26, UISplitViewController uses this to allow Mac-like placement of the search bar on iPad.
        /// Defaults to `NO`
        /// Set to `YES` to allow the containing UISplitViewController to place the search bar in the navigation bar for the trailingmost column independent of the column used for this view controller.
        /// Ignored when `searchController` is `nil`, when `searchBarPlacement` is `.stacked`, or when not contained in a UISplitViewController.
        /// When the top view controller's navigation item has this property set to `YES` in more than one column at the same time, only one will be respected; the columns are checked in order of `.inspector`, `.secondary`, `.supplementary`, `.primary`
        /// If the search bar has a scope bar, the scope bar will not be moved into a different column.
        #[unsafe(method(searchBarPlacementAllowsExternalIntegration))]
        #[unsafe(method_family = none)]
        pub fn searchBarPlacementAllowsExternalIntegration(&self) -> bool;

        /// Setter for [`searchBarPlacementAllowsExternalIntegration`][Self::searchBarPlacementAllowsExternalIntegration].
        #[unsafe(method(setSearchBarPlacementAllowsExternalIntegration:))]
        #[unsafe(method_family = none)]
        pub fn setSearchBarPlacementAllowsExternalIntegration(
            &self,
            search_bar_placement_allows_external_integration: bool,
        );

        #[cfg(all(feature = "UIBarAppearance", feature = "UINavigationBarAppearance"))]
        /// When set and this item is topmost, overrides the hosting navigation bar's standardAppearance. See UINavigationBar.standardAppearance for further details.
        #[unsafe(method(standardAppearance))]
        #[unsafe(method_family = none)]
        pub fn standardAppearance(&self) -> Option<Retained<UINavigationBarAppearance>>;

        #[cfg(all(feature = "UIBarAppearance", feature = "UINavigationBarAppearance"))]
        /// Setter for [`standardAppearance`][Self::standardAppearance].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setStandardAppearance:))]
        #[unsafe(method_family = none)]
        pub fn setStandardAppearance(
            &self,
            standard_appearance: Option<&UINavigationBarAppearance>,
        );

        #[cfg(all(feature = "UIBarAppearance", feature = "UINavigationBarAppearance"))]
        /// When set and this item is topmost, overrides the hosting navigation bar's compactAppearance. See UINavigationBar.compactAppearance for further details.
        #[unsafe(method(compactAppearance))]
        #[unsafe(method_family = none)]
        pub fn compactAppearance(&self) -> Option<Retained<UINavigationBarAppearance>>;

        #[cfg(all(feature = "UIBarAppearance", feature = "UINavigationBarAppearance"))]
        /// Setter for [`compactAppearance`][Self::compactAppearance].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setCompactAppearance:))]
        #[unsafe(method_family = none)]
        pub fn setCompactAppearance(&self, compact_appearance: Option<&UINavigationBarAppearance>);

        #[cfg(all(feature = "UIBarAppearance", feature = "UINavigationBarAppearance"))]
        /// When set and this item is topmost, overrides the hosting navigation bar's scrollEdgeAppearance. See UINavigationBar.scrollEdgeAppearance for further details.
        #[unsafe(method(scrollEdgeAppearance))]
        #[unsafe(method_family = none)]
        pub fn scrollEdgeAppearance(&self) -> Option<Retained<UINavigationBarAppearance>>;

        #[cfg(all(feature = "UIBarAppearance", feature = "UINavigationBarAppearance"))]
        /// Setter for [`scrollEdgeAppearance`][Self::scrollEdgeAppearance].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setScrollEdgeAppearance:))]
        #[unsafe(method_family = none)]
        pub fn setScrollEdgeAppearance(
            &self,
            scroll_edge_appearance: Option<&UINavigationBarAppearance>,
        );

        #[cfg(all(feature = "UIBarAppearance", feature = "UINavigationBarAppearance"))]
        /// When set and this item is topmost, overrides the hosting navigation bar's compactScrollEdgeAppearance. See UINavigationBar.h for further details.
        #[unsafe(method(compactScrollEdgeAppearance))]
        #[unsafe(method_family = none)]
        pub fn compactScrollEdgeAppearance(&self) -> Option<Retained<UINavigationBarAppearance>>;

        #[cfg(all(feature = "UIBarAppearance", feature = "UINavigationBarAppearance"))]
        /// Setter for [`compactScrollEdgeAppearance`][Self::compactScrollEdgeAppearance].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setCompactScrollEdgeAppearance:))]
        #[unsafe(method_family = none)]
        pub fn setCompactScrollEdgeAppearance(
            &self,
            compact_scroll_edge_appearance: Option<&UINavigationBarAppearance>,
        );
    );
}

/// Methods declared on superclass `NSObject`.
impl UINavigationItem {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
