/*
 * Decompiled with CFR 0.152.
 */
package proguard.strip;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.AppView;
import proguard.Configuration;
import proguard.classfile.Clazz;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationTypeFilter;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.AnnotationsAttributeEditor;
import proguard.classfile.kotlin.visitor.KotlinMetadataRemover;
import proguard.classfile.kotlin.visitor.filter.KotlinClassFilter;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassProcessingFlagFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.CounterConditionalClassVisitor;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MemberProcessingFlagFilter;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.pass.Pass;
import proguard.util.ProcessingFlagSetter;

public class KotlinAnnotationStripper
implements Pass {
    private static final Logger logger = LogManager.getLogger(KotlinAnnotationStripper.class);
    private final Configuration configuration;

    public KotlinAnnotationStripper(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void execute(AppView appView) {
        logger.info("Removing @kotlin.Metadata annotation where not kept...");
        ClassCounter originalCounter = new ClassCounter();
        MemberCounter keptMemberCounter = new MemberCounter();
        MyKotlinAnnotationStripper kotlinAnnotationStripper = new MyKotlinAnnotationStripper();
        MultiClassVisitor kotlinAnnotationStripperVisitor = new MultiClassVisitor(new KotlinClassFilter(new MultiClassVisitor(originalCounter, new CounterConditionalClassVisitor(keptMemberCounter, CounterConditionalClassVisitor::isSame, new AllMemberVisitor(new MemberProcessingFlagFilter(0x700000, 0, keptMemberCounter)), new ClassProcessingFlagFilter(0, 0x700000, kotlinAnnotationStripper)))), new KotlinClassFilter(new ProcessingFlagSetter(0x200000)));
        appView.programClassPool.classesAccept(kotlinAnnotationStripperVisitor);
        appView.libraryClassPool.classesAccept(kotlinAnnotationStripperVisitor);
        logger.info("  Original number of classes with @kotlin.Metadata:            {}", (Object)originalCounter.getCount());
        logger.info("  Final number of classes with @kotlin.Metadata:               {}", (Object)(originalCounter.getCount() - kotlinAnnotationStripper.getCount()));
    }

    private static class MyKotlinAnnotationStripper
    implements ClassVisitor,
    AttributeVisitor,
    AnnotationVisitor {
        private final KotlinMetadataRemover kotlinMetadataRemover = new KotlinMetadataRemover();
        private AnnotationsAttributeEditor attributesEditor;
        private int count = 0;

        private MyKotlinAnnotationStripper() {
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public void visitAnyClass(Clazz clazz) {
            clazz.attributesAccept(this);
        }

        @Override
        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        @Override
        public void visitRuntimeVisibleAnnotationsAttribute(Clazz clazz, RuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute) {
            this.attributesEditor = new AnnotationsAttributeEditor(runtimeVisibleAnnotationsAttribute);
            runtimeVisibleAnnotationsAttribute.annotationsAccept(clazz, new AnnotationTypeFilter("Lkotlin/Metadata;", (AnnotationVisitor)this));
        }

        @Override
        public void visitAnnotation(Clazz clazz, Annotation annotation) {
            logger.debug("Removing Kotlin metadata annotation from {}", (Object)clazz.getName());
            this.attributesEditor.deleteAnnotation(annotation);
            clazz.accept(this.kotlinMetadataRemover);
            ++this.count;
        }
    }
}

