/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.AnyMethodrefConstant;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.PartialEvaluator;
import proguard.evaluation.ReferenceTracingInvocationUnit;
import proguard.evaluation.ReferenceTracingValueFactory;
import proguard.evaluation.TracedStack;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TracedReferenceValue;
import proguard.evaluation.value.TypedReferenceValue;
import proguard.evaluation.value.TypedReferenceValueFactory;
import proguard.evaluation.value.ValueFactory;
import proguard.util.ArrayUtil;

public class ExpectedStackTypeFinder
implements AttributeVisitor,
InstructionVisitor,
ConstantVisitor,
MemberVisitor {
    private static final Logger logger = LogManager.getLogger(ExpectedStackTypeFinder.class);
    protected final PartialEvaluator partialEvaluator;
    private final boolean runPartialEvaluator;
    private ReferenceValue[] expectedTypes = new ReferenceValue[8096];
    private int referencingOffset;
    private boolean isPut;
    private boolean isStatic;
    private Clazz referencedClass;
    private Clazz[] referencedClasses;
    private boolean reRunFromStart;

    public ExpectedStackTypeFinder() {
        this(new TypedReferenceValueFactory());
    }

    public ExpectedStackTypeFinder(ValueFactory valueFactory) {
        this(valueFactory, new ReferenceTracingValueFactory(valueFactory, false));
    }

    public ExpectedStackTypeFinder(ValueFactory valueFactory, ReferenceTracingValueFactory tracingValueFactory) {
        this(new PartialEvaluator(tracingValueFactory, new ReferenceTracingInvocationUnit(new BasicInvocationUnit(tracingValueFactory)), true, tracingValueFactory), true);
    }

    public ExpectedStackTypeFinder(PartialEvaluator partialEvaluator, boolean runPartialEvaluator) {
        this.partialEvaluator = partialEvaluator;
        this.runPartialEvaluator = runPartialEvaluator;
    }

    public ReferenceValue getExpectedTypeAfter(int instructionOffset) {
        return this.expectedTypes[instructionOffset];
    }

    public int creationOffset(int initializationOffset) {
        int stackEntryIndex = this.partialEvaluator.getStackAfter(initializationOffset).size();
        TracedReferenceValue tracedReferenceValue = (TracedReferenceValue)this.partialEvaluator.getStackBefore(initializationOffset).getBottom(stackEntryIndex);
        InstructionOffsetValue producerOffsets = tracedReferenceValue.getTraceValue().instructionOffsetValue();
        return producerOffsets.instructionOffset(0);
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int offset;
        logger.debug("ExpectedStackTypeFinder: [{}.{}{}]", (Object)clazz.getName(), (Object)method.getName(clazz), (Object)method.getDescriptor(clazz));
        this.expectedTypes = ArrayUtil.ensureArraySize(this.expectedTypes, codeAttribute.u4codeLength, null);
        if (this.runPartialEvaluator) {
            this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        }
        do {
            this.reRunFromStart = false;
            for (offset = codeAttribute.u4codeLength - 1; offset >= 0; --offset) {
                if (!this.partialEvaluator.isTraced(offset)) continue;
                codeAttribute.instructionAccept(clazz, method, offset, this);
            }
            if (!this.reRunFromStart) continue;
            logger.debug("ExpectedStackTypeFinder: repeat [{}.{}{}]", (Object)clazz.getName(), (Object)method.getName(clazz), (Object)method.getDescriptor(clazz));
        } while (this.reRunFromStart);
        logger.debug("ExpectedStackTypeFinder: results");
        if (logger.getLevel().isLessSpecificThan(Level.DEBUG)) {
            Instruction instruction;
            offset = 0;
            do {
                instruction = InstructionFactory.create(codeAttribute.code, offset);
                ReferenceValue expectedType = this.expectedTypes[offset];
                if (expectedType == null) {
                    logger.debug(instruction.toString(offset));
                    continue;
                }
                logger.debug("{} -> [{}]", (Object)instruction.toString(offset), (Object)expectedType);
            } while ((offset += instruction.length(offset)) < codeAttribute.u4codeLength);
        }
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        switch (simpleInstruction.opcode) {
            case 46: {
                this.ensureType("[I", null, offset, 1);
                break;
            }
            case 47: {
                this.ensureType("[J", null, offset, 1);
                break;
            }
            case 48: {
                this.ensureType("[F", null, offset, 1);
                break;
            }
            case 49: {
                this.ensureType("[D", null, offset, 1);
                break;
            }
            case 50: {
                ReferenceValue expectedType = this.expectedTypes[offset];
                this.ensureType(expectedType == null || expectedType.getType() == null ? "[Ljava/lang/Object;" : '[' + ClassUtil.internalTypeFromClassType(expectedType.getType()), expectedType == null ? null : expectedType.getReferencedClass(), offset, 1);
                break;
            }
            case 51: {
                this.ensureType("[B", null, offset, 1);
                break;
            }
            case 52: {
                this.ensureType("[C", null, offset, 1);
                break;
            }
            case 53: {
                this.ensureType("[S", null, offset, 1);
                break;
            }
            case 79: {
                this.ensureType("[I", null, offset, 2);
                break;
            }
            case 80: {
                this.ensureType("[J", null, offset, 3);
                break;
            }
            case 81: {
                this.ensureType("[F", null, offset, 2);
                break;
            }
            case 82: {
                this.ensureType("[D", null, offset, 3);
                break;
            }
            case 83: {
                this.ensureType("[Ljava/lang/Object;", null, offset, 2);
                break;
            }
            case 84: {
                this.ensureType("[B", null, offset, 2);
                break;
            }
            case 85: {
                this.ensureType("[C", null, offset, 2);
                break;
            }
            case 86: {
                this.ensureType("[S", null, offset, 2);
                break;
            }
            case -80: {
                String descriptor = method.getDescriptor(clazz);
                Clazz[] referencedClasses = ((ProgramMethod)method).referencedClasses;
                this.ensureType(ClassUtil.internalClassTypeFromType(ClassUtil.internalMethodReturnType(descriptor)), referencedClasses == null || !ClassUtil.isInternalClassType(descriptor) ? null : referencedClasses[new DescriptorClassEnumeration(descriptor).classCount() - 1], offset, 0);
                break;
            }
            case -66: {
                String actualType = this.partialEvaluator.getStackBefore(offset).getTop(0).referenceValue().internalType();
                this.ensureType(ClassUtil.isInternalClassType(actualType) ? "[Ljava/lang/Object;" : actualType, null, offset, 0);
                break;
            }
            case -65: {
                this.ensureType("java/lang/Throwable", null, offset, 0);
            }
        }
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -78: {
                this.referencingOffset = offset;
                this.isPut = false;
                this.isStatic = true;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                break;
            }
            case -77: {
                this.referencingOffset = offset;
                this.isPut = true;
                this.isStatic = true;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                break;
            }
            case -76: {
                this.referencingOffset = offset;
                this.isPut = false;
                this.isStatic = false;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                break;
            }
            case -75: {
                this.referencingOffset = offset;
                this.isPut = true;
                this.isStatic = false;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                break;
            }
            case -72: {
                this.referencingOffset = offset;
                this.isStatic = true;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                break;
            }
            case -74: 
            case -73: 
            case -71: 
            case -70: {
                this.referencingOffset = offset;
                this.isStatic = false;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
            }
        }
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        String methodDescriptor = invokeDynamicConstant.getType(clazz);
        int stackEntryIndex = ClassUtil.internalMethodParameterSize(methodDescriptor);
        Clazz[] referencedClasses = invokeDynamicConstant.referencedClasses;
        InternalTypeEnumeration types = new InternalTypeEnumeration(methodDescriptor);
        int index = 0;
        while (types.hasMoreTypes()) {
            String type = types.nextType();
            stackEntryIndex -= ClassUtil.internalTypeSize(type);
            if (ClassUtil.isInternalPrimitiveType(type.charAt(0))) continue;
            this.ensureType(ClassUtil.internalClassTypeFromType(type), referencedClasses == null ? null : referencedClasses[index++], this.referencingOffset, stackEntryIndex);
        }
    }

    @Override
    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        String fieldType = fieldrefConstant.getType(clazz);
        if (!this.isStatic) {
            this.referencedClass = null;
            clazz.constantPoolEntryAccept(fieldrefConstant.u2classIndex, this);
            this.ensureType(fieldrefConstant.getClassName(clazz), this.referencedClass, this.referencingOffset, this.isPut ? ClassUtil.internalTypeSize(fieldType) : 0);
        }
        if (this.isPut && !ClassUtil.isInternalPrimitiveType(fieldType.charAt(0))) {
            this.referencedClass = null;
            fieldrefConstant.referencedFieldAccept(this);
            this.ensureType(ClassUtil.internalClassTypeFromType(fieldType), this.referencedClass, this.referencingOffset, 0);
        }
    }

    @Override
    public void visitAnyMethodrefConstant(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant) {
        String methodDescriptor = anyMethodrefConstant.getType(clazz);
        int stackEntryIndex = ClassUtil.internalMethodParameterSize(methodDescriptor);
        if (!this.isStatic) {
            this.referencedClass = null;
            clazz.constantPoolEntryAccept(anyMethodrefConstant.u2classIndex, this);
            this.ensureType(anyMethodrefConstant.getClassName(clazz), this.referencedClass, this.referencingOffset, stackEntryIndex);
        }
        this.referencedClasses = null;
        anyMethodrefConstant.referencedMethodAccept(this);
        InternalTypeEnumeration types = new InternalTypeEnumeration(methodDescriptor);
        int index = 0;
        while (types.hasMoreTypes()) {
            String type = types.nextType();
            stackEntryIndex -= ClassUtil.internalTypeSize(type);
            if (ClassUtil.isInternalPrimitiveType(type.charAt(0))) continue;
            Clazz referencedClass1 = this.referencedClasses == null || !ClassUtil.isInternalClassType(type) ? null : this.referencedClasses[index++];
            this.ensureType(ClassUtil.internalClassTypeFromType(type), referencedClass1, this.referencingOffset, stackEntryIndex);
        }
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.referencedClass = classConstant.referencedClass;
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.referencedClass = programField.referencedClass;
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.referencedClasses = programMethod.referencedClasses;
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        this.referencedClass = libraryField.referencedClass;
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        this.referencedClasses = libraryMethod.referencedClasses;
    }

    private void ensureType(String type, Clazz referencedClass, int offset, int stackEntryIndex) {
        TracedStack stackBefore = this.partialEvaluator.getStackBefore(offset);
        TracedReferenceValue stackEntry = (TracedReferenceValue)stackBefore.getTop(stackEntryIndex);
        InstructionOffsetValue instructionOffsets = stackEntry.getTraceValue().instructionOffsetValue();
        int instructionOffsetCount = instructionOffsets.instructionOffsetCount();
        for (int index = 0; index < instructionOffsetCount; ++index) {
            if (instructionOffsets.isMethodParameter(index) || instructionOffsets.isExceptionHandler(index)) continue;
            int producerOffset = instructionOffsets.instructionOffset(index);
            ReferenceValue oldExpectedType = this.expectedTypes[producerOffset];
            String debugMessage = String.format("[%s]: [%s] old [%s] & new [%s]", offset, producerOffset, oldExpectedType, type);
            TypedReferenceValue newExpectedType = new TypedReferenceValue(type, referencedClass, false, false);
            if (oldExpectedType == null || oldExpectedType.isNull() == 1 || ((ReferenceValue)newExpectedType).instanceOf(oldExpectedType.getType(), oldExpectedType.getReferencedClass()) == 1) {
                this.expectedTypes[producerOffset] = newExpectedType;
                if (!(producerOffset <= offset || oldExpectedType != null && oldExpectedType.getType().equals(((ReferenceValue)newExpectedType).getType()))) {
                    this.reRunFromStart = true;
                    debugMessage = debugMessage + String.format(" (rerun for higher producer [%s])", producerOffset);
                }
            } else if (oldExpectedType.instanceOf(type, referencedClass) != 1) {
                ReferenceValue actualValue = this.partialEvaluator.getStackAfter(producerOffset).getTop(0).referenceValue();
                if (oldExpectedType != null && actualValue.getType() == null) continue;
                newExpectedType = new TypedReferenceValue(actualValue.getType(), actualValue.getReferencedClass(), false, false);
                this.expectedTypes[producerOffset] = newExpectedType;
                if (!(producerOffset <= offset || oldExpectedType != null && oldExpectedType.getType().equals(((ReferenceValue)newExpectedType).getType()))) {
                    this.reRunFromStart = true;
                    debugMessage = debugMessage + String.format(" (rerun for higher producer [%s])", producerOffset);
                }
            }
            debugMessage = debugMessage + String.format(" => [%s]", this.expectedTypes[producerOffset]);
            logger.debug(debugMessage);
        }
    }
}

